(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('WeekdayAssignmentFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',
    function($http, $log, $q, $location, SystemMessaging)
    {
        var urlBase = '/wstr/api/weekday-assignments';
        var exports = ['id', 'season_id', 'daytype_id', 'dayofweek'];

        function WeekdayAssignment()
        {
            this.id = this.season_id = this.daytype_id = this.dayofweek = null;
            this.isLoaded = false;
            this.isLoading = false;
            this.isSaving = false;
        }

        WeekdayAssignment.prototype.load = function()
        {
            if (this.isLoaded) { return $q.all([]); }

            var self = this;

            return $http({
                method : 'GET',
                url : urlBase + '/' + this.id
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };


        WeekdayAssignment.prototype.buildPostData = function()
        {
            var postData = {};

            for (var idx in exports)
            {
                var property = exports[idx];
                postData[property] = this[property];
            }

            return postData;
        };

        WeekdayAssignment.prototype.deleteEntry = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            return $http({
                method : 'DELETE',
                url    : urlBase + '/' + this.id,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                self.isSaving = self.isLoading = false;
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        WeekdayAssignment.prototype.save = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            var postData = this.buildPostData();

            return $http({
                method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                data   : $.param( postData )
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                    self.hydrate(response.data);
                    self.isSaving = self.isLoading = false;
                    return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        WeekdayAssignment.prototype.hydrate = function(data)
        {
            for (var property in data)
            {
                if (!data.hasOwnProperty(property)) { continue; }

                this[property] = data[property]/1;
            }
            this.isLoaded = true;
            this.isLoading = false;
        };


        return WeekdayAssignment;

    }]);

})(jQuery, angular, document, window);
