(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('UsersCollectionFactory',
    ['$http', '$log', '$q', 'UserFactory', 'SystemMessagingFactory',
    function ($http, $log, $q, User, SystemMessaging)
    {
        var urlBase = '/wstr/api/user';

        function UsersCollection()
        {
            this.isLoaded = false;
            this.users = [];
        }

        UsersCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        UsersCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var user = data[i];
                var userObject = new User();
                userObject.hydrate(user);

                this.users.push(userObject);
            }
            this.isLoaded = true;
        };

        UsersCollection.prototype.deleteUser = function(user)
        {
            var found = this.users.filter(function(element)
            {
                return element.id/1 !== user.id/1;
            });

            this.users = found;

            return user.deleteUser();
        };



        return new UsersCollection();
    }]);
    
})(jQuery, angular, document, window);