(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TaskAssignmentCollectionFactory',
    ['$http', '$log', '$q', '$filter', 'SystemMessagingFactory', 'TaskAssignmentFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, $filter, SystemMessaging, TaskAssignment, AppModelCollection)
    {
        function TaskAssignmentCollection()
        {
            var self = this;
            this.urlBase = '/wstr/api/task-assignment';
            this.collection = [];
            this.collectionById = {};

            self.getTaskAssignmentById = function(id)
            {
                if (self.collectionById.hasOwnProperty(id))
                {
                    return self.collectionById[id];
                }

                self.collectionById[id] = (self.collection.filter(function(assignment){
                    return assignment.id/1 === id/1;
                })).pop();

                return self.collectionById[id];
            };

            this.startDate = this.endDate = this.searchQuery = null;
            this.reload = function(startDate, endDate, searchQuery)
            {
                self.collectionById = {};
                self.filteredTaskAssignments = {};
                self.isLoaded = false;
                self.isLoading = true;
                self.startDate = $filter('date')(startDate, 'yyyy-MM-dd');
                self.endDate = $filter('date')(endDate, 'yyyy-MM-dd');
                self.searchQuery = searchQuery;
                return this.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase +
                       '?startDate=' + self.startDate +
                       '&endDate=' + self.endDate +
                       '&searchQuery=' + (self.searchQuery ? self.searchQuery : '');
            };

            this.hydrateCallback = function(modelData)
            {
                var taskAssignment = new TaskAssignment();
                taskAssignment.hydrate(modelData);

                return taskAssignment;
            };

            this.filteredTaskAssignments = {};

            this.getTaskAssignments = function(day, organization_id)
            {
                if (isNull(day)) { return []; }

                var organizationKey = organization_id ? organization_id : 'both';

                if (!self.filteredTaskAssignments[day])
                {
                    self.filteredTaskAssignments[day] = { 1 : [], 2 : [], 'both' : [] };
                }

                if (self.filteredTaskAssignments[day][organizationKey].length)
                {
                    return self.filteredTaskAssignments[day][organizationKey];
                }

                self.filteredTaskAssignments[day][organizationKey] = self.collection.filter(function(assignment)
                {
                    var assignmentDate = new Date(assignment.assignmentdate + ' 00:00:00');

                    if (organization_id && organization_id/1 !== assignment.organization_id/1) { return false; }
                    if (day.getFullYear() !== assignmentDate.getFullYear()) { return false; }
                    if (day.getMonth()    !== assignmentDate.getMonth()) { return false; }
                    if (day.getDate()     !== assignmentDate.getDate()) { return false; }

                    return true;
                });

                return self.filteredTaskAssignments[day][organizationKey];
            };
        }

        TaskAssignmentCollection.prototype = AppModelCollection.prototype;

        return new TaskAssignmentCollection();
    }]);
    
})(jQuery, angular, document, window);
