(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('ShiftFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',

     function($http, $log, $q, $location, SystemMessaging)
     {
         var urlBase = '/wstr/api/shifts';
         var exports = ['id', 'daytype_id', 'name', 'status', 'createdate', 'modifydate'];

         function Shift()
         {
             this.id = this.daytype_id = this.name = this.status = this.createdate = this.modifydate = null;
             this.isLoaded = false;
             this.isLoading = false;
             this.isSaving = false;
         }

         Shift.prototype.load = function()
         {
             if (this.isLoaded) { return $q.all([]); }

             var self = this;

             return $http({
                 method : 'GET',
                 url : urlBase + '/' + this.id
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 return self;
             });
         };


         Shift.prototype.buildPostData = function()
         {
             var postData = {};

             for (var idx in exports)
             {
                 var property = exports[idx];
                 postData[property] = this[property];

                 if (property === 'status')
                 {
                     postData[property] = this.status ? 1 : 0;
                 }
             }

             return postData;
         };

         Shift.prototype.deleteShift = function()
         {
             var self = this;
             this.isSaving = this.isLoading = true;

             return $http({
                 method : 'DELETE',
                 url    : urlBase + '/' + this.id,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Shift.prototype.save = function()
         {
             var self = this;
             this.isSaving = this.isLoading = true;

             var postData = this.buildPostData();

             return $http({
                 method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                 url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                 data   : $.param( postData )
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Shift.prototype.hydrate = function(data)
         {
             for (var property in data)
             {
                 if (!data.hasOwnProperty(property)) { continue; }

                 this[property] = data[property];

                 if (property === 'id' || property === 'daytype_id')
                 {
                     this[property] /= 1;
                 }
                 if (property === 'status')
                 {
                     this[property] = data[property]/1 === 1;
                 }
             }
             this.isLoaded = true;
             this.isLoading = false;
         };


         return Shift;

     }]);
})(jQuery, angular, document, window);
