(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('OrganizationFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',
     function($http, $log, $q, $location, SystemMessaging)
     {
         var urlBase = '/wstr/api/organizations';
         var exports = ['id', 'name'];

         function Organization()
         {
             this.id = this.name = null;
             this.isLoaded = false;
             this.isLoading = false;
             this.isSaving = false;
         }

         Organization.prototype.load = function()
         {
             if (this.isLoaded) { return $q.all([]); }

             var self = this;

             return $http({
                 method : 'GET',
                 url : urlBase + '/' + this.id
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 return self;
             });
         };


         Organization.prototype.buildPostData = function()
         {
             var postData = {};

             for (var idx in exports)
             {
                 var property = exports[idx];
                 postData[property] = this[property];
             }

             return postData;
         };

         Organization.prototype.deleteOrganization = function()
         {
             var self = this;
             this.isSaving = this.isLoading = true;

             return $http({
                 method : 'DELETE',
                 url    : urlBase + '/' + this.id,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Organization.prototype.save = function()
         {
             var self = this;
             this.isSaving = this.isLoading = true;

             var postData = this.buildPostData();

             return $http({
                 method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                 url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                 data   : $.param( postData )
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Organization.prototype.hydrate = function(data)
         {
             for (var property in data)
             {
                 if (!data.hasOwnProperty(property)) { continue; }

                 this[property] = data[property];

                 if (property === 'id')
                 {
                     this[property] /= 1;
                 }
             }
             this.isLoaded = true;
             this.isLoading = false;
         };


         return Organization;

     }]);
})(jQuery, angular, document, window);
