(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('GuideTimeSheetFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function GuideTimeSheet()
        {
            var self = this;

            this.id = this.guide_id = this.organization_id = this.assignmentdate = this.temperature =
                this.precipitation = this.conditions = this.notes = this.createdate = this.modifydate =
                this.starttime_1 = this.starttime_2 = this.starttime_3 = this.starttime_4 =
                this.starttime_5 = this.endtime_1 = this.endtime_2 = this.endtime_3 = this.endtime_4 =
                this.endtime_5 = null;

            this.urlBase = '/wstr/api/guide-time-sheets';

            this.exports = [ 'id', 'guide_id', 'organization_id', 'assignmentdate',
                'temperature', 'precipitation', 'conditions', 'notes', 'createdate',
                'modifydate', 'starttime_1', 'starttime_2', 'starttime_3', 'starttime_4',
                'starttime_5', 'endtime_1', 'endtime_2', 'endtime_3', 'endtime_4',
                'endtime_5'
            ];

            this.propertyTypes = {
                number : [ 'id', 'guide_id', 'organization_id' ],
                bool   : [ ],
                time   : [ 'starttime_1', 'starttime_2', 'starttime_3', 'starttime_4',
                           'starttime_5', 'endtime_1', 'endtime_2', 'endtime_3', 'endtime_4',
                           'endtime_5']
            };

            this.getSaveUrl = function ()
            {
                return self.id !== undefined && self.id !== null ?
                    self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };

            this.buildCallback = function(property, model){};

            this.starthour_1 = this.starthour_2 = this.starthour_3 = this.starthour_4 =
            this.starthour_5 = this.startminute_1 = this.startminute_2 = this.startminute_3 =
            this.startminute_4 = this.startminute_5 = this.endhour_1 = this.endhour_2 =
            this.endhour_3 = this.endhour_4 = this.endhour_5 = this.endminute_1 =
            this.endminute_2 = this.endminute_3 = this.endminute_4 = this.endminute_5 = null;


            this.getTimeWorked = function(which)
            {
                var hours = self.getHoursWorked(which);
                var minutes = self.getMinutesWorked(which);

                // if (hours < 2)
                // {
                //     hours = 2;
                //     minutes = 0;
                // }
                return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            };

            this.getTimeWorkedAsReal = function(which)
            {
                if (this.getSecondsWorked(which)/60/60 < 2)
                {
                    return '2.00';
                } else
                {
                    return (this.getSecondsWorked(which)/60/60).toFixed(2);
                }
            };

            this.getMinutesWorked = function(which)
            {
                return (self.getSecondsWorked(which) / 60) % 60;
            };

            this.getHoursWorked = function(which)
            {
                return Math.trunc(self.getSecondsWorked(which) / 60 / 60);
            };

            this.getSecondsWorked = function(which)
            {
                var s1 = self.starttime_1 && self.endtime_1 ? (self.endtime_1 - self.starttime_1)/1000 : 0;
                var s2 = self.starttime_2 && self.endhour_2 ? (self.endtime_2 - self.starttime_2)/1000 : 0;
                var s3 = self.starttime_3 && self.endhour_3 ? (self.endtime_3 - self.starttime_3)/1000 : 0;
                var s4 = self.starttime_4 && self.endhour_4 ? (self.endtime_4 - self.starttime_4)/1000 : 0;
                var s5 = self.starttime_5 && self.endhour_5 ? (self.endtime_5 - self.starttime_5)/1000 : 0;

                if (which)
                {
                    switch (which)
                    {
                        case 1: return s1;
                        case 2: return s2;
                        case 3: return s3;
                        case 4: return s4;
                        case 5: return s5;
                    }
                }

                return s1 + s2 + s3 + s4 + s5;
            };


            this.hydrateCallback = function(property)
            {
                switch (property)
                {
                    case 'starttime_1':
                        if (self.starttime_1.getHours() === 0)
                        {
                            self.starttime_1 = null;
                        } else
                        {
                            self.starthour_1 = self.starttime_1.getHours();
                            self.startminute_1 = self.starttime_1.getMinutes();
                        }
                        break;
                    case 'starttime_2':
                        if (self.starttime_2.getHours() === 0)
                        {
                            self.starttime_2 = null;
                        } else
                        {
                            self.starthour_2 = self.starttime_2.getHours();
                            self.startminute_2 = self.starttime_2.getMinutes();
                        }
                        break;
                    case 'starttime_3':
                        if (self.starttime_3.getHours() === 0)
                        {
                            self.starttime_3 = null;
                        } else
                        {
                            self.starthour_3 = self.starttime_3.getHours();
                            self.startminute_3 = self.starttime_3.getMinutes();
                        }
                        break;
                    case 'starttime_4':
                        if (self.starttime_4.getHours() === 0)
                        {
                            self.starttime_4 = null;
                        } else
                        {
                            self.starthour_4 = self.starttime_4.getHours();
                            self.startminute_4 = self.starttime_4.getMinutes();
                        }
                        break;
                    case 'starttime_5':
                        if (self.starttime_5.getHours() === 0)
                        {
                            self.starttime_5 = null;
                        } else
                        {
                            self.starthour_5 = self.starttime_5.getHours();
                            self.startminute_5 = self.starttime_5.getMinutes();
                        }
                        break;
                    case 'endtime_1':
                        if (self.endtime_1.getHours() === 0)
                        {
                            self.endtime_1 = null;
                        } else
                        {
                            self.endhour_1 = self.endtime_1.getHours();
                            self.endminute_1 = self.endtime_1.getMinutes();
                        }
                        break;
                    case 'endtime_2':
                        if (self.endtime_2.getHours() === 0)
                        {
                            self.endtime_2 = null;
                        } else
                        {
                            self.endhour_2 = self.endtime_2.getHours();
                            self.endminute_2 = self.endtime_2.getMinutes();
                        }
                        break;
                    case 'endtime_3':
                        if (self.endtime_3.getHours() === 0)
                        {
                            self.endtime_3 = null;
                        } else
                        {
                            self.endhour_3 = self.endtime_3.getHours();
                            self.endminute_3 = self.endtime_3.getMinutes();
                        }
                        break;
                    case 'endtime_4':
                        if (self.endtime_4.getHours() === 0)
                        {
                            self.endtime_4 = null;
                        } else
                        {
                            self.endhour_4 = self.endtime_4.getHours();
                            self.endminute_4 = self.endtime_4.getMinutes();
                        }
                        break;
                    case 'endtime_5':
                        if (self.endtime_5.getHours() === 0)
                        {
                            self.endtime_5 = null;
                        } else
                        {
                            self.endhour_5 = self.endtime_5.getHours();
                            self.endminute_5 = self.endtime_5.getMinutes();
                        }
                        break;
                }
            };

            this.postHydrateCallback = function()
            {
                self.updateTimes();
            };

            this.removeTime = function(which)
            {
                self[which] = null;
                switch (which)
                {
                    case 'starttime_1':
                        self.starthour_1 =  self.startminute_1 = null;
                        break;
                    case 'starttime_2':
                        self.starthour_2 =  self.startminute_2 = null;
                        break;
                    case 'starttime_3':
                        self.starthour_3 = self.startminute_3 = null;
                        break;
                    case 'starttime_4':
                        self.starthour_4 = self.startminute_4 = null;
                        break;
                    case 'starttime_5':
                        self.starthour_5 = self.startminute_5 = null;
                        break;
                    case 'endtime_1':
                        self.endhour_1 = self.endminute_1 = null;
                        break;
                    case 'endtime_2':
                        self.endhour_2 = self.endminute_2 = null;
                        break;
                    case 'endtime_3':
                        self.endhour_3 = self.endminute_3 = null;
                        break;
                    case 'endtime_4':
                            self.endhour_4 = self.endminute_4 = null;
                        break;
                    case 'endtime_5':
                            self.endhour_5 = self.endminute_5 = null;
                        break;
                }
            };

            this.updateTimes = function(which)
            {

                var assignmentDate = new Date(self.assignmentdate + ' 00:00:00');

                if (which && self[which] === null)
                {
                    self[which] = new Date(assignmentDate);
                }

                if (self.starttime_1 !== null)
                {
                    self.starttime_1.setYear(assignmentDate.getFullYear());
                    self.starttime_1.setMonth(assignmentDate.getMonth());
                    self.starttime_1.setDate(assignmentDate.getDate());
                    self.starttime_1.setHours(self.starthour_1/1);
                    self.starttime_1.setMinutes(self.startminute_1/1);
                    self.starttime_1.setSeconds(0);
                    self.starttime_1.setMilliseconds(0);
                }

                if (self.starttime_2 !== null)
                {
                    self.starttime_2.setYear(assignmentDate.getFullYear());
                    self.starttime_2.setMonth(assignmentDate.getMonth());
                    self.starttime_2.setDate(assignmentDate.getDate());
                    self.starttime_2.setHours(self.starthour_2/1);
                    self.starttime_2.setMinutes(self.startminute_2/1);
                    self.starttime_2.setSeconds(0);
                    self.starttime_2.setMilliseconds(0);
                }

                if (self.starttime_3 !== null)
                {
                    self.starttime_3.setYear(assignmentDate.getFullYear());
                    self.starttime_3.setMonth(assignmentDate.getMonth());
                    self.starttime_3.setDate(assignmentDate.getDate());
                    self.starttime_3.setHours(self.starthour_3/1);
                    self.starttime_3.setMinutes(self.startminute_3/1);
                    self.starttime_3.setSeconds(0);
                    self.starttime_3.setMilliseconds(0);
                }

                if (self.starttime_4 !== null)
                {
                    self.starttime_4.setYear(assignmentDate.getFullYear());
                    self.starttime_4.setMonth(assignmentDate.getMonth());
                    self.starttime_4.setDate(assignmentDate.getDate());
                    self.starttime_4.setHours(self.starthour_4/1);
                    self.starttime_4.setMinutes(self.startminute_4/1);
                    self.starttime_4.setSeconds(0);
                    self.starttime_4.setMilliseconds(0);
                }

                if (self.starttime_5 !== null)
                {
                    self.starttime_5.setYear(assignmentDate.getFullYear());
                    self.starttime_5.setMonth(assignmentDate.getMonth());
                    self.starttime_5.setDate(assignmentDate.getDate());
                    self.starttime_5.setHours(self.starthour_5/1);
                    self.starttime_5.setMinutes(self.startminute_5/1);
                    self.starttime_5.setSeconds(0);
                    self.starttime_5.setMilliseconds(0);
                }

                if (self.endtime_1 !== null)
                {
                    self.endtime_1.setYear(assignmentDate.getFullYear());
                    self.endtime_1.setMonth(assignmentDate.getMonth());
                    self.endtime_1.setDate(assignmentDate.getDate());
                    self.endtime_1.setHours(self.endhour_1/1);
                    self.endtime_1.setMinutes(self.endminute_1/1);
                    self.endtime_1.setSeconds(0);
                    self.endtime_1.setMilliseconds(0);
                }

                if (self.endtime_2 !== null)
                {
                    self.endtime_2.setYear(assignmentDate.getFullYear());
                    self.endtime_2.setMonth(assignmentDate.getMonth());
                    self.endtime_2.setDate(assignmentDate.getDate());
                    self.endtime_2.setHours(self.endhour_2/1);
                    self.endtime_2.setMinutes(self.endminute_2/1);
                    self.endtime_2.setSeconds(0);
                    self.endtime_2.setMilliseconds(0);
                }

                if (self.endtime_3 !== null)
                {
                    self.endtime_3.setYear(assignmentDate.getFullYear());
                    self.endtime_3.setMonth(assignmentDate.getMonth());
                    self.endtime_3.setDate(assignmentDate.getDate());
                    self.endtime_3.setHours(self.endhour_3/1);
                    self.endtime_3.setMinutes(self.endminute_3/1);
                    self.endtime_3.setSeconds(0);
                    self.endtime_3.setMilliseconds(0);
                }

                if (self.endtime_4 !== null)
                {
                    self.endtime_4.setYear(assignmentDate.getFullYear());
                    self.endtime_4.setMonth(assignmentDate.getMonth());
                    self.endtime_4.setDate(assignmentDate.getDate());
                    self.endtime_4.setHours(self.endhour_4/1);
                    self.endtime_4.setMinutes(self.endminute_4/1);
                    self.endtime_4.setSeconds(0);
                    self.endtime_4.setMilliseconds(0);
                }

                if (self.endtime_5 !== null)
                {
                    self.endtime_5.setYear(assignmentDate.getFullYear());
                    self.endtime_5.setMonth(assignmentDate.getMonth());
                    self.endtime_5.setDate(assignmentDate.getDate());
                    self.endtime_5.setHours(self.endhour_5/1);
                    self.endtime_5.setMinutes(self.endminute_5/1);
                    self.endtime_5.setSeconds(0);
                    self.endtime_5.setMilliseconds(0);
                }

                if (which)
                {
                    if (self[which].getHours() === 0)
                    {
                        self[which].setHours((new Date()).getHours());
                    }
                    self.hydrateCallback(which);
                }
            };

        }

        GuideTimeSheet.prototype = AppModel.prototype;


        return GuideTimeSheet;

    }]);

})(jQuery, angular, document, window);
