(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('GuideAvailabilityCollectionFactory',
    ['$http', '$log', '$q', '$filter', 'SystemMessagingFactory', 'GuideAvailabilityFactory',
    function ($http, $log, $q, $filter, SystemMessaging, GuideAvailability)
    {
        var urlBase = '/wstr/api/guide-availabilities';

        function GuideAvailabilityCollection()
        {
            this.isLoaded = false;
            this.isLoading = false;
            this.availabilities = [];
        }

        GuideAvailabilityCollection.prototype.empty = function()
        {
            this.isLoaded = false;
            this.availabilities = [];
        };

        GuideAvailabilityCollection.prototype.reload = function(guide_id, startDate, endDate)
        {
            this.isLoaded = false;
            this.isLoading = true;
            this.availabilities = [];
            return this.load(guide_id, startDate, endDate);
        };

        GuideAvailabilityCollection.prototype.load = function(guide_id, startDate, endDate)
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            this.isLoading = true;
            var start_date = null, end_date = null;

            if (startDate) { start_date = $filter('date')(startDate, 'yyyy-MM-dd'); }
            if (endDate)   { end_date = $filter('date')(endDate, 'yyyy-MM-dd'); }


            return $http({
                method : 'GET',
                url : urlBase + '?guide_id=' + guide_id + '&startDate=' + start_date + '&endDate=' + end_date
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        GuideAvailabilityCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var availabilityData = data[i];
                var availabilityObject = new GuideAvailability();
                availabilityObject.hydrate(availabilityData);
                this.availabilities.push(availabilityObject);
            }
            this.isLoaded = true;
            this.isLoading = false;
        };

        GuideAvailabilityCollection.prototype.deleteEntry = function(availability)
        {
            var found = this.availabilities.filter(function(element)
            {
                return element.id/1 !== availability.id/1;
            });
            this.availabilities = found;

            return availability.deleteEntry();
        };

        return new GuideAvailabilityCollection();
    }]);
    
})(jQuery, angular, document, window);