(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('GuideAssignmentFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function GuideAssignment()
        {
            var self = this;

            this.id = this.taskassignment_id = this.guide_id = this.starttime = this.endtime = 
                this.weather = this.discrepancy = this.notes = this.status = this.createdate = this.modifydate =
                this.noticketscollected = null;

            this.urlBase = '/wstr/api/guide-assignments';

            this.exports = ['id', 'taskassignment_id', 'guide_id', 'starttime', 'endtime', 'weather',
                            'totaltickets', 'discrepancy', 'notes', 'status', 'createdate', 'modifydate',
                            'noticketscollected'];

            this.propertyTypes = {
                number : ['id', 'taskassignment_id', 'guide_id', 'totaltickets' ],
                bool   : [ 'status', 'noticketscollected' ],
                time   : ['starttime', 'endtime']
            };

            this.getSaveUrl = function()
            {
                return self.id !== undefined && self.id !== null ?
                       self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };

        }

        GuideAssignment.prototype = AppModel.prototype;


        return GuideAssignment;

    }]);

})(jQuery, angular, document, window);
