(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('AppModelCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory',
    function ($http, $log, $q, SystemMessaging)
    {
        function AppModelCollection(){}

        AppModelCollection.prototype = {
            getLoadUrl : function(){},
            hydrateCallback : function(modelData){},
            collection : [],
            isLoaded : false,
            isLoading : false,
            loadMethod : 'GET',
            postData : []
        };

        AppModelCollection.prototype.empty = function()
        {
            this.collection = [];
            this.isLoading = false;
            this.isLoaded = false;
        };

        AppModelCollection.prototype.reload = function()
        {
            this.empty();
            return this.load();
        };

        AppModelCollection.prototype.load = function()
        {
            var self = this;

            if (self.isLoaded) { return $q.all([]); }

            self.isLoading = true;

            var httpRequestObject = {
                method : self.loadMethod,
                url : self.getLoadUrl()
            };

            if (self.loadMethod === 'POST')
            {
                httpRequestObject.data = $.param(self.postData);
                httpRequestObject.headers = { 'Content-Type' : 'application/x-www-form-urlencoded' };
            }
            return $http(httpRequestObject).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        AppModelCollection.prototype.hydrate = function(data)
        {
            var self = this;

            self.collection = [];

            for (var i in data)
            {
                if (!data.hasOwnProperty(i)) { continue; }

                var model = this.hydrateCallback(data[i]);
                self.collection.push(model);
            }
            self.isLoaded = true;
            self.isLoading = false;
        };

        AppModelCollection.prototype.deleteEntry = function(entry)
        {
            var self = this;

            var found = self.collection.filter(function(element)
            {
                return element.id/1 !== entry.id/1;
            });

            self.collection = found;

            return entry.deleteEntry();
        };

        return AppModelCollection;
    }]);
    
})(jQuery, angular, document, window);