(function($, angular, document, window) {

    angular.module('phillyByFoot')
    .directive('autoResize', [function ()
    {
        return {
            scope : { trigger : '=autoResize' },
            link : function(scope, element)
            {
                if (!element[0].startHeight)
                {
                    element[0].startHeight = element[0].scrollHeight / 1;
                }

                element.on('keypress focus', function()
                {
                    var h = element[0].scrollHeight/1;

                    if (h > element[0].startHeight)
                    {
                        element[0].style.height = (element[0].scrollHeight / 1) + 'px';
                    }
                });
            }
        };
    }]);

})(jQuery, angular, document, window);