(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('TimeSheetsController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'OrganizationsCollectionFactory', 'GuideTimeSheetCollectionFactory', 'PayPeriodFactory',
    'IntraControllerActionHandlerFactory', 'StaticUserFactory', 'GuideAssignmentCollectionFactory',
    'TaskAssignmentCollectionFactory',
    function($q, $filter, $scope, $http, $window, $location, OrganizationsCollection, GuideTimeSheetCollection,
        PayPeriod, IntraControllerActionHandler, StaticUser, GuideAssignmentCollection, TaskAssignmentCollection)
    {
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.guideTimeSheetCollection = GuideTimeSheetCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.payPeriod = PayPeriod;
        $scope.staticUser = StaticUser;
        $scope.user = IntraControllerActionHandler.model ? IntraControllerActionHandler.model : StaticUser;

        $scope.payPeriod.updatePayPeriod(0);
        $scope.startDay = new Date($scope.payPeriod.datePicker.start);
        $scope.endDay = new Date($scope.payPeriod.datePicker.end);

        $scope.isLoaded = false;


        $scope.getGuideAssignment = function(taskAssignment)
        {
            return ($scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return (guideAssignment.taskassignment_id/1 === taskAssignment.id/1 && $scope.user.id/1 === guideAssignment.guide_id/1);
            })).pop();
        };

        $scope.hasMissingHours = function(day)
        {
            var hasAssignments = false;
            var hasTimeSheets = false;

            $scope.taskAssignmentCollection.collection.forEach(function(taskAssignment)
            {
                var assignmentDate = new Date(taskAssignment.assignmentdate + ' 00:00:00');

                if (assignmentDate.getTime() === day.getTime() && $scope.getGuideAssignment(taskAssignment))
                {
                    hasAssignments = true;
                }
            });

            $scope.guideTimeSheetCollection.collection.forEach(function(timeSheet)
            {
                var assignmentDate = new Date(timeSheet.assignmentdate + ' 00:00:00');
                if (assignmentDate.getTime() === day.getTime() && timeSheet.guide_id/1 === $scope.user.id/1)
                {
                    hasTimeSheets = true;
                }
            });

            return hasAssignments && !hasTimeSheets;
        };

        $scope.isRoundedUp = function(day)
        {
            var isRoundedUp = false;

            $scope.guideTimeSheetCollection.collection.forEach(function(timeSheet)
            {
                var assignmentDate = new Date(timeSheet.assignmentdate + ' 00:00:00');
                if (assignmentDate.getTime() === day.getTime() && timeSheet.guide_id/1 === $scope.user.id/1)
                {
                    if (timeSheet.getHoursWorked() < 2)
                    {
                        isRoundedUp = true;
                    }
                }
            });
            return isRoundedUp;
        };

        $scope.getWorkHours = function(day, seconds)
        {
            var totalSecondsWorked = 0;

            $scope.guideTimeSheetCollection.collection.forEach(function(timeSheet)
            {
                var assignmentDate = new Date(timeSheet.assignmentdate + ' 00:00:00');
                if (assignmentDate.getTime() === day.getTime() && timeSheet.guide_id/1 === $scope.user.id/1)
                {
                    if (timeSheet.getHoursWorked() < 2)
                    {
                        totalSecondsWorked += (2 * 60 * 60);
                    } else
                    {
                        totalSecondsWorked += timeSheet.getSecondsWorked();
                    }
                }
            });

            if (totalSecondsWorked)
            {
                var hours = Math.trunc(totalSecondsWorked/60/60);
                var minutes = (totalSecondsWorked/60) % 60;

                if (seconds) { return totalSecondsWorked; }
                return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            }

            return 0;
        };

        $scope.getTotalHours = function()
        {
            var totalSecondsWorked = 0;

            $scope.payPeriod.activeDays.forEach(function(activeDay)
            {
                totalSecondsWorked += $scope.getWorkHours(activeDay.day, true);
            });

            if (totalSecondsWorked)
            {
                var hours = Math.trunc(totalSecondsWorked/60/60);
                var minutes = (totalSecondsWorked/60) % 60;

                return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            }
        };

        $scope.returnToCalendar = function()
        {
            $location.path('/calendar');
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskAssignmentCollection.reload($scope.startDay, $scope.endDay));
        promises.push($scope.guideTimeSheetCollection.reload($scope.startDay, $scope.endDay));
        promises.push($scope.guideTimeSheetCollection.reload($scope.startDay, $scope.endDay));

        $q.all(promises).then(function()
        {
            $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection).then(function()
            {
                $scope.isLoaded = true;
            });
        });
    }]);

})($, angular, document, window);
