(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('SeasonsController', ['$q', '$scope', '$http', '$window', '$location', 'StaticUserFactory',
    'SeasonsCollectionFactory','SeasonFactory', 'OrganizationsCollectionFactory', 'WeekdayAssignmentsCollectionFactory',
    'WeekdayAssignmentFactory', 'DayTypesCollectionFactory', 'ShiftsCollectionFactory', 'ShiftAssignmentsCollectionFactory',
    'ShiftAssignmentFactory', 'UsersCollectionFactory',
    function($q, $scope, $http, $window, $location, User, SeasonsCollection, Season, OrganizationsCollection,
        WeekdayAssignmentsCollection, WeekdayAssignment, DayTypesCollection, ShiftsCollection, ShiftAssignmentsCollection,
        ShiftAssignment, UsersCollection)
    {
        $scope.user = User;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.seasonsCollection = SeasonsCollection;
        $scope.weekdayAssignmentsCollection = WeekdayAssignmentsCollection;
        $scope.dayTypesCollection = DayTypesCollection;
        $scope.shiftsCollection = ShiftsCollection;
        $scope.shiftAssignmentsCollection = ShiftAssignmentsCollection;
        $scope.usersCollection = UsersCollection;
        $scope.sortedSeasonList = null;
        $scope.sortType = null;
        $scope.startAt = 0;
        $scope.currentPage = 1;
        $scope.editingSeasonName = null;
        $scope.openAssignmentsGroup = null;
        $scope.editingAssignment = null;
        $scope.isSaving = false;

        $scope.shiftAssignmentsCollection.empty();

        $scope.days = [
            { id : 0, abbr : 'Sun', name : 'Sunday' },
            { id : 1, abbr : 'Mon', name : 'Monday' },
            { id : 2, abbr : 'Tue', name : 'Tuesday' },
            { id : 3, abbr : 'Wed', name : 'Wednesday' },
            { id : 4, abbr : 'Thu', name : 'Thursday' },
            { id : 5, abbr : 'Fri', name : 'Friday' },
            { id : 6, abbr : 'Sat', name : 'Saturday' }
        ];

        $scope.pageItems = function()
        {
            $scope.startAt = ($scope.currentPage * 15)-15;
        };

        $scope.getOrganization = function(id)
        {
            var list = $scope.organizationsCollection.organizations.filter(function(obj)
            {
                return obj.id/1 === id/1;
            });

            return list.pop();
        };

        $scope.getFilteredUsers = function(organization_id)
        {
            return $scope.usersCollection.users.filter(function(user)
            {
                if (organization_id/1 === 1 && !user.organization_constitutional) { return false; }
                if (organization_id/1 === 2 && !user.organization_spirits) { return false; }
                return user.status && !user.is_admin;
            });
        };

        $scope.setSort = function(which)
        {
            $scope.sortedSeasonList = null;

            switch (which)
            {
                case 'organization':
                    if ($scope.sortType === 'organization') { $scope.sortType = '-organization'; }
                    else                                    { $scope.sortType = 'organization'; }
                    break;
                case 'startdate':
                    if ($scope.sortType === 'startdate') { $scope.sortType = '-startdate'; }
                    else                                 { $scope.sortType = 'startdate'; }
                    break;
                case 'enddate':
                    if ($scope.sortType === 'enddate') { $scope.sortType = '-enddate'; }
                    else                               { $scope.sortType = 'enddate'; }
                    break;
                case 'name' :
                    if ($scope.sortType === 'fullName') { $scope.sortType = '-fullName'; }
                    else                            { $scope.sortType = 'fullName'; }
                    break;
                case 'status':
                    if ($scope.sortType === 'status') { $scope.sortType = '-status'; }
                    else                              { $scope.sortType = 'status'; }
                    break;
            }

            var match = $scope.sortType.match('-');
            var reverse = match !== null;
            var field_name = $scope.sortType.replace('-', '');

            $scope.sortedSeasonList = $scope.seasonsCollection.seasons;

            var sortFunc = function($oa, $ob)
            {
                var $a, $b;

                switch (field_name)
                {
                    case 'organization' :
                        $a = ($scope.getOrganization($oa.organization_id)).name;
                        $b = ($scope.getOrganization($ob.organization_id)).name;
                        break;
                    case 'fullName':
                        $a = $oa.fullName;
                        $b = $ob.fullName;
                        break;
                    case 'status':
                        $a = $oa.status;
                        $b = $ob.status;
                        break;
                    case 'startdate':
                        $a = new Date($oa.startdate);
                        $b = new Date($ob.startdate);
                        break;
                    case 'enddate':
                        $a = new Date($oa.enddate);
                        $b = new Date($ob.enddate);
                        break;
                }

                if ($b === $a) { return 0; }

                if (reverse) { return $a < $b ? 1 : -1; }
                return $a < $b ? -1 : 1;
            };

            $scope.sortedSeasonList.sort(sortFunc);
        };

        $scope.saveSeason = function(season)
        {
            $scope.isSaving = true;
            season.save().then(function()
            {
                $scope.isSaving = false;
                $scope.editingSeasonName = null;
            });
        };

        $scope.editSeasonName = function(season)
        {
            $scope.editingSeasonName = season;
            setTimeout(function(){
                document.getElementById('season-name-' + season.id).focus();
            }, 60);
        };

        $scope.addNewSeason = function()
        {
            var season = new Season();
            season.organization_id = $scope.organizationsCollection.organizations[0].id;

            $scope.seasonsCollection.seasons.push(season);

            $scope.isSaving = true;
            season.save().then(function()
            {
                $scope.sortType = 'enddate';
                $scope.setSort('enddate');
                $scope.editSeasonName(season);
                $scope.isSaving = false;
            });
        };

        $scope.cloneSeason = function(oldSeason)
        {

            $scope.isSaving = true;

            var season = new Season();
            season.organization_id = oldSeason.organization_id;
            season.startdate = oldSeason.startdate;
            season.enddate = oldSeason.enddate;
            season.status = oldSeason.status;
            season.id = oldSeason.id;

            $scope.seasonsCollection.seasons.push(season);


            season.save('clone').then(function()
            {
                $scope.sortType = 'enddate';
                $scope.setSort('enddate');
                $scope.editSeasonName(season);
                $scope.weekdayAssignmentsCollection.reload();
                $scope.isSaving = false;
            });
        };

        $scope.deleteSeason = function(season)
        {
            if (confirm("Warning: Removing this season will remove ALL data dependent on this season.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingSeasonName = null;
                $scope.seasonsCollection.deleteSeason(season);
                var sortType = $scope.sortType.replace('-', '');
                $scope.setSort(sortType);
                $scope.setSort(sortType);
            }
        };

        $scope.toggleAssignmentsGroup = function(season)
        {
            if ($scope.openAssignmentsGroup !== null && $scope.openAssignmentsGroup.id/1 === season.id/1)
            {
                $scope.openAssignmentsGroup = null;
            } else
            {
                $scope.openAssignmentsGroup = season;
            }
        };

        $scope.setEditingAssignment = function(assignment)
        {
            if ($scope.editingAssignment !== null && $scope.editingAssignment === assignment)
            {
                $scope.editingAssignment = null;
            } else
            {
                $scope.editingAssignment = assignment;
                $scope.shiftAssignmentsCollection.reload(assignment.id);
            }
        };

        $scope.saveWeekdayAssignment = function(weekdayAssignment)
        {
            $scope.isSaving = true;
            weekdayAssignment.save().then(function()
            {
                // $scope.shiftAssignmentsCollection.assignments.forEach(function(assignment)
                // {
                //     if (assignment.weekdayassignment_id/1 === assignment.id/1)
                //     {
                //         assignment.save();
                //     }
                // });
                $scope.shiftAssignmentsCollection.reload(weekdayAssignment.id);
                $scope.editingAssignment = null;
                $scope.isSaving = false;
            });
        };

        $scope.deleteWeekdayAssignment = function(assignment)
        {
            if (confirm("Are you sure you wish to delete this assignment?"))
            {
                $scope.editingAssignment = null;
                $scope.weekdayAssignmentsCollection.deleteEntry(assignment);
            }
        };

        $scope.getDayType = function (id)
        {
            for (var i=0; i<$scope.dayTypesCollection.dayTypes.length; i++)
            {
                if ($scope.dayTypesCollection.dayTypes[i].id/1 === id/1)
                {
                    return $scope.dayTypesCollection.dayTypes[i];
                }
            }
            return { name : 'Undefined Day Type' };
        };

        $scope.getShiftAssignments = function(weekdayAssignment)
        {
            return $scope.shiftAssignmentsCollection.assignments.filter(function(shiftAssignment)
            {
                // if (weekdayAssignment.id/1 === shiftAssignment.weekdayassignment_id/1)
                // {
                //     console.log(weekdayAssignment, '=>', shiftAssignment);
                // }
                return weekdayAssignment.id/1 === shiftAssignment.weekdayassignment_id/1;
            });
        };

        $scope.addWeekdayAssignment = function(season)
        {
            var assignment = new WeekdayAssignment();
            assignment.season_id = season.id;
            assignment.daytype_id = $scope.dayTypesCollection.dayTypes[0].id;
            assignment.dayofweek = 0;

            $scope.isSaving = true;
            $scope.weekdayAssignmentsCollection.assignments.push(assignment);
            assignment.save().then(function()
            {
                $scope.isSaving = false;
                $scope.setEditingAssignment(assignment);
                $scope.shiftAssignmentsCollection.reload(assignment.id);
            });
        };

        $scope.getShift = function(id)
        {
            for (var i=0; i<$scope.shiftsCollection.shifts.length; i++)
            {
                if ($scope.shiftsCollection.shifts[i].id/1 === id/1)
                {
                    return $scope.shiftsCollection.shifts[i];
                }
            }
            return { name : 'Undefined Shift' };
        };

        var promises = [];

        promises.push($scope.user.load());
        promises.push($scope.seasonsCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.weekdayAssignmentsCollection.load());
        promises.push($scope.dayTypesCollection.load());
        promises.push($scope.shiftsCollection.load());
        /**
         * shift assignments list is massive, as of now over 1000 entries - this quickly exhausts browser memory
         * so each time we need to access the shift assignments we'll have to reload to only grab those shift assignments
         * that we need to work with right now
         */
        // promises.push($scope.shiftAssignmentsCollection.load());
        promises.push($scope.usersCollection.load());

        $q.all(promises).then(function()
        {
            $scope.sortedSeasonList = $scope.seasonsCollection.seasons;
            $scope.sortType = '-enddate';
        });
    }]);

})($, angular, document, window);
