(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('SearchTasksController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'TaskAssignmentCollectionFactory', 'TaskTypesCollectionFactory', 'UsersCollectionFactory',
    'OrganizationsCollectionFactory', 'GuideAssignmentCollectionFactory', 'TourTypesCollectionFactory',
    'EmailMessageFactory', 'IntraControllerActionHandlerFactory',
    function($q, $filter, $scope, $http, $window, $location, TaskAssignmentCollection, TaskTypesCollection,
             UsersCollection, OrganizationsCollection, GuideAssignmentCollection, TourTypesCollection, EmailMessage,
             IntraControllerActionHandler)
    {

        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;

        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();

        $scope.searchTasks = null;
        $scope.contactGuidesAssignment = null;
        $scope.emailMessage = null;

        $scope.sortedList = null;

        $scope.datePicker = {
            start : null,
            end : null
        };

        $scope.tinymceOptions = {
            branding : false,
            menubar : false,
            statusbar : false,
            toolbar: false,
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.startAt = null;
        $scope.sortType = null;
        $scope.currentPage = 1;

        $scope.pageItems = function()
        {
            $scope.startAt = ($scope.currentPage * 15) - 15;
        };

        $scope.contactGuides = function(taskAssignment)
        {
            $scope.emailMessage = new EmailMessage();
            $scope.emailMessage.messageType = 'SimpleEmailMessage';
            $scope.emailMessage.messageBody = null;
            $scope.emailMessage.messageSubject = $scope.getTaskTypeName(taskAssignment) + " on " +
                                        $filter('date')(taskAssignment.assignmentdate) + ' ' +
                                        $filter('date')(taskAssignment.starttime, 'h:mm a') + ' - ' +
                                        $filter('date')(taskAssignment.endtime, 'h:mm a') + ' ' +
                                        taskAssignment.tourname;

            $scope.contactGuidesAssignment = taskAssignment;

            var guides = $scope.getAssignedGuides(taskAssignment);

            $scope.emailMessage.messageRecipients = guides.map(function(guide)
            {
                return {
                    id      : guide.id,
                    name    : guide.name,
                    enabled : true
                };
            });
        };

        $scope.sendEmailMessage = function()
        {
            $scope.emailMessage.save().then(function(success)
            {
                if (success)
                {
                    $scope.emailMessage = null;
                    $scope.contactGuidesAssignment = null;
                }
            });
        };

        $scope.cancelEmailMessage = function()
        {
            $scope.emailMesage = null;
            $scope.contactGuidesAssignment = null;
        };

        $scope.getTourType = function(id)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === id/1;
            })).pop();
        };

        $scope.getGuide = function(userId)
        {
            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();
        };

        $scope.getAssignedGuides = function(taskAssignment)
        {
            if (taskAssignment)
            {
                var guideAssignments = $scope.getGuideAssignments(taskAssignment);
                return guideAssignments.map(function(assignment)
                {
                    return $scope.getGuide(assignment.guide_id/1);
                });
            }
            return [];
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            if (taskAssignment)
            {
                return $scope.guideAssignmentCollection.collection.filter(function(assignment)
                {
                    return assignment.taskassignment_id/1 === taskAssignment.id/1 && assignment.status;
                });
            }
            return [];
        };

        $scope.getAssignedGuidesNames = function(taskAssignment)
        {
            var assignedGuides = $scope.getAssignedGuides(taskAssignment);

            var names = assignedGuides.map(function(guide)
            {
                return guide.name;
            });

            return names.join(', ');
        };

        $scope.doSearch = function()
        {
            var startDate = null, endDate = null;

            if ($scope.datePicker.start) { startDate = new Date($scope.datePicker.start + ' 00:00:00'); }
            if ($scope.datePicker.end)   { endDate   = new Date($scope.datePicker.end   + ' 00:00:00'); }

            $scope.taskAssignmentCollection.reload(startDate, endDate, $scope.searchTasks).then(function()
            {
                $scope.taskAssignmentCollection.collection.sort(function(a, b)
                {
                    if (a.starttime.getTime() === b.starttime.getTime()) { return 0; }
                    return a.starttime > b.starttime ? -1 : 1;
                });
                $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection);
            });
        };

        $scope.getTaskType = function(taskAssignment)
        {
            if (taskAssignment)
            {
                return ($scope.taskTypesCollection.taskTypes.filter(function (taskType)
                {
                    return taskAssignment.tasktype / 1 === taskType.id;
                })).pop();
            }
        };

        $scope.getTaskTypeName = function(taskAssignment)
        {
            var taskType = $scope.getTaskType(taskAssignment);
            return taskType ? taskType.name : null;
        };

        $scope.openTourDetails = function(taskAssignment)
        {
            var day = new Date(taskAssignment.assignmentdate + ' 00:00:00');
            IntraControllerActionHandler.action = 'edit-task';
            IntraControllerActionHandler.model = taskAssignment;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/edit-task');
        };


        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());

        $q.all(promises).then(function()
        {
        });
    }]);

})($, angular, document, window);
