(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('SaveTheDateController', ['$q', '$scope', '$filter', '$http', '$window', '$location',
    'GuideAvailabilityCollectionFactory', 'UsersCollectionFactory', 'OrganizationsCollectionFactory',
    'MonthsFactory', 'ReservedDateCollectionFactory', 'ReservedDateFactory', 'EmailMessageFactory',
    function($q, $scope, $filter, $http, $window, $location, GuideAvailabilityCollection, UsersCollection,
             OrganizationsCollection, Months, ReservedDateCollection, ReservedDate, EmailMessage)
    {
        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.reservedDateCollection = ReservedDateCollection;
        $scope.months =  Months;
        $scope.selectedMonth = 'Jan';
        $scope.activeMonth = new Date().getMonth();
        $scope.currentMonth = new Date().getMonth() + 1;
        $scope.activeYear = new Date().getFullYear();
        $scope.currentYear = new Date().getFullYear();
        $scope.years = [];

        $scope.reservedDateCollection.empty();
        $scope.guideAvailabilityCollection.empty();

        $scope.isLoading = false;
        $scope.isSaving = false;
        $scope.sendSaveTheDate = false;
        $scope.sendEmails = [];

        $scope.activeDays = [];
        $scope.startDay = null;
        $scope.endDay = null;
        $scope.datePicker = {
            start : null,
            end : null
        };

        $scope.orgEnabled = {
            constitutional : true,
            spirits : true
        };

        $scope.checkOrganizations = function(which)
        {
            switch (which)
            {
                case 'constitutional':
                    if (!$scope.orgEnabled.constitutional && !$scope.orgEnabled.spirits)
                    {
                        $scope.orgEnabled.spirits = true;
                    }
                    break;
                case 'spirits':
                    if (!$scope.orgEnabled.constitutional && !$scope.orgEnabled.spirits)
                    {
                        $scope.orgEnabled.constitutional = true;
                    }
                    break;
            }
        };

        $scope.selectMonth = function(month)
        {
            if (month === -1)
            {
                $scope.activeMonth = 11;
                $scope.currentMonth = 12;
                $scope.activeYear = $scope.activeYear - 1;
            } else if (month === 12)
            {
                $scope.activeMonth = 0;
                $scope.currentMonth = 1;
                $scope.activeYear = $scope.activeYear + 1;
            } else
            {
                $scope.activeMonth = month/1;
                $scope.currentMonth = (month/1) + 1;
            }

            $scope.startDay = new Date($scope.activeYear, $scope.activeMonth);
            $scope.endDay = new Date($scope.activeYear, $scope.activeMonth + 1, 0);

            $scope.buildActiveDays();
        };

        $scope.setMonth = function()
        {
            $scope.activeMonth = $scope.months.indexOf($scope.selectedMonth);
            $scope.currentMonth = $scope.activeMonth + 1;

            $scope.startDay = new Date($scope.activeYear, $scope.activeMonth);
            $scope.endDay = new Date($scope.activeYear, $scope.activeMonth + 1, 0);

            $scope.buildActiveDays();
        };

        $scope.selectYear = function(year)
        {
            $scope.activeYear = year;
            $scope.selectMonth($scope.activeMonth);
        };

        $scope.getFilteredUsers = function()
        {
            return $scope.usersCollection.users.filter(function(user)
            {
                if (!user.status) { return false; }
                if (user.organization_constitutional && $scope.orgEnabled.constitutional) { return true; }
                if (user.organization_spirits && $scope.orgEnabled.spirits) { return true; }
            });
        };

        $scope.buildActiveDays = function(skipPicker)
        {
            $scope.isLoading = true;

            if (!skipPicker)
            {
                $scope.startDay.setYear($scope.activeYear);
                $scope.endDay.setYear($scope.activeYear);
                $scope.selectedMonth = $scope.months[$scope.startDay.getMonth()];
            }

            var day = new Date($scope.startDay);

            var activeDays = [];

            while (day <= $scope.endDay)
            {
                activeDays.push(day);
                day = day.addDays(1);
            }

            if (!skipPicker)
            {
                $scope.datePicker.start = $filter('date')($scope.startDay, 'MMM dd, yyyy');
                $scope.datePicker.end = $filter('date')($scope.endDay, 'MMM dd, yyyy');
            }

            $scope.activeDays = activeDays;

            var promises = [];


            /**
             * Make sure we reload the reserved dates collection when changing the dates
             * @type {boolean}
             */
            promises.push($scope.reservedDateCollection.reload($scope.startDay, $scope.endDay));

            /**
             * Reload the guide availabilities when changing dates
             */
            promises.push($scope.guideAvailabilityCollection.reload(undefined, $scope.startDay, $scope.endDay));

            $q.all(promises).then(function()
            {
                $scope.isLoading = false;
            });
        };

        $scope.pickDate = function(which)
        {
            $scope.startDay = new Date($scope.datePicker.start);
            $scope.endDay = new Date($scope.datePicker.end);

            switch (which)
            {
                case 'start':
                    if ($scope.startDay > $scope.endDay)
                    {
                        $scope.endDay = new Date($scope.startDay);
                        $scope.datePicker.end = $filter('date')($scope.endDay, 'MMM dd, yyyy');
                    }
                    break;
                case 'end':
                    if ($scope.endDay < $scope.startDay)
                    {
                        $scope.startDay = new Date($scope.endDay);
                        $scope.datePicker.start = $filter('date')($scope.startDay, 'MMM dd, yyyy');
                    }
                    break;
            }

            $scope.activeMonth = $scope.startDay.getMonth();
            $scope.currentMonth = $scope.activeMonth + 1;
            $scope.selectedMonth = $scope.months[$scope.startDay.getMonth()];

            $scope.activeYear = $scope.startDay.getFullYear();

            $scope.buildActiveDays(true);
        };

        $scope.getGuideReserved = function(guide)
        {
            var filteredReservedDates = $scope.reservedDateCollection.collection.filter(function(reservedDate)
            {
                if (!reservedDate.reserved) { return false; }
                if (reservedDate.guide_id/1 !== guide.id/1) { return false; }

                var rDate = new Date(reservedDate.reserveddate + ' 00:00:00');

                if (rDate < $scope.startDay || rDate > $scope.endDay) { return false; }

                return true;
            });

            return filteredReservedDates.length;
        };

        $scope.getTotalReserved = function(user)
        {
            var filteredReservedDates = $scope.reservedDateCollection.collection.filter(function(reservedDate)
            {
                if (!reservedDate.reserved) { return false; }
                if (reservedDate.guide_id/1 !== user.id/1) { return false; }

                if (!$scope.orgEnabled.constitutional && reservedDate.organization_id/1 === 1) { return false; }
                if (!$scope.orgEnabled.spirits && reservedDate.organization_id/1 === 2) { return false; }

                var rDate = new Date(reservedDate.reserveddate + ' 00:00:00');

                if (rDate < $scope.startDay || rDate > $scope.endDay) { return false; }
                return true;
            });

            return filteredReservedDates.length;
        };

        $scope.getDailyReserved = function(day)
        {
            var guides = $scope.getFilteredUsers();

            var guide_ids = guides.map(function (guide)
            {
                return guide.id / 1;
            });


            var filteredReservedDates = $scope.reservedDateCollection.collection.filter(function(reservedDate)
            {
                if (!reservedDate.reserved) { return false; }
                if (guide_ids.indexOf(reservedDate.guide_id) < 0) { return false; }

                var rDate = new Date(reservedDate.reserveddate + ' 00:00:00');

                if (!$scope.orgEnabled.spirits && reservedDate.organization_id/1 === 2) { return false; }
                if (!$scope.orgEnabled.constitutional && reservedDate.organization_id/1 === 1) { return false; }

                if (rDate.getFullYear() !== day.getFullYear()) { return false; }
                if (rDate.getMonth()    !== day.getMonth())    { return false; }
                if (rDate.getDate()     !== day.getDate())     { return false; }

                return true;
            });

            return filteredReservedDates.length;
        };

        $scope.isGuideAvailable = function(user)
        {
            var availabilities = $scope.guideAvailabilityCollection.availabilities.filter(function(availability)
            {
                if (availability.guide_id/1 !== user.id/1) { return false; }

                var date = new Date(availability.availabilitydate + ' 00:00:00');

                if (date < $scope.startDay || date > $scope.endDay) { return false; }

                return true;
            });

            return availabilities.length > 0;
        };

        $scope.getAvailabilities = function(day, user)
        {
            return $scope.guideAvailabilityCollection.availabilities.filter(function(availability)
            {

                if (availability.guide_id/1 !== user.id/1)    { return false; }

                var date = new Date(availability.availabilitydate + ' 00:00:00');

                if (date.getFullYear() !== day.getFullYear()) { return false; }
                if (date.getMonth()    !== day.getMonth())    { return false; }
                if (date.getDate()     !== day.getDate())     { return false; }

                return true;
            });

        };

        $scope.getOrganizationName = function(day, user)
        {
            var reservedDate = $scope.getReservedDates(day, user).pop();

            if (!reservedDate) { return null; }

            var org = ($scope.organizationsCollection.organizations.filter(function(organization)
            {
                return reservedDate.organization_id/1 === organization.id/1;
            })).pop();

            return org && org.name;
        };

        $scope.getAvailability = function(day, user)
        {
            var availabilities = $scope.getAvailabilities(day, user);

            if (availabilities.length > 0) { return availabilities[0]; }
        };

        $scope.getReservedDates = function(day, user)
        {
            if ($scope.isLoading) { return []; }

            var reservedDates = $scope.reservedDateCollection.collection.filter(function(reservedDate)
            {
                if (reservedDate.guide_id/1 !== user.id/1) { return false; }

                var date = new Date(reservedDate.reserveddate + " 00:00:00");

                if (date.getFullYear() !== day.getFullYear()) { return false; }
                if (date.getMonth()    !== day.getMonth())    { return false; }
                if (date.getDate()     !== day.getDate())     { return false; }

                return true;
            });

            if (reservedDates.length <= 0 && $scope.getAvailabilities(day, user).length > 0 &&
                (!$scope.orgEnabled.spirits || !$scope.orgEnabled.constitutional))
            {
                var reservedDate = new ReservedDate();
                reservedDate.organization_id = $scope.orgEnabled.constitutional ? 1 : 2;
                reservedDate.guide_id = user.id;
                reservedDate.reserveddate = $filter('date')(day, 'yyyy-MM-dd');
                reservedDate.reserved = false;

                reservedDate.id = 'new_' + (new Date().getTime());

                $scope.reservedDateCollection.collection.push(reservedDate);

                reservedDates.push(reservedDate);
            }

            return reservedDates;
        };

        $scope.getReservedDate = function(day, user, organization_id)
        {
            var reservedDates = $scope.getReservedDates(day, user).filter(function(reservedDate)
            {
                if (reservedDate.organization_id/1 !== organization_id/1) { return false; }
            });

            if (reservedDates.length > 0) { return reservedDates[0]; }
        };

        $scope.isReserved = function(day, user)
        {
            var reserved = false;

            var reservedDates = $scope.getReservedDates(day, user);

            reservedDates.map(function(reservedDate)
            {
                reserved = ($scope.orgEnabled.constitutional && reservedDate.organization_id/1 === 1 && reservedDate.reserved) ? true : reserved;
                reserved = ($scope.orgEnabled.spirits        && reservedDate.organization_id/1 === 2 && reservedDate.reserved) ? true : reserved;
            });

            return reserved;
        };

        $scope.saveProgress = 0;

        $scope.saveChanges = function()
        {
            // $scope.sendSaveTheDate

            var emailMessage = new EmailMessage();
            emailMessage.messageType = 'SaveTheDateMailer';
            emailMessage.messageSubject = '';
            emailMessage.messageBody = '';
            emailMessage.messageRecipients = [];
            emailMessage.messageOptions = {
                startDate : $scope.startDay,
                endDate : $scope.endDay,
                organizationId : $scope.orgEnabled.constitutional ? 1 : 2
            };

            var promises = [];

            $scope.isSaving = true;

            var totalToMail = 0;
            var totalToSave = 0;
            var totalSaved = 0;

            var updateProgressBar = function()
            {
                var percentage = ((totalSaved / totalToSave) * 100).toFixed(0)/1;
                $scope.saveProgress = percentage;

                $('#progress-bar').css({
                    width : percentage + '%'
                });
            };


            for (var i=0; i<$scope.sendEmails.length; i++)
            {
                if ($scope.sendEmails[i])
                {
                    totalToMail++;
                    emailMessage.messageRecipients.push({
                        id : i,
                        enabled : true,
                        name : null,
                        email : null
                    });
                }

            }

            $scope.reservedDateCollection.collection.map(function(reservedDate)
            {
                if (reservedDate.reserved && !reservedDate.emaildate && $scope.sendSaveTheDate)
                {
                    reservedDate.emaildate = new Date();
                }
                
                if (reservedDate.changed)
                {
                    totalToSave++;

                    promises.push(reservedDate.save().then(function()
                    {
                        totalSaved++;
                        updateProgressBar();
                    }));
                }
            });

            $q.all(promises).then(function()
            {
                $scope.isSaving = false;

                setTimeout(function()
                {
                    totalSaved = 0;
                    updateProgressBar();
                }, 1000);

                if ($scope.sendSaveTheDate && totalToMail > 0)
                {
                    emailMessage.save();
                }
            });
        };


        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());

        $scope.isLoading = true;

        $q.all(promises).then(function()
        {
            $scope.isLoading = false;

            var newDate = new Date();

            for (var year = 2008; year <= new Date().getFullYear(); year++)
            {
                $scope.years.push(year);
            }

            $scope.startDay = new Date(newDate.getFullYear(), newDate.getMonth());
            $scope.endDay = new Date(newDate.getFullYear(), newDate.getMonth() + 1, 0);

            $scope.buildActiveDays();
        });
    }]);

})($, angular, document, window);
