(function ($, angular, document, window)
{
    angular.module('phillyByFoot').controller('NavigationController',
    ['$scope', '$location', '$route', '$q', 'NavigationFactory', 'StaticUserFactory', 'PayPeriodFactory',
    function ($scope, $location, $route, $q, Navigation, StaticUser, PayPeriod)
    {
        $scope.payPeriod = PayPeriod;
        $scope.staticUser = StaticUser;
        $scope.openSubnav = '';
        $scope.navigationRoutes = Navigation;

        PayPeriod.updatePayPeriod(0);

        $scope.isSmallScreen = function()
        {
            return $(window).width() <= 1024;
        };

        $scope.canShow = function(nav)
        {
            if (nav.skip) { return false; }
            if (nav.admin && !$scope.staticUser.is_admin) { return false; }
            if (nav.noadmin && $scope.staticUser.is_admin) { return false; }
            return true;
        };

        $scope.toggleSubnav = function(section)
        {
            if (section == $scope.openSubnav)
            {
                $scope.openSubnav = '';
                return;
            }
            $scope.openSubnav = section;
        };

        $scope.isActiveNav = function (viewLocation)
        {
            var path = $location.path();

            if (viewLocation === '/wstr/members#/manage-account' && path === '/manage-account')
            {
                return true;
            }

            if (viewLocation.url === path) { return true; }

            for (var idx in viewLocation.subSections)
            {
                var subsection = viewLocation.subSections[idx];
                if (subsection.url === path) { return true; }
            }
            return false;
        };


        $scope.postLoad = function()
        {
            /**
             *
             */
            if (!$scope.navigationRoutes.isLoaded)
            {
                return setTimeout($scope.postLoad, 100);
            }

            if (StaticUser.change_password && 1 * StaticUser.change_password === 1)
            {
                window.location.href = '/wstr/members/#/new-password';
            }


            $scope.navigationRoutes.loadComplete = true;
        };

        $scope.toggleSlideMenu = function()
        {
            var $slidebar = $('.ms-slidebar');

            if ($slidebar.hasClass('open'))
            {
                $slidebar.removeClass('open');
            } else
            {
                $slidebar.addClass('open');
            }
        };

        $scope.toggleSlideNavSection = function(nav)
        {
            nav.collapsed = !nav.collapsed;
        };

        var promises = [];

        promises.push($scope.staticUser.load());

        $q.resolve(promises).then(function()
        {
            $scope.postLoad();
        });

    }]);

})(jQuery, angular, document, window);
