(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('AdminTaskManagerController', ['$q','$filter','$scope', '$http', '$window', '$location',
    'OrganizationsCollectionFactory', 'TaskTypesCollectionFactory', 'TourTypesCollectionFactory', 'UsersCollectionFactory',
    'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory', 'TaskAssignmentFactory', 'HourSelectFactory',
    'MinuteSelectFactory', 'GuideAvailabilityCollectionFactory', 'GuideAssignmentFactory', 'IntraControllerActionHandlerFactory',
    function($q, $filter, $scope, $http, $window, $location, OrganizationsCollection, TaskTypesCollection,
             TourTypesCollection, UsersCollection, TaskAssignmentCollection, GuideAssignmentCollection, TaskAssignment,
             HourSelect, MinuteSelect, GuideAvailabilityCollection, GuideAssignment, IntraControllerActionHandler)
    {

        window.scrollTo(0,0);

        if (!IntraControllerActionHandler.model)
        {
            $scope.activeTaskAssignment = null;

            $location.path(IntraControllerActionHandler.returnPath ? IntraControllerActionHandler.returnPath : '/admin/calendar');
            return;
        }

        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.usersCollection = UsersCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.hourOptions = HourSelect;
        $scope.minuteOptions = MinuteSelect;
        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();
        $scope.guideAvailabilityCollection.empty();

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.isCloning = false;
        $scope.isSaving = false;
        $scope.activeDay = null;
        $scope.activeTaskAssignment = null;
        $scope.showTaskType = null;
        $scope.leadGuideStatusMap = [];
        $scope.filteredUsers = [];
        $scope.changesActive = false;

        $scope.getTaskType = function(taskAssignment)
        {
            return ($scope.taskTypesCollection.taskTypes.filter(function(type)
            {
                return type.id/1 === taskAssignment.tasktype/1;
            })).pop();
        };

        $scope.getTourType = function(taskAssignment)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(type)
            {
                return type.id/1 === taskAssignment.tourtype/1;
            })).pop();
        };

        $scope.hasOtherAssignments = function(user, day)
        {
            var other = $scope.getOtherAssignments(user, day);
            return other.length > 0;
        };

        $scope.getOtherAssignments = function(user, day)
        {
            var otherAssignments = $scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                var assignmentDate = new Date(taskAssignment.assignmentdate + ' 00:00:00');

                if (assignmentDate.getTime() === day.getTime())
                {
                    var guideAssignment = $scope.getGuideAssignment(user, taskAssignment);
                    return guideAssignment.status;
                }

                return false;
            });

            return otherAssignments;
        };

        $scope.scheduleConflict = function(user, activeTaskAssignment, day)
        {
            if (!$scope.hasOtherAssignments(user, day))
            {
                return false;
            }

            var otherAssignments = $scope.getOtherAssignments(user, day).filter(function(assignment)
            {
                /**
                 * Other assignment is the same as the active assignment, remove this from our list
                 */
                if (activeTaskAssignment.id/1 === assignment.id/1) { return false; }

                var activeTaskStart = activeTaskAssignment.starttime;
                var activeTaskEnd = activeTaskAssignment.endtime;
                var otherAssignmentStart = assignment.starttime;
                var otherAssignmentEnd = assignment.endtime;

                /**
                 * Other Assignment ends before or starts after the active task, remove from our list
                 */
                if (activeTaskStart > otherAssignmentEnd || activeTaskEnd < otherAssignmentStart) { return false; }

                /**
                 * Other assignment starts before active task ends, keep it
                 */
                if (activeTaskStart <= otherAssignmentStart && activeTaskEnd > otherAssignmentStart) { return true; }

                /**
                 * Active task starts before other assignment ends, keep it
                 */
                if (otherAssignmentStart <= activeTaskStart && otherAssignmentStart > activeTaskEnd) { return true; }


            });

            return (otherAssignments.length > 0);
        };

        $scope.reloadTaskModels = function()
        {
            var startDate = new Date($scope.activeTaskAssignment.assignmentdate + " 00:00:00");

            /**
             * Avoid race condition
             */
            if ($scope.guideAvailabilityCollection.isLoading ||
                $scope.taskAssignmentCollection.isLoading ||
                $scope.guideAssignmentCollection.isLoading)
            {
                setTimeout(function()
                {
                    $scope.reloadTaskModels();
                }, 200);
                return;
            }

            $scope.activeDay = startDate;
            $scope.guideAvailabilityCollection.reload(null, startDate.addDays(-30), startDate.addDays(+30));
            $scope.taskAssignmentCollection.reload(startDate.addDays(-30), startDate.addDays(+30)).then(function()
            {
                $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection);
            });
        };

        $scope.getFilteredUsers = function()
        {
            if ($scope.filteredUsers.length)
            {
                return $scope.filteredUsers;
            }
            $scope.filteredUsers = $scope.usersCollection.users.filter(function(user)
            {
                return user.status && !user.is_admin;
            });
            return $scope.filteredUsers;
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            if (!taskAssignment) { return []; }
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.getGuideAssignment = function(user, taskAssignment)
        {
            var guideAssignment = ($scope.guideAssignmentCollection.collection.filter(function (guideAssignment)
            {
                return guideAssignment.taskassignment_id / 1 === taskAssignment.id / 1 &&
                       guideAssignment.guide_id / 1 === user.id / 1;
            })).pop();

            if (!guideAssignment)
            {
                guideAssignment = new GuideAssignment();
                guideAssignment.taskassignment_id = taskAssignment.id / 1;
                guideAssignment.guide_id = user.id / 1;
                guideAssignment.status = false;
                $scope.guideAssignmentCollection.collection.push(guideAssignment);
            }

            return guideAssignment;
        };

        $scope.getAvailability = function(user, day)
        {
            var availabilities = $scope.guideAvailabilityCollection.availabilities.filter(function(guideAvailability)
            {
                if (guideAvailability.guide_id/1 !== user.id/1) { return false; }

                var availabilityDate = new Date(guideAvailability.availabilitydate + ' 00:00:00');
                return availabilityDate >= day && availabilityDate <= day;
            });
            return availabilities;
        };

        $scope.updateLeadGuideStatus = function(user, taskAssignment)
        {
            if (taskAssignment.guide_id/1 === user.id/1)
            {
                taskAssignment.guide_id = 0;
            } else
            {
                taskAssignment.guide_id = user.id/1;
            }
            taskAssignment.leadguidegivingtour = false;

            $scope.leadGuideStatusMap.forEach(function(leadGuideStatus)
            {
                leadGuideStatus.enabled = (taskAssignment.guide_id/1 === leadGuideStatus.guide_id/1);
            });
        };

        $scope.getLeadGuideStatus = function(user, taskAssignment)
        {
            var leadGuideStatus = ($scope.leadGuideStatusMap.filter(function (status)
            {
                return status.guide_id / 1 === user.id / 1 &&
                       status.taskassignment_id / 1 === taskAssignment.id;
            })).pop();

            if (!leadGuideStatus)
            {
                leadGuideStatus = {
                    guide_id: user.id / 1,
                    taskassignment_id: taskAssignment.id / 1,
                    enabled: user.id / 1 === taskAssignment.guide_id / 1
                };
                $scope.leadGuideStatusMap.push(leadGuideStatus);
            }

            return leadGuideStatus;
        };

        $scope.isGuideAvailable = function(user, day, activeTaskAssignment)
        {
            var availabilityList = $scope.getAvailability(user, day).filter(function (guideAvailability)
            {
                // if (activeTaskAssignment)
                // {
                //     return (guideAvailability.starttime <= activeTaskAssignment.starttime &&
                //             guideAvailability.endtime > activeTaskAssignment.endtime);
                // }
                return true;
            });

            return availabilityList.length > 0;
        };

        $scope.guidesAvailable = function(activeTaskAssignment)
        {
            var availabilities = $scope.guideAvailabilityCollection.availabilities.filter(function (guideAvailability)
            {

                return (guideAvailability.starttime <= activeTaskAssignment.starttime &&
                        guideAvailability.endtime > activeTaskAssignment.endtime);
            });

            return availabilities.length > 0;
        };

        $scope.guidesAssigned = function(taskAssignment)
        {
            if (!taskAssignment) { return false; }
            var guideAssignments = $scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.status;
            });

            if (guideAssignments.length <= 0) { return false; }

            return true;
        };

        $scope.updateNumGuidesRequired = function(taskAssignment)
        {
            taskAssignment.numguidesrequired = Math.ceil(taskAssignment.numpersonsontour/40);
        };

        $scope.cloneAssignment = function(taskAssignment)
        {

            $scope.isSaving = true;
            $scope.isCloning = true;

            var newTaskAssignment = new TaskAssignment();
            newTaskAssignment.id = null;
            newTaskAssignment.shiftassignment_id    = taskAssignment.shiftassignment_id;
            newTaskAssignment.organization_id       = taskAssignment.organization_id;
            newTaskAssignment.task_id               = taskAssignment.task_id;
            newTaskAssignment.tasktype              = taskAssignment.tasktype;
            newTaskAssignment.assignmentdate        = $filter('date')(new Date(taskAssignment.assignmentdate), 'MMM dd, yyyy');
            newTaskAssignment.start_hour            = taskAssignment.start_hour;
            newTaskAssignment.start_minute          = taskAssignment.start_minute;
            newTaskAssignment.end_hour              = taskAssignment.end_hour;
            newTaskAssignment.end_minute            = taskAssignment.end_minute;
            newTaskAssignment.tourtype              = taskAssignment.tourtype;
            newTaskAssignment.numpersonsontour      = taskAssignment.numpersonsontour;
            newTaskAssignment.tourcontactname       = taskAssignment.tourcontactname;
            newTaskAssignment.tourcontactphone      = taskAssignment.tourcontactphone;
            newTaskAssignment.tourcontactemail      = taskAssignment.tourcontactemail;
            newTaskAssignment.notes                 = taskAssignment.notes;
            newTaskAssignment.status                = taskAssignment.status;
            newTaskAssignment.numguidesrequired     = taskAssignment.numguidesrequired;
            newTaskAssignment.tourname              = taskAssignment.tourname;
            newTaskAssignment.paymentstatus         = taskAssignment.paymentstatus;
            newTaskAssignment.paymentnotes          = taskAssignment.paymentnotes;
            newTaskAssignment.thankyouemailto       = taskAssignment.thankyouemailto;
            newTaskAssignment.leadguidegivingtour   = taskAssignment.leadguidegivingtour;
            newTaskAssignment.updateTimes();

            $scope.activeTaskAssignment = newTaskAssignment;

            setTimeout(function()
            {
                $scope.isSaving = false;
                $scope.isCloning = false;
                try {
                    $scope.$digest();
                } catch (e) {}
            }, 1000);
        };

        $scope.deleteAssignment = function(taskAssignment, $event)
        {
            if (confirm("Are you sure you wish to delete this Task?"))
            {
                $scope.isSaving = true;
                $scope.taskAssignmentCollection.deleteEntry(taskAssignment).then(function()
                {
                    $scope.isSaving = false;
                    $scope.returnToCalendar();
                });
            }

            if ($event)
            {
                if ($event.stopPropagation) { $event.stopPropagation(); }
                if ($event.preventDefault)  { $event.preventDefault();  }
                $event.cancelBubble = true;
                $event.returnValue = false;
            }
        };

        $scope.saveAssignment = function(taskAssignment)
        {
            if (!taskAssignment.organization_id ||
                !taskAssignment.tasktype ||
                !taskAssignment.starttime ||
                !taskAssignment.endtime ||
                taskAssignment.starttime > taskAssignment.endtime)
            {
                alert("There are errors in your form.  Please check and try again");
                return;
            }

            $scope.updateTimes(taskAssignment);

            var userConflict = false;

            var assignmentDate = new Date(taskAssignment.assignmentdate + " 00:00:00");

            $scope.getFilteredUsers().forEach(function(user)
            {
                if (userConflict) { return; }

                var assigned = $scope.getGuideAssignment(user, taskAssignment).status;

                if (assigned && $scope.scheduleConflict(user, taskAssignment, assignmentDate))
                {
                    userConflict = user;
                }
            });

            if (userConflict)
            {
                alert("Unable to update task due to schedule conflict: "+ userConflict.name + " is has tasks assigned for the date and time specified.");
                return;
            }

            $scope.isSaving = true;

            var doPush = !taskAssignment.id;

            var promises = [];
            promises.push(taskAssignment.save());

            $scope.getGuideAssignments(taskAssignment).forEach(function(guideAssignment)
            {
                if (guideAssignment.id/1 > 0 || guideAssignment.status)
                {
                    promises.push(guideAssignment.save());
                }
            });

            $q.all(promises).then(function()
            {
                $scope.changesActive = false;
                $scope.isSaving = false;
                $scope.reloadTaskModels();
                if (doPush)
                {
                    $scope.taskAssignmentCollection.collection.push(taskAssignment);
                }
            });
        };

        $scope.updateTimes = function(activeTaskAssignment)
        {
            activeTaskAssignment.updateTimes();
        };

        $scope.openDayDetails = function(day)
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/edit-task';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.action = 'open-day-details';
            IntraControllerActionHandler.model = null;

            $scope.changesActive = null;

            $location.path('/admin/day-details');
        };

        $scope.sendConfirmationEmail = function(taskAssignment)
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/edit-task';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.model = IntraControllerActionHandler.model;//taskAssignment;
            IntraControllerActionHandler.date = $scope.activeDay;
            IntraControllerActionHandler.action = 'send-confirmation-email';
            $scope.changesActive = null;

            $location.path('/admin/tour-email');
        };

        $scope.sendThankYouEmail = function(taskAssignment)
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/edit-task';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = $scope.activeDay;
            IntraControllerActionHandler.model = IntraControllerActionHandler.model; //taskAssignment;
            IntraControllerActionHandler.action = 'send-thank-you-email';
            $scope.changesActive = null;

            $location.path('/admin/tour-email');
        };

        $scope.contactGuides = function(taskAssignment)
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/edit-task';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = null;
            IntraControllerActionHandler.model = IntraControllerActionHandler.model; //taskAssignment;
            IntraControllerActionHandler.action = 'contact-assigned-guides';
            $scope.changesActive = null;

            $location.url('/admin/contact-guides');
        };

        $scope.returnToCalendar = function()
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                    return;
            }
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/edit-task';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.action = null;
            IntraControllerActionHandler.date = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = null;

            $location.path('/admin/calendar');
        };

        var promises = [];

        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.usersCollection.load());

        $q.all(promises).then(function()
        {
            IntraControllerActionHandler.stopEvents = true;
            $scope.activeTaskAssignment = IntraControllerActionHandler.model;
            $scope.activeDay = IntraControllerActionHandler.date;

            $scope.reloadTaskModels();

            $scope.$watchCollection('activeTaskAssignment', function(newValue, oldValue)
            {
                if (newValue && oldValue)
                {
                    Object.keys(newValue).forEach(function (property)
                    {
                        if (property === 'thankyouemaildate' || property === 'confirmationemaildate' ||
                            property === 'thankyouemailto') { return; }

                        if (newValue.hasOwnProperty(property) && typeof newValue[property] !== 'function')
                        {
                            if (newValue[property] !== oldValue[property])
                            {
                                $scope.changesActive = true;
                            }
                        }
                    });
                }
            });
        });
    }]);

})($, angular, document, window);
