(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('AdminTaskListController', ['$q','$filter','$scope', '$http', '$window', '$location', 'StaticUserFactory',
    'MonthsFactory', 'OrganizationsCollectionFactory', 'TaskTypesCollectionFactory', 'TourTypesCollectionFactory',
    'UsersCollectionFactory', 'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory',
    'TaskAssignmentFactory', 'HourSelectFactory', 'MinuteSelectFactory', 'GuideAvailabilityCollectionFactory',
    'GuideAssignmentFactory', 'ShiftsCollectionFactory', 'ShiftAssignmentsCollectionFactory',
    'GuideShiftAssignmentCollectionFactory', 'GuideShiftAssignmentFactory', 'EmailMessageFactory',
    'EmailTemplateCollectionFactory', 'CalendarFactory', 'IntraControllerActionHandlerFactory',
    function($q, $filter, $scope, $http, $window, $location, StaticUser, months, OrganizationsCollection,
             TaskTypesCollection, TourTypesCollection, UsersCollection, TaskAssignmentCollection,
             GuideAssignmentCollection, TaskAssignment, HourSelect, MinuteSelect, GuideAvailabilityCollection,
             GuideAssignment, ShiftsCollection, ShiftAssignmentsCollection, GuideShiftAssignmentCollection,
             GuideShiftAssignment, EmailMessage, EmailTemplateCollection, Calendar, IntraControllerActionHandler)
    {
        window.scrollTo(0,0);

        if (!IntraControllerActionHandler.date)
        {
            $location.path(IntraControllerActionHandler.returnPath ? IntraControllerActionHandler.returnPath : '/admin/calendar');
            return;
        }

        $scope.staticUser = StaticUser;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.usersCollection = UsersCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.shiftsCollection = ShiftsCollection;
        $scope.shiftAssignmentsCollection = ShiftAssignmentsCollection;
        $scope.guideShiftAssignmentCollection = GuideShiftAssignmentCollection;
        $scope.emailTemplateCollection = EmailTemplateCollection;
        $scope.hourOptions = HourSelect;
        $scope.minuteOptions = MinuteSelect;
        $scope.emailMessage = null;
        $scope.calendar = Calendar;

        $scope.tinymceOptions = {
            branding : false,
            menubar : false,
            statusbar : false,
            toolbar: false,
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };


        $scope.dayTimes = [];

        $scope.isCloning = false;
        $scope.isSaving = false;
        $scope.isEditing = false;
        $scope.editType = null;
        $scope.activeDay = null;
        $scope.activeTaskAssignment = null;
        $scope.showTaskType = null;
        $scope.leadGuideStatusMap = [];
        $scope.filteredUsers = [];
        $scope.filteredTaskAssignments = [];
        $scope.changesActive = false;
        $scope.showUnavailableGuides = false;
        $scope.guideShiftAssignment = {};
        $scope.timeAvailabilityList = {};


        $scope.orgEnabled = {
            constitutional : true,
            spirits : false
        };

        $scope.toggleOrganizations = function(which)
        {
            if (!which) { return; }

            if (which === 'spirits')
            {
                $scope.orgEnabled.constitutional = !$scope.orgEnabled.constitutional;
            } else
            {
                $scope.orgEnabled.spirits = !$scope.orgEnabled.spirits;
            }
            $scope.filteredUsers = [];
            $scope.filteredTaskAssignments = [];
        };

        $scope.getTourType = function(id)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === id/1;
            })).pop();
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.getAssignedGuides = function (taskAssignment)
        {
            if (!taskAssignment) { return []; }

            return $scope.getGuideAssignments(taskAssignment)
            .filter(function(guideAssignment)
            {
                return guideAssignment.status;
            })
            .map(function(guideAssignment)
            {
                return $scope.getGuide(guideAssignment.guide_id);
            });
        };

        $scope.getAssignedGuidesNames = function(taskAssignment)
        {
            if (!taskAssignment) { return null; }

            var assignedGuides = $scope.getAssignedGuides(taskAssignment);

            var names = assignedGuides.map(function(guide)
            {
                return guide.name;
            });

            return names.join(', ');
        };

        $scope.getGuide = function(userId)
        {
            if (!userId) { return null; }

            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();
        };

        $scope.guidesAssigned = function(taskAssignment)
        {
            var guideAssignments = $scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.status;
            });

            if (guideAssignments.length <= 0) { return false; }

            if (taskAssignment.tourtype/1 === 1 && guideAssignments.length >= 1)
            {
                return true;
            } else if (guideAssignments.length >= taskAssignment.numguidesrequired/1)
            {
                return true;
            }
            return false;
        };

        $scope.getFilteredTaskAssignments = function()
        {
            if ($scope.filteredTaskAssignments.length)
            {
                return $scope.filteredTaskAssignments;
            }

            $scope.filteredTaskAssignments = $scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                var assignmentDate = new Date(taskAssignment.assignmentdate + " 00:00:00");

                if ($scope.orgEnabled.constitutional && taskAssignment.organization_id/1 !== 1) { return false; }
                if ($scope.orgEnabled.spirits        && taskAssignment.organization_id/1 !== 2) { return false; }

                if ($scope.activeDay < assignmentDate || $scope.activeDay > assignmentDate) { return false; }
                if (taskAssignment.tasktype/1 !== 1) { return false; }
                if ($scope.showTaskType !== 'private' && taskAssignment.tourtype/1 === 1) { return true; }
                return $scope.showTaskType === 'private' && taskAssignment.tourtype/1 !== 1;
            });

            $scope.filteredTaskAssignments = uniqueArray($scope.filteredTaskAssignments);

            return $scope.filteredTaskAssignments;
        };

        $scope.showPrivate = function()
        {
            window.scrollTo(0,0);
            $scope.showTaskType = 'private';
            $scope.filteredTaskAssignments = [];
        };

        $scope.showWalkUp = function()
        {
            window.scrollTo(0,0);
            $scope.showTaskType = 'walk-up';
            $scope.filteredTaskAssignments = [];
        };

        /**
         * FIXME: should the return path after contacting the guides be this list or the task???
         */
        $scope.contactGuides = function(taskAssignment)
        {
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;
            IntraControllerActionHandler.returnPath = '/admin/task-list';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = $scope.activeDay;
            IntraControllerActionHandler.model = taskAssignment;
            IntraControllerActionHandler.action = 'contact-assigned-guides';
            $scope.changesActive = null;

            $location.url('/admin/contact-guides');
        };

        $scope.openTourDetails = function(taskAssignment, day)
        {
            IntraControllerActionHandler.action = 'edit-task';
            IntraControllerActionHandler.model = taskAssignment;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/edit-task');
        };

        $scope.addNewTour = function(day)
        {
            IntraControllerActionHandler.action = 'new-task';
            IntraControllerActionHandler.model = new TaskAssignment();
            IntraControllerActionHandler.model.organization_id = 1;
            IntraControllerActionHandler.model.assignmentdate = $filter('date')(day, 'MMM dd, yyyy');
            IntraControllerActionHandler.model.numguidesrequired = 0;
            IntraControllerActionHandler.model.numpersonsontour = 0;
            IntraControllerActionHandler.model.tourtype = 0;
            IntraControllerActionHandler.model.paymentstatus = '0';
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/edit-task');
        };

        $scope.returnToPreviousController = function()
        {
            IntraControllerActionHandler.model = IntraControllerActionHandler.priorModel;
            IntraControllerActionHandler.action = IntraControllerActionHandler.priorAction;
            IntraControllerActionHandler.date = IntraControllerActionHandler.priorDate;
            IntraControllerActionHandler.returnPath = IntraControllerActionHandler.priorReturnPath;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = false;

            $location.path($scope.returnPath);
        };

        $scope.openDayDetails = function(day)
        {
            IntraControllerActionHandler.action = 'open-day-details';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/day-details');
        };

        var promises = [];

        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.usersCollection.load());
        promises.push($scope.shiftsCollection.load());
        promises.push($scope.emailTemplateCollection.load());

        $q.all(promises).then(function()
        {
            IntraControllerActionHandler.stopEvents = false;
            $scope.activeDay = IntraControllerActionHandler.date;
            $scope.returnPath = IntraControllerActionHandler.returnPath;

            if (IntraControllerActionHandler.action === 'show-walkup')
            {
                $scope.showWalkUp();
            } else {
                $scope.showPrivate();
            }

        });
    }]);

})($, angular, document, window);
