(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('AdminCalendarController', ['$q','$filter','$scope', '$http', '$window', '$location',
    'TaskTypesCollectionFactory', 'TourTypesCollectionFactory','TaskAssignmentCollectionFactory',
    'GuideAssignmentCollectionFactory','CalendarFactory', 'IntraControllerActionHandlerFactory',
    'TaskAssignmentFactory',
    function($q, $filter, $scope, $http, $window, $location, TaskTypesCollection,
             TourTypesCollection, TaskAssignmentCollection, GuideAssignmentCollection, Calendar,
             IntraControllerActionHandler, TaskAssignment)
    {
        window.scrollTo(0,0);
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.calendar = Calendar;

        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();

        $scope.updateMonthCallback = function(firstDayOfMonth, lastDayOfMonth)
        {
            $scope.taskAssignmentCollection.reload(firstDayOfMonth, lastDayOfMonth).then(function()
            {
                $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection);
            });
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.guidesAssigned = function(taskAssignment)
        {
            var guideAssignments = $scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.status;
            });

            if (guideAssignments.length <= 0) { return false; }

            if (taskAssignment.tourtype/1 === 1 && guideAssignments.length >= 1)
            {
                return true;
            } else if (guideAssignments.length >= taskAssignment.numguidesrequired/1)
            {
                return true;
            }
            return false;
        };

        $scope.hasTours = function(day, organization_id)
        {
            return $scope.getTours(day, organization_id).length;
        };

        $scope.getTours = function(day, organization_id)
        {
            return $scope.taskAssignmentCollection.getTaskAssignments(day, organization_id).filter(function(taskAssignment)
            {
                return taskAssignment.tasktype/1 === 1;
            });
        };

        $scope.getToursCount = function(day)
        {
            var c_tours = $scope.getTours(day, 1);
            var s_tours = $scope.getTours(day, 2);

            return (c_tours.length + s_tours.length);
        };

        $scope.addNewTour = function(day)
        {
            IntraControllerActionHandler.action = 'new-task';
            IntraControllerActionHandler.model = new TaskAssignment();
            IntraControllerActionHandler.model.organization_id = 1;
            IntraControllerActionHandler.model.assignmentdate = $filter('date')(day, 'MMM dd, yyyy');
            IntraControllerActionHandler.model.numguidesrequired = 0;
            IntraControllerActionHandler.model.numpersonsontour = 0;
            IntraControllerActionHandler.model.tourtype = 0;
            IntraControllerActionHandler.model.paymentstatus = '0';
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/edit-task');
        };

        $scope.openTourDetails = function(taskAssignment, day)
        {
            IntraControllerActionHandler.action = 'edit-task';
            IntraControllerActionHandler.model = taskAssignment;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/edit-task');
        };

        $scope.openDayDetails = function(day)
        {
            IntraControllerActionHandler.action = 'open-day-details';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/day-details');
        };

        $scope.showPrivate = function(day)
        {
            IntraControllerActionHandler.action = 'show-private';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/task-list');
        };

        $scope.showWalkUp = function(day)
        {
            IntraControllerActionHandler.action = 'show-walkup';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/task-list');
        };

        $scope.contactGuides = function()
        {
            IntraControllerActionHandler.action = 'contact-guides';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = null;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/calendar';

            $location.path('/admin/contact-guides');
        };

        var promises = [];

        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());

        $q.all(promises).then(function()
        {
            $scope.calendar.updateMonth($scope.updateMonthCallback);
        });
    }]);

})($, angular, document, window);
