(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('AccountController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'StaticUserFactory',
    function($q, $filter, $scope, $http, $window, $location, staticUser)
    {
        $scope.user = staticUser;
        $scope.phoneRegex = new RegExp(/^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/);

        $scope.formOkay = function()
        {
            var user = $scope.user;

            return !!user.email && !!user.username && user.username.length > 5 &&
                   !!user.name && user.name.length > 5 &&
                   (user.homephone ? user.homephone.match($scope.phoneRegex) : true) &&
                   (user.cellphone ? user.cellphone.match($scope.phoneRegex) : true) &&
                   (user.password ? (
                        user.new_password && user.password_verify &&
                        user.new_password === user.password_verify && user.passwordOkay()
                   ) : true)
                ;
        };

        $scope.saveUser = function()
        {
            $scope.user.save(!!$scope.user.new_password).then(function()
            {
                $scope.user.new_password = null;
                $scope.user.password_verify = null;
            });
        };

        var promises = [];

        promises.push($scope.user.load());

        $q.all(promises).then(function()
        {
        });
    }]);

})($, angular, document, window);
