<?php
/**
 * Display all errors when APPLICATION_ENV is development.
 */

if (getenv('APPLICATION_ENV') == 'development') {
    error_reporting(E_ALL);
    ini_set("display_errors", 1);
}
/**
 * This makes our life easier when dealing with paths. Everything is relative
 * to the application root now.
 */
chdir(dirname(__DIR__)); 

// Setup autoloading
require 'init_autoloader.php';

// Run the application!
// Laminas\Mvc\Application::init(require 'config/application.config.php')->run();

// Load application config
$app = Laminas\Mvc\Application::init(require 'config/application.config.php');

//  Set base URL so Laminas routes work correctly under /wstr/
$basePath = '/wstr';
$request = $app->getServiceManager()->get('Request');
if (method_exists($request, 'setBaseUrl')) {
    $request->setBaseUrl($basePath);
}

// Run the application
$app->run();