<?php

namespace Application\Services\Mail;

use Application\Model\EmailTemplate;
use Application\Model\User;
use Laminas\View\Model\ViewModel;

class TourDataExportMailer extends GenericMailerInterface
{

    public function sendMail(User $user, $future_schedule_task_list)
    {   
        if (!empty($future_schedule_task_list)) {

            $config = $this->serviceLocator->get('config');
            $config = $config['smtp_service'];

            /**
             * @var $messageHeader EmailTemplate
             */
            $messageHeader = $this->serviceLocator->get('EmailHeaderFactory');
            $messageHeader = $messageHeader->content;

            /**
             * @var $messageFooter EmailTemplate
             */
            $messageFooter = $this->serviceLocator->get('EmailFooterFactory');
            $messageFooter = $messageFooter->content;


            $viewModel = new ViewModel();
            $viewModel->setTemplate('messaging/guide-future-schedule')
                ->setVariables([
                    'tasks'         => $future_schedule_task_list,
                    'messageHeader' => $messageHeader,
                    'messageFooter' => $messageFooter
                ]);

            $this->getMimeMessage(true)->addPart($this->getHtmlPart($viewModel, true));

            $mail = $this->getMailMessage();
            $mail->setFrom($config['default_from']);
            $mail->setTo($config['default_from']);
            // $mail->setTo('hitenwwt@gmail.com');
            
            // $mail->setTo('ankur.worldweb@gmail.com');
            // $mail->setBcc('hitenworldweb@gmail.com');
            
            $mail->setSubject("Future Schedule List");
            $mail->setBody($this->getMimeMessage());

            $this->dispatchMail();

            echo 'Email sent successfully.';

        }
      
    }
   
}
