<?php

namespace Application\Services\Mail;

use Application\Model\EmailTemplate;
use Application\Model\User;
use Laminas\View\Model\ViewModel;

class ForgotPasswordMailer extends GenericMailerInterface
{
    public function sendMail(User $user, $nullData = null)
    {

        $config = $this->serviceLocator->get('config');
        $config = $config['smtp_service'];

        $resetBaseUrl = APPLICATION_ENVIRONMENT === 'production' ?
            'https://' . getenv('SERVER_NAME') .'/wstr/application/login/reset-password?key=' :
            'http://' . getenv('SERVER_NAME') . '/wstr/application/login/reset-password?key=';

        try {
            /**
             * @var $messageFooter EmailTemplate
             */
            $messageFooter = $this->serviceLocator->get('EmailFooterFactory');
            $messageFooter = $messageFooter->content;
            $messageHeader = $this->serviceLocator->get('EmailHeaderFactory');
            $messageHeader = $messageHeader->content;
        } catch (\Exception $e)
        {
            $messageFooter = '';
            $messageHeader = '';
        }

        $viewModel = new ViewModel();
        $viewModel->setTemplate('account/password-reset-request')
            ->setVariables([
                'user' => $user,
                'resetUrl' => $resetBaseUrl . $user->passwd_reset_key,
                'base_url' => 'https://www.theconstitutional.com/wstr/',
                'messageFooter' => $messageFooter,
                'messageHeader' => $messageHeader
            ]);

        $this->getMimeMessage()->addPart($this->getHtmlPart($viewModel));

        $mail = $this->getMailMessage();
        $mail->setFrom($config['default_from']);
        $mail->addTo($user->email);
        $mail->setSubject('The Constitutional Walking Tour: Forgot Password Request');
        $mail->setBody($this->getMimeMessage());

        $this->dispatchMail();
        
    }
}
