<?php

namespace Application\Services;

class DatePickerFormatter
{
    private static $months = [
        'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'
    ];
    public static function toSqlDate($dateString)
    {

        /**
         * Already in SQL format
         */
        if (preg_match("/[0-9]{4}-[0-9]{2}-[0-9]{2}/", $dateString))
        {
            return $dateString;
        }

        $dateString = preg_replace("/,/", "", $dateString);
        $dateString = preg_replace("/\+/", " ", $dateString);
        list($month, $day, $year) = preg_split("/ /", $dateString);

        $month = array_search($month, static::$months);

        return sprintf("%4d-%02d-%02d", $year, $month + 1, $day);
    }

    public static function toDatePickerDate($dateString)
    {
        return date("M d, Y", strtotime($dateString));
    }
}