<?php

namespace Application\Model;

/**
 * Provides access to the user table
 *
 */
class UserTable extends StandardTable
{

    public function findUserByResetKey($key)
    {
        $rowset = $this->tableGateway->select(['passwd_reset_key' => $key]);
        return $rowset->current();
    }

    public function findMatchingUser(User $user)
    {
        $rowset = $this->tableGateway->select("UPPER('{$user->username}') = UPPER(username)");
        $row = $rowset->current();
        return $row;
    }

    public function findUserByEmail(User $user)
    {
        $rowset = $this->tableGateway->select("UPPER('{$user->email}') = UPPER(email)");
        $row = $rowset->current();
        return $row;
    }

    public function getLiveUsers()
    {
        return $this->tableGateway->select([ 'status' => 1 ]);
    }

    public function setLastLogin(User $user)
    {
        return $this->tableGateway->update(['lastlog' => date("Y-m-d H:i:s")], ['id' => $user->id]);
    }

}