<?php

namespace Application\Model;

use Laminas\Db\Sql\Select;

class TicketReconciliationMapTable extends StandardTable
{
    public function fetchTicketReconciliationMap($startDate, $endDate)
    {
        return $this->tableGateway->select(function($select) use ($startDate, $endDate)
        {
            /**
             * Don't want to show anything past right now
             */
            if ($endDate > time()) $endDate = time() - (24 * 60 * 60);

            $select->join('guideassignments', 'guideassignments.taskassignment_id = taskassignments.id',
                [ 'guide_id', 'totaltickets', 'taskassignment_id', 'noticketscollected'], Select::JOIN_LEFT)
                ->where([
                    'guideassignments.status' => 1,
                    'taskassignments.status' => 1,
                    'taskassignments.tasktype' => 1,
                    'taskassignments.tourtype' => 1
                ])
//                ->where->notIn('taskassignments.tourtype', [0,1])
//                ->where->greaterThan('guideassignments.totaltickets', 0)
                ->where->greaterThanOrEqualTo('taskassignments.assignmentdate', date("Y-m-d", $startDate))
                ->where->lessThanOrEqualTo('taskassignments.assignmentdate', date("Y-m-d", $endDate));
            $select->order('taskassignments.assignmentdate ASC, taskassignments.starttime ASC');

//            $query = @$select->getSqlString();
            return $select;
        });
    }
}