<?php

namespace Application\Model;


class TaskAssignment extends StandardEntry
{

    public $id;
    public $shiftassignment_id;
    public $guide_id;
    public $organization_id;
    public $task_id;
    public $tasktype;
    public $assignmentdate;
    public $starttime;
    public $endtime;
    public $tourtype;
    public $numpersonsontour;
    public $tourcontactname;
    public $tourcontactphone;
    public $tourcontactemail;
    public $notes;
    public $status;
    public $createdate;
    public $modifydate;
    public $numguidesrequired;
    public $tourname;
    public $paymentstatus;
    public $paymentnotes;
    public $confirmationemaildate;
    public $thankyouemailto;
    public $thankyouemaildate;
    public $leadguidegivingtour;

    public function toArray()
    {
        return [
            'id' => $this->id,
            'shiftassignment_id' => $this->shiftassignment_id,
            'guide_id' => $this->guide_id,
            'organization_id' => $this->organization_id,
            'task_id' => $this->task_id,
            'tasktype' => $this->tasktype,
            'assignmentdate' => $this->assignmentdate,
            'starttime' => $this->starttime,
            'endtime' => $this->endtime,
            'tourtype' => $this->tourtype,
            'numpersonsontour' => $this->numpersonsontour,
            'tourcontactname' => $this->tourcontactname,
            'tourcontactphone' => $this->tourcontactphone,
            'tourcontactemail' => $this->tourcontactemail,
            'notes' => $this->notes,
            'status' => $this->status,
            'createdate' => $this->createdate,
            'modifydate' => $this->modifydate,
            'numguidesrequired' => $this->numguidesrequired,
            'tourname' => $this->tourname,
            'paymentstatus' => $this->paymentstatus,
            'paymentnotes' => $this->paymentnotes,
            'confirmationemaildate' => $this->confirmationemaildate,
            'thankyouemailto' => $this->thankyouemailto,
            'thankyouemaildate' => $this->thankyouemaildate,
            'leadguidegivingtour' => $this->leadguidegivingtour
        ];
    }

    public function getTaskTime()
    {
        list ($start_hour, $start_minute) = preg_split("/:/", $this->starttime);
        list ($end_hour, $end_minute) = preg_split("/:/", $this->endtime);

        $start_meridian = $start_hour >= 12 ? 'PM' : 'AM';
        $end_meridian   = $end_hour   >= 12 ? 'PM' : 'AM';

        return sprintf("%d:%02d %s-%d:%02d %s",
            $start_hour > 12 ? $start_hour-12 : $start_hour, $start_minute, $start_meridian,
            $end_hour > 12 ? $end_hour-12 : $end_hour, $end_minute, $end_meridian);
    }

    public function getThankYouMessageSubject()
    {
        $subject = null;
        switch ($this->organization_id)
        {
            case 1: $subject = 'Thanks for Taking The Constitutional Walking Tour'; break;
            case 2: $subject = 'Thanks for Taking The Spirits of \'76 Ghost Tour'; break;
        }

        if ($this->tourtype == 6)
        {
            $subject = 'Thanks for Taking The Constitutional Virtual Tour';
        }
        if ($this->tourtype == 5)
        {
            $subject = 'Thanks for Taking The Constitutional Bus Tour';
        }

        if ($this->tourtype == 9 || $this->tourtype == 10)
        {
            $subject = 'Thanks for Taking The Constitutional Scavenger Hunt';
        }

        return $subject;
    }

    public function getThankYouTemplateKey()
    {
        $template_key = null;
        switch ($this->tourtype)
        {
            case 2:
            case 4:
            case 6:
                $template_key = $this->organization_id == 1 ? 'thankyouemail_const_groupschool' : 'thankyouemail_spirits_groupschool';
                break;
            case 3:
                $template_key = $this->organization_id == 1 ? 'thankyouemail_const_vip' : 'thankyouemail_spirits_vip';
                break;
            case 5:
                $template_key = 'thankyouemail_const_bus';
                break;
            case 9:
            case 10:
                $template_key = 'thankyouemail_const_scavengerhunt';
                break;
            case 15:
            case 16:
                $template_key = 'thankyouemail_const_yf';
                break;
            default:
                $template_key = 'thankyouemail_generic';
                break;
        }

        return $template_key;
    }
}


