<?php

namespace Application\Model;

use Application\Exception\EntryNotFoundException;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;

/**
 * A standard table, uses tableGateway to fetch row(s) from a table
 * @author tpeeler
 *
 */
abstract class StandardTable
{
    /**
     * @var TableGateway
     */
    protected $tableGateway;

    /**
     * @var ServiceManager
     */
    protected $serviceLocator;

    public function __construct(TableGateway $tableGateway, ServiceManager $serviceLocator)
    {
        $this->tableGateway = $tableGateway;
        $this->serviceLocator = $serviceLocator;
    }

    public function fetchAll()
    {
        return $this->tableGateway->select(function($select)
        {
            return $select;
        });
    }

    /**
     * @param $id
     * @return array|\ArrayObject|null
     * @throws EntryNotFoundException
     */
    public function fetchOne($id)
    {
        $id = (int) $id;
        $rowset = $this->tableGateway->select(["id" => $id]);
        $row = $rowset->current();
        if (! $row)
        {
            throw new EntryNotFoundException("Unable to find the resource requested");
        }
        return $row;
    }

    public function saveOne(StandardEntry $tableEntry)
    {
        $id = (int) $tableEntry->id;
        if ($id == 0)
        {
            $this->tableGateway->insert($tableEntry->toArray());
            $tableEntry->id = $this->tableGateway->lastInsertValue;
        }
        else
        {
            if ($this->fetchOne($id))
            {
                $this->tableGateway->update($tableEntry->toArray(), ['id' => $id]);
            }
        }
    }

    public function deleteOne($id)
    {
        return $this->tableGateway->delete(['id' => (int) $id]);
    }
}