<?php

namespace Application\Model;

/**
 * A standard table entry, represents a single row from a table.  Must implement the toArray() function
 * @author tpeeler
 *
 */
abstract class StandardEntry
{
    protected $id;

    public function __get($property)
    {
        return $this->$property;
    }

    public function __set($property, $value)
    {
        $this->$property = $value;
    }

    public function exchangeArray($data)
    {
        foreach ($this->toArray() as $key => $value)
        {
            $this->$key = (is_array($data) && in_array($key, array_keys($data)) && isset($data[$key])) ? $data[$key] : null;
        }
    }

    /**
     * This should return an associative array containing all the elements that are required for the table row
     * All standard entries should have an $id field that is the primary key
     */
    abstract public function toArray();
}