<?php

namespace Application\Model;

class GuideTimeSheetsTable extends StandardTable
{
    public function fetchCurrent($startDate, $endDate, $order_results = false)
    {
        return $this->tableGateway->select(function($select) use ($startDate, $endDate, $order_results)
        {

            if ($startDate) $select->where->greaterThanOrEqualTo('assignmentdate', date("Y-m-d", $startDate));
            if ($endDate) $select->where->lessThanOrEqualTo('assignmentdate', date("Y-m-d", $endDate));

            if ($order_results)
            {
                $select->order('assignmentdate ASC, starttime_1 ASC, starttime_2 ASC, starttime_3 ASC, starttime_4 ASC, starttime_5 ASC');
            }

            return $select;
        });
    }
}