<?php

namespace Application\Model;


class EmailMessage extends StandardEntry
{

    public $messageType;
    public $messageSubject;
    public $messageBody;
    public $messageOptions;

    /**
     * @var $messageRecipients[] MessageRecipient
     */
    public $messageRecipients;

    public function toArray()
    {
        return [
            'messageType' => $this->messageType,
            'messageSubject' => $this->messageSubject,
            'messageBody' => $this->messageBody,
            'messageRecipients' => $this->messageRecipients,
            'messageOptions' => $this->messageOptions
        ];
    }

    public function exchangeArray($data)
    {
        parent::exchangeArray($data);

        $this->messageOptions = json_decode($this->messageOptions);

        $messageRecipients = json_decode($this->messageRecipients);

        $this->messageRecipients = [];
        foreach ($messageRecipients as $messageRecipient)
        {
            $messageRecipientNew = new MessageRecipient();
            $messageRecipientNew->id = $messageRecipient->id;
            $messageRecipientNew->name = $messageRecipient->name;
            $messageRecipientNew->enabled = $messageRecipient->enabled ? true : false;
            $messageRecipientNew->email = $messageRecipient->email ? $messageRecipient->email : null;

            $this->messageRecipients[] = $messageRecipientNew;
        }
    }
}


