<?php

namespace Application\Factories\Mail;

use Laminas\Mail\Transport\Smtp;
use Laminas\Mail\Transport\SmtpOptions;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class MailTransportFactory implements FactoryInterface
{

    static $service = null;

    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$service == null)
        {
            $config = $serviceLocator->get('config');

            $transport = new Smtp();
            $options = new SmtpOptions($config['smtp_service']['mail_transport']);
            $transport->setOptions($options);

            self::$service = $transport;
        }
        return self::$service;
    }
}