<?php

namespace Application\Factories\Mail;

use Application\Exception\EntryNotFoundException;
use Application\Model\EmailTemplate;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class EmailFooterFactory implements FactoryInterface
{
    /**
     * @var $emailTemplate EmailTemplate
     */
    static $emailTemplate;

    /**
     * @param ServiceLocatorInterface $serviceLocator
     * @return EmailTemplate
     * @throws EntryNotFoundException
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$emailTemplate == null)
        {
            try
            {
                self::$emailTemplate = $serviceLocator->get('Application\Model\EmailTemplateTable')->fetchTemplate('footer');

            } catch (\Exception $e)
            {
                throw new EntryNotFoundException($e->getMessage(), $e->getCode(), $e);
            }
        }
        return self::$emailTemplate;
    }
}
