<?php

namespace Application\Factories\Auth;

use Application\Services\Auth\Listener;
use Laminas\Authentication\AuthenticationService;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class AclListenerFactory implements FactoryInterface
{
    static $listener = null;
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$listener == null)
        {
            /**
             * @var $authService AuthenticationService
             */
            $authService = $serviceLocator->get('AuthService');

            self::$listener = new Listener($serviceLocator, $authService);
        }
        return self::$listener;
    }
}