<?php

namespace Application\Factories;

use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\User;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class ActiveAdminFactory implements FactoryInterface
{


    /**
     * @var Admin
     */
    static $admin = null;

    /**
     * @param ServiceLocatorInterface $serviceLocator
     * @return User
     * @throws EntryNotFoundException
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$admin == null)
        {
            /**
             * @var $user User
             */
            $user = $serviceLocator->get('ActiveUser');

            try
            {
                self::$admin = $serviceLocator->get('Application\Model\AdminTable')->fetchOne($user->id);

            } catch (\Exception $e)
            {
                /**
                 * If we don't find the active user in the admin table, then we just send back a null object
                 */
                self::$admin = new Admin();
                self::$admin->enabled = 0;
                self::$admin->user_id = $user->id;
            }
        }
        return self::$admin;
    }
}