<?php
namespace Application\Controller;

use Application\Model\Admin;
use Application\Model\User;
use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;

class PartialsController extends AbstractActionController
{
    public function calendarAction()             { return $this->indexAction('calendar', false); }
    public function dayTypesAction()             { return $this->indexAction('day-types', true); }
    public function guidesAction()               { return $this->indexAction('guides', true); }
    public function saveTheDateAction()          { return $this->indexAction('save-the-date', true); }
    public function searchTasksAction()          { return $this->indexAction('search-tasks', true); }
    public function seasonsAction()              { return $this->indexAction('seasons', true); }
    public function ticketBreakdownAction()      { return $this->indexAction('ticket-breakdown', true); }
    public function ticketReconciliationAction() { return $this->indexAction('ticket-reconciliation', true); }
    public function timeSheetsAction()           { return $this->indexAction('time-sheets', false); }
    public function manageAccountAction()        { return $this->indexAction('manage-account', false); }
    public function metaDataAction()             { return $this->indexAction('meta-data', true); }
    public function emailTemplatesAction()       { return $this->indexAction('email-templates', true); }
    public function adminCalendarAction()        { return $this->indexAction('admin-calendar', true); }
    public function adminTimeSheetsAction()      { return $this->indexAction('admin-time-sheets', true); }
    public function adminDayDetailsAction()      { return $this->indexAction('admin-day-details', true); }
    public function adminManageTaskAction()      { return $this->indexAction('admin-mange-task', true); }
    public function adminTaskListAction()        { return $this->indexAction('admin-task-list', true); }
    public function tourEmailAction()            { return $this->indexAction('tour-email', true); }
    public function contactGuidesAction()        { return $this->indexAction('contact-guides', true); }
    public function dayDetailsAction()           { return $this->indexAction('day-details', false); }

    public function indexAction($id = 'index', $admin = true)
    {


        $fallbackTemplate = "application/partials/index.phtml";
        $template = "application/partials/{$id}.phtml";

        /**
         * @var $activeAdmin Admin
         */
        $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

        /**
         * @var $user User
         */
        $user = $this->serviceLocator->get("ActiveUser");

        $viewModel = new ViewModel();

        $viewModel->setVariables([
            'user' => $user
        ]);

        if ($admin && !$activeAdmin->enabled)
        {
            $template = $fallbackTemplate;
        }

        try {
            $viewModel->setTemplate($template);
            return $viewModel;
        } catch (\Exception $e)
        {
            $viewModel->setTemplate($fallbackTemplate);
            return $viewModel;
        }
    }
}
