<?php


return [
    'router' => [
        'routes' => [
            'home' => [
                'type' => 'Laminas\Mvc\Router\Http\Literal',
                'options' => [
                    'route'    => '/',
                    'defaults' => [
                        'controller' => 'Application\Controller\Index',
                        'action'     => 'index'
                    ],
                ],
            ],
            'login_route' => [
                'type' => 'Laminas\Mvc\Router\Http\Literal',
                'options' => [
                    'route' => '/members',
                    'defaults' => [
                        'controller' => 'Application\Controller\Login',
                        'action' => 'index'
                    ]
                ]
            ],
            'logout_route' => [
                'type' => 'Laminas\Mvc\Router\Http\Literal',
                'options' => [
                    'route' => '/logout',
                    'defaults' => [
                        'controller' => 'Application\Controller\Login',
                        'action' => 'logout'
                    ]
                ]
            ],
            'wstr' => [
                'type'    => 'Literal',
                'options' => [
                    'route'    => '/application',
                    'defaults' => [
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller'    => 'Index',
                        'action'        => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes' => [
                    'default' => [
                        'type'    => 'Segment',
                        'options' => [
                            'route'    => '/[:controller[/][:action[/][:id][/]]]',
                            'constraints' => [
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'action'     => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'id'         => '[0-9]+'
                            ]
                        ],
                    ],
                ],
            ],
            'tour-data-export-to-csv' => [
                'type' => 'Laminas\Mvc\Router\Http\Literal', // exact match of URI path
                'options' => [
                    'route' => '/tour_data_export/tour_data_export_to_csv', // URI path
                    'defaults' => [
                        'controller' => 'Application\Controller\TourDataExportToCSV', // unique name'
                        'action'     => 'index',
                    ],
                ],
            ],

        ],
    ],
    'service_manager' => [
        'factories' => [

            /* Application\Model factories (dependency injectors hooray!) */
            'Application\Model\UserTable' => \Application\Factories\Model\UserTableFactory::class,
            'Application\Model\AdminTable' => \Application\Factories\Model\AdminTableFactory::class,
            'Application\Model\TaskTypeTable' => \Application\Factories\Model\TaskTypeTableFactory::class,
            'Application\Model\TourTypeTable' => \Application\Factories\Model\TourTypeTableFactory::class,
            'Application\Model\OrganizationsTable' => \Application\Factories\Model\OrganizationsTableFactory::class,
            'Application\Model\DayTypeTable' => \Application\Factories\Model\DayTypeTableFactory::class,
            'Application\Model\ShiftsTable' => \Application\Factories\Model\ShiftsTableFactory::class,
            'Application\Model\TasksTable' => \Application\Factories\Model\TasksTableFactory::class,
            'Application\Model\SeasonsTable' => \Application\Factories\Model\SeasonsTableFactory::class,
            'Application\Model\WeekdayAssignmentsTable' => \Application\Factories\Model\WeekdayAssignmentsTableFactory::class,
            'Application\Model\ShiftAssignmentsTable' => \Application\Factories\Model\ShiftAssignmentsTableFactory::class,
            'Application\Model\GuideAvailabilityTable' => \Application\Factories\Model\GuideAvailabilityTableFactory::class,
            'Application\Model\ReservedDatesTable' => \Application\Factories\Model\ReservedDatesTableFactory::class,
            'Application\Model\AvailabilityTable' => \Application\Factories\Model\AvailabilityTableFactory::class,
            'Application\Model\GuideAssignmentTable' => \Application\Factories\Model\GuideAssignmentTableFactory::class,
            'Application\Model\GuideShiftAssignmentTable' => \Application\Factories\Model\GuideShiftAssignmentTableFactory::class,
            'Application\Model\GuideTimeSheetsTable' => \Application\Factories\Model\GuideTimeSheetsTableFactory::class,
            'Application\Model\TaskAssignmentTable' => \Application\Factories\Model\TaskAssignmentTableFactory::class,
            'Application\Model\TicketTypeTable' => \Application\Factories\Model\TicketTypeTableFactory::class,
            'Application\Model\GuideAssignmentTicketTable' => \Application\Factories\Model\GuideAssignmentTicketTableFactory::class,
            'Application\Model\EmailTemplateTable' => \Application\Factories\Model\EmailTemplateTableFactory::class,
            'Application\Model\TicketReconciliationMapTable' => \Application\Factories\Model\TicketReconciliationMapTableFactory::class,
            'Application\Model\SeasonTaskAssignmentMapTable' => \Application\Factories\Model\SeasonTaskAssignmentMapTableFactory::class,

            /**
             * Mail services
             */
            'MailTemplateMapResolver' =>\Application\Factories\Mail\MailTemplateMapResolverFactory::class,
            'MailTransport' => \Application\Factories\Mail\MailTransportFactory::class,
            'Application\Services\Mail\ForgotPasswordMailer' => \Application\Factories\Mail\Services\ForgotPasswordMailerFactory::class,
            'Application\Services\Mail\TourDataExportMailer' => \Application\Factories\Mail\Services\TourDataExportMailerFactory::class,
            'Application\Services\Mail\NullMailer' => \Application\Factories\Mail\Services\NullMailerFactory::class,
            'Application\Services\Mail\SaveTheDateMailer' => \Application\Factories\Mail\Services\SaveTheDateMailerFactory::class,
            'Application\Services\Mail\SimpleEmailMessage' => \Application\Factories\Mail\Services\SimpleEmailMessageFactory::class,
            'Application\Services\Mail\Cron\ThankYouDaily' => \Application\Factories\Mail\Services\Cron\ThankYouDailyFactory::class,
            'Application\Services\Mail\Cron\TaskScheduleDailyMailer' => \Application\Factories\Mail\Services\Cron\TaskScheduleDailyMailerFactory::class,
            'Application\Services\Mail\Cron\TaskScheduleWeeklyMailer' => \Application\Factories\Mail\Services\Cron\TaskScheduleWeeklyMailerFactory::class,
            'Application\Services\Mail\Cron\TaskScheduleFutureMailer' => \Application\Factories\Mail\Services\Cron\TaskScheduleFutureMailerFactory::class,
            'Application\Services\Mail\Cron\TimeSheetWeeklyNotesMailer' => \Application\Factories\Mail\Services\Cron\TimeSheetWeeklyNotesMailerFactory::class,
            'EmailFooterFactory' => \Application\Factories\Mail\EmailFooterFactory::class,
            'EmailHeaderFactory' => \Application\Factories\Mail\EmailHeaderFactory::class,

            /**
             * Factories for user authentication and management
             */
            'Application\Model\SessionStorage' => \Application\Factories\Model\SessionStorageFactory::class,
            'AuthService' => \Application\Factories\AuthServiceFactory::class,
            'ActiveUser' => \Application\Factories\ActiveUserFactory::class,
            'ActiveAdmin' => \Application\Factories\ActiveAdminFactory::class,
            'Application\Services\Auth\Listener' => \Application\Factories\Auth\AclListenerFactory::class
        ]
    ],
    'controllers' => [
        'invokables' => [
            'Application\Controller\Index'      => \Application\Controller\IndexController::class,
            'Application\Controller\Members'    => \Application\Controller\MembersController::class,
            'Application\Controller\Login'      => \Application\Controller\LoginController::class,
            'Application\Controller\Logout'     => \Application\Controller\LogoutController::class,
            'Application\Controller\Partials'   => \Application\Controller\PartialsController::class,
            'Application\Controller\TourDataExportToCSV'   => \Application\Controller\TourDataExportToCSVController::class
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions'       => true,
        'doctype'                  => 'HTML5',
        'not_found_template'       => 'error/404',
        'exception_template'       => 'error/index',
        'template_map' => [
            'layout/members'          => __DIR__ . '/../view/layout/members.phtml',
            'layout/logged-out'       => __DIR__ . '/../view/layout/logged-out-layout.phtml',
            'layout/layout'           => __DIR__ . '/../view/layout/layout.phtml',
            'error/404'               => __DIR__ . '/../view/error/404.phtml',
            'error/index'             => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy'
        ],
    ]];
