<?php

namespace API\Exception;

use Laminas\Http\Response;

class UnauthorizedException extends Exception
{

    public function __construct(Response $response, $message = "You are not authorized, please log in")
    {
        parent::__construct($response, $message);
        $this->response->setStatusCode(Response::STATUS_CODE_403);
        $this->key = "unauthorized_exception";
    }
}