<?php

namespace API\Exception;

use Laminas\Http\Response;


abstract class Exception extends \Exception implements \Iterator
{

    protected $response;
    protected $key;
    protected $has_accessed = false;

    public function __construct(Response $response, $exceptionOrString)
    {
        $this->response = $response;

        if ($exceptionOrString instanceof \Exception)
        {
            $this->code = $exceptionOrString->code;
            $this->file = $exceptionOrString->file;
            $this->line = $exceptionOrString->line;
            $this->message = $exceptionOrString->message;
            $this->key = "exception";
        } else
        {
            $this->message = $exceptionOrString;
        }
    }

    public function __toArray()
    {
        return [ $this->key => $this->message ];
    }

    public function current()
    {
        if (!$this->has_accessed)
        {
            return $this->message;
        }
    }
    public function next()
    {
        $this->has_accessed = true;
    }

    public function rewind()
    {
        $this->has_accessed = false;
    }

    public function valid()
    {
        return !$this->has_accessed;
    }

    public function key()
    {
        if (isset($this->key))
        {
            return $this->key;
        }
        return "unknown";
    }
}