<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\TourType;
use Application\Model\TourTypesTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TourTypeController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {

            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application/Model/TourTypeTable');

            /**
             * @var $tourType TourType
             */
            $tourType = $tourTypeTable->fetchOne($id);

            return new JsonModel($tourType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application/Model/TourTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $tourTypeTable->fetchAll();

            $return = [];

            /**
             * @var $tourType TourType
             */
            while ($tourType = $resultSet->current())
            {
                $return[] = $tourType->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application/Model/TourTypeTable');

            $tourType = new TourType();
            $tourType->exchangeArray($data);
            $tourType->id = null;

            $tourTypeTable->saveOne($tourType);

            return new JsonModel($tourType->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');


            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application/Model/TourTypeTable');

            $toUpdateTourType = new TourType();
            $toUpdateTourType->exchangeArray($data);


            $tourTypeTable->saveOne($toUpdateTourType);

            return new JsonModel($toUpdateTourType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application/Model/TourTypeTable');


            $tourTypeTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Tour Type Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}