<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\TicketType;
use Application\Model\TicketTypeTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TicketTypeController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $ticketTypeTable TicketTypeTable
             */
            $ticketTypeTable = $this->serviceLocator->get('Application\Model\TicketTypeTable');

            /**
             * @var $ticketType TicketType
             */
            $ticketType = $ticketTypeTable->fetchOne($id);

            return new JsonModel($ticketType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {

            /**
             * @var $ticketTypeTable TicketTypeTable
             */
            $ticketTypeTable = $this->serviceLocator->get('Application\Model\TicketTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $ticketTypeTable->fetchAll();

            $return = [];

            /**
             * @var $ticketType TicketType
             */
            while ($ticketType = $resultSet->current())
            {
                $return[] = $ticketType->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            /**
             * @var $ticketTypeTable TicketTypeTable
             */
            $ticketTypeTable = $this->serviceLocator->get('Application\Model\TicketTypeTable');

            $ticketType = new TicketType();
            $ticketType->exchangeArray($data);
            $ticketType->id = null;
            $ticketType->organization_id = (int) $ticketType->organization_id ? (int) $ticketType->organization_id : null;

            $ticketTypeTable->saveOne($ticketType);

            return new JsonModel($ticketType->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');


            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $ticketTypeTable TicketTypeTable
             */
            $ticketTypeTable = $this->serviceLocator->get('Application\Model\TicketTypeTable');

            $ticketType = new TicketType();
            $ticketType->exchangeArray($data);

            $ticketType->organization_id = (int) $ticketType->organization_id ? (int) $ticketType->organization_id : null;

            $ticketTypeTable->saveOne($ticketType);

            return new JsonModel($ticketType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $ticketTypeTable TicketTypeTable
             */
            $ticketTypeTable = $this->serviceLocator->get('Application\Model\TicketTypeTable');


            $ticketTypeTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Ticket Type Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
