<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\Shift;
use Application\Model\ShiftsTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class ShiftsController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $shiftsTable ShiftsTable
             */
            $shiftsTable = $this->serviceLocator->get('Application/Model/ShiftsTable');

            /**
             * @var $shift Shift
             */
            $shift = $shiftsTable->fetchOne($id);

            return new JsonModel($shift->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $shiftsTable ShiftsTable
             */
            $shiftsTable = $this->serviceLocator->get('Application/Model/ShiftsTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $shiftsTable->fetchAll();

            $return = [];

            /**
             * @var $shift Shift
             */
            while ($shift = $resultSet->current())
            {
                $return[] = $shift->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            /**
             * @var $shiftsTable ShiftsTable
             */
            $shiftsTable = $this->serviceLocator->get('Application/Model/ShiftsTable');

            $shift = new Shift();
            $shift->exchangeArray($data);
            $shift->id = null;
            $shift->status = 1;
            $shift->createdate = date("Y-m-d");
            $shift->modifydate = date("Y-m-d");

            $shiftsTable->saveOne($shift);

            return new JsonModel($shift->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');


            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $shiftsTable ShiftsTable
             */
            $shiftsTable = $this->serviceLocator->get('Application/Model/ShiftsTable');

            $toUpdateShift = new Shift();
            $toUpdateShift->exchangeArray($data);

            /**
             * @var $oldShift Shift
             */
            $oldShift = $shiftsTable->fetchOne($id);

            $toUpdateShift->createdate = $oldShift->createdate;
            $toUpdateShift->modifydate = date("Y-m-d");

            $shiftsTable->saveOne($toUpdateShift);

            return new JsonModel($toUpdateShift->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $shiftsTable ShiftsTable
             */
            $shiftsTable = $this->serviceLocator->get('Application/Model/ShiftsTable');


            $shiftsTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Shift Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}