<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\GuideShiftAssignment;
use Application\Model\GuideShiftAssignmentTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class GuideShiftAssignmentsController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $guideShiftAssignmentTable GuideShiftAssignmentTable
             */
            $guideShiftAssignmentTable = $this->serviceLocator->get('Application\Model\GuideShiftAssignmentTable');

            /**
             * @var $guideShiftAssignment GuideShiftAssignment
             */
            $guideShiftAssignment = $guideShiftAssignmentTable->fetchOne($id);

            return new JsonModel($guideShiftAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            $shiftAssignmentIds = $this->request->getQuery('shiftAssignmentIds', null);
            $shiftAssignmentIds = preg_split("/,/", $shiftAssignmentIds);

            /**
             * @var $guideShiftAssignmentTable GuideShiftAssignmentTable
             */
            $guideShiftAssignmentTable = $this->serviceLocator->get('Application\Model\GuideShiftAssignmentTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $guideShiftAssignmentTable->fetchList($shiftAssignmentIds);

            $return = [];

            /**
             * @var $guideShiftAssignment GuideShiftAssignment
             */
            while ($guideShiftAssignment = $resultSet->current())
            {
                $return[] = $guideShiftAssignment->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $guideShiftAssignmentTable GuideShiftAssignmentTable
             */
            $guideShiftAssignmentTable = $this->serviceLocator->get('Application\Model\GuideShiftAssignmentTable');

            $guideShiftAssignment = new GuideShiftAssignment();
            $guideShiftAssignment->exchangeArray($data);
            $guideShiftAssignment->id = null;
            $guideShiftAssignmentTable->saveOne($guideShiftAssignment);

            return new JsonModel($guideShiftAssignment->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $guideShiftAssignmentTable GuideShiftAssignmentTable
             */
            $guideShiftAssignmentTable = $this->serviceLocator->get('Application\Model\GuideShiftAssignmentTable');

            $guideShiftAssignment = new GuideShiftAssignment();
            $guideShiftAssignment->exchangeArray($data);

            if ($guideShiftAssignment->guide_id == 0)
            {
                $guideShiftAssignment->guide_id = null;
            }
            $guideShiftAssignmentTable->saveOne($guideShiftAssignment);

            return new JsonModel($guideShiftAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $guideShiftAssignmentTable GuideShiftAssignmentTable
             */
            $guideShiftAssignmentTable = $this->serviceLocator->get('Application\Model\GuideShiftAssignmentTable');

            $guideShiftAssignmentTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response,
                "Guide Shift Assignment Deleted"));


        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
