<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\GuideAssignment;
use Application\Model\GuideAssignmentTable;
use Application\Model\User;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class GuideAssignmentsController extends AbstractRestfulController {
	public function get($id) {
		try
		{
			/**
			 * @var $guideAssignmentTable GuideAssignmentTable
			 */
			$guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

			/**
			 * @var $guideAssignment GuideAssignment
			 */
			$guideAssignment = $guideAssignmentTable->fetchOne($id);

			return new JsonModel($guideAssignment->toArray());

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function getList() {
		try
		{
			$guideId = $this->request->getQuery('guide_id', null);
			$assignmentIds = $this->request->getPost('assignmentIds', []);

			/**
			 * @var $guideAssignmentTable GuideAssignmentTable
			 */
			$guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

			/**
			 * @var $resultSet ResultSet
			 */
			if ($guideId) {
				$resultSet = $guideAssignmentTable->fetchAllByGuideId($guideId);
			} else {
				$resultSet = $guideAssignmentTable->fetchAllByAssignmentIds($assignmentIds);
			}

			$results = [];

			/**
			 * @var $guideAssignment GuideAssignment
			 */
			while ($guideAssignment = $resultSet->current()) {
				$results[] = $guideAssignment->toArray();
				$resultSet->next();
			}

			return new JsonModel($results);

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function create($data) {
		try
		{

			$assignmentIds = $this->request->getPost('assignmentIds', []);

			if (sizeof($assignmentIds)) {
				return $this->getList();
			}

			/**
			 * @var $activeUser User
			 */
			$activeUser = $this->serviceLocator->get('ActiveUser');

			/**
			 * @var $activeAdmin Admin
			 */
			$activeAdmin = $this->serviceLocator->get('ActiveAdmin');

			/**
			 * @var $guideAssignmentTable GuideAssignmentTable
			 */
			$guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

			$guideAssignment = new GuideAssignment();
			$guideAssignment->exchangeArray($data);
			$guideAssignment->id = null;
			$guideAssignment->totaltickets = null;
			$guideAssignment->createdate = date("Y-m-d");
			$guideAssignment->modifydate = null;
			$guideAssignment->starttime = $guideAssignment->starttime ?: null;
			$guideAssignment->endtime = $guideAssignment->endtime ?: null;

			if (!$activeAdmin->enabled && $guideAssignment->guide_id !== $activeUser->id) {
				return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
			}

			$guideAssignmentTable->saveOne($guideAssignment);

			return new JsonModel($guideAssignment->toArray());
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function update($id, $data) {
		try
		{

			/**
			 * @var $activeUser User
			 */
			$activeUser = $this->serviceLocator->get('ActiveUser');

			/**
			 * @var $activeAdmin Admin
			 */
			$activeAdmin = $this->serviceLocator->get('ActiveAdmin');

			/**
			 * @var $guideAssignmentTable GuideAssignmentTable
			 */
			$guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

			/**
			 * @var $oldAssignment GuideAssignment
			 */
			$oldAssignment = $guideAssignmentTable->fetchOne($id);

			$guideAssignment = new GuideAssignment();
			$guideAssignment->exchangeArray($data);
			$guideAssignment->createdate = $oldAssignment->createdate;
			$guideAssignment->modifydate = date("Y-m-d");
			$guideAssignment->totaltickets = (int) $guideAssignment->totaltickets ? $guideAssignment->totaltickets : null;
			$guideAssignment->starttime = $guideAssignment->starttime ?: null;
			$guideAssignment->endtime = $guideAssignment->endtime ?: null;

			if (!$activeAdmin->enabled && $guideAssignment->guide_id !== $activeUser->id) {
				return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
			}

			$guideAssignmentTable->saveOne($guideAssignment);

			return new JsonModel($guideAssignment->toArray());

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function delete($id) {
		try {

			/**
			 * @var $guideAssignmentTable GuideAssignmentTable
			 */
			$guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

			$guideAssignmentTable->deleteOne($id);

			return new JsonModel(new DeletedEntryNotificationException($this->response, "Guide Assignment removed"));

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}

	}
}
