<?php

namespace API\Controller;

use API\Exception\EmailSentNotificationException;
use API\Exception\EntryNotFoundException;
use API\Exception\SystemErrorException;
use Application\Model\EmailMessage;
use Application\Model\MessageRecipient;
use Application\Model\User;
use Application\Model\UserTable;
use Application\Services\Mail\GenericMailerInterface;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\ServiceManager\Exception\ServiceNotFoundException;
use Laminas\View\Model\JsonModel;

class EmailMessageController extends AbstractRestfulController
{
    public function create($data)
    {
        /**
         * @var $activeUser User
         */
        $activeUser = $this->serviceLocator->get('ActiveUser');

        try
        {
            /**
             * @var $userTable UserTable
             */
            $userTable = $this->serviceLocator->get('Application\Model\UserTable');

            $emailMessage = new EmailMessage();
            $emailMessage->exchangeArray($data);

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }


        /**
         * @var $messageRecipient MessageRecipient
         */
        foreach ($emailMessage->messageRecipients as $messageRecipient)
        {
            try
            {
                /**
                 * @var $user User
                 */
                $user = $userTable->fetchOne($messageRecipient->id);
                $messageRecipient->email = $user->email;
                $messageRecipient->name = $user->name;

            } catch (\Exception $exception)
            {
                $messageRecipient->notfound = true;
            }
        }

        try
        {

            /**
             * @var $mailerService GenericMailerInterface
             */
            $mailerService = $this->serviceLocator->get('Application\Services\Mail\\' . $emailMessage->messageType);

            $mailerService->sendMail($activeUser, $emailMessage);

            $recipientNames = [];

            /**
             * @var $messageRecipient MessageRecipient
             */
            foreach ($emailMessage->messageRecipients as $messageRecipient)
            {
                if (property_exists($messageRecipient, 'name') && isset($messageRecipient->name) && $messageRecipient->enabled)
                {
                    $recipientNames[] = $messageRecipient->name;
                }
            }

            $recipientNames = join(', ', $recipientNames);

            return new JsonModel(new EmailSentNotificationException($this->response,
                sprintf("Subject: %s\nTo: %s\n\n%s\n",
                    $emailMessage->messageSubject,
                    $recipientNames,
                    substr(strip_tags($emailMessage->messageBody), 0, 60))));

        } catch (ServiceNotFoundException $serviceNotFoundException)
        {
            return new JsonModel(new EntryNotFoundException($this->response,
                'Mail service message type not found: ' . $emailMessage->messageType));
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }
}