'use strict';
module.exports = function(grunt)
{
    require('load-grunt-tasks')(grunt);
    require('time-grunt')(grunt);

    var memberJsFileList = [
        'public/js/dates.js',
        'angularjs-datepicker.js',
        'node_modules/angular-ui-sortable/dist/sortable.js',
        'node_modules/angular-aria/angular-aria.js',
        'node_modules/angular-messages/angular-messages.js',
        'node_modules/angular-route/angular-route.js',
        'node_modules/angular-ui-bootstrap/dist/ui-bootstrap-tpls.js',
        'node_modules/angular-toggle-switch/angular-toggle-switch.js',
        'node_modules/chart.js/dist/Chart.bundle.js',
        'node_modules/angular-chart.js/dist/angular-chart.js',
        'node_modules/ng-currency/src/ng-currency.js',
        'node_modules/angular-sanitize/angular-sanitize.js',
        'node_modules/@cgross/angular-notify/dist/angular-notify.js',
        'node_modules/angular-ui-tinymce/src/tinymce.js',
        'public/js/angular/app.js',
        'public/js/angular/directives/*.js',
        'public/js/angular/plugins/*.js',
        'public/js/angular/filters/*.js',
        'public/js/angular/services/*.js',
        'public/js/angular/services/*/*.js',
        'public/js/angular/controllers/*.js',
        'public/js/angular/controllers/AuthenticationController.js',
    ];

    var publicJsFileList = [
        'public/js/dates.js',
        'angularjs-datepicker.js',
        'node_modules/angular-ui-sortable/dist/sortable.js',
        'node_modules/angular-aria/angular-aria.js',
        'node_modules/angular-messages/angular-messages.js',
        'node_modules/angular-route/angular-route.js',
        'node_modules/angular-ui-bootstrap/dist/ui-bootstrap-tpls.js',
        'node_modules/angular-toggle-switch/angular-toggle-switch.js',
        'node_modules/chart.js/dist/Chart.bundle.js',
        'node_modules/angular-chart.js/dist/angular-chart.js',
        'node_modules/ng-currency/src/ng-currency.js',
        'node_modules/angular-sanitize/angular-sanitize.js',
        'node_modules/@cgross/angular-notify/dist/angular-notify.js',
        'node_modules/angular-ui-tinymce/src/tinymce.js',
        'public/js/angular/app.js',
        'public/js/angular/controllers/AuthenticationController.js',
        'public/js/angular/directives/Equals.js',
    ];


    grunt.initConfig({
        jshint : {
            options : {
                jshintrc : '.jshintrc',
                reporterOutput : ''
            },
            all : [
                'Gruntfile.js',
                'public/js/angular/directives/*.js',
                'public/js/angular/filters/*.js',
                'public/js/angular/services/*.js',
                'public/js/angular/services/*/*.js',
                'public/js/angular/controllers/*.js'
            ]
        },
        concat : {
            options : {
                separator : ';'
            },
            basic : {
                src : [publicJsFileList],
                dest : 'public/js/account.js'
            },
            extras : {
                src : [memberJsFileList],
                dest : 'public/js/application.js'
            },
            angular : {
                src : 'node_modules/angular/angular.js',
                dest : 'public/js/angular.js'
            }
        },
        uglify : {
            dist : {
                files : {
                    'public/js/application.min.js' : [memberJsFileList],
                    'public/js/account.min.js'     : [publicJsFileList],
                    'public/js/angular.min.js'     : ['node_modules/angular/angular.js']
                }
            }
        },
        watch : {
            js : {
                files : [
                    memberJsFileList,
                    publicJsFileList,
                    '<%= jshint.all %>'
                ],
                tasks : ['jshint','concat']
            }
        }
    });

    grunt.registerTask('default', [ 'dev' ]);
    grunt.registerTask('dev', [ 'jshint', 'concat' ]);
    grunt.registerTask('build', [ 'jshint', 'concat', 'uglify' ]);
};
