<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.17.1
*/$ia="4.17.1";function
adminer_errors($Hc,$Jc){return!!preg_match('~^(Trying to access array offset on( value of type)? null|Undefined (array key|property))~',$Jc);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$dd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($dd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Hi=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Hi)$$X=$Hi;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($u){if(!preg_match('~^[`\'"[]~',$u))return$u;$re=substr($u,-1);return
str_replace($re.$re,$re,substr($u,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($rg,$dd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($rg)){foreach($X
as$ie=>$W){unset($rg[$y][$ie]);if(is_array($W)){$rg[$y][stripslashes($ie)]=$W;$rg[]=&$rg[$y][stripslashes($ie)];}else$rg[$y][stripslashes($ie)]=($dd?$W:stripslashes($W));}}}}function
bracket_escape($u,$Na=false){static$si=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($u,($Na?array_flip($si):$si));}function
min_version($Yi,$De="",$h=null){global$g;if(!$h)$h=$g;$kh=$h->server_info;if($De&&preg_match('~([\d.]+)-MariaDB~',$kh,$B)){$kh=$B[1];$Yi=$De;}return$Yi&&version_compare($kh,$Yi)>=0;}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($wh,$ri="\n"){return"<script".nonce().">$wh</script>$ri";}function
script_src($Mi){return"<script src='".h($Mi)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($P){return
str_replace("\0","&#0;",htmlspecialchars($P,ENT_QUOTES,'utf-8'));}function
nl_br($P){return
str_replace("\n","<br>",$P);}function
checkbox($C,$Y,$gb,$ne="",$vf="",$kb="",$oe=""){$I="<input type='checkbox' name='$C' value='".h($Y)."'".($gb?" checked":"").($oe?" aria-labelledby='$oe'":"").">".($vf?script("qsl('input').onclick = function () { $vf };",""):"");return($ne!=""||$kb?"<label".($kb?" class='$kb'":"").">$I".h($ne)."</label>":$I);}function
optionlist($D,$ch=null,$Qi=false){$I="";foreach($D
as$ie=>$W){$Af=array($ie=>$W);if(is_array($W)){$I.='<optgroup label="'.h($ie).'">';$Af=$W;}foreach($Af
as$y=>$X)$I.='<option'.($Qi||is_string($y)?' value="'.h($y).'"':'').($ch!==null&&($Qi||is_string($y)?(string)$y:$X)===$ch?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($C,$D,$Y="",$uf=true,$oe=""){if($uf)return"<select name='".h($C)."'".($oe?" aria-labelledby='$oe'":"").">".optionlist($D,$Y)."</select>".(is_string($uf)?script("qsl('select').onchange = function () { $uf };",""):"");$I="";foreach($D
as$y=>$X)$I.="<label><input type='radio' name='".h($C)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$I;}function
confirm($Oe="",$dh="qsl('input')"){return
script("$dh.onclick = function () { return confirm('".($Oe?js_escape($Oe):lang(0))."'); };","");}function
print_fieldset($Kd,$we,$bj=false){echo"<fieldset><legend>","<a href='#fieldset-$Kd'>$we</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$Kd');",""),"</legend>","<div id='fieldset-$Kd'".($bj?"":" class='hidden'").">\n";}function
bold($Ua,$kb=""){return($Ua?" class='active $kb'":($kb?" class='$kb'":""));}function
js_escape($P){return
addcslashes($P,"\r\n'\\/");}function
ini_bool($Vd){$X=ini_get($Vd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($Xi,$M,$V,$F){$_SESSION["pwds"][$Xi][$M][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($P){global$g;return$g->quote($P);}function
get_vals($G,$d=0){global$g;$I=array();$H=$g->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$d];}return$I;}function
get_key_vals($G,$h=null,$nh=true){global$g;if(!is_object($h))$h=$g;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($nh)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$h=null,$m="<p class='error'>"){global$g;$Ab=(is_object($h)?$h:$g);$I=array();$H=$Ab->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($h)&&$m&&(defined("PAGE_HEADER")||$m=="-- "))echo$m.error()."\n";return$I;}function
unique_array($J,$w){foreach($w
as$v){if(preg_match("~PRIMARY|UNIQUE~",$v["type"])){$I=array();foreach($v["columns"]as$y){if(!isset($J[$y]))continue
2;$I[$y]=$J[$y];}return$I;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where($Z,$o=array()){global$g,$x;$I=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,1);$d=escape_key($y);$I[]=$d.($x=="sql"&&$o[$y]["type"]=="json"?" = CAST(".q($X)." AS JSON)":($x=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($x=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($o[$y],q($X)))));if($x=="sql"&&preg_match('~char|text~',$o[$y]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$y)$I[]=escape_key($y)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$o=array()){parse_str($X,$db);remove_slashes(array(&$db));return
where($db,$o);}function
where_link($t,$d,$Y,$xf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$xf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$o,$L=array()){$I="";foreach($e
as$y=>$X){if($L&&!in_array(idf_escape($y),$L))continue;$Ga=convert_field($o[$y]);if($Ga)$I.=", $Ga AS ".idf_escape($y);}return$I;}function
cookie($C,$Y,$ze=2592000){global$ba;return
header("Set-Cookie: $C=".urlencode($Y).($ze?"; expires=".gmdate("D, d M Y H:i:s",time()+$ze)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($kd=false){$Pi=ini_bool("session.use_cookies");if(!$Pi||$kd){session_write_close();if($Pi&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Xi,$M,$V,$k=null){global$oc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($oc))."|username|".($k!==null?"db|":"").session_name()),$B);return"$B[1]?".(sid()?SID."&":"").($Xi!="server"||$M!=""?urlencode($Xi)."=".urlencode($M)."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$Oe=null){if($Oe!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$Oe;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($G,$A,$Oe,$_g=true,$Oc=true,$Xc=false,$ei=""){global$g,$m,$b;if($Oc){$Eh=microtime(true);$Xc=!$g->query($G);$ei=format_time($Eh);}$zh="";if($G)$zh=$b->messageQuery($G,$ei,$Xc);if($Xc){$m=error().$zh.script("messagesPrint();");return
false;}if($_g)redirect($A,$Oe.$zh);return
true;}function
queries($G){global$g;static$vg=array();static$Eh;if(!$Eh)$Eh=microtime(true);if($G===null)return
array(implode("\n",$vg),format_time($Eh));$vg[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$g->query($G);}function
apply_queries($G,$S,$Kc='table'){foreach($S
as$Q){if(!queries("$G ".$Kc($Q)))return
false;}return
true;}function
queries_redirect($A,$Oe,$_g){list($vg,$ei)=queries(null);return
query_redirect($vg,$A,$Oe,$_g,false,!$_g,$ei);}function
format_time($Eh){return
lang(1,max(0,microtime(true)-$Eh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Qf=""){return
substr(preg_replace("~(?<=[?&])($Qf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($E,$Rb){return" ".($E==$Rb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($y,$ac=false){$cd=$_FILES[$y];if(!$cd)return
null;foreach($cd
as$y=>$X)$cd[$y]=(array)$X;$I='';foreach($cd["error"]as$y=>$m){if($m)return$m;$C=$cd["name"][$y];$mi=$cd["tmp_name"][$y];$Fb=file_get_contents($ac&&preg_match('~\.gz$~',$C)?"compress.zlib://$mi":$mi);if($ac){$Eh=substr($Fb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Eh,$Fg))$Fb=iconv("utf-16","utf-8",$Fb);elseif($Eh=="\xEF\xBB\xBF")$Fb=substr($Fb,3);$I.=$Fb."\n\n";}else$I.=$Fb;}return$I;}function
upload_error($m){$Ke=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(2).($Ke?" ".lang(3,$Ke):""):lang(4));}function
repeat_pattern($ag,$xe){return
str_repeat("$ag{0,65535}",$xe/65535)."$ag{0,".($xe%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($P,$xe=80,$Kh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$xe).")($)?)u",$P,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$xe).")($)?)",$P,$B);return
h($B[1]).$Kh.(isset($B[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($rg,$Md=array(),$jg=''){$I=false;foreach($rg
as$y=>$X){if(!in_array($y,$Md)){if(is_array($X))hidden_fields($X,array(),$y);else{$I=true;echo'<input type="hidden" name="'.h($jg?$jg."[$y]":$y).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$Yc=false){$I=table_status($Q,$Yc);return($I?$I:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$I=array();foreach($b->foreignKeys($Q)as$q){foreach($q["source"]as$X)$I[$X][]=$q;}return$I;}function
enum_input($T,$Ia,$n,$Y,$Cc=null){global$b,$x;preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Fe);$I=($Cc!==null?"<label><input type='$T'$Ia value='$Cc'".((is_array($Y)?in_array($Cc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Fe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$gb=(is_int($Y)?$Y==$t+1:(is_array($Y)?in_array($t+1,$Y):$Y===$X));$I.=" <label><input type='$T'$Ia value='".($x=="sql"?$t+1:h($X))."'".($gb?' checked':'').'>'.h($b->editVal($X,$n)).'</label>';}return$I;}function
input($n,$Y,$s){global$U,$Hh,$b,$x;$C=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Ea=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Ea[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Ea);$s="json";}$Jg=($x=="mssql"&&$n["auto_increment"]);if($Jg&&!$_POST["save"])$s=null;$sd=(isset($_GET["select"])||$Jg?array("orig"=>lang(8)):array())+$b->editFunctions($n);$kc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$Ia=" name='fields[$C]'$kc";if($x=="pgsql"&&in_array($n["type"],(array)$Hh[lang(9)])){$Gc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = ".$U[$n["type"]]." ORDER BY enumsortorder");if($Gc){$n["type"]="enum";$n["length"]="'".implode("','",array_map('addslashes',$Gc))."'";}}if($n["type"]=="enum")echo
h($sd[""])."<td>".$b->editInput($_GET["edit"],$n,$Ia,$Y);else{$Cd=(in_array($s,$sd)||isset($sd[$s]));echo(count($sd)>1?"<select name='function[$C]'$kc>".optionlist($sd,$s===null||$Cd?$s:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($sd))).'<td>';$Xd=$b->editInput($_GET["edit"],$n,$Ia,$Y);if($Xd!="")echo$Xd;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$Ia value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ia value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Fe);foreach($Fe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$gb=(is_int($Y)?($Y>>$t)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$C][$t]' value='".(1<<$t)."'".($gb?' checked':'').">".h($b->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif(($bi=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($bi&&$x!="sqlite")$Ia.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ia.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ia>".h($Y).'</textarea>';}elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$Ia cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Me=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$B)?((preg_match("~binary~",$n["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$n["unsigned"]?1:0)):($U[$n["type"]]?$U[$n["type"]]+($n["unsigned"]?0:1):0));if($x=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$Me+=7;echo"<input".((!$Cd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($Me?" data-maxlength='$Me'":"").(preg_match('~char|binary~',$n["type"])&&$Me>20?" size='40'":"")."$Ia>";}echo$b->editHint($_GET["edit"],$n,$Y);$ed=0;foreach($sd
as$y=>$X){if($y===""||!$X)break;$ed++;}if($ed)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $ed), oninput: function () { this.onchange(); }});");}}function
process_input($n){global$b,$l;if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return
null;$u=bracket_escape($n["field"]);$s=$_POST["function"][$u];$Y=$_POST["fields"][$u];if($n["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")return
array_sum((array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$cd=get_file("fields-$u");if(!is_string($cd))return
false;return$l->quoteBinary($cd);}return$b->processInput($n,$Y,$s);}function
fields_from_edit(){global$l;$I=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$C=bracket_escape($y,1);$I[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($y==$l->primary),);}return$I;}function
search_tables(){global$b,$g;$_GET["where"][0]["val"]=$_POST["query"];$fh="<ul>\n";foreach(table_status('',true)as$Q=>$R){$C=$b->tableName($R);if(isset($R["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$H=$g->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$H||$H->fetch_row()){$ng="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$fh<li>".($H?$ng:"<p class='error'>$ng: ".error())."\n";$fh="";}}}echo($fh?"<p class='message'>".lang(10):"</ul>")."\n";}function
dump_headers($Ld,$We=false){global$b;$I=$b->dumpHeaders($Ld,$We);$Mf=$_POST["output"];if($Mf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Ld).".$I".($Mf!="file"&&preg_match('~^[0-9a-z]+$~',$Mf)?".$Mf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return
false;$I=dirname($p);unlink($p);}}return$I;}function
file_open_lock($p){$r=@fopen($p,"r+");if(!$r){$r=@fopen($p,"w");if(!$r)return;chmod($p,0660);}flock($r,LOCK_EX);return$r;}function
file_write_unlock($r,$Tb){rewind($r);fwrite($r,$Tb);ftruncate($r,strlen($Tb));flock($r,LOCK_UN);fclose($r);}function
password_file($i){$p=get_temp_dir()."/adminer.key";$I=@file_get_contents($p);if($I||!$i)return$I;$r=@fopen($p,"w");if($r){chmod($p,0660);$I=rand_string();fwrite($r,$I);fclose($r);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$_,$n,$di){global$b;if(is_array($X)){$I="";foreach($X
as$ie=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($ie):"")."<td>".select_value($W,$_,$n,$di);return"<table>$I</table>";}if(!$_)$_=$b->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$I=$b->editVal($X,$n);if($I!==null){if(!is_utf8($I))$I="\0";elseif($di!=""&&is_shortable($n))$I=shorten_utf8($I,max(0,+$di));else$I=h($I);}return$b->selectVal($I,$_,$n,$X);}function
is_mail($_c){$Ha='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$nc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$ag="$Ha+(\\.$Ha+)*@($nc?\\.)+$nc";return
is_string($_c)&&preg_match("(^$ag(,\\s*$ag)*\$)i",$_c);}function
is_url($P){$nc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($nc?\\.)+$nc(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$P);}function
is_shortable($n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($Q,$Z,$de,$wd){global$x;$G=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($de&&($x=="sql"||count($wd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$wd).")$G":"SELECT COUNT(*)".($de?" FROM (SELECT 1$G GROUP BY ".implode(", ",$wd).") x":$G));}function
slow_query($G){global$b,$oi,$l;$k=$b->database();$fi=$b->queryTimeout();$th=$l->slowQuery($G,$fi);if(!$th&&support("kill")&&is_object($h=connect())&&($k==""||$h->select_db($k))){$le=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$le,'&token=',$oi,'\');
}, ',1000*$fi,');
</script>
';}else$h=null;ob_flush();flush();$I=@get_key_vals(($th?$th:$G),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$yg=rand(1,1e6);return($yg^$_SESSION["token"]).":$yg";}function
verify_token(){list($oi,$yg)=explode(":",$_POST["token"]);return($yg^$_SESSION["token"])==$oi;}function
lzw_decompress($Ra){$jc=256;$Sa=8;$mb=array();$Lg=0;$Mg=0;for($t=0;$t<strlen($Ra);$t++){$Lg=($Lg<<8)+ord($Ra[$t]);$Mg+=8;if($Mg>=$Sa){$Mg-=$Sa;$mb[]=$Lg>>$Mg;$Lg&=(1<<$Mg)-1;$jc++;if($jc>>$Sa)$Sa++;}}$ic=range("\0","\xFF");$I="";foreach($mb
as$t=>$lb){$zc=$ic[$lb];if(!isset($zc))$zc=$mj.$mj[0];$I.=$zc;if($t)$ic[]=$mj.$zc[0];$mj=$zc;}return$I;}function
on_help($ub,$qh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ub, $qh) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$o,$J,$Ki){global$b,$x,$oi,$m;$Ph=$b->tableName(table_status1($Q,true));page_header(($Ki?lang(11):lang(12)),$m,array("select"=>array($Q,$Ph)),$Ph);$b->editRowPrint($Q,$o,$J,$Ki);if($J===false){echo"<p class='error'>".lang(13)."\n";return;}echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$o)echo"<p class='error'>".lang(14)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($o
as$C=>$n){echo"<tr><th>".$b->fieldName($n);$bc=$_GET["set"][bracket_escape($C)];if($bc===null){$bc=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$bc,$Fg))$bc=$Fg[1];}$Y=($J!==null?($J[$C]!=""&&$x=="sql"&&preg_match("~enum|set~",$n["type"])?(is_array($J[$C])?array_sum($J[$C]):+$J[$C]):(is_bool($J[$C])?+$J[$C]:$J[$C])):(!$Ki&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$bc)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$n);$s=($_POST["save"]?(string)$_POST["function"][$C]:($Ki&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Ki&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}input($n,$Y,$s);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(15)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Ki?lang(16):lang(17))."' title='Ctrl+Shift+Enter'>\n",($Ki?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(18)."…', this); };"):"");}}echo($Ki?"<input type='submit' name='delete' value='".lang(19)."'>".confirm()."\n":($_POST||!$o?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$oi,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7i2\r1-HGF#a;:O!r0t~f':hB'c͔:6T\rcAzrcXKg+ZXkvM77_\"){}ƣ-4N}:rfK)b{H(Ɠєt1)t}Fp08\\82D>NCy8\0惫\0F>(3	\n9)`v-Ao\r&Xn*A\0`A\0q\0oC=σ\r\\#{Ȍ2R;0dBHL+H,!oR>NA|\"Kɼ0PbJd^ȑdР=<:J#¶ڮaБ>TeFkj#K6#9ET1KŴ+CFI	(L|jPpfEuLQGZ2Υ2!sk[:1k6%Ypkf+W[޷\rrL1\0ҝ8=cT.-~#sOvG+yO{J9COײ|`+(Mr\rO5\n48(	-lCj2[r5yKy)¬+Ak2g߳3iĔHS>W<f}jfMiBϹ84uLZCI\$2P\r߅\"+2n-~C24:2,:ܑgcwGҨǃhV] \\6`R4=#x^1\0Pم:-8o~ov>ƣmط'|C<:G)M&WYQQi=\\[ya\rBe\\B7Ne}:lk\$44rq}\rPALaC5sm\rYέ&(  \n\$jE%^qx\rhW0FuRmJ:z@:rj7F5,wr\n' iP|>8Wfm2 9H@\$M\$qXԹ!\r90ΣR:\"7D r0uĢ܌JꉼFF<PYe^)	8nLo2Eʔ\r1伸˩Cf,q]N\08d8b*4J\\Mͺ4HlRd̯!aJ	.e5ˀI0ђQ\nCQ.n^0IF7<R3woMѦweD4b7+F>g64Jj`t!Fx;md8o7Bj]=Sj¨*0A;RQFD1\"OnɼϨ4Ê4eq\nK*;9H9@Չ#ƹ'YSclan.Ͷk:h\$9d9\r1PqʃDy%sbaƟʜ\rZRH_%\0@Sw77ERjwMP2@\n.aW~JH,nJ`o@zõoN|LڨVK x	u3*qK`]AGiUaȳQre\$[W\"@bĸU\r=.EE\0}rDH\"ImǌutϮGPP̗8\0pD ;Vs(#Ruʖ\$˖\0cEB\n̎g\0004	+އ2cnf!>ǟ3]J35|GtTaU Hi'KZg	#iVυ4TW\0\"1ݕQԺ_>}>QqrmV!<d9S,v'uykb]pMyI[&\\9Gviu7Ek^[%Aa;H#t,k[Xݑ5Q^yI}ۧU(b\rex%K\\œ+!Y_)eF`[[nZ=wn_\$+\$#FFjic̕lk6[Ymt\rQxW%Az@t\r4\"n,4Cfa|vaGtżńt\$?Y9Hty0GO(<GWjWR/_' \\z%>j{Zs?eV/@0:h.FQ4j^/g]`	F=n&&&je @p OnHX*+5J\nPuf&KZOǑPXfl(@ړpH{/dK0P&&|\0οPd&NLMPm	NU*)hEER@	8-<49\0\r چ\"/6 @C\0\0~@[aig3(gccIA[s6 q`Ħ\0fnɬѸ	SG\riqOkIQhU1\0\rQi\r+)V!uI\0r,;)\"1 Q\"N7Y2%Q#C1Q!Q#BiC%јyDN!M<0.-\"3!1RQ@iK#)i\"B*Ɣc2*+r\"eP2(*#g+2,*2,R2,0*2/2q\$h\0Ҙ?2R2/0l,B 趒c%BҔ8/*4&t`ah{3u7%@n6Q}93+`rӅ5[FgS3sQ:R'*&Qa<2u\$= B<RU<ܡ6S?2)+?s<=ڔ>9J@s=SAReASBsB/>1VqTI.qR_3E\"eY\".3ȑ\"JqBɫD)̝4#\$a l(S<4[\"Qd0%A4_qiCKR07HI:Kj 2SA3t?NT\$Mos'	\rNgPR&8POR3Q23 eHIR:\":R#F	LKmS*(,v82\$35VD3c\n0B&\rä+Ҋ90:\r8qATTI*]5J0JSH&f");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*HVw8J\nm@O#P@YpöwP\r8X\$X Pd	Q\0Rx1\"T]\"	QbR`M-RSE8Go0	dB^\0\":mN.j%@3(x l 	W\n:\r\0}@qm;@-Zg.zFf@\rWck <	0z'4\r\0jELY(%\nMDoFBqKg#Z\"\nЮh2-n\"jy\"\"g!,*TxP5%L`LM@ Z@`^Q0R%9&jvhX oG#DHK¼lX-2hWli+&s'rz(҈%tK6rrK.*,*vbgj#LȮvZQ\$p܏n*hvB\\FJX%x f\$A4K74a#3\n(|Z,e2l\r|K0W2-m)	)Z'%	7.**\0O;C*\$A;V(ltK.Dƛ_>:v3=d\$R擠Sl7B[!@][63zSe>srDz;T0S*C+o\\\0{Dkz@= D4V炏ʕ*\0WtvyD-5C3Dt!_UXL]FFnF&@%b>cPI)3<@ `\r55%/3Q@G5\rѱT,EN&j\0h̾\$ 353TB'FL'DU#LэPm*Ѡ\\\r@@)EUUU]V`MRDFV{4`3U45#T`Q(ߵq7M*@SVMĢ#~2 մjl@\\ .J|2U\\ v\\b;^\06x·]^uULZMP֙4H9\$03'VuT@KW|/\$J*D]	X_pޕѥղuI܅z䢮r\n%8i^U15n;I\nR3QU455`zacb`qOtNu6)TjXRe#J-S@\"UCUU86-ki/Y R\$!\rn[6VݭqՀ.Bcppps!\0Ow\"ngsXwGi{Z\0Su*k`Ξa!Qo'd x Cac!60P\rʂTҜ,j&@ʃ( OAPTjGhλb\"%\nqXz %m~@~rJnW~ 	]RXFrxNmHp +@kl#\0ˁvX&,idz\0N~w\0Wၷ\0KNm	0pBץ'X)`YeXyI: `dѠt\n('N\rHGuKe\0*3)n3ͤ oV}vN\\؍1i)\".`t>\rcߏfoA\"׭  OyYF\r[5Bo*/t(%R[<8V\$AM59'*X܅\\\"jrD\reX|^n#dͥlnMt~\\͛\0@ᛂg=2.*\0@'9y ߞ9 d	zq6]P~\nP:<DY:]5[['IF\$B<PP@N0/E:^DJw\0_Cdz#zFW4(K{U[{>\0^%M@XSڇZSlWwY ޔ\"B*R`	\nQCF*Yͧe+Hj\$Q ^\0Zk`VB%(X**2ͺN`| -~8Z ƇRz2\"	J4S~J&temV}Nͳ'r5f.&1jKm{`w !^#5TKEhq\$kx|m:sDdzAڋ?[LȬZX:[(!kXVy \$\0C9dSiin{`\n`	|K :5# t}xN{[)CFKZjPFYBpFk0<@D<JEi05T\"VhŇHWDeSsN\0xDL1<!\r3qdK3PyE/`Pz\ndYϼ5X8WI8w[7`\n@ۻCpP=V\rZ{*q\$ R֓eqЬ+U`BOf*CLMC`_ ˵O\nT5&C׽@\\We&_X_ܻ.84d Yüp\$ezA[\$]<]|`,\rul\r5qpdu Yi@z\n7;Ȁܝ7b'dmh@qCh+6.JWce]ekZ0Z_yfpc8&͂z\0EΝ70	\"\$=!>怂g7B-QƐ/e&Ƈ6ap\re3cNIjn-\$*x-WVj@oΏ#w5'O.Mو\0HC9-mP8Sv!;gtL5,	#n#ޏx-7f5`#\"Nbg eb,7SGjoՋF?T6ms-m6q;dl0fE8]P'X\nMG\0x\05*#*1>*]ȖWs\r,\0O,q2j+H FGE>d@bIzaR8@7LBH A˳pp@	dkz4EA	߉WA1\"2bGk\"\0dhRDp!fPs3`Fe	OkLAC/a@|@:!ᘂoT/blL8Djʄ@2κEN\"1zq,\\^)8Vq1	<'4C!F4ftc\rmz*M(A2)PrƊಈ45	\0Z[d9hYt1eE\$o`X gUd\0G~DR<hUpy=T(DZ-bHȏyaHlbb(HL8esCeI=D{]<a✊Q=T\$!COِUG)QVTb\".\r@<)o`V\r0qjsXF\"*bIڢ|A hp\\	Xj#b#O>5w?T;l1ac\"t5vĮ`x\\CM=ib!.HLmHҬ%+D4FڼC[KX}P >e:Vt;#Ѧ&Rȴp,a˘HƜDt\0\$q/t~J`,㺼]`%3>ގ@Nx1,rxr):80B,EAB0(E8@n[	(hdD	HRQ^! v< 6E\"&V(GBU_Hs@*BN)QHvTG0hR٥ن+-&TC?zd\0\$bSڡ<܏Q@PdpO>+>x|	MeER4k(W{*-G\$	'j\0H	(љ>A%Yʴ6v^K G%2Ed͔<J#DE{0\$T+2T%#&W2e\nS䧆Lcdh=|e\"' [a2#%=uk:6,K\\dȗYGr;·= LɴXyVh*O *F-bK*#:.<RY\"EU'x3eQq@>bKx4e DG?!Nxka4@/\rc0ҬD! @ ;D9\$:& W\$R5ڗHA2o=@=:\n%@og]tT&# qUfc@|BW&_\rR\"(Lzrs5*T -5\"Z74%\\!yΒ7K @Z/v\0/IÎ֯s@11&-F5DAu;@[<HO.y@Zs	ӶAO\0ʴIZ{0rԒǡDP'Ov\nB?i@#[HB!~P>x!uE.\0(wIE1Eܠ/\":\ru|T Ky8[N ?xgP!;uNBT΃ɡ\00 6\r`bhE\r\\Cpt@;El{(>1*\n)MC|@`i\"\\KFɥ	|(K4gJXiBP'\$>q1B	NxXcߧŪ,Chy(B7S#\r!H09MJT.0)ZDB?-vq*,J<b&dPKG; y	#>)iȑi&Ȝ8]*C,ô 9\nhW\\	iM 7!9_,9\$T\",)51v\"Lf&-9>y QBJJ4\n,*0Pg6yw/M\n<Bi.F2dBrPjjwi.pI\0 <xV,\nCS0PPr+Yx#'IUe\"cQC\0*%Ġ\"PhUr׬ic,5VW@-l_=\n4rU!F5YO5!{+4)OFeɬUVShk*V_\"gzsjk/1UnaW[zɈ\")dFR&7Yfȕ	-2r_I<q80)pP	PԽ0rYBcD#\"#4R:\$^US&ZInWmKĔ\$+#zD+6dv Bba41d@,1	n	4)	t(-u*#۴[N2P\n_)|4H0 L\"N0&\$	`Eְ,B_\\x\0Qb^&ro#i&n%6{&L\r'#F`ѠJņldR(h% x\"HCK? v8KCP Q\0_#P)ia\nH%ǩzzVci\0D(DV5QӰob'\r2QFO`BD'x)雽~,@)}XrPN7T<MH\"'7Vn!=X ȶŲ\0,x[X,زŦȮqep5!>\nSCD\"A\0SQ\n],-BdƂ=ST>Z(\0/Vl.q3T@\0+;kMD\nq4ayT`\"559|@`&:R؋\n2v.mA`Tk||2L)\\<V3q#CD2h3פ,`0:eK]4R>Lg\\[0 ˸qʨ*VV]r0q0	tޞO/\$;2ꗁL;+\$l*ŘJC\rn{\rՍr;<Ű8U!5`c-X#\nk\0:^I§6!ky*AQo@uὖ`Ns'7F&CL:Rn(%ۄ3٤epx`Hbl*E4pɜi{xs{p5QLqn&ؙC\07\0;[\$Lj@:2L{|pTR5M7_D\nbpP\0]>ldr5CCeq2*]^0n	nK@|i/ªo;MKƸk}y[k\rW[\$\r^u\nwH7\0^a5-R'!e|R%\npw,]~N&;QS\rƗiy<--00 mH#\nqF!2N=Av4WsP@d<˓*1*B,Y\\w:HǃTUz'T틀eO_%q(oH(qk̀*oPw5%p괟Ծ|hi=wAu@g1P\\\"F:2,}}ƨjcXVi9HcENRRӓjVrpv9R?%Ÿ\nn.\0)?EX(/%.v;Ow+3[BGI{Mper\$R\$o%)3WذAx`*I1#Ԋ9pR'c\0=)J_,=)H^W4ϖ͚b1aB!:@4#6evh_(ǆn\nvZ ̦e=8nJ>mG{^Yf+0;wvP\$@/#5/9s81)0E+	R0l\"&U7 uiB2hXFo+~PKpA#V%oZp69X͙l^%`GA*U\n\nJ{DǮqr\$8扮с,܆Ձ\n6YaNz.(\$N\nG4Y}pZ?@.6)f[Go%GϨ\r9r^ҰmRɱ\"V(ז3\0dză*ZlJfa~l@U|x>8J5p]2U/ykǧ<<q'}aggZ'jt+lԡGA֑{_k\rη3lD9KB%\\їVɿ8<KA!wVi:.Lܪ_LNgxZ9rWyCbqw#q LH\0Cp1.\ro>[`j>(@F6-@잦*(>@YIh\r멧XH>Nbctrn֍x?X%%vx{5l\\yϦ6tta]w0.ݡLC6f&%D۾B08`mGk?eZNuݳ^q\\!+e\\Z0@f`B轘`*z۶o\\%i펚gzA^\"VGkukf՘o79;vY`.`{@P&	T![\n#lZF=aiHț6CS,p7!{[BT͆;d\nN[k;\0\"yP3`.NQPT(nT#Fo\"!0иF!]߂C#J?t[纐Vt 	ߏw.<O k'kBOpd#Nǆ@nd\$f\0U%^傍Hqu(EUPym+Pn@~G\\px(9~)	jLPLqbxjxB)Oɫ\n萔o:N߆(]%P;o)KFv\njzLi1/fnج'0b7PDdc30:l	S_n3ev-o(!b(&*wlfgor(w6SSamATbq,@)	kZϺح}+ȴ`RNupwz^wmt+\"Iƞs!F@8AJ|Ds.;L0\rɣcrn!WR\\Wq|~nwYE]`dN{]^	YrA&Uu|pfu6Aq(MXtGe2xS\"B2	:3z4\rW&(7\"PzJXV_Z!mto\r8 \rRZ*rDZB[T@lH2VhWL6\\:r&(em//JGhi:}I	EBQ#ٛtRӀΞ};eS(oZJe,e]>	{F+^#ԇ.fS6ls'k[ۼv9eⷱbRY-|eJK\$^jWz{֖Ewh{\nw=}ńqHr!!cX]f&\$lڨܞ1g)LD;w}4'^WܾuǗԱ-Ja*~!oK.;wPpXo_â_\0찐~'?BxIGFGY,*^g j\$W|X¤oID'XX/3%5CZzٹ`e1^IWw2T]㵵}Ra- ғзϬ~~g{酞ߤ;JWk-;3,g~GUWxa\r	\r/\0γ{Bdtb_XaAl	hh!w+h1#+h0\ri(@PYLfMl{(3re(\r*;_ZT>\n_6,)&I>B4Idm\n^>MЙkxLo(D@:F9YWFa+\"\$/X~(\$\"0#1CkQ3_nGQzT)*tm؟T\0azBgűO~9.JW*ف50	C@P˓\"c:Ѥwm`O5Ky+P-`\0X9<c\r,&@G)F^t8n\ne	7Z\$;Ex(¹?o ]'5mKpPV\rf<U?*%P҉dHӋk7!W-H+0>m`6,ACԐ21EC|gLP/VI(SP\n\0aS.RAcр\0HhwP/\0; N+Oxcv>\$.p1xhi=Ǝ\r\0kM6 :@\rQ'Eh@` P)Cv5%s5);C\n02@	UP0[H.6a@D&\"7PA\0 ,@:\0e57Iz?!\r@\"mx\\\n=C\rڐVAkT	0d@`g {Q,IiSdDRR}kÂh	@9NEsA<>t]mp99=]02\\8rU`2\n ҿ\$M?FXIp		x\n\$i:h2.0}1t\$m\n'C[*;O?k\n\n.0	XN))TPtI{C1\0VPM\0WRh\$Bp\nTZ|-\08\\+H_db@](.\\-2X4uBj	4B/&ރS\"D\\2H4h8XT!\0eVIb 1!q@d\\@!8\0A/ԅ:kݕ.CASXfθNJ4&!c/\rk\081vCZka/ނN/Jd&\r(5A`جf!K:Grܘ#x gȡ  (4;?XxqApTupؑ*`u.VۉA . hKD-C NrgP\r	#:D#\r︔\r\0D*bBe\\[( <0B/tG\\Ph%BÃC73B\\5C	t:ط(c\0\r@<8ʷ6dC Ch");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%23Hb2&<9R(tTH	z' o>4?\rZwӂ4`Ї鍆NӀ'-I0(Srw,Kr'-2Hlo-U_'W#'/H֟j6̉ȫ\0<j1EQTTrBcm16͈g٫:w6ͯh@1I:2pL/w:őK<E<J76Ӏs.̲sZ/\$AsEyϜrr:w?Չ!?ǙZM9՝\01?ARͦ%7>MARr}sr)\\t-8=ЎU,WOCsՆ#w5ERlM*D1>]gKV\n\\s܇8͹seͧ9so~w4xf@D96\0	@.@9\0C;Ky+J٥u<\\`c{ӋE>yJ=l/-7Z46uC5PΩRVʳlVaNx`մ?U7(HP}jVJzNQJSs-gQ!aV_SwRO3amZXwZo'waOoZ![\n<ZOҶ'Omo[a=Q>:T\n\0=mjATRbu(I:\$vWuS\\V8v\\g!Mжu_&is\\CRVM]tXT7\\UoTo_ԯݛS?alS-LutZGei`	}XZi}QyW[iTYo(ZE\\}nٍifڋWd%Tpu3uTf5)v]UR3VEY]X\n^VqSS}XiGfv>SvJMQvڕ\\g]QYEݵ#1Vl5UEK]\0SU?\\BwSU7mZV5\\Wfէ[eUr{G\\U,W[]xVj5mTVj~u7\0VU'tw?ms5Vvݏq}u-Uq]ݗc]W]Tt:fMke][-p}^I[XDYVdO]	seNZWY[tV?3ǵMݙ`t^wd:qTL@@>]j\rFqv-LvGKwiLwIPMoǹMgv[Uss~	w:BANE{!-do\0}&hXA5%٣fzLH5d Y_%vә!m]%=B>E [#^}hYFa>{gSp[FDa6nx98LI㈫Na=S@bPk.NHl\0:2#Θ;vO}9ik]	&{ 2|a&Q)oفǸ:&.\05q\0JL64hy3ޢaރIzOﮈ\"yBʳ{3%5r(mx.7rb%^eM2\0x!b}.Y6\$qS\"^|xEaXǡ59'TR	c9W1AΔP؏h6'o-pT(\nn\rŐ1RRUgxPe#*kT<<>b;\0gL.<kZvz8~y7Yȁ7wOdn><E3wSۆ@ oW1Һze޽1z\0f=c㊤g{>np\0Α:HBn6FBrW=C>M.1~@3G98q<S|Y8QP`L[qz۫PN<{_-ٮdOd-NB74BN.V9ƨQ3{IcP\$h<R yy?G:ng;Ah!&+>ˀ;Mˌ	6SNڌ=#`T#+n;r,X|#\r#?\nD>|VSeϗ~Jm99\ns{S|r],~˹ qI?\"|w%|j\0rE,kSnqƕd8B.1\"/|؃]EϜNlxI IcŸ.|\$8DFPK3\\jxUC/җA{eܾ\rpU\n՟Wlo­Y{`]'s/|o3r};[nOM7ߣؼqq(_lqsNy;igt:ՙqk{?zMȗo'jcy߄ggkwf8Vc7fAY+Kx=gKAkT,95rd+Gٯ[%Aw柞7ଅ%{m8%_mqV˨_%!Ei~h~C߭~%_rLkDy~?p1O!?v\\Pm\"<E6 EVzk9z~/պ!Q>ONm3r Fle;M߷Ͻ_a!~Cfb}3 Kf. 	}.DX	i5|?=\0???@Õfu~a^nyQ;q)sS,\"G\nu%UYAKl\nBI86VCcO\0`}.x,-N@~TG'dJy1zlæfgABa!M\\<gʃz4ƿ@/CÂ@	Qq)x/.7inD#= *79cFd2(.V3\$g`A᧋rl|mb/qEô!bU@9i;ppdפ=1yxx	=v=(vs_Boɂց#K\r n\\# fPXu-3&	J&,F(9v0&@khZygCԋz Áhi=s9T eT>g3dtF2b&:\0PB-Q8~LSMڷcgTh'f(\$.EVLAIߌrg\r0T1P`1d\r4=6@F F=ɂ6A>NAV	(\$A/;?gf^	\n&KOn{]g˛8cўϷ\n7Lt:ѠhFVO\rJ)b(\"OBm	o\$]TSHZ^Kw\\[A9('لcۑb0 KsrBx\n*Baz6o\ry&tX1p'^M<Cg`48GHzd?gX.@,7w۞:+TiUX16Ls:\rL6fr\r`t67~gxgH9JO=-\$4?r٪4O:z{D`21Fܵ(DM;&́ڭU>I6c߸@\r//ԕ_H\n7z 7aɻ[9D'}BORݟB#s]z!(D@L^	x@ouOD!e`\nak>0`-*8EZ6=f%c㛰K=F\rShyN[v*v\r@#߸퉁Ah*L\$AA\\%*	p\r*==8\$W\r [Jx0yZ+&YHA~A\n,\\(p!F<6S&IP`6Xz+df\rJ£is+&5/rEM^\$R(RQEw3lH*m\0BqarLBQz6~lB\rI®GXٸXVbsmBHc_K\$p-:8Nj:х-#F	\0aiBs\\)<.!\\NbIw8͹tPjW`y\0&0i?Ҕ:Ia)=C,a&Mapƃ\$IIFc\0!Yxa)~C1PZL3TjC\0y`\\W\\t\$2\n+a\0aKb\n]C@?I\rHヮKs%N^9CL/=%ۨh:?&PEY>5n[Gْ%V*w<gJ]*wd]B5^֢OQ>%s{ԅ畫;WzGi*RnG9E,(u*Ւ×XsR:5;)RNvK(RMb_{F<<3:%HVYS\n%L+{o.>Z(QkN!,:rH}nRNkI		[ӧg֤;mYҳg%9V~-J_g\\ɮQ\n!t\\UY-tZnd:Bʽ*]')twɫ[BUm*r4ؖ*yvvZչ+GHZnP܅|\nT %#\\AX\0}5b+wrXwܲ1u%Cg=Iv`cre0`..<h+H̝^\\jyF%]B\0r+>%Zx %C.`Vn1KSk\rX|[;6H	U@D:޻Mj	Ε?]ڤbA+G\0thxbL`64MޛY#hfD=ew=c+H:.%^\$DZrAzjfLl7o\0-Edމyz'V ӞW	ZK+d(AfyP?xR^h'A\0:p\rd(Vdt	SFcHȟ]rrCHY	X_/fͽ 4 7e6D{,<<Z^j\"	\n+ƀMY9A(<Pllp	,>Ѐ{E9&Ghh{(Agg8(@jTngZŰJx@icՋ(p'oJ0MnĀ&\r'\0Ց\rqF4)cL_oJ}5co|6m}Q4Qb[xm( &@;+򘥮f|IR48 {	`k`ur`W㸱`\")fI\n;8Zjg~AΈ!j%TE\\\r3EjjFXZ	AykHXdgCQ΀0dt	zk`@\0001\0nH\04\0g&.\0\0O(P@\rE\0l\0X\rE8x@ԋ\0^z@E\0.^Qq\"YD_p&3\0mZ.Pp\rEϋsv\"0`w,_`\rc/]xq3\0q.pq\0002_iъE\0a1bwJ \0l\01,`1y\09#?0T^q\$F6/\$dFDyJ0b\0	W\0.c{c E\0s3l]@\rbF\"\02`\"7/\0a	^04eQ{c<ьj/_ѐc\0001*28BA\0000xƔiؾ1F50ljH\"F30\\_q\0fTl_0тBEČ#3]sƽ64_X1\0ƽd``\rS_JMV/f1\0005I6tf4F34fF-6d\"4k\$h±#Ě\06_01c@F/d]XQ#G\n5gqEF\nm\\DnqYFv1/4`q4=8bq|\00043mX1e\0.\\QcI	.7\\x`\"\0i^3(籒\"Ev4l_q\$FoȾ\r#UE䍩^9t.\03|r1\069l^xѼPF-]\n0vQy\"G2,sxQq#F+\0/Diq}8[6,j\0cmoN5ehQvGLH<T_Q?Fɋ..\$fyEC2l1s#EDlohѲj8eűbF!9`xqC7hx٣Ŏ7^xK<h	,u鱑G);lu#Eߎ<kb\0sR.wֱ#z~w2|x(\0001':v\0001G挿?|` .2X#G8K@<z1ƹ\"9|j	G/6qGs7/\0001bߍ:|8Q#~FW4g#<F\r 2XQ#Fvk7x1#Ǝ@rhFZ;frcy!\r	_x1\"H10Twٲc\rF1 \n8dXrԌ2Db{d4HrA<~1dBHI[J?q~k0t#F\r#0\\h\rGEttc7U!=D_cN\0y6a Fg!v1q1KǇ@eѳcGo\n/ƲE\"3t`#cH<cqF%?Tb蹱d) r0qcE>3\$tyQңECl`9)VFHMJ7f\$HHQ ;ri7#F-FHQ#\0G!1^&4vG&7gృ\$\0G\rr/dR(s6@'RAǬ&g\0k z=|Hٱ^J]sd,\$1<cqǦJ_bGQvJرH5FpIc[@rvH%3Dc<I\$M.dr1c=F.4c2bG.!L|{Xѳ{INFdxqscݍ#Ea)#GJm.\$=GhAN=sŤE͑GG\\a10HF.tg8ä[Idn8F.TF3E6riqsF6xrL=nFTod>-3|2\$0= :xcHI\"NP\$bQ\$F DĂ}F%?(G3\$O\$^x2T0R#D:E|i/2XG8-\$Hv=d `:laxI:XRJRmxJ#\nGG9!N{cI&IR=I\r&j:8g#H'3_xbH}>7cُ\"&K<x2H\"6@db뱭e;)!.]/dm*f6,vɪL(qAI87d9TtcULX%HI*z:|IXqs-Bq^(Raq(~e9JU+-eq*nT>\$ѫerαp\nռ\$es+VIbeq:#]cc7r\nf,gYTC%	}\0\\*EWPa:E,&Wp)xlM3\0t\0/IipD'\0	k\$TF]fdMȀK\$H(@ɔ(znWҤ_Mݔ*\0elF^H	W*BZPe֘R/dRRʅ\0Ku,yH)\"SXI'Z=LR3\n'[k6@;}RI_)w[ \nnʓbBrl,\$v԰H\\s*.QtBdb@?3S`a@K\\.~f),?|&ӶKZ9.X+S|\0PʼEe/\0V^K\0\n-	:Sز)ת0j9TXBK\"ů²,2'2P,xpKꗪ\"D#TVD1Ao;ؕ/9TH%V`WJ<9aeʰK/V^/Q\nBZ\"9XүM~\$5\$0dIU2^X\n*E7I\nV3+aIiNKKg0az*V#bJyMҦeZ V`U1C.\rF-j&LUp9s鹊+Q&1RmӱgZ	,.XryZ첰032A1ւeN(?Al ,Nue\$|r_%E05E}\$X2%Ze \n\";<9ah㶥a]8*uLdR0+Qm.,GM_2edBݸ,S2>U԰4vl~e22eĵYg2nf=\$%ٖFfa)fTƶGg2W,[X>)tA]R*&Z6j2|\0(p	9 uҪ?`n-lZn!H9zL9VLϹyݢZJhRgEfLU~`4Yx)\$BQR#ÕS,6i#Y,;Cri&X]\nw54Kx\n*&TW+SлqNcyIW\0W5cɫ&+Vr)Kg? |gRhR%K)Z#5,ֵk漻`l:LsC[MUB6ldѓJ1nl:jLߖ\0h *)p/ާ5\\<9V/ޫhTdjrMbx\n]RWR MaU3=`0o,Zl}m월lmLS6\\tΙL\\%JK7oѩefMoCYv慭NV4=RsJ*hhn-m44yHM|isU=A\$ڭiϙ>ppQfq,5sUL8}ݬ٪#XHI9U8c:If7kl5}fLYN2ް}&	ic,I3R6r؉3b͍6>lXYfL)+S,ى*elU\"ed\"Zږ6ZDE9%΂Y9rmtE'.M[4^ɷ;Mw59av+70ld%<3_<lN(v+7YRl΅Ӫ].4I)=փNT]۹'U^?S7XCũӨ1u9EߙkL;NhSqNXk;1[LgpVB1_gs;RlENT8w,s1Pxrq3(;Z	yӾ'{O	_rȪMg|I92eLfO\rYnkuSNv9Vk	3ǧ.̛v9zyd)NY&s\$jd'6͔Q<V)e+:جYjtpu<ʖ3]qMY:9XSgIÝ*mCvGR@֯jT=:e(\0_Vn,?p	3'Π\r|\"igTnP皤\nӔq,Sf.YQ AA,ZeSsE\rvTQZ\"pIsUAϛ\0vZ}rKtfPf9疮{^Jς\n0%NGګ*~lD.Ke6[,%O՘-~쵕jRO;@	˨enb_%sKŜYY0LWjrՐφ!BPvfwګMR22z4rh;#M@}\0|M\0=ځ=f-!6pg[P4C[5:\rCtàu@ۺ<ifNun[!u8j{&9KuFQlRi(CA䮙s4\0Y;fB<{嘼R_I~6|MWTA]4e@JeP|[r5*OΠBt)%-\0Pjm	us}ИBi^*z0YK.`[Y2Ы|XB(?З.\$l,XD\njOD->_<֝\0sh\\ea\\\0e䑙Y`7U\"eCYTzt:V9P_aЕF;݀\0M2eHCZ?V'}cYa脬?Qh8	0QCM`6,JeZZ\"GWuu\r>49KI%LV9։Z{VEOX;oagP\$\nRX@}!-SiRqz	ITH.\nk\n\ndϮT>\n?E`5D+f?#zIZ7T[Qs#D\$PI	3*:9YIHHX0D!u7JmYB}E简r8Q\n}'PS	Q\$`R)^(OP\0aKm3\$H.X)V`9 .Y18eU`X9	\\LcjIE N鍫6WDXB	Z:|Ϥ:	E-P-&)*l)Puy|RLh.p_*QA@ ?,ƧY)tч<P*jVuQ:2\0L?J,TPHLE%\0yP(YJZTHX\r	Q4hO;\\vV#TWw\\`Oҡ?JR2=F]I5TMjI9,(ƤDv|t)Wy-]zea,pQ6\$I-g=%SW#TPܐ)T&]X15jB8Vӥ\nem yh*d4ςbd!0gRJ\\ Mt1R\n\nx._u+Ƽ;*4θ)]\\l(m\"QnT(*\0`1H@2	6hYcH_f?a7=KKdetH2\0/\062@b~`\0.\0v) !~JPĝTO{t\0005/ீ\rJ^0a!)8%KޘPP4~H\r+Lb/24)GKe0eS1B	-0jfSwLΙid L\r1hȩS MJJht)+?Le5n|FHMN5jɩSHL4=TDMn6Zm@I@S`)'7fzSzx~OU1kSFMOU4p٣2\000076k#xSl'K77\nlxSuLR77stxS}GM78*qt#xSOM\"78u)ӏ\09r)Sr2;)7Njm/xӿsNڞ:jy4SgO:1=\ncTSͧ;{Sȧ/ORH\r=tTIݧO\\zx4SM>j|TiSO~\$lO}t٧Oz*%]PPvU\"ݧK@\nojH;P>1FdP.5Bظ\r3uB<L#<QPECʁu*\nۨyPNl\r6?KmBZijHO2}1JM_MmD&KQ6Fzv6ӹQj;jj)*mEʌ9FdQv5eGɵdԄEM\0+D\"j)SDQҤpZfƂmR&HUہ%{Rv0m0z䧟Lƥ@'ER?eJ>ԝMIYTR/Bʕ.UTYRΡL:jNԅRL5ji&,OmJD5,9Q1hTfNޥQ'7Lih\rcjԝSzu\0nԺg9@c\rT%LAfTMT9uQ\n)USuD:jU	ƨPږq*EڪKSbl\\ڤFŪGTzgJHSF	\"Q:1;RꦵL*~EߪoTҦ\\z:]SꕱBU^JuR*kE	TQtRg2UjV\$_SmPHU\\T[Uʫ5Jhٵ\\UpV7a_*=R>\0I*VX:hU8jTKZ\\:)jT8	WZUbJ8R=YUVUR\\:-jѫiV.[zҪ-{TZuojU3 [>E %\\h#bՅWZ-\\CW>]ںg4#KTrZʤwj\$z-RjtjU*Wtp\n4'NMxUX32[x+\$BUS*qUͪqXZ}Sx@-W\n5XZՅJU2=\\F+V0]XXU0-VJ+/Zʮ5sjDU޲%bɵV%Y^u@dբW愔ŲRk&YR\\ŒRkYcVO-\\	kdKoXK/9]VO-U<@嬥Vγ[6U=eϵo4TݭY0eHդ\r96(󮝕+7ybrI |\0:Fz\n|s<R%J]F3jΣYZ^<5XIJM`nO\\B&rsQuzx	TVwJ5g	?vqF49ӝ6zjOV\ru=@ʒfT͚y	֫pKaXU9m\nekMo5\nhTꦦVv:s\\p>L:)O=nk}jS&֮~yeܚZֵ)jtVRVsr:+ao,!TlUϕ*n5\\Udv+M\\)]B|Jl;45pLӵئ7Li[~bmtSe\"Bvd@ͧS4)ؒZ\$)5ic!Ό\\R*SDw\$9tS\nGfPԛʸ*	KDVy5uȦJב\\C\$W,M\\5k^Vs5kֻM^{uϤwFQJHgWNk8ʉ+1br˕VX]dLjYTv6twy˕kvx=5h8]˷x\"c|ufU\0ҧ5jȩ}Pkn̚Rlf٪+ۣ>c4W+TDoqSXb}}hn&<?/3-áhqn	p%)SyP\r͵m-f5[\\=T}y )Ydؤ46#Y>3נm\n09h;40+ae\nȃİȞ!)@xx}\$AFÑ0N R	ӄiܥU?b5!+׭\0Gw{ӤlI )w-4;p8ؤ;@\r\n\rN5ƅF\\ӹhgPE il0X%)\nLk^2<5FdI<FjbMd'	ƲDBmaOYXgg8ZV%mf%F-,\naFwfs0G乑Z\n	1;J1\"iPByCtzӉ;l4ҡJmLX+lᘪ{8\"\nV(\$Y\0d\\݆6D9BHd%16f \"TJ`/>C=c쨱?e!k*3l~i,Az/dMoڲn\"ɽzTr}eٌ{MaC7fiT/6WP8Fa`5Mf2V]['}cn4]heZŧ\r2XllGa`((\0_lOf&f1c8D{Q	S6p\0Y\0\rq3m&*f;p6r^cϳ`ɵ&zn^ڱ;DSoj^=L'g5&Ef&|\nK 6?bX*.fψE~&9!dk@v\"FGx\\=E7XP2[:\0׎X~7X64(\";B\nXhy&DֈZl\nKCp`mS	2U;G8{-WBm\$F\rl&BY2\rmAőwZ6RВ%d_T5``BaGcXK\r\0gN\\;Ns^\nuѲVwzUF\"\0T-,^\02 / EW/\0¼ľ4;\"K-NZMcλRVNeZwj6aÿKVlN?jt2T/[Nj|0t% #\0`5F<X@\nӢZF\\-mcd2p5Gv'B'7{k*'LAZ|Ik\n-.C6k-Sk]_\$+Gנ[^z]k8\\F|?B^B̎|@BzPW/R?[!bBkѠ'	(e:xfr7\r_qMa\0#7|Q&\0Ɂ@)1뮆LA[Pt\0`6\\ezxS݀vՈπU:ڱTϗ>f\nql+K(|\\ѠGU؋@(*iS%F\rR\$CL;dļg-\$m?lhʝ3?PY\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$r=file_open_lock(get_temp_dir()."/adminer.version");if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$g,$l,$oc,$wc,$Fc,$m,$sd,$zd,$ba,$Wd,$x,$ca,$qe,$tf,$cg,$Hh,$Dd,$oi,$ui,$U,$Ji,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Rf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Rf[]=true;call_user_func_array('session_set_cookie_params',$Rf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$dd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$qe=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($u,$if=null){if(is_string($u)){$fg=array_search($u,get_translations("en"));if($fg!==false)$u=$fg;}global$ca,$ui;$ti=($ui[$u]?$ui[$u]:$u);if(is_array($ti)){$fg=($if==1?0:($ca=='cs'||$ca=='sk'?($if&&$if<5?1:2):($ca=='fr'?(!$if?0:1):($ca=='pl'?($if%10>1&&$if%10<5&&$if/10%10!=1?1:2):($ca=='sl'?($if%100==1?0:($if%100==2?1:($if%100==3||$if%100==4?2:3))):($ca=='lt'?($if%10==1&&$if%100!=11?0:($if%10>1&&$if/10%10!=1?1:2)):($ca=='lv'?($if%10==1&&$if%100!=11?0:($if?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($if%10==1&&$if%100!=11?0:($if%10>1&&$if%10<5&&$if/10%10!=1?1:2)):1))))))));$ti=$ti[$fg];}$Ea=func_get_args();array_shift($Ea);$od=str_replace("%d","%s",$ti);if($od!=$ti)$Ea[0]=format_number($if);return
vsprintf($od,$Ea);}function
switch_lang(){global$ca,$qe;echo"<form action='' method='post'>\n<div id='lang'>",lang(20).": ".html_select("lang",$qe,$ca,"this.form.submit();")," <input type='submit' value='".lang(21)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($qe[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($qe[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$va=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Fe,PREG_SET_ORDER);foreach($Fe
as$B)$va[$B[1]]=(isset($B[3])?$B[3]:1);arsort($va);foreach($va
as$y=>$ug){if(isset($qe[$y])){$ca=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($va[$y])&&isset($qe[$y])){$ca=$y;break;}}}$ui=$_SESSION["translations"];if($_SESSION["translations_version"]!=1429097780){$ui=array();$_SESSION["translations_version"]=1429097780;}function
get_translations($pe){switch($pe){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41CdHe9,\nH(:Eb9Ai:&yw{('h,@pzM52NDz2\ny3(+W&3yk:\rvc!i~_k3XL0Srݭgsu89J( itAg<3((E#j\r47CF\r-|(j*h:-%m~%h#'9\r`P2lS5ʢ˃(9:)BS1?nx޵\r\n6#+l#` jָ=\nB \$CƤnBDH@;B\no>`@\$cB3:xE<+8A|<C ^(ڳp̳\rj|9(Ʀ+]9<(:KZ ^ˋ,\n(B*B1-iGcxؗɢV6Ҹꌄƀ3#z\r֊um^èW,\$3`J1\0S<\">\0PȤ퓐祭ʒ#k^cOc\n\"`@\\7hXucI59r-@< ,\$XȊ<Ll2.Mv-\"'B~,r)(뼸%b{UxǠ,\0003ds*\rԠ7(	\\L{J[=B˪0aSlQ[R'!4үFDi[m<0\n5ROM3#?4C4XF2\"9RtTu6}cTUUd@C\"z#7;Y(%Hܸt_5>2QJ1G>\\o ک: \0dy!]@5҉MMCMw&+M䙗D22\$!34w8hD~\0JF}v?E|	 \n ( 	((\0DI1%t7Ftk\$\\O1&\$	 ܾ\\qF4Wŉ>\$a&wTwPˤ3+ťAH@52ZLBRz&M] QE:JIY-%7!d\$B|S95Qrֻ!AB_-%bMQ\$(=g2c#Ǟzgc[%9aaHoD[q6D)L0ڞ\"(q葲:G)RH#R:TS!hăPi;\0hL\"M	8PT*\0B`EKo.	RBp.#Z3(	卂t<N))\rW`Q\n|K/H-6|dJG*[rD<O)okΓT@PVDuct&h'ZPu9GHߟ@IL\"8kmpf !͈ڠ\\#Vs®4i\"Y[\r&YQSA_IN\nXAX4գ%|S 3؊Z	pJᐛTR)eh1gEP\\@]#-&qpqyquv\0\rNimS(m8TAa O{e~QIPw۫l@C		_(.M˽)D]\$rps9l1AU13fhb×'6:P2^ky=9ú-ܤ!8#x0A(c`?*(rG`(+PaQ7'!k%FCz;+3fk\\YQG/M02D6sd,&DKk&htFA=wN	po1nmetSv޾ތw[':7f\$r*^6LOe[F%-Dxu?	j0wǛ (e<.%EΓ(	ՠ֡B@WyXƩ7;DnmbQtk7:U˶y<귋n~[W\\0IPRK}ww\"dMsS:Y/xO̽S`l{ԠAS;R02!xc&SSmO\\O!EF<qWI(\"tK*M?f6D>6ؔҞG?8S[5yZmMV'򟲰|Q~0;7_hb|W=&_2VfCc\\dlԫÚ0)*#nOm⒮P,(p*.hH`FTIP3H.hsdC\\LWKE\"ZG,|OU鰐70@%P-𒳏\n]oNX\\n#e\\\rpiOPi,rl*Ð-d\n70<5)y4&D0] 0{/0@<HDeҢ\rj	\0։[rM:.ވ#ÉR#\"-0m%\rJ.d(\rV@tMn#, 20'JEBZ6:LO%oۑq\"f]ڻIe	Pz\rBv01*7B)E\rg!'2_Crr@@\$\$>HC!P\n'k/q MV\r&pK&0Jgr{'.x|x6䴽&\n|K\\+\rl\n&\"`+b2C ͢^)v-'ePz>GPTi\"/ʯbл\0\n\\i0vl)@HZJL	*M3<\r&N4 \\";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*:C#%<U[VDXT\nh1b1YM7MQv2\ri;MS9 :m!:\r;Że\r^k\\BUePe2թOfB3vꃥzIߕ	utl+/*[f;\09Cx䙈30m7͐:#n	D09ȧ+b)L0jrl	18)bx*+%zY+dB&' Ҥ\\=IV̴ʬB!\0#\n\\Z\n-WQo+=	0bkbB(\$܏hB2pʻ댄W+%O#Ԍ{ 2\rCpgqH#o`W6#q\0H2\0yi3:xu\ri[Bpp_qDTJ`|6M3BCk4px!6̆b\$2I9@T&2[&'T*RʉS2Zɻ(B9\r28Ӆ+9Nd2YhlRR&b:\000=0O!ZltUHE*3ET۔dZIoQAk>G,L^B668svcFz|\nb!ۮ^Jl4R4ZϦo2Φ~[rgQv7/٪zqyddq3nm2 -/7ȈMBPpm(x8bL݁kF9@Qgf7`@j}U\0IX\n\n0`A\0ua,@\0l\r5(!0PA\0 V:pPIFꜭ2X<RZ3&\$\nf\rr	79B}h=l8C\"[fo.Ĺ2]KwF5mF>0SKW%F*1\\ \"VRf\r&3	`𾖺4Vm\\+ruҺú]p@/C\r:H`|beZ\r %Af0D\r	)hν<:3#جA\r`1h!3JTCW/s ՜rN#ae\0+`il#!T{)=1EC68(D1!TRJ[H@!x`xZ\n#<xw=Rx%43EDMLA߭0扖?A%VZ;\"iOZl\\uC%<dS\nAѲx\"&-0\\XRj4\"*V+T+mR'eh(eӮ 	{i*\"O8&a\$V#EF#kj~fh3!eڷ41\$3Bj*&7 dād`P	L*\"lฅ\nЌ=jfb򥲒0М;kRTҹJ}bM@@P56ΠӇrU:`@ 7+L#@sA\r3!_?sr6L56UEl+D!ڧc[\\A<'\0 A\n!PB`EnAKRnTQĨZ&8E@%4Q]Ih|Y>.IY(,_Ґ36~^\$7	ɰ%%v',wv4K{2%aS;A&x3]fI\0_:J;OFK;br⨉ʊB~	()Ȉ)SwN*4\$oaYV(1XJ9KDh&2v0[YCfDٙ\$lp72\"j<ȵ\0 x,:٤沮JR9.d`c\rdp!^9kOۤƳSqCOh޽X\n)?(=Yj\\IoҦ.S& C	\0҇`W¡tVSDyD`EdRQ0Q,K~wp^	I~ECAy֡Qg͍+.UdϘVڱm<^;c\rt~i7MAp	f_&|GԋE39 (&b\\CKᣓAU&I[bfʠ~%(Ly^ԑ~/JJ<\nX&V c\0003@(+4yy-di</f>f/\0\$I#h\$f\\lfpXc8'K0ZGPNUzeGuPhԎĜ2\"lcض*\rd@B*J)~ƢJM*FDͭNJ\r\np@ef昱P\n./|gb.bkG\"BOfT#.y	V{	P.%i=LmRzL0hpP3PJC4t*P|hg<@[/6bo<k0/F)nm\0&HvP*#1	1o%	2RΊNy|F\$Z&#	2cدz:afq[\"S  .oIc\0q^2Ee!=͊0%\"(qNW.]	Dg.>%@nAOp^wc&b0[.T)*qd)'2+rMrƃR-+n''(Q&b:Cd2󂂑#g)dbqmB,B1\r,K0U3(`.Dls-)Mb{<32dR|;0RD\n<G2TSc6/IS673v}3SA23e8ZF^N6ד3bibU*BӨi`d50^q	;\\7<FȔs;<+&`l%nS\$B~TNOF'@bR|p:G\rAӭ8i/8Ѣ&۳]@fQNP7yD/9D\rD\"&2ƯVƤ|cm3\r50j,.Ѭ\rzO#+nBx4\"r.Pt;j1%\"H^\0k\r3lf9J\r\r ̅&` گD@|\nZ>z\n\\葬 rb:h&\$o@lbe	Mck%98#ҋ)Nw@P @D5NIAQ/H	&\0[Œ9V>%*O5P4TENwTM1НtuYKZP?[BG7\\6<@VH&<Rd\"mp	\\L\nDbh3.|aT)wr.(\np`\nł\r& ::blq;ϞU:3|XvmD*\$.\rfn86-drbRT^o&\0)/K 	\0t	@\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<GRzo:ʢuFCEal*:E\r,Z\"(NtV	QvmY_aޗZ9:xn^SICYVFnB>*/\"	8|בא0\"Pt9QL*MZ*%?2s6@B5x7(9\r㒈\"#1#x9莎c9ȸv\$HKQ\$B\\\rAz&.P͐P2pD{t-ˊ洫N<+*A^>Sy`&hR&[fhal#j6̮d!,UWms+?_&hLI޳JQ4F\nRխ[o P2\rHH4%It##w0xH c:\rx%!9ʒ`@2D49Ax^;pr\\Ѱ]x7>9xDls!4r6ǣH7x.5󲘲ˢ[:]V:#E|YNco,޾ͣL+Z\"`P0Cu\"-(tJ짎Zl\rXLZ)ż0Q\r;@*76ʄ/skR59/<.L7FPD\$#\0UH\\*։6AhVNIǓQCZ6TPCMϔKӋC&hOjT=5L!꒓dDLOYϞcRZ^Uh5fLZHmJXweKikՅg͢rҠuǵBhDo	\$)ܟ'}U@DP*SA44~nRDdA<FNYs.\$\"@Pl(}ZXMi˛gA\$oԓRPi@G]+m,BXQߣiZ)H.0q9ȷq^I,\$zu?HyC0e#ylJ-%a\r,My\n\r'.9I%J(P4^rz*It1C91&(Řcݏ2	Ó%d\"`Ι@\"5zA\\2rsI%Me=A|\\UR0Ke\"&&C6M)<}O\"ثc,mș#&e7DYDtExIW-Dy 3_23m|TK\n4@6֒^qS^Ȑ׍g`Ct݃fӨ9U0u7ueh!<76&pWKݡ! p@:d\n,3@PMZDm\0(-הoU	*(\rpCu\r9c\0g(\$C{Ϩ|S\r\$\0,%jߩ1@@*)4I9%-}806ҫ,4;dC;	0;.C5O/iP~3ne:=[LeL&v2d<\n9I:x:.e:a'78^FHK%GA\"#X2#=6n'!s)⩔@?L<MRVq\r\$+sUhJVZG0v;q#	N{ކB J)^TMrԱ5ׄ6HgB )CY0TD3\nmpR-y8C[KPh&Q\$G!z5A'ڥtYvQ<KZU82j_tbR=[]Rz*\$DȚZ7'@se\"]l;A,!GAep#9(Jd{_Sź8/Z:NxT:jaGi7q⹧E@~V-V4}ػN7[H|(ƖL|=l̂^!8-Q)U4-Z*{hl\":ӮٺYz3𶩷7/s=38~ݹVY.>}C95\00ruࠆ\0\rb<fG\0g3h=n^n3DW(mނ(ࡠ|\$:t\"Ec.AdjwDnwcp6WY\\@\n`\0l\r\$^HJRPhN҅v&o^0nîopNh\0j+kZy`K:G+<)e\rE-Z\rz,:\"8g/MLҐ+B@:ȇ(n}o1\rBrIR+;\"k#6%/\rL\rkr-	4)hD*M:bWW%pǭ\"uou\"X\0O=b\no`&YT\$i\rׂ>:=N,3\0VGzce\0R&.\$Fq##\$R4ybjrg&1&|l+QN./lm<r5RRg\r.K/oUitcTP{>ghG\0B/!+M/r8R6/ج--xrqxG|rfNθѮ)(4go+HY+N%CZnRvo&44#+\r&2\\G6(4ݒA2*^M7'8.2qq5x3W*V~os\$8bq8>t'Q6\$o5 jd35R3S2P\\uB2M4,Yb;-j?'?be?((Ⴐ߰C<g%3k:1=>4;)S);=PdC;RPH<3./Z˾ɤ:ҹd%?-i9\rt4&N4H氭Opp(D>BT	y5<L&t\\,aRy)봾o&NV0('4L44\$HG(S2RiT?Kq55\$Ft*3;SsjPEh}ɹQTNsW;EKHrsDҖUUq85-+)oU7.Tg+p-Xu\\sfsp%20@	.Wi0Zs)@GMc7\\T\\	\\ƻE\\#QFnR^tVslAGrV5~*Z]ѣ`'qF9YjtarKg[GQG#609PCU5XRvH0Ӕe#w8oeOf\rvgekVTWV^5jggdebi^vciΈ3-J4EQu_5x4h}CbvSm\0000\riH,fd.K7\n\0vI3n|l\nVnIonr\nEPP3!]\\ +Rwrs^6;K,*c;S6P,0؉=vARvXŃKM5RkBCxLu5NWF78WVq-3BO D5B)9QEa\"zByIW9]B25~sG~:QE\"^&mI#gM9BEa:h++1'W`b9\"bd\r,N5bU\r=MxOQvHQ\0\nq\\k|\r~GZzer |ʲ%8D\$D );'[,l(+uK8?T'\"6Aι`EADklu9D?%,NeNiOu\$k\ry5Aei.fy?J.?*2ChOe-s#ebVcMxX@X'yg'U]Mm4ӸSLU?ReFx2porRG4fqm9S԰AML<쏖LL'3[&{ǒr#@9OG`ؓP\\6y44bV>&EG.~ҲludGjiY\$YE\0!%[pjOwb>: ";break;case"bn":$f="S!\n\0@xJ_:6\0P\\33`\0!(l	MS,S,\$])d5s@qD<6(R\$i撦VI\nxʙ+\rBb\0!e4M*+Vp@%9;e2S'	`ObM^bS%UPH)x2S)zʞ4\0h3Qh*\$mm'Fs\rU:-O40YBWNX.._sC:\n`2B,_(o:\r@7\r\09\r#689: :?à41A۸S<SFª:ȇ<B*+'QR\n*\n`<*z>\r{΀b>D[8(Tc6R\0/CNJS4:j[\"Z\nʯ&KM\np\0p@2C9/b\$'\r#2\r[7 8QJc2Cͫ-Ĥ*l:R:.l\$3LJM&I.M9>j'-k&Oce_|^Oϣ :V`䪧2[k~!'R['}OTR/U:^\njS:Pe\n猷q8ZJ	Jcp2\reSNtB#s`ϠgJø?T02\0y3:x﵅iRxp_Qu-NK|63Ql&4px!Sev۱~FHujLS+25j=8Le8+osS4k4*x%%ʜvsFdDmɁ1P+#ݣ\$a(^Y{S1	r&7Ҧ䶎b;{eŮfE՝~YN۔ʂrMDk::lw3\\|.h\\MO_o%a[#HY,UZM):__eB.}kuF\r3\"!(0d5+жCb\rCh 0PS\n!05CʲFOS1\"unr;^weQzؿu*7PIƏ6\"\"15cҗV<lR%/P}DSUѤhݫx%Hk#ݔzI!Hy3kD1Q,7L&Z\nC5tဨh\rxc6U,äo@.7@fuhM3@P@xgMͬ@=g)PǸCpuB9RUKaa,aLs\r0%;e8T?j8@=*mΈ(Ʋiݭdl͡6M[rnmCv@8tmbU,!LjKLH4oIZHbA\\/ }[WAMRRXx*)almko\r07&ݦ՚I@mnҬ-Pz:,*\00U?sdVJCAh5AĂ\"b?FRDfz}hQM9 ےH\r0fIˎV& )#pw*ʺI\ncnbe%Ȃċn&Ɇ:Lb@WtAaM+þ&U&|%^y\\cSjnI7úaҼ+U,Kq01\r:g@+zQ1lwX)ڹ& ,aML+5'@T	<\\ux)\nL\\,4i6Q?ZөQ1i:o\n/e}]7HC&jкk5:pmvIرQRY\\^\0T!2\rE\$y;C4#lvz{Nyl8}n|3tdIj\0007?1YE!\n\0ۚ@b-@  @L#L޸i}RIUf  \0\r\0K]Yҧ&X\n<Lє\n~O/FreW8+G[kL|G)H6]cwNoKޅ1>ӃE<:bG~|v')=-賴Om降+灸𒧫?nNh[L|CSJIKnLoߢΤW!%ncH5.ymwRtq&!h/9S)i\nnA*U8m~gR}fl\"2LA~_]gdbjg,ثgvf\n`Hk>H\n`A<x/4)´\$&Qޝ0z)bY\nGD.PEļt.H퇄aNdg\"dxL\n-&%VpĜk`\$`kJp\rpbX0u[LFoe\n<8*jBBEn\0:Ҩn*pΣ(2dNŧtZO\\z'h \n`\r4z#ge<PBPC Eoh\\b{^:z>] {q(JQ2`q\0>.\n.Xui:gn%oD:1;HʆL);G\n;o8GuX0}l9;>*\$?bIޣ\$G &8UBN(r0#9.s#=Gu\$c%1p}b8@NJQ\$e{l%a\0ju*rg:䐐-C \"X\"r\"͢ie#/N%*HoBd;J*tx6B0\nyP\0Ŝt\\*b_Íb\$>KMLƢf\\üGxa|\0VT\$cGm-(Z1ʍLtysl*-\0\r,5e8sjǋ&0й9:\0BYtb;;	\n2\"9OR:+S}9ֳ.fbb}cI8@ZsptQ9 #L!o:>Wo#IC\"̇q;*1Px1)I5c]s>q<j0}L)Cv.cZ71<K77ICE&@?!DO>3%T/aMMSMDP_v{7ԁ8(wJJy>OPTKuM-NO>\0ts(%5%CR'iLm!UK4,0r8QFN	9D_UQmCPTU42cG'V	VuWT\nC<p23X.\$=>	sK,\n_?Q@QZ4\\dGo/\"-L^P:-!KR.bp<7*sD:U_Ud=`l4_\\![FZ& ra#\">ȸKuTKcdbG@#wSxUD_SrP\\u3OV!5^TKi>T;\nvՅ;ְ+\\?k6R	o6.\"2P~jսBC6HTGoꑖ^4ZR	pMo3p99\$7#q6̑IChvnb>\rwkY2-F-KW!L^U=en\$`;e֝T}nooUwv5jUip	w]j^r	.ġtYx[jwtEDtқu	wmρr8r#|\"|d7xIv6 qlԏw}[6Svu`x4'סR7Q!MSr4e5U5r-q灗H*)Gf3WԌFvn5x/8K#ӂcS}8D֣{wj|L;mfv?E* nqBAdX\rx(f짊>=[\r	mRZ9f\"Ȏוm8xb_^9\r8w͉A{y5xG\0r\$Bҥ冘kշyy\\8oo!mH'PufI}+[G{y1L6ku.>@UuY2mY\r:w%Y rYXٷEd7xsWY2\rmśS!k983f:LQYRuZOԠm\r8B\rvi2\rS\nppd/uDՎu`5!%]96;.C㨨1Vz}i]-=S=!-\rs2aFݦ\n	T\r:X4u-Yp)6USB.9y3\"V<U[\$2^8F8X	\0\$CRz|M8ψ\"\$-\$0c@SC0C驳\\N\nyI{\r\r2&j<YTqm=3ϣu\nA?\nfRU;w@\\CUΔ\r<r! Cwt¯AGN<Is'R^ɐ\0w	Lr/ۇ88_D2l@h ۀbaCHdE86l|HF&O.1d-h/LrMܴvy\\T@'@@@)ƤWgHOW5T	\0@	t\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(Ulf:k\r5B2C	VaOFLU6N>\$@r2\0Qdu31Al4MS97A|vr♆uњdo\"b Oڸ\$2h2̼?''G3pC8d!|\\)\nU476\\5乪0h5\n\n:\n:5`;c\"\\&H\ro:4\r#[1)Ji^\n\\**h3J3,:솮\"k@b#{2:Ir j/c/JNؘ *0BсB5(̀*Ò0900cl98@CK|p\rá`@ #C@3:x]\rr3^8CP2\r˘ڏ#x|ȏLl\nNFOO*<5`24ٌ_,c6^bpѠ+(m291u<5HK&,f-b<j>o2710:k`d26C\rWë1\\\n'9t43Җ8ɥH+\rCjj1 v(z\rz%m\$(86l{q6h&D4.Cw0c\rz׽OMEN\\\$羃(yֵ<b*l9w'I^0b uP4,v~\"/ŔSF7S	L3Qx3 j\\'\$76<J6n@xg(U%	E:\r((`RROFEѣTͺQDL*ox4\rJV*ZurúW%a%?0Kif肶r[ĸ+.B@PjPhibFUR:N0@T,ʭV%dWJ_BanXh>	-ٲpKa%A˙}+DUDhr>.\nm,!\nR!5B` 1ƽ#2f )H?N,RQ@s&d3@z@i.|ΘpӐNhy(@\$6\nEQd\n\\VfH`lGh\\ۜo񨗆SFJw'\r>̃@t\rPY\nZu,)s~1Yّ3Y\r%:.|zH C\naH#8T<Y<ƅQ:ؾneu%9IkS\\6d]24ֈ#9Hy4vQq88Sl2Dp`(|vfi,۬kPA?\$(تe\n(r4vI!	*mCpf!D1J-Y\r65x>jP@oWnY@ FRpA40r2FSY=lB6`[C6-(P*P@\n\roH94a *\0B`ESmd=\nJԶ[@SjmX'v݋` IЖ)tEUia¸8vEmjX_uiĺHsLC*gY@蜞FƮa/FzR)b|OmY1ň=ˁT:{ahSQ9'4\\1!*1{`b3\\ynx7 kf.'WVX>@&whP١\r+z*S_5@P]ËA\r49KJk3A&n?A<a֭\r4'Q>4GPRe\n#}|qP 0+jB!4+q#e(\rBq=\0&%AN\rʪ[f'܎585!%TnH|P|Y9?h{^E͗\\bSzpSsNC|.y ܯtI=D]3g^=Tb[y	|&Q p(|<(Ub=F_R<)T8A2 V	z*ކPr*Vk-O HZ(rK:SmtG+fRjs^t<OSZ5h̓<2}r|i\nFƬi94s;ݷQN~+-\n-W6IcB\$\"°PgN@\0\0\0C^<PF;BGĂJmldi;lp&\$\\ɎN-MjNnODi2p>\\x\"d#I	ІЋ	!	/MtNM'Lp\rWȞBtpB0BM\"DKפHB0\n#M}P\nò\\hz@HNZ\$50J \$40EMj(BdBVH& \"m\nW[\$lz^,~mg2x2Qb\rk-BEСm@_)'v)Aj9Pcc\rnՅ& q9F(c4OO.FC@Ȝ	@蔍HPPD.%r-pէhc*^r_\"\r-) R^n2c'C)&4%#^yjW)L)K xբvyI\0)RB]&c)@f\r#0&Jm5\$\"B	.ؒ6r.U0@ʯ	4CgƤm2'2#*|'6,-M3 M4MI!\$/)56d<;3@DJMk@p.2Ndgbc¢s&#I.6]e}:25:XoXEB\\b,jC`YE!>Κ.!?b	\r.xfKk?,F\0R1Q;*h!>f@\np@܅p=δܥpǊE4V;.#Pǐg<wV^c\$\r|.+#\rѬ/D\r\$P`x+,bdR\rpKbK1r-jtd*g\r&0:%&`ATyTf}ڷTE,xǒ0C)R0ʈiHB2Z,%0#P(^KXDZ5А#B⨚`H(y\0~ l\"\nr8gwS@\$ȧ+LDZ&0..D R\nDBD\n\"{\0*";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&QPp:ӣ>%4A@h'l0L9Xf;  e47bY7qv 8]ƘជNt鍂#fYQ<'E'\$`yuV)/&pQOvXby|U:o%T5cܓC.P ߫c\"Ô\$8Ac0-0:\0h(~2+>49I`4\nb!:\rB9KǮ脼\0P2(3\ni{wRDl:q̥:ApIH4cJh 2aom4\r08#\"mHt 7Sh\nC1cpΏAp<`-3\rC\$J&CB3:xc.˨|0V ^*!ں̺j}%-G/UL	0:c,V^v߃}@Pi,4ҡ;bK?`J283:3ʳNo0C:R9uƬ茑P1 ]EFQ\"^IÍ87#`7}jH7(ؘa&&F(Kҗ]h*0h3\$7[Є&.V>`>BUpb=a:p?>@O83<r,(7M \"hB(P3Y\"]ճ\\/\$#@7FHΔJ&\r6I*:74SH7:*\r|&3Reנo/}C8a/'M.((`7<QHLB?oczYa2Q21^*%Kn8.(LA'r.gM9j̮\0L\r.'IAjFex ICv/T:!Һg0`,%Bʈ\$-yO[\$P8cA(GjCZB=H4^\$%Ш \"Q}\ruQD@[b#\09B҄fMQh`TU2J4-bFmŘLdL#mK\0@@PBo>\0PTAJ\rHY?!40p܆vocwd 8Go!3\rQ,EaRAICqB9sA5.id	/L0FTP@d{&쒒rCӡK*5I. \nx]i\"2`Q&!\$c<PfSB	*@bH:>_A|\r @'0AB'`4!WvhzXd/t5Bg-5ԕTmb}uiEĸj  Ru)0OUBAPmIpDp(ȬJDP*Wu E	#dtՆꬃfIÅ\r\$ϩ@B)<ڪ_JU#?ON=YrDN)	|*ue%H׈]#r1AX=D@	\"\nĽC4nK#|EEBLmX9#*Y	M׌zh)Ċ	=<N=A\"\rejm&99Q+lf#'&p@[f\nrFt }eaDdfZLxH\$҅gɡHeކFIvM2A ()\"x)\$i0\";\$ድJp*%@.Pe:ww]\rc0hecTҷ]]Hg#1D{|=jQ.|Z8JQP߆Uäל7B8\$,{xq'\"h).)8EkwىT&ڠK\$@\"VI37ҞUT<MuJIwjKG)Eɕ@ʮ:mؚW&l 0rI!1d3ΡZÆOb\$dw>=w\\;2{՚sKLaJz8saxor~\"d;ũ5,٬>10ŷ>N<kJSZD@PoPV%f߲2[{E&{8BBP!ZhPe\$(FkL%~BG,B\rʉ\0BRJvP8G0Hv*-\\rbŉb>btBtrygQs\0\$Pj\\e@nFym	uО?0@@ᤗA0jK\rhZR\rfvԈ/PNT0\r&NkH.r̅GZ4%%:0\0Dı/Ks\$\n:k*).Wb^~pԭP8̤Ӭ\0ڽ1L/\nϞ`Lk%`hO	p|uѠVњ'<N'ύ%qMauͮxn̓-82EVN\nʣ@gLˠ\$/0\r	S&1rbhܺ5H3fc%F@r8;bKpmpT <.PR%&y&s!&`'Ҁ%]&m'\$_)) p-+w+&02j+U\$6b\nMpSr-JZ.c!-`|@BLQ*Lɉj\$R0k\"g;2>ב4Mt%w&2-.(l5 +sZM@AigMĵ&&0\\A%BF=#G\0<8\"c\rܟbH/95<i=9,:a;f\"b\n\0KjPP|o1kvj0\$\$J<\nZ~6TNw90<cwD-AZ䄖gtG P]r'6-%Pw?@?t0\$%:aL*g@d0[g8:n>=o3L'J\nf/Im0(t<2q~ap7JʑK~LL8@re2\n|  6@r?\"lQLMBjbTѥ8׆K,f0p\0yD01Ƽ\r\"h.ޜlvT@dOTRE4^3.9D3\00051指e:5wL.8(ҨHJ\$.[fbAR`	\0t	@\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\n*WƓA9jp<t0YVU'@QZ3zⱊp-plPDle2f!td2YC_?{xno5~ f&3M\$Mfl6\n)L'(<8IXcC0b\"ȭ܈h@9)X9(玭\0ԿܦA7m5\nN´+Q021QF&AM>:c\n!\r)>	RB874\"0ck2J\04\r	3\$Ac\n4=r4/c8OSD󧋸2\rЫC\$\$#A3\"ÄTNhC,SH`@9\03:x]\r!I%IHc^8IØxDòk ̔Cj|8\"-\r@X)s=\r\"Sqy^2cXꇷor\$r80ÖC*%H0`N#c-X蹾8*0P.'LB~	1`2ˣs8+ey&7\r5[>07\rrb3; 7\rc\$^/:-_44\n86d&&\rr<c~c0R²8)\"bnӕHh(33ze#ӻ_̸P:'3>4t/@TU;	cʂH	3(?}'\$]WQHCD9C+4jmAe3#X50̡AX2QSC<ejn`A̹S6ʨ=@4Hp7h1u\"./||\09r.`Q58A\$1bP\\ߙh6 X+3\$PWy%~D{#hv90\$ML9IhV!VnV]+}VrXk@Gi8)ÁDan-:xY9\rEMO8rQ0#qQ?Ԝ!Y8l\"UrL6ZYUnUwWǘ\rX7,탁;g(|Q)AUMQ#IP(dr?|S\$(RJtTխJBֈ]Hhy˂HJ7R1	=uVԦTtJYe,|S͎vD`RĤ\nH\n\0Lhh(*\0\r'\$+h(0C=5g(>l'mU;h\\\r1@ʆCᴹ9<CȔB)BPr#t=&Jf~&@R?0y\$Z66_Z\$0%a<ȄӰȗfjҍ>O2tMl`ZyGJ`LH5>\nazW\rB'\n1N`oFvM2\n8_+%\0Tu-3ӉVQ@Jb+3S#hif뼾M	nNU`ȐEkho #Jvs:W6cQ+a=T+mkؒ\$l=jP!6-!LpNǄ݆>dXmt#*<=1\$/\r'L.͆,itj| ٭Q;J3;MS?OrudMxb4ȦT2Qq7ל	̿|VOXrT\n\"Q\n1\"GL8-;/|\"0՟\"VKK_PZN\"j̟Z\$vjփOrk%bBdC8:[OYDbRlzɩeQv]E[gM?yeSC'PՑ7gYcAl`834^!2(7.#)|/ F~\0A\nP 0U&HJO}ځ׏@=06.h5L]`2A)XMîDUY:c%mk8nZsg 7qK>W'vݓw~j#_~S{/t1sҩEx%\n)}qzp^{Ob_k=|8}i\nr\$hp1J`a;-cZĪ`tjpwĚS!@#EΓƨE]\"sK\\<N	8j:p4#0 @9a태lnrP0Üy|`\"<CBtq|a'B~8xf8fH^h۰p0Rېm+:<'Ff5L`(1*9khxg\0ƄM]9 ^`6'pRCLڋB'\rnNhⲛ(BVe<²`nRFp`ΰvI'1g0Q%B0`yN_	1A\nm30v6*qNI1ǎueVy>6\n P~ k^a#1z<l1rQĞ~Hq#ѭ0	LHQ^\nQА\rv@ީ9\nfD\nl&!Z(zu\ncT#!EFF;igHkK,\\ZB|++%CnF7&m܍B2LdLrFqMq GiRwx\\w-TQ6\nRWq2,I¤s\$.,R-2'׃Z?FVAL	b*S\nDVF>~7?Q+x36C3q3һ/JJi)'<8^.\06&;s0Sm#c\ne-\rbEO93ZJ:By:+>sjP3;3}/-<;*4k 3+/R:ft=9 %sߩiQH?q5j5EtF?N!B;M=1BE'+ hB4'>\0@MdI.\rr/\"M=B:=Fd/oCrGm>eb>Bѿ5%zBys#곋<*qh5JJO8 Ԩ#T6thFT#+2>.o@gJCJ<Bvs.4O6ELq47uv5|e\rV=blk_BUEM\n`@Dd3dfS%i:hl\nZ7Cl2QP/\rKW8\rcQQLZoX\rcRuN R*\"RP)j\\g5<32FGCB	b8#\n0h ƈ0@DDI&S\\4T-xZ<Jo_\\'\$CL.(23\$vꐄo6֐400kb\"ja]d=b?G@emcn5>Bck!M7\r&\\:J\$\nAP\$p(\".&\ro.1@\nt((GCQkpg0Lfb#gAmc_#cBLZ#J</fh~\\Sevd&39O3@d!";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	B9L\nM:Yb!Rri^6y҄,l#\n\"A\r\n=:LL5\nblNi=R'#ly 3YΘvO\r^[3jڇ/tmX德Lࢩn7pND_4sz5g8Ä;\"N.A\0\rJp)c\n\"0Mr|M*ZIi8:''%5C{ߦ#\"޵X2j5\$pB,pB#܉/2BcB͢sVRx2\rZ2>􂿯1o(+>:\rxՌ0C X(ОD44#xMҋ8A|9p(^(ڳ[93i7x\$67#\nzX:f62Uh#}-[tBc8憌\0nHKti%-,\nz\rq\r/C{1 3#Վh,W5ȭ4~X`7\\\nt9\"~8K6\$P4,xcZ3@Pk捣\0006H\"k\$6Z+'ף+\n`PG;t0ʏ9ZLčb*W1[A[b  \")<!#\n#C(5oWbԶx3hʤ7\0t#;pA2-cwc0nztaJO-7,蓊C8;=>QcF4H\rQ]%J1MSԨCT+`ܪ5K\\Da)ڳp`\rX-aZ\\#%𓒗Le@ARurQAU.TwSD ;tK}0L @|,dI#V]ա)O} nl#R0mCR0 O\0B](I'~	x-?(a#Ҧ []!z/p2-\"DOĚ2Oj*WN	ѡ4(]B@SɁ%bdչ\"[e.kiPYxil<!=)2~(s@)(bPʡD.Hc\rDEԶcO|kMXC\naH#BJ\\73Ŕ M(%Dj1>di4ن	^i>y\"!՘uқP&1%\$g\08KF`O\naQ=qIU(4|RHmgԑġM@RKun=58GT2D6P\n#@}f1tTґʍzcA1p\ne2P\0U\n @ڭ@D0\"䠽\r\$AAq'\0[rYlP0cQ%?'Pطfκ]`B}+=swiA ! vɬdb\$mgOa\n}\nˎKC_ZsT)b,K7(9s3uQgsVp%\n>oIb\\VwÁlZ\$\ri-GK2~DCL0)nrPNQZRi+A'T-DPٕYD%۴-hjgV()(7Ѝlg6j`!P*>pm\"c5ϸpP.@ʲ2fTe1Ea,k 	-E-pePZAȄNa]o\n/fyDRڪh؀9D2l\rv_nݧݜ3ҹA#|AbrI2\$0,E..JKp{t_R~Y8_A!:,xJ(m\"xqzI?9u\\86\":ess%\n㧴PIߣė'ƊD\\rur1!#&0wNCdXi.5FO\neu/w]]WU<)oxt\$펜CA}\nW]g89SMŭɴ&0Jbv6\$ommΨ~Rj[KBH\r;3ڄl2W<dǌVlO42Ljp(F荇Ab\nc㰽.~(5t`2Dg\0I)E9 8B'z?O\")LvO[Lk\n\r^>hEnE{|zZ)fO<0񐮗\$BДl\rի5pZ&H Pf`0ÀaϜ0\"EojbFcH\r`;0Ř#p@Nʃ\nYf\$\rdt1 tT)OZ(PSqfOt\rp'B_Qk([/#'>i2C^@?\0f*1@ʨ&D1 )d΋3v̈́KaREpxFPDIQ(\"R.Q>cH1K\0@orr\r.m]PnR`NBRg^\\,b-vž#R-mdH\rV\rd\rp2&Q-NrbNm֍(V+R\n\nCJ%\$	pg.o(BKHmx\re[.)QЂ|@JR927I`ZhҰr^+56?Tl%1SBƂ '1&pN)p̬02Sp᫟̂#f(S5f7k78}8Vb3dC7!\ne\nj[jB	f\$,%sh/̮*ЂBt<f;\")-`\0(sv18rVȾFAJ/\n@-d/BfI\0@-D['B.\r@";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n!GC26f֎T1Pb2-+rdQfa&8\\n9ԗ,\n 4c^@R2¤sPc@a5n\n9סF`BHrd2+%뜣U\nlz\r#9s㤣B9RT\ns 5#s2RJ\$hn&9)\n@(#7i(-*:\n46j½5tB@OB76-0[8lDɬC'9\r`P2lʺ?M<?( 6`츯#rQd\\;9D\0P7AE!oT\n2\r(;)y:H̉#&Q41\\[H`Dxc2C1xYЃJ}7\r\07тs#\$x!L2o09HB+\n5H1̃-2N9c+ф<N2ci ZcbI0L7?\nm59e+Y͔Χ\nrѴ\0#;NHrΣ:G볘21(L{}L782ـ.gKf\0N2ЌP+\"y\\\"2\rВCݓCW<cA\$7OВ6+j#\"IPό V;v\$7\rÏ-{|!z9(bdd^;c}N6SI1Mb6Thb%a7\0@hnY5r4 7ly-^0n\"᠞rp	@Ȑh  u3JPL9AW py?AT%\rН?\"M@.MdVoH01O<ؙdʻ_%2YQ,^F jdlw\r&H58W:<ipjDo;x&0x{| ZOHIS%i[_,ޱV8wY1}fGPl3d\">-p-Ȑ}\rӔi%xI0ȜRqA9khdi'4'(B-pwr4,RG\0iZH^JOJ{83PFF]İ-i {|\":@Jq:~n+4S#NHbSsEF@OA]d^?H((W*x\$NF.hY2䍳%U&a(ҁ9pKAgZj\rBŔ[4H0UDO:B\$!0\0T\ryXC<9V\n FVaN\"BlF'\$յRP\"hJ!g%Yo\$C\n>!\$f{F؆dު_hv/,(KKr0VTConOLO\naP@F\r*{`#rR+Or^4 \nI\"WE^!-7G{\\ hT*a	=>ruݤh.e35%\\dYQ%'\0 A\n\" .Kd͆WPi \$ܧTSp?A<8.F	>'PWIQ	̹6捘w^\$ӧG@\$R%lt(CAXˆBt\$hMfT&i[NEӺșN8l: cB1A#90eJEH@6>P0s%02pNy[\0Ϟ)^k'lHAkbwd@NK|iwB@Uh\0Pxhq;\rUFXc\rl!:`ѧ	amWS\$Mf;K]da(`ښw\$3#}ORAa\"+L4	~6wD3B,`(ŏ{c\rXzu n5<o;Bb7,\0ObZ+iwQyʇl]z	EN46!P#5݇\"Iu<P#OGݑ/~xWLg/cGmfO?8!l}!YQ26qqc&uC]Ӡn\$d '/t*Тr#4`su5#1N}ah2I-F\"s]ib\$|PJ8>p6'=P*w\rOcǁ\r\$xfL&lM0<d!^b4fr2v zmƢ1f!̺Hz\$Q/3FbbBYJ>ކ\na&duD\n#Ĳ[\r-!\rp\ngtu\0Ct5ͷǅ	\r0aJ>@˜UCrV0L0nP  &@)\r\nuv#qЀsNmoc`bU#2J>\n&2@ZK`@\"o#K@-\$% 74\rDNV1FJ+,oKWn1|>BφN\r\rDN:6e_ѕpr1'#0览{(Qny%a%b%j(YNw&%\r@C?b6@ͨz͢􈢸quq?r]gC&q#(Qti,Ҡ/<|h1-.c9B|4.\$jPq\nfF a###\0001O3\n#\$P	01\\02se/Qm+g4R'0Re\0--/RN 7\$B6'2fz3jp]?3}6S6.:n,\$3b2[\$3+1;s2<)-?:5CK,;&\"2Pҵ>N;-&5,sTE{1\0\r\$p^,!.Z7(,4&`cPPCcwj'q\\Be\rWDkP/#Sć\\ZhzBOPpƤ1TQYNvp[tB%OT.ppk#,L#NG<rfD&`%\$rLR1\0#CN-N?Db\0;`MuB+`@\r\rCS4<L!H*4̐/3K562u;+#T3uC5OVV'̢qV_R:#_hc6(͒)m`@Z?Qv0F@RӀ̄S-tNzҧ`ZmQ䧕GTH5p4D,I&_V`zV,3&D\"B\"X8TCC  ";break;case"el":$f="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0;=UӡHx9]P\nyζgZQwJ+R?A\$&RU=So\n⵪ص)w/L@2m~[Xբ/>DT~!Jt%HW=\n\$IgApj\"+Tġ)B\"&NJ֟IB/C/J!n{F+kz`)t^)gB.C\"Hqvgʃ5(B5x7(9\r㒌\"#1#x9H8c9ȻdsV֧LBmLBB~:`+b;5J9о/\n1@KTs[ZeƲL֖)(,CWW4gHg4Pm5Ci=Z\n\ni X{LW@M:6xĐ\\;|^\r2*@N+=7(%׉2\rH7OAP5#?ypϜO<c:\rxA!9єpXh90z\r8a^(\\0tN#8^2~C ^.8yp87^0Qfr_?6\$ԩor@PYqd|߭*)Ne3355ȷDӖ;DJJ+#ݟ#(C2>WO-LuuHlCsҸ&=\$2w*ƫw*F_ h!tPZ J̜pδؾPJXDBŒ}8S!DQ &Q\\	\r<ܶ<kKr`בBxnJ6qX[ @L\$ɒ0'HJvh`g0%`{1B\nPPc耫C\n :\"*y%њ4/c\\R}I#\0bYđIqGgj70E܄@cUoCw\rCtWxngZ@#Ծɂ-\r9\$mZ2Vm'cgAY<e/dh0vS)}-DԑR\na1'bh) =X9\$WaTRKӚRN'xI!,N@n\nۣ*)T&BZ|9K<#P\"A \nfddʕ*9E'IAEe*@:[-eɩ9xC#0jZalm;vT`rmbq@8*AwҜ\"HiLqI58.\$:ZKSAOQ-АdO)zab\\[\n\\u5f֚^l\r6fT[mm[˙w\\KhҢy+>UʖSՙ.!LP!芉QCz;hnѹ^e6ޥWS4dB`Cq7MQB{g5cOa7T^Xa>0Ιf6˯G\r\0'S\0ckd7W\0%X\$J\"){8LMUAO7yx\$s6YH\n\0@RK\0(*HLw/!F^OÁ L!(*oi5`AR)q(\"_\0iE3A0\r[\r1Z×KWUIѣXPraL)f!Kti\n.LSPw9ܵBQW] ^\"ح;\"592u'VĩSdm=.)1J<£9H1gozڪ46@̿I~w1G#=`(R'Ƹ|@'0'S-TYXnoMШHK@-\\B'}9?JxD|4	t*z)M4n:,LTy`\02]3۲efWGmƏGD,(V\0`䄼\\RhIC:2DD\$E Hq^8>\"		|H[PXSzw!AI\0sshAA)4`7	#hBs+H\"vLɈ4%cgVaeG!5QF}nxKI\rUcrCIR^X'zÊ))O&\"RsoN _VUBcd3&&'`t\"*0;	lVf2I~ׂt,v\$d˯\0܇dH'x+{>)9gȮ%xdJI0*Nh\"PاBdBΞ*25'6ℰG3\rhy	8&HXLchH5(ٌ[qvZI ^#OuHGcLm8bHh`k`#kOm:@^CHi#,~&FJpBG\n!iD.xGP eҼrf(r2؇X%u6@\n 	\0@ MOpkPlfyc\$oHDz@^2yn)( c!r_l8(P{Cz%I~Bx*R6zR5h2#Ļ Ȃq3\$#>5B(RF\$.rG)<.0(H&Hb`+cV%,DG\"s)A8J^&[\"%)0^k2:bIB%\"DXa\\*P\"f4.mr0\"FL2!ZJ: B\\J't}SKq/JX|/⒠n?D_ĆiRe:blIf4hW\"*{	Dwr^ϼ\$ւk	Sϙ8'9\$2|\\%//[	_I4|&.YwL\nPdS!B/M'k?}?GJ;C5,\$>vЂbD@OBPEGb>>!Cv@+,AHFI7D谄B\n)Ɲdp*@N\0V`~K83FT=%p1){F-pHD+}Do#N{UL&6\"AK`_Ӫ.oڍ=013E.ЧțF/+{@<ѴMQTa^#L]Q(9JCB>48TʵyRSi.LEiU6{*v\"C{&'\"'r\$%Wj5WW5!}E-'!҅UBo /NS)5COG%n\\r\\jC>v0ȅ3R5^\$^u^EiCT CkC	'Z6`4\";XkCb#NMb6S1/MbumcCN=^WB-V\0̢*)0A_TiCq2{D\rt!o}fL}Wp?su/_Uk?upsA>_m\n%tWaY(uS\0\"Vnx{\"3!tS>TVq4:)m5,SaUHW'qEVQV_qCR]uW)u+(	|ApSUP?·}OE0WcZ5nyyr?1zvzz.s4_tP}NEwVQZSoCpgz^*H*w]`U>w_lM*~qx'Q4R..G{nwnlXutt	+b%L]tK̓Z%UQW	Ձ4KHsCB8MQa7ˆwAs8vc>\rjO,nH	=Ĩ\0@ˌNٌxߎ\$@)fO76dI+sR#\nf|7\",7tIe}3&COy6ͬ'GIK'usB!lT4q5sf+{4EKǷ?E{Aimx7Avvbd5F\$H'hZ^yp=82U9[R{+&	w4CI\n|K[Л<mXXJYg5á#[X@ xUC&bi\rV`ӘF%<gzedY<><`0(6Y|>1D2a#Ϛ8C\0\np(I'!.!t@*YR!AiAs32BBt\$V_*/@T;W/וYe~S\ntw_9r6,ҪDMw`=e:ΚTZf:\\.M3/2FmگTbڄ+0pD&\"8\ncWREhT-wrTD&NGX\$7h. 8(b[]riVnBؑO'F{UG7*;٥:R4&FEUg]GW\r)҂c_bȓfP\\'n+Tb\$]Qy%}19=.u0zHwy<E%񨌲ck\nQ[Brz+&]-\0+'۳?d\rMǞZXuZ %\r/<[cp5Y/o:8& ";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&QPP֓I;JSRi7js H'94d4rQr\"ьf8A@Qdu'iR7o;d&xB.u88܄5c\nyȀo7-<bPnt99'SN;\n)&yIrs(952H`12iު\$аɎc2&36kpX0\n@62m#7#z)J:b4	0qZ*aClB0ʗŎз P1\0P2a,:01t!9Cr9,nrŰ&	z7<N#Xʢ60DZ7|,Z1h<%l5C:Jc-Cc;X440z\r8a^(]\"Rt-8^f\rs7rr;^0ɠ 0ϰELrĲSҌC:!s3.̍,Tܠw0=.D'*-3++B8 @1,h2O#`6˲9Lĉ#pIN.0\n:P2ă˞^3۞#seNQ\"I~&gD/DJ{3Pop	BUXEh43ɹo(;7DO)b[7Z%%SAMv~cㄿAc+t)m8\n\rtC\"9.*ksQ aӀ o0;A#LFqhm8៹s`Cx3>TQRj@7,-AQ^2'LGT0pZIc%WPPI4\ndeRDE01RPA4\nJ!\nIdNC%JثvUXk;u&PZY֨>h.%:{ANI\$&D>)FӆL1i!ii4CEp!X	b,e`rYA紵VHIJ˛@NCYCH!C^#tFi3AD^,*K%	A%1`Zj\0zUu\r%3dud*4TXZ2Ҹ\08owG\nJA `9YRR&nL]ybd\$\0@Il\r.DΠ/\"1)dC-']Q,A#Q\r3 HpUmF,Ɂ/^rD	0d2cS\nAb\n}.YƂLq=3K%>ee4<*0p|~h1b|(JEm'Z2`Yz\$0ki}h,(1t\$,\n%TB;M5,7'0B'\$y>JKa:6`:'@6Xl	u>BpcD>(cHSp@BdYu\0'E\$nГ4,uF\n*F(rEiL!*PHZ!J\0Rf(6#@k#H[t\\	Id1O	4>hNyxa\rF\$tVsܕuGҲ/.PSeLP\$-bsQsEm\n.2\$ajp DdWR*qݸ9q0\nwߘRZg{Tw)\r*=O!Իrx(jA3h\rM5ԗ.)sPN9eՌ}Ηi^=#\$W#9bZpwplpΒQяJj7^E[Ô;-ԄN7{`E6:A-\$ @|@ t%޾KõׂXCROU˱3PCذ/+lq㚠طy,}C8H;<KC5j\0#Ɉ(Ar\\y2/T:GNڃ4eOLpn6.9pk:374ꍛҹN\\F4s\rSyӶm\rзew:ce0;rn'Ú.<̷ҠQ[NKPŜ/q=!Ǖ-JW2~DpBGZ4FҠ>CV-+#8N21<Jw3L7߭.fOd4ւ2_ (D侼6_\rPSA>tk+lC'j6xg	LS\0eN\rTjF^Ơ5L`luDrrlf#C@*BilTxgJG-4tυ)m^@lBvN~&nj;o	/4i\"ψ/HJ*K@-Ep\rAWD	F\$\\-l1lH)B1Ϊfe2\rN(irGDT-f#\$I&I|P16ɰ%Dr.Αcp<\rPdMr--|ΦE-HyPj԰/1g?`.Mm`eM5%QneÄ-&@C:%\$BFdlKl}4ݍR01oQri.Qףnݲ=dzq\"q\"gNh/\$j&#ѥRa.O%Vp\"-`!T0=2y&lNEo1+K'2)NĞ\rcbF)B4D@Ҫ#R1n*M+l4h&~R_*m@NZ'.02\r5/-.2t=3.39tFO#C.52{O3@2`KE\\.NHQ98r(%FeJ2sa1|%gq5F,E0d%sގ:HD\rV/0RH0-;PI&`0,(\nZ(:0-Bh尶i\nSj\np4cz/LÌ^,:q?ô>McO	TM9*eD3> JgPޑd108*]辶#rIc&\rTr:-N2KԘBB#Cdz\0;E(JDb:2d0`+1q°2mE*3BxjK2od`TC:\"BKmT|3DRXST2Ur&9Ic\rn%&3J@X[)MXj<	\0t	@\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\nPQȼ&@QPbFUP̆QLs2x~@aXI5,΢A)7VhgȈt,+5)̴,gù.hgI>Kyt1Hr3}ipTd,6:ʦ^nNG+LԈ/\nR2\rR:\"V9A9K(&CˮN\$CHʅ.@)j:Nʜ4IK'hĵ((3ڹ(;Z-x!-\nx5Bz:B2R(6(\\)07rx4zLL\$Α`޶\"	Nk OP9\$\r6A##ȧO0@ ST,`@;@2D49Ax^;؁rH?Ar3_p\$J@|6)J3-#j4px!j+\$nK1?0Q;5j\"&N<@P+	\"(-\nޡ:ފ	|4CU+r3*@N<d+=#Â/r'Otd(:A<68α4-z'S^4b*	t3E%jaJ(\r892T4cZ\rcd1jCuz \"Û	71+Q,ѭ׌ņ^}axj>t=#haZ	#lB*s߬X@\"LoOI=bMR t?zC(\rڏʚ1IG'%#x3#iAqH6.tLyx:@!Y&(C9?)|C((`sL#7\$Qg'.ef6\n'Y5NbV[vUXkc5xhn2eµL[qS g\$t,Ui6?`J5PD2RndҮZ*0.VjxXcC%J|h}-ECf!*tW \0\$`@TQ[EuZ4Đ#I\$N[\$%!-8aJ(`C~[d׈aL\01r̃I2d\"a)C+p(lבfKT@\$	p2ITA	=lQIk\rq l@}\r<RJjiu	f^(9Onn9- Aùfa薵y.y)pn aL)hO+F3ei-xK`u!9\$2<AKu!5	\$P<%*^z2.gncJ6	)AqS5\n<)@[GW)[-YrHR1c׫<g\nʭ%A8 X+z)g2k4*Oe'cYf/JVQ/xgB<)-<'\0 A\n^PB`EiA64IZNIPۣv\"ˠF ĎjV/dI[a҈,\"A^&F,d<]td>Aa`#<LF#Aѱ1&\"@5V+bZKw{	ŨtNzOe l F[>[\"UvWx'-5#c=\0wbsZ\\'2aNݢުsˆAheAt[IEbNWhAoЀEyF`Ykt{&x1˵:ՁӚ[	\0IRkI\"\$E:~(Շ]-	ȽS#ə렊(N\nM-T|R.o@@ ؿ\nSc\$ﱲ~U	5Dp^8h -Xs8vK)(6Xq/a-ҥ+*=U*25[XJ.dT-pd̱aYd؉'A;bF2) ~^N\$\$Bi\"詾Άwer\n@-@2xA(:FtGu7\"kj'?I	=iu1	YqR{'A-1gg'3CK4=9O(?\"}oޣX˖>(ԛNnܝYH>8>Y3Z	'~*__vOfZGKqLUB_Fexen	FR,\\EA<GH.q'co/8O\"u\"8(o:O.O4\npNa(pc\"p@MpEu0th|!\rMK8 I:jR#>O(褣t?0CbP9j	>7\0ZH\nWN?I䗉V0dX^[freVBuRo\0IZCB!OD5+ n3'Q-M0ĺ1x&m_`0%%`&\"pmjPCn|`cdpTKPT{w\r0Ҡvl\r ݦx2`!/*g#91*20;R`MEѕp#Е\$5*Qs&FȆ5rO#'&Eh&\"Q\0e\$#q#sc	R\$q*Qneb\0q#[\0O*pr_)((e,VZ4D>Rmg.0Ń.DM`7\"gHs֯ئLJ\$&؍p}s6j̉3S+R%jo28]'BU4mݤq=29s.>\r;I83{)Tc蠐̜\0P	k?#'`s2[>Z16LdNF=<	o\r_\0Jmos<b\nˣ2oT|:FL@`&fH)k0\nLZ\rl\$̭K#F`FOhD0ZBl\0cگhVCHcjX[\n@TDC	kj#IFP]#dhjLeFͰb\"d*IJ*fT9p\rxE#iN8z4O1\"L\$EE1BPsZDZg|D>/v\nOOU&]RB\0mufk \$R,&Pk`\\\$ 6%mM8c7dt=tWN -Cq*)X@t@2-..zdʜ\$-	\0t	@\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQx=VRiYb,uUDX01;J\r[XϠİ+H\"t6\r5u͡,\"gb^B=~@*Xw`R\\İ3	n3h\nd*3JBWB5x7(9\r㒀\"#1#x9h荎\n:9ȭ\"\nRdHI|3\$30΂NBT'-\n(C(I\n3U:Ih*\$\r%sت 0VάS:E'r\0פlqbJ\nȩm(s;ςMA#P;%:P-P2\r%DQ\$MEQ`@0cF9=gC0;H4\rN0pFA`@Y@2D49Ax^;pTUP*3(V`2\r>Ш#x|3;%B7:J,пN&ͯ;H:JqICz|\n7W(J2=TyM@@tƬ,HZ&:0L%<Hp%-%!I8:LZUI+28D#Yb2::2L4H=\$#(䈕L\nJ<[@ein>\\	A&0)RBYo<9M%pF868*n(I\nat3%|+E,,Ť;SӬL:wެNL&%k 9cd>\"7~?I~(R_H6t\rޒQDU] Y#u6ORWK:3\"\n1\"	M(pj`&jHNAc\"0\0!PBA	IGaVat0LFCBJaEv &\$x'HZPT\rE\0uW*uRp4EVZYl-\0w\\K<.`P/D/:/_0\"[G\0W)pDvc;Lܾxy#B 1,\0fOdKXHA-UV[qt\$:]o\0%כU'o1H#\$>Q182 sAytD2(Hs:\")lٓCT	4\$D4>\$6@pBQ6VhC4\0:Un\r3z&@ Xh}Q@֜~\rT0>wEeHR9r,aJAL0((;d#\n\n)1\r<7\n57OydH(oXUQ9H	VD#9*%5!%@sERggCppX%D@itTuEa9RR7H%FQijb,a\r\$ؚRJYM%2;fVR  ^'H,d#4ƕet]`\$Q}(h!p̅lu\0J2(WQ3	v3ܱ	}d-r[c\r(ILH\"R&	FcڏK-\$OҸҡ;6JP%Jx9I(Р\"0T6eOPhh\\\"41G>j#-3Q\0PO	*\0BE9\"Ps{P@%y%AfDؔ:Be׮{\"s`ЂS7kiNO,l<+,׎~T{&^FB I*_zMęrI\rvKn%f\$twI+CXrUZ])\$\"qD9\$GK7ēdYf	Y\r-8|D=j\r+669s	V\$:_Blm6Z[Hoz|\rit818֚C2ҥSE~kueH3s[Yvub5fnl\nP 0/\r(Y;\\	ݜؤSXpY\r#g̨4X|7_%)2m|γDuH~SW#y:OP3>Ar+ ?ܜpter%憂.Y,~h\$/Pc	0f\"\\@q,̅2U|ojL`30`\\5B#f/GtQLjARHd&.0p\"CbʸMLP5êd&+d<ȓZ@LP#\rPfv#L(0dƇ6>&b	#Ѐ<QҘJ&9-^pJ.R-Z\rmHz¶'n\rC)Q\nyd8Xw8)%	s:ePiX\$z\r<\"zi~wK\\&\r0=,lQLQ0́R6iqGQѪIz T4L|/d1DGp\nPC>(0gzX4΄LЄjnrR-(cO\"Pd?Qs\$D=1Pv-.%dVGm\rDp\"ґX9A'ROh/%W'tr)*+c&1=+g,+Ok\$C­&h2%R/F/+\0i-/0/+#m.20֐\$:~DfS28D0zO46sP~\0SF ؤJn/70sэ*%9ѳӈwd}QVDN-hk1qQ2jaӧMO'f\$Oi&1jLLzg-C?is'ˣ >R')/|#7H&OW+h۴3)r8R-\nn\rVU3kdR,\npf/F)kOQ̿sӬ^Re\"ئI1p\$VlDlnc<Rbq)RIInjބK2gDb`SBV hч5;H*d02(F#QRbgFB&=̗0uS}MIPSu2NRS3TNu`㔆MUQM#nG 96ySGѧ9\r%\rJxQ1R'FNulkn\r(Tsd溊2~bbQ?I)\r0ss5Te \$/:	Ȩ?{.f9H24";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dn퇚֤Z'IEJNé5&i	L4<u.Js\\= 7ifY@]NSmICmvf>)>N r08\$kMNGy3Ғ~`\n(X^o{t2£s͙2(6>:L9.|5\rJv)jL0N5n|(ږ5/9\r0\nBpQ/c-c,!'mt^B87Ct	K`Ix\n	b\\//rb4dWp|0 		`9.4m{2찂2:o8ӨpDPM,4RyAs`9H֍h@#@2D4(x_=x3^Ń27K`x&XpJP	ϛ502-z:7-X-mڔsz\nBP@oG,,?p(|èat]b̠>( *.H!߁=#>Z#8YO7[(Pic&C_uʃS@8c,@'\"\"8XU7\rc5xl(j	#kr%.^/؜_˲U+6\"S2{Xl,0m²-	Ky;ZŁH:pO\\ERŲ4Q¾mla3+1BkΠOZRX3L(ZAqjB1Ӫţ,4σj|ئL\r\nttu%HRpOj|b\n5!rc\n{\$>x)|Gl6'GfCO_e%5C_[K7`HD鸞j{)m!tTZ'ER2\nՊV\\zúQ9,UCp/#	D(h|DPQw7MBK>}hB]̂+?qʺ)#zblP\nZ+epҼWaEȼPe7\"VTB`|jQ\rᐐ.Տəj?(\0QxDn8P	Rk¢׉&fI/B5!!oħ\r4ELeܟ`0]\rVH\nj;@AN*BIO#_E!EXpC˕#^Ci\r\\8,bGY<#R<\$	A1uBg0l7T*h`)QmEAR>LS40\rܔJxAd!0kP%(@a7M\nI\rHN\rB.z蕎y'<:eq\0j^ch/Iv\$D&lC|'\0 -\\vRAI[8'}q⃝#L0i1.H\nѾ2%lSnNrxPD>ôߌ\$<\n}5Kɉ/%44AɆ ]2\0U\n @p@D0\"&Nz	麒tGi԰fXC OyuN]!PXpDrƉT*6F\$dDQrY`5S2PG+)Dᑎrp;\\p:wօP8w,NdFLf\",k~oቆli1Ceַu948!24oF%FyÉ@PI\r͆f	ެ\\%ƣRob,xH%!ƈ\0PCVg-=i%fg\0*L6AD'?h	0>V^y;cnrPD9fYΐZ-n\r\n!\roѤJxy\\:tl\0^k3᥇lKn`	cW&Cxٓȸy䯫Py+olyɛk¼]p^\\Ǚҹ6W)aLSBcb|Jm&M2;)Xw۴jaK%ư4B_9Ҩer,i]rR 1܉7j 2?p}G\0?D`u:!-.JnSe\\SD|è^{J	P+œRu9t٪pcu0a'YРˌ6>礥q x~H/FT@9NRi0.2kBp\"`ČS%/l8,FJ\"Юg0Xp0IGFO}v9dz	c^n\$TNPrbx`	bTpu\nkoɯ=ƛ0gpBsP\rim%*r~ r05FB \$IB&0\02ڄ/e:0\"GT(\rR%\$Tt//Ep*lh45N-{plfqzmHM-!P`-ڝm2Ѱ!Msѥc`&	\0eb&(&hI	%P)0j&Q	Qlfn:^\"fq!'fONrM\$#QM\0j\\с2F\rrJ˱%RH.;q%dD#9'RLM,cAC+m^0P(\r2zsB-qTL4s.&*}+h+,\0,@A,xm?\0&Z\r-MmAǿ/pi0P Ѹ]-@.c7=jo(ρ2;LJ0|c\n	8B>!2Ex;#vˢKq)DF2=o\nbATN_:nU:QJ@J@cWH<pKڻ>qO\n	r+7Ф#)n]8.6RoOe  bo&V9&pSM4C:\$4%CSڎ%㾹bK+E.\$P/FaJ{dd4)Q{ZF\"-C5D,gHf~`Ԋ92QmA*lE\0(-G@ԪjO\0\\TP_(b\rf'\0#M\"e\0\$8F\\r4&\"Dcu8VNoeHSh-rƂ6Q5FNBHnRH&Z&c(#\$sx-\n9B>";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n*NҀi9`GS(u1M҈utM7\r3HdxsaNY~D 9hNgSd8:+A&9e=LdN0@m2,R@ja|O:\"wӟ/9݆7f\nx6G]8Xwô2[00ljx7P*cΈF\"(z17BsB2h8\$(kt&*P7j^â:	;r°`6Dύ/2*ʘ++B0es&x14h%`P\r3()5C(:B;C14+p\nc˺aE\06dE*1wMl2D::ǎ[ͦTӔTO3t(l# ڈ&KW%nB!3DS%Jĳ<iRrXьD49Cxq\reZ<)pp_hpJ|8\rBR2\\px!t dS4a) :103v7Pbi#n6\rcۡD(\r:9y9(7,:rŘh7mIS1TC+(d^p˟Tl#<dT5X%mt7e\09+VT~l0bXCcC I(?F\n\r*c.aUЦ(U1k;VG0-5d9ـ,Ƀ\$y\rtm؞xP.yP3hZΈ~=p\"PHI>|!A\r0SR\$8kLi_NK|2d\0ƔQOxT,a!'\ni&M-2bCɸe87D#IYL*\r䒨L2Faɹ9~JbAӇ6N Y	_x @b)ZhhAemվWw\\Իs\roI#'AN4'Zj%âҦdv-nҊR\$hzeV<RAHE\\KsGZ]E&e轈f2	O}pM\r:#&F7	h6RMQ,uRBR<C#\nXpFBS>4-dۆ4bBCk9dQؙLӖʙ92|GHP	A+\0(*P4n\$]P7R7J>BhK骋6aK٠YQNE@-qMYLiBYH\$\"yڰ kp{-v4:2o\rk01,H\$t\n:eij)`Eę	AC(d6ԶH\ny%&h;,+6fۛl:jѺbÂ<!1t-2	WZ	()	L*V:\n4'DQGR=OR=J5D>#A@*ok\rvHY[&&60@,>pI+U0)7\$#IK,TRXgPȰQ1A<'\0 A\nЈB`E`)0YOO+I116n,sԢxp`*l:{--[\":\nv&KmL%tksĻ6(8R-DbhZ?\$MIt*^No\${M 6S5͡*88:4Ԉ`p>UU>M(]!ǞAs.}j\ra*Y(D66RWA{hXl6s\0>	U\$r!je\$<;3*y\0萴Nc;2ƊqOc4:\\qz	]1 c\$Q5Aqxv%!Jn5rۇ;1IϘ+B:0HvPM@\r:tj0Ęޮ4P*\"(z9]%sOs7XqȻ;DZ;BA/޲g댟*6Th]68j	]\$(Ư\nwK<xiOG0yoIBsy3C|:#:(<	919>-<|c8[5ym*\0ˉ3' (#%;lo +P\$ oh+tc~Q>5k	!.	x/fC@10:	\nقzRw,XkJAP@eFO>Jz~½~xd0aduFO	PvjBQ\nDfZl.\\ld\nmq\r,\n\0f&|P0\n'GN<;lZ'FDElsɪzmѐ0Ґ{{HX0tii\naj>xQ.qGp>G'IDY\riz#1nzr(qw0`XNANSpNτH1\\`>=	mŔK*Őtd\nІN!Qlbч	L_{&X8Җk=D9lAT9|0@Zb\"#lqϪ\"\0005l  .*#'`S\"وJTqƗ\n\"\r.*RC&CQ*1q QLYM@dRAP%\r%R*C,*cC.-1 ry,RR/r@J(nEX]Kp*i>Q`kġ@ŏV-q(H.q4CQ	b+/,'j({gc-=,.+&6,3s4M\nFFtє#C5pw4\n#:\n+:Ӟ=S3N2Hd;8s9S;*253':b;Q}/2izs?F\080`'NA@D!4\n As4B4*`Z&L:nV»-SL[E3LXTOE/)EXM(GP0[۰@H\rQaRAhHIFRIto+t	.4:8fF q5P5'b&{MxٔlV<:hD'h/NMlj*qwQfqO-5 ,@ln\r0*72M=+8Ë61'\"v)O+)'-dj2K\nZb1l@oERW\$\"FlMmJ~lUjoGS3 H+up4E[ J+!I%G'_2&'KP}u\rqBN<NcT5\\\r~OSX,CuMU\"`ՉGЋYaab3X<@/		씡=`2[cVm.,*2#ocdмra;hhey\$>\npI4/:\nlri1(3n&3\r*1&>kJ1T|6&:Ik`;j} %7H\0Dfk\nqHz\r";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74uT4u3,OFYuM3)n4f34\")Q\$f,r2͒z):lcWA@Ĝ%	6OR5PL <ɤꜺ4uXtRsuCs\$&=+{7=N˓!^NZBg銣H*Z;R9& +\n:	,,c13N7-8am:9)b\\)4\r+\"h!*'5jPrNBOc\"ɊC*(%Vbܧ P7U\0!`!N\n뎒d73H()I1A\0ƊЭ& el++,ѐEx#)5;\0XD49Ax^;؁tK)Ar3_V.^*ڼcp̼*r*|Mi\01K1ɂ\r%-:K&7p|_Is:H)7P P0憌\0< HK':\rھ':ai:ɴac\r[/ju\nˬH5\"ܴ-Њ4WtF8 \"ɂ1GɫʴF<&LjfƊ>*&'sqj\"WG=9)\"`S VX\0}3%?]92\"`|8rbQ@IxH`S <CM'<2{\"[C(5͡\$SUxByt`ʣp?v&ٵM\"TB^ \"th[|Y`P	_aTU,K'/Ȩ?FR\0 D1A}JH\"⥴h0klF@rVo2RRWJ_,RdyP/z( }y\\!Uê;Ϻ\nR2\$T	iN<Sv{A\r:/(J^*ǉ2',箌Z80b>%P|(D0}eif\"C^G0̆#|ht/&\n.@d{2\$*C1;P0cٌ_o.JQ]^F%<#Efe\"!A\n (PQp XӠT	'dx\$2*q&8:@fM?0CxwKInUR1dtJ~@L\rE(8Lpa\"7Z;R4#>C:bĄ:Kaxo\rp!0/4\0xOѹ?w*T\\Ś	\\h\r%%BPjSLB83ƒR̙K{i\r*oN)0E8hPa,ƒR_\\3AdYO\naP@k62,@rTJhѶ~B5F|-+e@-\$䝒f0Tfuf\n+5	32ET(0b-,A	\$->xNT(@.\$!vA\"0U&I%\r0\nhuKa<8\\W};IAz.Xr^̘E9*X9,b rW{\n=^!\nt̬ܪssE'RyTPr^axJI΍9u9'5*zgBrZ'K%l3M1a\0\nl]Ck5M>HұtR`b	VLinr)KX0i%	˰\"RҡkE2{ݿM\$S)L!\07*;{@NnYw)\0~sܩ=Y)&E\n{<뀠`\n\nJ+10|bLI93XT\n\$D^(XǩMF۞[+jMN\0/i.KugDGZ|UEYq:3dR6^Mc%̆4	ÜH=MP)*zwww~5َgg4#]䣵΢^9=w5AGQzA)A>|@\nRk#BΘHLн3t]<l\r|WLnqM܄cPe!)#0X!{6ľr`P#Tg#vK@ʙL!@FL%%\"J}\"P\\`V3P-b`6b'\$#DT(^dQ\rC\rM\$#4U.42(w	PΧ)ϾRrl#RДto2؏_'%6'LփU\r\"\0쮖n30;.dm\n\$+/Р߄M޾p6'h'1l\\/NJ(\0\",5\nЃb\"#ef(iH<\$V\"Z(ZdqHqr+䠬C\nܣ0X&D,FH+-ږlݬ&I\n_q/eq,.@P1#\r9>~!\n4hn,=n⠂n侒9Qo7laT!Qjq 0%E %&P9\\(fa!hhjwrp!RS'c\0#gPp0N6op rɿ2Rrsri+s*x;ң+=h	ds,rޥ\n\rdbJD+.̠ʀ꿒.0*\\ws/RM.:4@&Al(34Mҩ#@\"-33M\rK5sBs6nr#F;\r7fW4q8\$&N`5æPrR5DDփ\\X\r(b6:;KHpr4<\$~9<oih\\OfPNd\rVciC`rgnKCF1rBVgDBRQ(T\nZ7͊.CCr`V1B:zC͆ocX]ATD@@9&᫔*s45%\$43GB\roI}+JdZ6bB.oC.{eѬĄLf4T1tE&)Ltf'L&jMB]q=\rbt\$\nd	pmLcxCB ޠg\".Ot&CHǔT\$U\0\$.45O(IL%EZPR,ޞ5U>d,?<Ah%c&B\r";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cs΅>B/nCx7DTeQZ\r	r/sMNqGܞ\n`%~^.hq/jvl]lG7~\r+2/l&1|'~\n*fy 2FD0&#	 2̧1茎?9`\$jJߡh;I'nҴ#Iʠk1-6L,Sk.cĢ6'\\h-+. pF1^I\$2k֝Rpt6FH\n롌JLpk{/6#s?O\0@P @0c9Σ<>/H4\r00AA`@R@2D49Ax^;Ձp9ίH\\x709xDkΣ36#H7xAc5r3<\"!\\26!jQ0Bp+#BA(\n1<&RkLd% )j*I2#]3{3*(C79N%i,ڞƼ8rS8ZNC+}Dh>1Ȳ\n'Hm؎JƩ,\"ao	\nbmˎ+ĸ/Y֭;\nv(۠Z1\$35]Z 'a o\$^kvn#6>X@=w7ο<2oBYcϭm9cɁ!Ȇm\ro%?nqZw1B[kpVU4'#Ȅ1} ɮdˠ3U5ڐ'/(4!!/hX[WΓ+d SʁQ*ELRX?fE>jȬ,՞IȜ75F \\̙)/\"E+HQ'i fl T*RuRkV'Z+epPnua`<Jd;px=l^C#8pl ;ŭA΅%!2KP'd@}Y`Fc WaΩ0Tf6Νd\"\r\0Gw5#\0cS[`q3+ErD!Y\0\0()`ؼflZvpX7(`Ԩr\r!4\$?d'!,Ax^`zV!R( A(%,\rI)TU\r14\$>1}cԋzl]IСP͞pH(xWuhT ^<_Ȁ\"HJ]\nhSNqzKHu\$왛T҆QDASIC5t6JO\naRJC;\$&6:D1,rfEX24IhF\n\01-YaǥIM&#VID0C=Y*Ycna&ǳܺEbEAǘ%3+.L	*aمtb/xk6yURbdrd>G8Y5ҔySm|[C'ؽcQ!-+cȡe蔗=NKQR_Lukx9<JdE%8B[#\"OaPjl2%fغ	}'.Xp\r.16U`S%oɣ%΄rU9hj (rEGq14>2[B3N^.jLΩX:iHG2 	qASLֽl_	^.JƢT\n!v%E\"8#\"7̶4j[SڎH4x&Mj]`+iTNQVZj:Â}D)i)pr]\"U8ηsVE)?3\" ;s\rGR壇kX&ܞI8۴ЌkhĆBpu]{In2#=;g4tfKSTM\rupUH-Dbz0=8\"'L#Ҍ\"e%\$ΘQɏ.⪕1ݭ\\2/q{9^wtkޯ{l`{煻SnoYn33(A#d8udk^aKM*{0e.gm.&?qhۑs	F{dk5Qt3SHrQz\rXw,\rX+}dwQ6r~0z̸ί֧+\\bLvGmv\\B\"BLnl&&/p<\",TmMM\n;nؗ6ef\$D6P1*\"@l/\nPFS͖lFpDM]\n Mfvd-0gM\"C\" :J -o&g\n:#e0\nn0IP5 &OuP/:rbJ`l\rh>VAq2̑8\r<1@(QKq:?T<T\r(1L.83q|l{I,x'JH8Oh~)Q\$o%1Q\"ȊT[\nN㰣ih'f7\"Z;F6w\"U\rRBmۄH Ih:LI4rk3!c^o|{@R@q m~GrΟΈ\rBE#C1lΔ8daR[B^e\n\0cPR/i&k`FL#\0B8w^3&K&^߯8|<bя&͂E.2.	Ek6MdR90*,Peq\nBL(\rŰ,OR|PofF\0,Vo!.c\"FMKoBZsjLk6 \r= GTf#bd&<J|آ";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLH((4NgtRʕi7ಥ	aQYtǦbFS9QaNK\" (ܲo:/'c-L 8'cIIΧ!!4Pd&qnMJ6oyL~do6N\n\"髝s33BV9*:<\$/K\np7\rC9&#/MHBPڔ8/C\rRXҬM3.zd\r\nj%m(#h\"\"@##\\̱YNp#*=:HHxϮbLŘ%%ΜNsC;)B8< P6=)+NCk8JP1lCQ@;CqU8l^9`@&#B3:xieOÐ|X9р^)\r@\rp7^0ɸ0#ؒ:iS<ʻ&\"eH9,c\0rcxkdԐ\nX-(ȃ&e\n&UQCS0'w0l+48@ݣªr(0H@;_C	n˰	cL58Τ2+.8d\rEU>)u2.z%c[*7K\\6,Ġ[JM)b8/[Rc'\"ez9sLP6ѻ4CENϊXݽvbȫ)WLuN]P8(4>\$C-(bk%c\0a ٕ>L|;kr\"(.`7~M_\nnU9pPOX\n%&|ۛoCxf\0vT\n߮h'U35|XK<\0L@ ,OA@s&D6@^	'aU Saa8U7Kd֊Uk\$/?zv!E(8yK)}jt\\\$z'4b,TYK1g-5#@m-ܷ r}r0|ƎA6\rY9\$\$VFH7RC* ȫo!(I1푝dk	c]\\ēr]a2p4\"U8QU::@@q\r+QHD	Hyl@֚yY(\nA<v7kM@8b\nt\"_aܹq\"C&я`zN\nC\"\nLC,U\"+W[i,O9)6t.R=/pE.,ϫ @R)8'D\nѮPT7i ` 2wHJ) pDCɸT)t\"ftH-X9̆K5H-AE-{ԒEZ\n<)J~s l0[72Zܣa%Wed9~*ĊWй_kYY*&Tϰ@sLilLORl2иkj.o\n;*6*a<X!X\$8ÃalmaE,kR\"Y'N@PLi-I(C-ޜz;QeAloMS*Fa?k9eA]ex8s\n\nfƐ\ng1aQPyDdǅpEg<d\nd7\ryE\"@ZN=UR'@2lPGX1I{K&0ښmaf_[8'WC#f1A7\\2p1jeݯ	8'	rK,!0xAԿ㗅A\nP 0-Y\r'\"UJU5Aa;UZ<\$Ͳ^WaL.hPA5^eKu>M5d1~ܠNB\r|Kz\noNRK(4^Kz\0t\"G='ޘw)7ƋVd^IPs~r7S眨|*{]\$*[2H&D\rdcʇt?6SN/^2	<Ӓ4s\n1?\\JI)43ױvi{Xa+i\$c@Xok0ˀɞ/ZeRW\\16JaHߑ\$5V~ccugb/,V'#bM 0\0g|| ʎlv{\$\\312\0ر>;C*lC@G\nh^.%LU L0TlOfɐ@ S醲%'=d	-|8g&t`\$'ΡML0~GZK0tOkä0\nZb&v'x}0+\r+k\rOcRAN\0hϊ4nNnbnÅQQ-q6L1P\rE\nW\rW\rCC#\ni~j\rRBo1cR0Q8|XBcARI\"1*BZ1AVCjl|kUD\"ilqUMp1ΐML@M. as&\0p\0ƒ2o!P0\"n\"SX#\nR6Jh[\"?\$C&@28a+@ j\"QN4F\\BECE2/HҞ2\\'&lq!hȨ-,2\rph|Gv@\r,_|\n(M#SC%QCg>\$23	/1ws%CS&ka'0#rQig1r\$	24G':aܫO2F/ۓf/SjBHE6-7S| |\0Su܍\0\rݲ\"e݅A:S^ӧ;25M33%%%chL~O':>.P2O;o6O>;/CY'<RCAR?XmfX]c (ƊIT0'NBlBAC#T /(VBLTT3X4!G,RI.JduH.\rVf%VF\reZGn藋Zb\nZԬ?odzT/̸eMN7MM~\"<\$D\$@}g G4%c>/J\nE0hOl@e\0'Tn-52d/0\"3,a(x(\r\\Nc	YM\$\0=c=POFLa{bD\rEoVĲ5IY\$',5o4%:?{9/ƌSf05'b>u[V6	 \ru	MWOx5YSCF\nV	]% \$.\"?ArA? Y%kYc0*Zc[B'X(%j-ad*&\r+63La8+ AZچSmTt\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6ADnpJΆ9ZS,;q@Ejp3-,΢Aev4y?6u8@Ohld\nmg1}j:gm6	ƾSqD	!I%wR<\r9MƼރ(9R\$j+\r\\l6ck9;\n#&2cV79:X&s\$:32\0003HrBN`@;в\\1[87BCC(%\n'#\"ɻTX5R.ڜP2\rBPi@1i r9ֲH@@X90z\r8a^\\#rP>C8^\$9xDk!31(x!Z(4#JK+Be|\"DIbmBYJ2B(!\$ɐ\n!(ȓO먖7ֶ7;bKF]X	㤀-PF#؍А2ɕL=s)##8c<ۼ+\"('#T^&Na{c(4HT8IB&Coh_`i#.bzkLe+>c<4S\$2^bfe!k8aWس\n@@o2ۜxXȲi072O%^mbn @3`Y3*FĎ!aJ2voZ*2ZoY&nLQC|b)5,GR)KS95>u\rF7Z}_o\\ʌKuK0ZY3T!JQO}G&Tm4>@q(4UT@p4KC@o\\k錵7rC#%n2xPXh31fhY'3\\zku)n]AOƴĢ H pB\$*<֑P\n (t\$>'@b0\neODק\r4&26	MIty*KB\n4@IB@WrPMj\ry\nd4u\"M#)l><C\naH#Hr)p 	aNo8 \nje:&NLhdNX6R='h]Hk(xL;\\i>k`q`jm_D(!t[(e>\0£,EBb|\"E+\"d	'FCn :Re.P\$hA2mI0@hF\n(\0\$>Y!k{bQXO	*\0BEU@-qA:4:κc34XJ/jPHвBgZD;x5x^qRӤM	;2q]lUjm63 c67J)p[})	u-Z)l:C nE-\"ͫI&SwNuRgHF'Vr7ȹj/+OM!\0t'Z/\0BN !Ġǂ%ĚC۱<P.)\$ma̍\0pHB2v	LP*\ngƕX(#%Q#@ :0^3*3˵h@lPD\\\$j1KdK]c֝{3tI·GZ,\$Fψw\"'4Bˋ\$o77bv'>\$\ni7թ)+::|Jca#()hAv!L9mjUk跉mUu{ǌN\r\$k\$&JRJIXᵘoywntш-%:ܡ|C!LR8GApy/l]x\r]k|fZIfvZmJ>o\rO	P35Ky/tKAщ1aMjc>:YV ,o,H#Cu5'<]o.gs|Mήzk HG	wi-\$lg|gLsFysǌ&wOoxO?J`^DomL|	\$TW;}?Z8o	uD\\77~=QOBk׬gD\"klp̀(/pNX# j#:,i*dO#p6aP>OIb戦#1R.N_jEϺEF\"_p0Lįb&NA0?bh\$,ð\"ǋ&CW@`d֗pg^\r/p'<H[ll^[j[oL\"sb<q0Ay\nLr@P 0M`C0R4T˦`1v_Bn@nwhv%E\0j),,`5HHv%ʹw\0\npp,1>1й\nxZ˭+\\n\$,|fC<c:cLi\$jZ8b@(n[Z	ި\\QbX2JB;t\"5ĖP4-1,BgMTM.^o`ڒV&'6m	%\r*\rtY6,Z	Cne~el.eBt*@%ַȘʱrBC Jz:bc-,bEWbhlQ!RbHګ6I@3WG@FeFqD6F4";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&T4\r3Ws2[MsR,eC	7 MCLxafXӁζ1aद\rp6( 0VaBq:p&lvӶCl9!uq&Y(i3{a	a6S`Q2	?@U9(&̑實rާI\nFC7ct9@Ȗ	6#MB\"HJ\n-F@n40p\" P0i\nOLb)#z)8¨L=|(Aph2FQ\0B\nx\r\07I+\\9'3\n,jh`A	1l1\nJ\"a'r`460z\r8a^\\0ͳx-8^\$.Ft-c2Мx!Z+;=PHh׌4	9/1Lc5Jűx°\\762k0IP3\0\0<Mw^\n7\"ط/!\\䴋p` P	P2KV\nwk}.ˈ-l\01:77\0) S͌e7XC,`۷2#&CP˾.Ei[OVǾd!PǱ8=>@Եl6{=߲ mRCb£Z`Ʒ| i!&\0Җj\0RJ?\nv7+,2'XmV\n3YȚ!2Qp\"Kys\"bgj\rśȵ->?\n.~2Zv>Ѩ3Gt=%HXs#P\0AS9(MHrQ*-F\"ԪS!M(\"ÜIH>ur>pR\"ADYPiE\"m(BHj QG)\$SJqBà/!ܪU[sr\\,9P\$3F9&f&P(RU%Ą<O	#D'X8a\nB6\$0\n!.Fۿ}GIJk'dұksl&cluј'hL!dCd8P	A9'F	((6A.2FbBCnLjLLP̒Ǜ4b	#\r0RDMj\r:ڍie6H(Hc%*EA\0C\naH#N\"<-fG\"IL\0P50Ɏ0oGG\"wBFfE\$%%ЈizRT3sXGmi90ѤAB!%7SZpL\$L&#Vc%䌒Ĵ!Z\\rL (8~p \n@\"@U\"i\nB}-e>j=;jCK'2wh\\vZ\n\nD tfPOa*݂yjÆ!06ƶț-_甐0hA̆aUGtRV2Z8%CIӖWaLBa]_M2.pT6'\0čM\$)0N7m0L	E-	+0 eѾ8F.ז1*j\\G +t 9sVFZHr,p6TFڲ۰3&a\0qjcI\0GSR>fh@ R\r̈́T.noI'LC	\07Ù\$iͽLZ}lp0܇,x  봴,oID+thy<%X+E3)Y:Xut:Z:^VF]KY/2jNbZQa[wYm92mviav>!|0Swڿ_}d-FvE%\$S[89N	ȨilCzYV~*}ow_[RG.MF5u~#	o-`.@rYӼ?1|JylcHp\0(6V|ҹD!((7eysus\r-H!F-\"vcp\$N^^{Chׇb\"|e3|[m%fN_JTls쏎P3`˹z&8?2PA3}e_!iC NQ*g`ȕ*϶eQ՛+eItא uvvڻO/G6ܝ.O`*\\\"\"g&2 Xvn80@O^l\0Z80`#D0hߏŮP:pj˦*~2N޵/c8hk\$y+onBlM\np:cL-O(hЀ&\0Bo\r(\rYG\$#\\I&S0LbX0p:\r70_.bk /l\nŢ&#f/#~/Nͤ/QDY\"YՀ֊Bt]ʢ\0zf #HCQтK#5\rl6C_O̈%/Q\$1.1t_kRh\"~\nGpBGOKbZ	tE\0DP\\&J^pOO~VE!\r!+(c ^g\"-\$h3)NDG`')RLRP`Xt%4\";`<3C\$H(KŲ`4jZKD\npz&dҮ:NbD\r^o΂N~&8G+8<L%>R*b1(5UʾMޢ,bed&C!\$#(#+&LH%IB	,b3c3ZFTS4IS3Z4^Pil\$3a73>9Y\$|3N9EGFFL)}70D\0gc?xv<GmR\r0	8~&Y~_, d\r\04F\nk+J@K&rM\"ƌ%&Q\"Zdg	zr\$`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:a[L 	:RO\"k\r-\$AP((*qe+PMJ\nYDZ9&a;Dxr4&)s7St\rAbNEv{2ζL^rt/׮TRr.J)LAP@Q<헥J\0P7\rm7(9\r㓴\"99C cxn`>9 \"M#1Pjs(^\$o*G\$\"9򬣲	sIUzK.rzJrzK12#eRiYD#zA+LJ6AT\$4:8U1R8Ce8i\\A\\t0:>T3E) F>\\,iSiOuD\\yX*zXQMF9cYe# 4аADOX#v6:1C4ME2\0yx3:x\rnBt23(Üa\run#x}uD_9t8I-I(\$IM[ǫ	]ziP96WGQ8s+#wK(O+t9VQ0L@@'I\\Tt:oM\re!8s]g1GE[nN0BMsi[71JE#`\$P1#p)\"fۺe;kMӴ\\ZAIidȘdARVJ8Nz>XcoѿcP)BI6\nO7P8D:@Pn^(HC\r˵6pm:#dm30(#@oYxn :°꺗`fw6η,0p·`m@mt@s1\0RR #o\n[	\r˽lT,C-\r!o03lC\na91&(ţclu(D@K34Bj ujDO3kN6օ%@PMCB2FШx#6\$C	al5&ث[H91<aKi mcPI:k9Q0VPIrR(YLG%I&'\$+%O*:nLf@{@pBu6\"(뭑E'b^H䆃tfΰCd.' 4:9 ưBOH\n\$0! fP A Z2Rhcbْrb=zo	8`r%]7zvȍµ&&KYT>Wr(P2#:dKsDd\r!sKa!a0aL)hdR3BrgL 	\$4\"^%d0fÈ_PE'\0Ĵ]%m):a-r5 O۸<I(!	h+BmA\$p\$zEzy3u83!#U\n8)myE\0£Wy/j I!G&wګ)]^aq!	H:@0w\nq1ȡڼD(s\"^^т\0f@/\rͬ4tYp&aܡ)pQ\n)ܛP*P\0D0\"ՙy	ǧ]ݭ@XW}Gl\\)\nӖvtGVzEQҾ{I8.}ǗWVarHk턪Ս)@S{,ØBU\r܇pI\n6,mܥDXr< dRӎ|ߜE\0n@yLK!ƽ\\6ˬPu\0EPh`jS]2iܪ4AѕN\$%yQ^ڏX\nYJVnYwpc\ri`!cn\0eEQD(?yӚVϔ(Fl;uQA6^E:aшB|`^\rٙ*Bܨ6StEGX:jO\n`DX/;=\ni9uyLcw{k^}!d}&mۨFLʙzF GzW C,]bU\\B9]%ε/::#?ЅOD!l`LTtp\0KB)VKpQ@Dja@&+!&40Ƹ!~ aPH/\$lv#lD <<4Djkm`?\0joFkF{,Y\$p	4M	N2xG\no~ট|	sf+HVEhELp0j1Dj\08gSgGeB0D\r&#nnG2oGhv#\r~\$i\r\\QXVn.&x{Owzd\rR\rQtH(}Q+>M1bqO!x ,\"Gt UpOtQitL}FbL2}Rr	!\n>tM(\0b>誾Fv!+A 2A1E2 l\"\r\nH``,ONm\$WNvj3QjâLtRa&#%&jMC\"y8~`}\"23,2\$hfh/--M ѹ,%-%+r.z|.jACD^d l!\$g;1H.yi E3z+bX \"8{\rSTѦ3͛6	NTM6l\rGfnsbTAc4Mw.Џ-s#v79yӡ;:n3]:39#TCT+0[2.0ҫ=%:sS=5V0r\rclCLcſ4F`AA㐣\$	1AoC`BJhB.H`챷9%,te4r>vR{4	G/8\$qx*O\r=Tf@3@GJ3@C\\34Ů~1a0?!LhDs^	GR0:s%rlpLO1	ƙ\nFhj\rVC*&^ \rȖ_̦\rD0l\np);Q Hҳ\r\$B<\$zT;8~4-4O<U3Blh.lG|{\n%P|y\\b\r5]c?b8G\r'O8/PV <1ІxX0b0aw\r\r8RXVq>2\$\n89n74\"B	0[nOB&r{0rG[4Eђ .ogbŬ@5Ѡ\n\r0D3B%n;0.,f1DhGegpanqmgpQbNb\r:;h%9e!.GcFM*OKxrF!";break;case"ka":$f="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]vtḳ^\$:%ĠV'HXz*c\nɨ\nm!Î@YUn齄gD^d.NrѤKG=1/NyR}'\0>}iBJ\$ΫΧAiV@;<dB@pBJ)Jr?(K1Qr(#b.\n7\0 mTv#6-:8V\r	#R쵷P[)z,*rl1K2t\$)(KzG*kt1t(;	\n\04I\nyL˔JQزJj\rU>J):sӪ̸ʬBJ¥5#8	Tuur0AO`A`)+G2K!)\$Y\"# 4(3ZX<<9J읪(bUVLHL!\r3:x\r|_Ap9x79c^2BJM䦇x:J1J=;);HABZ5Bxm!I>;\\^HJ4ӧoC?n-	sʲk֩;Sԩ> UZo\$9V͸2:#0@\\Siqlk/fCXI<MmMv[1il\0AsNPے9QQOi=%Kg)s~A-.=Js\0ow틮[z<(ЦBb/9R!N>k/wlR\"m	{|D48TINԑ\n7W1od⒯;VOVN\"WQJX|CGhx ,δ	rnT&b\$ЪxIҫ5:&(%D5TcŅ\n8#zp	دJ\$\"<^3j0PҚ\$h0{t8\$@!fHCxPER	\0;(`P乏{Q%ُ*Xϥt3)<ʸ!.%cAf0Ƙd2fPʦk-eřpa|3րaEEZ<qXSmTA!9L\\~Cȴ\$AqHT]v#%iIO_IT~q<Dc,mB+'쥕\\4:30?>sѓ\$M藡\0V.b]RքIa{DdT4GvA0Ĝ*]&kJPP(\$=J'zXgf]Q'AxJU-%-#ZmK0ۭu*u&:Ut<N7<jv[D~(H\0PWIWRmhLczr2*+ޯsC̓aވMVSTe\0j\\JG,7CVY.@難h) 0r2f\0\\u?2R2p\\CaGs	ͣCS<kGNoǭ	-kVE=<q;1y9|K1.ν\rc.kLbG2JKҦ%Vs`cǒJTܓTmgYX,Ig* [c;A3}ZvD>aұDS٩ENL_7S+X|pi~Re)SRwF\nA~[ucaAW	<EԹ.L\nT,&\0\nM!@qZjPH <ozԫj5cȰ>@{_t\n+NV_\n]4QNlܧTA]RRB_b^d\njX\\,2)+(s6vE0si\n#bMoq-ًSCZomIK.\nWCVz	jZxYӨsjU=ܑ{O{\$EMag9Ti0Ӆ'Z͑ZNYmnEXLRBHRL#F^OC\r101?j<Vk& \nMruzEt~[]|1,}޳O-\"\"( @ 	,Kr)JvW*h\0#J\\LCxQJp ^/:Bz/o6)\$#H	ZCĠp H+ڱ&BKBM#p\\0&&@0Tom(r<Ƨ\0nkM|MvTP2~N;wPOb8׮	PHGtލ9\"/u)5N)Fjvp*yzmJO ,jN\\(K):Z-PlĎxug2O80poE#h8B@Z7H\np`?NVGfTx֥u\n\"ǧѢ7H\".kbO1B(JpرGFek8/.V%7OMr<g~/?{(2qqHJNHzk\rO\0'd5d5\"cnQs(^)CJKboHe(ѰOK*+Xpl\"Cb,\\7|KqpVT)OXyR.R\r/du(rc\r30l0=)#KǖH夬Bk'0PKmPRq1|ϞXkz\$<o\";O#htSE\0BM90ͼ`mmHۓq@3s6x:Pp`Έ.\\0\nk<l\n2O=r2]1)S־.w\"%+SҰh3ndA\"\0p?s k'BKi)r#C'Cf(RQ@EBDaAP)'EeC'F{@rq2Gq\n.XR	s#ԄBP.k/+/攦ִD4K@C{8tGZJIGM(C9TԴ.cN	JԴL8\$DO5W~T)4;U&*5SE|֤gS'/S5\$y\"\$sf)J4o0uvTS2iqTMLAMS+U(KXwV7GOdcn\0f\0@\0'[`\\Uժ\r] rOy^τM2_Bp`\"(QB'5QmS7Ooc<\ra\rWZ,+/AkE\"8χ\nu+*.\n6^SfUQb\"HtBO!+Ljz]_TZK(km3Qhl7GdBGDP;i4K#0C.qzmcz77\"8kh\rV| SM24k4Jf҄`@\npqT3m6\0!q<\"#CʥO몈6E,5OURIj0æSqo3mH\nH3nļr\$T\$!xbljTTyVDS{o.F[:tPVM\$JȓtMq1{ЧWBmM'	>qΘj)<0RY)X\$g٪8ĸWUld˭/G?m?Qֿ\"xaBQ:h#bJ)uP4\nUZRYNd\\梁`<.XB탂6x>xkBòr#~x.:oj\"=w'P7:RtqW \r*TU7TR-%N&F愌e";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\0r')D-kjui@h.rاHPKE;󸅪مNݹo:lՅiڊ\\AΥ2@z݄Yw26\rӤ{gO{\$ylu,\04;TV82a4Tp7\r19(\" :# ʄc8CqXc624d*c<R)0uRJ^#HEru<mV4 )U(?\$#pqB NC)10JJ`OS8!`uRP(:e7TT-M9/[Di0n+rvBk^u1:ŝui@@x&vaY1b6|KTYFV0c*98@0İC\04@:af9ƱX90z\r8a^\\0L9\rx7]9xDl7p466H7x(5-CP;&r|)iB(/Ei?>%\02h:eiU/NF&%\$>o@`ߖ=hK̵viA	G'YL1:b%0dV;#`2f\\A؜0B!DEQPp)*uc\nKD/3ȓ'*e2#e9c\n\"cU%sP=SDՄUZ-vE!SNާ>TUpAUH}ގgToX\0Uzv2Z inp@@n,Ctaka6J	roA¥!% +*֛cf/lAx c<\0jZᙼ\0:\0k:(C8a@\0-Vr9Jȕbbx0FХ0kGhUAƌ=w8JC\"^ yUW_;6\nx.a)\"h4@O1YABs\0GXj@xON@>\$б2~&8Ddr6b`<\0ҽ^K{/\0`LApX[\n0P&(ChpvIP\\H[FF>!T!%aG,1I+U_2h*av\rjJ>Hlvap@'c]!c\"cE5dh,39;CK}ĉm%\n (jzwAAT&:r~+e|B<Yl~L9A 'A`Z	\"޴O\$1T.XX2c>[h+\rt.i2w\r1C:r.s-t\0F 'luRKf^m)8L33S(	RfR\nQL ętb9UtUA)#2\rf6)GCD\"\"G82\rKOD:PBO\naP,V/hd)w./u`\rx/¼\0H1Ce0#@-\\q!VZKɈI_\"\$_DcR7\nL&2i8KrQ2.XOV߹4pa9(SiKC7<B<zXX>xMΨ)VQ9IyCB1ҵ޼;}6eӨRyJD\rucd}ꧬ`ke}yM`%Zw@P(,e_E**QQ*=/Z\$/\\9Vz u`-d*3+hcB{}I5}sծMZ=:G\n{\01l\r!C=go)DM}4\n!+\$B\r	zr`DkBq5B\rdÉ`+b?hƭU@soGqP̣УEĮ,֐JЄ, W!P*1{Vz/F5x]AJWpL5@\\?\$́㺞xنJd4OO]o&;-(X6GEҐO_[rt b1M2N+:ox2yޓQ7%a\$DLRRqR8Bn''frgg>J@ni&#4L5iƠ,ˎ*iS\n?!b Yﾂ5jRX6JJ9̕Mcy~Ƅhݤ5\r\0&6P0i4R.3O1!p?!\$4z#F98Z*+pZ40hipvipV:%fP0udmRMY'A\$\rB}0A|4ϽoDQlϿq+\r{IT'-mq-n1FՎ~?Q@{QHI[z˥D4.!q@\"6z1^,@Ρ1gaqT0<h)m\"V+:)\"9|@Q/̡ M\0q><qd+,!*qNun{d>=9\n1KR@g;n*Q,3#_ JczG%.<5!BZLyd2/\"cxûR&Rio+}Z^ QjzM|:|p\0={.^j<\r'.A\0;\rVђJ0q(-S1:-1sh&zeI22tHŲ5-\$..Rr#/:` iDk6D2p讕7|ou793S&YK+7nNY0,P~鳾e-4s5Q=<;7!a`R\$6D<2%,A#3\nSS'@Dj&9ˌ>,Ȕ34Ϣ^3*Dv@=(cCB	B##n~TZa)x+P8%P=^h\rV+(\rh.Bo\\*b\r ̈( %\rEk8`\np)\rKdW<#;'#G&TL?O!,XOhhc\$C=\n(',,G0zR7UH.+aMC\0FUlGR4\\N6bz!G(}ad\"1>+rR#bPГC\\!QZ7GU[POg=h||\0\\3B	@Y98?>2[[\02Õq=	OqPnXЃr|N%d5C^d@HN2QHajf_YJ/BQm76gFy\\Al!.'3Z0GDq,I?DN";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InPEc	o1v\"i11n:F79!Hd01S]q1PEy@hDv4ߌY}@u8b07SDa1_u3/NWV\"dq8*.dƳIӮ\n)MpQRɀ+	;~d^7(9,i 0?\rcF!౎\"9c2\$<PJ\r:70ktz9J\n*Qւ+.K6 \"(2+:l\\(6\"(*V@RjȆr-B8A&)|7Z.\r˘@K(LH:l`-]P4֕-B6A0	B\01mbRԼm*03\r\0yX\rC@:t㽌4*9|/YC ^'AڱK8̱h7x\$n;:<He:ݦ)V9<39=맀:\0s~®-B=hhJ2Oh\$xxʂdoB6BP-J#\\\$<P28`Ih]Wc#PXA\r#*E69B4kW9/CRTBbTQv5+42#V`۷-1#s(|+7\r,@L߻4<%z=ō)׌}<a1,4\05Z\$ܵG=na3OGsr\\p')z\0O}i<0#rSqi  G!3Ŵb]!Дco\"Ĭ7^TAY]pXs\n\r2\nI J_D@QdXQ?o\\Y8 RP+PʖV}]+|Xd,r\r>`Uc\rf K<8x!\r[PH*RM\r-WQM\\H\nXdzпxж^`p/7ޗcYhr8@DRA.b<#9DD8 Un=)sR!7pM%XmPaKvjXc/%XJTCHoeFi0V3@PE'PN\nk4WMqx椢t,	y4\$rPu Q\0YۦfVyGbtL4!EPy	Ã:V(bFm] R_MZ~	peCDS\nA4Z N4]q\\\rV'l?-\\cdQJ\$䤕^_r,#VX`GD>rjMd	Ed:B7K3jKΐq\ndbT^RĿDM\"&,b~	L*Vamb*+|+iGDaO#l}6dT7bʾS 0-SƚTJE?GA`*Pr^j<~Ӑʀ\\,iHN@T0;![qh0d>,\$B+eX+!T9lo:3A{l9S#1ؤ	>S֬}3w>tNT/D`\"()좞2}{n5eݖjOP4%%tqxP̿䙠haO\\Bg9XsIz?\r!EEՄ3x	/QKL7!~1dC)^O!|BM7giՌqrA\r/T:`MKP2\0Jegzu k7bE:H ={K!,c#G<7FRP!&9\rPPKLh\"g;fQ:\rȷBT!\$DT4J\\1H_9B\\R[!9&()c2,ӓIX6LM\$S\0.!W9^+)r=׺_bzl#EXwfiPXNyϳ\$:^'j^3:ռo='G*k0DЪ^N('Ƨa<.\$>@WJ{>&qU9u 5ǝ\\+%:6?1S3xV=Sy-0-RV-l0H\nB/&Ĭ> (! \"wp&bX&wc |9C^@\r<dX[X4\$X6\rp:mP\":7m%boP<ԤLʥb\0s\nhLxH0MxP \np\r'GuG8n*Ώ.q01j[13&8H86֯\"#\0oIĤbxNDmۄo#h66,\"<'0A\rDp,gB6\$V:	\n?\n;/A(m,1Oo1PaP\0O	Bܭ#E!^1-Pw!\rI͌ܟ͐<ke!R:\"?DRIPotBR0z_ \0Y+xdfd-RFKQg<;mΑ!p71fk(8/+fd<Cul][**+C&#4)(;\0-f GPI.P.%RG^cf/\nk\nU\"I0-r#/\r3B@\0&ZC%3S8>S8@JPNZ45c\$=zLsCm*o2Q\$&._\n	'P<-JM,,;)\\Mf!/x\0Ҵ-Rɲ(_d2Ϊe7s(B?35@T\"\$Hw?8ğ@gT&PH%*15.bh'4P34e\rVh6TjD>(,<z\0ڻ\np}\0t^\\\"SԪO'Jl|.00 !0Vi=P!G&\"H@:Em\",b1(:-:Bwa24cˍO5\nbn8[jp6B	(%Jd.ͭM̴\0FMHo*\0R˄LUkU\" PdyrVj|46D\0\rn\$ldi\rƺk+Mnid\r~.ypÒD:mU^Do4./`@Y)U\"Ё6DTlsVDVPr\"<j&\$fUPT0\$\" kILX#\$31@";break;case"lv":$f="V0DCse1Mг~\nfaN2OFC)sC͐#&t&)2ӓFD	m 2!&r8	A\0BP\r&AeNgIt@\nFC1l7AGCF\"%I!C}j\r'H(agpa;i>)L\n\$pxX`A{7AWFE(Ņ]{f\n)L#@匉u-&E9N˄vMfiлrN\n\rC+\0* @5UȲc+,2®3a\00Cz	#҈\rS(c69\rj<)cJ^1x<n4P/c(*X֮F!D2kνnBĲj#kհR<(C%2D+5, r!B716I'\n܌@@178X90z\r8a^\\0th/C8^2|69c2䅍iH3/JAiB^0\0iZ_B9Éd,c:AwsQ (Wv=k&޷[ΦP0jbx\"F2[8%#\r8#c	(Z<%5O	g\ru\$7a\"p-L\0pp\\LRc]O=H3z=\\O5gBZ	BưTf*GPIh92Y(+l73ې(8Mڣ̆tӎn{wrqv\r	p:X&93K<B)GQ?\n,6\"w[3xH\"NGS5\$Z	9Nơ2z×2x\rtlq8C6+/L<3+B|9C%2:HCS>i.I&ʫQ\$l_J\rJ\0vMp )JPP]Ba PB\nd\n{6'D5\r(vIJ~2*)M0Þ\$VG_|65<M>FʟY\$	.Bv	\nRuRjV!YRʻW˘ʱA4H#O\r+VJ^\r!M5>n\\k\\ݝ2B'𱓐Zӱ5đ\\TʡU*\\@9+x\r2]c0|peey<\0004hO&)8Q(AS4rQ)e ` \rD,1Ag3a!ꅌPpХ'\r*\r'\0\"hGn\n.(#&@֟ \n (c?3\"^j3\0fT6U&^/>eɐA,`ʦz7r!(q);Tt{AIpҧ]j]\$W/O]^d3F8\"\0>ĩD@9@fHxn @o\"\nP)KHbqĜ01EthL\nY(I\nvq*Dzmty8DLQ\r,8P	L*NA5_-\rpc\"9D2қЁ㸰C0i-i6nO2ZK| MfMIsM&ܲRѦ3AA\0-~\"%2Lӟ*'2O5c݆#jM\nN&|mھA Edd&LA&3wH2pP1JFd1D44ѷ0e=XKD/9q挙og6cBPA`G<G9!5ԮV[UDr_=35dqJS)̡¶&Mf{%JC}emu*CM>'_0]5\0?\$أ40\"D3T.%,[':;L5]z1UN! B2H1ҹ{D8WFlЌHsFx.P#(0Y&4jdAa\"_{>*Bau溂PY7\r_Łygb1_V\\GUSp,CIc^D	{ϐ.׋^^E{bs[Hb1\$F26O'Zԙ4_uޛ<^>â]ZPRd6<C]!H}׼%D\\E;2'pIMl=x^L	[t[c}mڵH~1+VfLsBhkZ1w\"@P2\re\0MR#+쫭o\r-Hxp-+|cr%Xfhf^k-g|F.9#%g.n&gdLgL 'hi\r܂-(1PVm+!s'6BOǰ(RL.!YdOp	>٬p\riV0in٩A\r,`\r o^b.Q\$Q\r( PQlF>3q9	ĬNRpY0*Lfh\$.]qq,S{\rTK~̨\"XFe>T3lp)BgeE	&tш\np\$rPWF9)IAlQx12oԼ夙.X1[\"=2&c !H\neZ2\$'\"<11!mQH^\"\"\ntb]vb)Ft\"s5'IA(`hҋ#qFdOiBBa\n0GBRh[,C&H',P5#,ʳ1BU\"e r3R \nŚ\rSx\\:\04B|߭s+BT2s2Q1n|S:OQ\nN͏/\"M|\nf,RC0-b*N!5Ӄ*%!M\0N3a\0'?j0#37g9)j\rf&Ҭq2fTOD⢌/(e1=)2!=\n>2n	c\"b^k޺(2n{NAqX'Ӎ6> v`8`}\0VCHaBFⶠ1\np6DA^(NGd3q&b7wԆ\"ꔑv7B>(֥S8;JC&{Cn0 @ELPD|JђC`nkX4PR\"tNQE`@#MQ%6P*z1Eu(BP<1jDx<\$/&NN^.̾m\n-M#abL̰?eH0(N8\$C#.!ͦB7̓+Qsb#V\r5YR(,4EGh`q,J&dF0JJ	\\";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaJNpIu\$DIES%:& RX>.M 5nPia^55M d9РF聄bNNSD{¡KNx\\@t23t%><B =U7r7H\n92o, ;*\$s)*:;)JjV:2KP70CZ᥏SFp\n,XNrBʣ&` c껯\"[(b(Ǌ\n C&\rˤāS\$#m# ;08j1pO\0H4\r-(|\"4C(C@:tL(|IC ^)A-B|JH\n\rmX%&6\$	\":B`٧J22˰c|.\r!Z|\r7Bu\nY6X#9)TC11r'q0Ȧ\0SJ7\$(V/%^	.;JYbpӀ&NB&[{:)kΊ@)Vq/k/^Ѧ-3PgP:B*_nqp0(!\$8YCK\".O\0A`c|2ܘ-#wpN\n\08i3mVMZ⣳,Ì+JChܚ)(BxUQ]Q K2Ik@pݖ5݂SJw'uSYK4TJSuPUYU7ZHi-*]vIjX|{Q-\$]>-+&&_b|}o8rReM>UT*ՋsNri1ph\0Ʒ Dmpʗ[7a3c KD-P[\r05qHl#%~*!\" SԏlQpz9\r!9_PȌĘJ\"BqH\n\0PRLl-rU\n<CBA7x<Jl'81J\r*7E\rB\nHBsyI.Ne|q\0FbiCxA7LR1Z(D)4%P^̴aA d!SKy dL1h{U&\"nT)	U'WHr{aͳt.\n<)H<s@ ƲaiRFLFGLde-BTKi]RUCzkQ3I&xX^*CPA5Q\n	8PTJ@-a)@/gh2RE,4<ɻ5%^ϊD@vLĿ?E tڀL)9	-IR5tMO쿚3Xj͡0,/Xh)hbZLY\nful\nZ3iF`A*eYJM/\r3\0aIi*L)mA[l=3 pH%!\r|d-\\1>6|лl 6\$DZH6P]sve%v[&ۭb-A96rt5OʭW4sqBM%ؚ\"()(d̔4\"7Qd<b3Twdя:,9x A4s dnK^DT)P-c٬Մ\rE+\rި'0h٫v.\rbj\"\$L5[\"coN\r?hXSS٫Juj_:#ٴ@j|=]pl#ֹ[삐 3x4q3bl/!qٛr偦[vƑ<l'faL>Aw8s!G\$q\"Q;:Wa,-db_#g<-Ĺ\\DM4Gwvtjh%tKj(Ľ0Kqؽ~\"+{g0ݶ^gyp8Ǚែ=e3Q=٬Υ]XpbrԵ}lp,Q^7{ol_zZbht|Fk)4n\r)33\\/aR/#Ϯux,U;;EV[_m,^B6QnjkN<fv\r/H0OϘ!-\0m\"pOp(\$LF=b&(ͮ?\$î/Ђ&@O;*CD~\nHP	/&Ɛ:n(e-VlZ,#*-пGPeZ0\$pO;F8PR/PVZk9kzEVn\"ˀʆ.bz?K,10a6̑.{\0D\$'FNά;p5.pOo\nͬ	mZέ1opJPf\0`\n#Ċ=En\0!		i1@hd@;Kl	|!\rFQN2i\n\rP\rVb\"V4`DJ4Pz.\\,h\nZJodjnitNe(N-Khtͮ9izK%!\rȴ[(3%T1fr{BK\n,}*bPk%Zf-'ge&JjLBGt2d4u1wP\r4fF|u%ct'&nD0Z#ֹdS <J@./3a0#B3(\"\"Y2:~.Ja\"_4\r; 2C+BY:OLil";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(e1aʔeF2NK&.S@Ud\r5\rg. (F7@)c4/|e\ns\"U,8Ng=i<sIRvh0qz[	9ctTV#ž8=bF20:PNRX>(:(2;J:&@;8+9Øtj´(+Db!i+*3M<:'R\rC#:#K#f	Я41AC6P*h78h+£.IRB\nN6!#R(#\0%# ڽ;Pdܕ9#:N3/(M\$9q;C X\nD܎xtt&4z9˰a{^*\0/P7C(x!:;r.CVĊ:P\"Oc+CuӉx)\\:,3qO`JCVi	cz_9\n!bB7ry@.r)\n2B|%ŠP\\YG 4~.H¾kӈ#2^ɥɻ֒ΕϹ)NĹ\")\"`@7 :cO<.09mkW>CP4\r[0BSH8hkN\"HBͽ6PךC\n6F&ԃq_LWz(,t͂iTkTx_;ϛ/9RgU\nbGH\r/Kڋd8RzV>ԛGļC5/ CZècd9SJ&P4vE(|CUXc,H*\\V\\+rX	b^C\r%ep\r*ZdUsY^*%M4}͝x;P&HDd6'HL*Ve>+vaK\rbd`jLY\r`xh\r@ޡ\"\r eAI#'(Snn!\$|@p\$JM\rBOPL`\\\rbZ-Y!e9@&\naҒ5YGt_IA\0\04[ a\0j|%ܢ	GiNBIG'&biMI:Q}xWbIF5!W{#*uNeUBY+FiV]{J,\0F'x	IWb \rib؜xcQfS)\rDm<T)%2<tHH1)cxYAz?Ur22MBO\naPMK)Bt^4S_saʩTn1AvàA\0k8Y( Lu^LNiU*MSNʋr+si&RQHbcPCEp \n@\"n &[(0P\"mA0ts\nYiɧ	ʑptKoRG\$*9D'~UЎ8És.T*>\nI!wT_!Dֶk8_+;T/tw=)tV_+7,w\"yRn!DyP{׆E3 (\$0sq<MΔþ	}O/Vmqn=a8cjz2X޴Q.ᜎm\$^4h@\0Kn4!UTq7Xx7ȻLE[Ћ'BhX*\0q5K#SW9c0QD	E\r\$@A\rQb՚pÖҼǪ\"j9Oo)[(Tۄ9c&\\TmIhk;˂Im\\]L t|)oBHڃ@+(R\\Lw#e?8Lv.skSjmʹviT@(\"'|VoTR 2F܋YPؔCO};K4giO#n37V)f3Tvmǌ5[7WJ-z'͙wFL2ep{%ײw,K8r\r6l'ߍXe_c7qC^7zWk\r·.='JG/so3XQ/83܍r-Jm\0L\rf,cR#B:㌧b\rBXo\rV;P\$ kH/OPF (б\"9\r=dTF(IzOl#0#!#=cN]\nEP\0ϢG.eJ1.C%0\0\rdƔN0l0Oe4̓rƜBxNFb\ra-VI*^Im[n\rƴnñ(9cOBCN+b2Huf>/j&(\rI:wш&q)*4F5c#'H'>ѫmqBm&QB9BGr1Ǿ(ѢVN\\`@B\n&1#\rrϏ )!'' rΒ1X\\tK6-n? C<T/#\$8ŷI@4b&nͥ!fb'):\$}ruP'<b hi\0.`#j*rJe\rVAkHi7ɂ.4Z	i~\nZCa)G訠<j?\rR#tsl 0n#4B@k*\\Plqtfj2DD \"BSJ\r`Dl8ȾY8	\\/By{IF=,.L5BHO#71.BSb]85;P=( ̍:p:y.33<i;'thb1n:kb,gfHneOOFͰNjƱ@5g6NK><9\$\rƞ,EbA-	=;*i\$OKV:-i		Ńp5e2:n\"T>`/bf";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n!p&=.da1O͐IHd^JfYf-z_F&DL7}612_r[@./0fI0g		Yuu	\"\rnILx[SͻpyʦYwBVItGCyV:Øꑭc2%\"l6-H@1=-@0vʨ\r\"9\nR\"R)K	ɀڼ @CHȸ-L`;!O82b*ŎRhR;\rPAl.-3H\r# ڶ(o@,8@12R:\rx!90XXhПD4&ÀxQ̤ދAr3X_G#J(|63-f7^0j~+*,R\"M4j6hܭp2P0Cr3hh	)\0\"c|B2#l_3ȃE`֟`c.26:ò:p3B2*V0J^\":]K㾝@4kDa\nKe\nx[6ߪr>݌\$3c\$!cpͻ∘k,MxHmگl\n5C+4	?\0p-[kkZ\$꼈o\rn/\$}Lv\0hs(\r58J@HLR2	4T.6;EߣxL+Os͉WSI7~0rwXaJR*Out<bR*\rW^ #M:F\rJ.ҜyP*%HUj7[U@uְ!)b`5e	p:\"Q,7/JIYQ@X _L)QK)TTaR\"UΙ:4 p0l4B\0|yd2ο\\l8j'fʠdf\\7k:5Nɱ\r,;#hːd]׿3Dʅ&Lz!קglz(eL8sd`1Ks/e(/`ڬH#P	@M((V6L/!.ɚFG4\0_d5k5:;6_T]^Bo65F4WA8(RP40\r	02R1\"8\$8) C{:ś(di1f4pK	q0Bb~L\r:@zGBLDC˾1:<i>,a	cL_01(jlt֑ZOh e	F_nRftO	fI:ҝάK5_ ͑<M\$/x6I4Z4#@fTBu&c2HXg@Qp奕P*Vm E	ޯV]ץ4\n]cYe]1\$t6CdfH\"#6㜥@~1!	 Lid6t[)X V]Wk96%Լ.Иa \nPE@F-]kWCHz`5¾+pD>wH'Ewڶ[8p*K\\Ce1^2Nтi-pMs-0\\?c%(!)3--/,vIjEi9&XG\n[@0	ztpRQpEm_|BD[BH,-VSo@)ݛ:I98B[נ _\\0ȼ~/!.oY	-I)^ָr!0FH {7`B!.tȔƲI '/lǉlf l\0 2kv]Ȝj'7ciIM\$g¬\r'<McF2dClIcX`\r;向K:Ysqh[Q 3y-|H\rG'Wdk\n]5є9DcSƦukbB[7sW] 6EsR&ţqF\rĮ]J(if/yq>g&\\.J1%2;zrJ@eIMyʘ[ڮ>cّ;}{&{Ykn_,rſIMqC\\'~pcl\">A6fqҽH?-[nhJ↏c`~\nd^O6&\n6Gb)ˊnk0P<f#b'V)GOo'TE0F̫@20EoDOOu	M2NZ,R%0/pdϖ0v(M,nEfQf	Yl ފbü\$̘'Pzcwf\0A,1\r(CZ\"_)b\rqSP)qTsL(1]	9gR_BF1z1\0O\\5c/f)Όif(*M]~\\1 *\r,B9L[;6:σ\nlh'J \"\n2)	b%&cDa))G!+\riPf1:N%\$RCc_e&MT-2a\rϸ Rfۣ*)-΄R\rV\rd !:/\$(9p6B.kp\nj\r\$%2ҴKfڒ.gBRؐ4/ 7pB~ePCC.pN9r6\$J C|BD^3. ô	~#Tbl1nPƲpKf13c7NBD3s8B1a9oM6&c45c\nelMe3%MTE2f\0f=V[M`8n3Ɍ\"ڻ\nf!@Ml@13pX`\0	s/*f!@-+_!\$l:LC-hFn\"";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n*N#t(7d؊dM@!a\"r20gyju8GpP*@dr3QA5mtCH(a8VnWKpj1y7rB\rhL8';a ݃Y<QT}B]	4y1CGi7\r9Cx1#׍*X7P8@Шc2*p+x<(d7:V@Ӹ2hA\nq3! \n'lhQc)(-=A0ҠRp P2P9.PJBhOj@,\$AH2^:C6\r;9.ô0ØE#\"P%\0BxP1h-7pl@:H\\94`@(#C:3:xe\r-+Ɓt3_\rp>J|X3@4px!7-Lc:t7!q^M5tQBt3ȍ2̮3!(ȓ3cSpfDP7J/YT1O ։X7lb\njPM,1xP:͢ mFMC8=!0ء2I2d(=J:2H!1J_\0R\0@:%1d\\ƣ	\0=HN☢&Pfңa20Atj1եS:s׍)68tԌ-Z D\0P6z=kP!MdԏQhb({\\r93_R?< utiA8lLgȂrC0f\$Hp17Z]Jq1 OXaWL9Aæ-.e)uhvp	a\npb\"]'R@jWV8k:P(X@%td.6g\"JF!\$v	!hЭx~ԪFz\rLz\nXdHZk\\6`P:[&WZ&ɹI\\0s%1*Ad,Ex40R\nPhO\"rRQ+UeX	b,edZH9-@%_an-~ܦ.fJP*Øn|1dHTы/⨒A	aA@* ϴ1J6\0	Tw*1ɐPHl\rJca3u2{\"֍FaF zlv\r\n5r@(b?FhPࠉIy1&eٶ84	KJoH\\8x0\0S\r6LY1D\rZ|02+=4eEx4A(-6.{!=E!.pTFڥ\\Trֆ(A4â1aI\r60Jsn aL)ib:rSHm,bYBCZJqvvvڧUb\$IL1\"@hh D:8MQJt=*7a1\\ӕ0rSi\r<ʴ\0\\=jD4LeV0oJLLXDv?tpn `ҡV\rX<Xk6h&Naz0w#Pv|`SJrIKen*Rԁs̠aCa2a/K;2ơ,e	bFXˎ>sUh;x\0('e5pOEh{pw5戔0|lD_(\r]D@aO Q)yGO~Q`OVgAּuJ	(syb\n5BŎi(8̠9\rn&1AC,39yPݶ\\Q\n3ЏҺDP.N=jlioz1̍)iEð&sV{]c+;\\:8\\ūhD'DI˖܆2tߌ\n@*S~^2D\n`\\ifi˕hl6ԭeeA)8dL_Y#0\$T\n!1:hw`gOЅV_-tN\\R&y^dEC8gyPl	9FKUxSA|v!Ԉ`e8t`ZĢd29o.I_<7\r	& 1>3]jSWù'v}UJ=~D???[=n-˱,hT#B8P**)B0Mdx~l}Dj=VL*\0BH9 \"z7-4L̠ī!2^	jn\$X2+\"L\nĦh1#ø\"B\$.m`DJ=>QȘL\\P%(V^'\$m	D>~m^aB2-(0)y	h \rA	\rOx(\nVplrm7c`6\$ kE\"\"@b6Q.T#kΤ7h7'\rR'p\rf\0\\QZhnpqB0OVձ^BУg~ՍiVoW\$Ov\rqwrwѿnKUP\n7ked.obJ YR\n!pD) !#/FT\rяrSrJe\nl&RW1䨎Z4N^ΣΦe\$FBNoDZ%jhIG9WD0!Zt%R\$ TmeڅDO-RKu\$Wh\"UrrJrV/,bfFΖ72--*f\nβ4F㌵ы\n`1N;2 \nh2N.`ò떫%q֨\nEd6SY S]3s5bZl.IO7S݄|fBZc9m\n\$=M8npFLR9\"=\r/\rD.<=-=_3{1@֓u>`QSDz?@I@2\0`-*3hg3_&\rt*6IGBB3?\\A9D	4s4[B/1k R]PFy7?T%ATcB@艐A8 @>6BmHԎ}\"|Ԝ產*uJʷ*nD@fFXG3&=NMr[>M|4{4&vNoĨS6q\"yH*3&QWQ&%RþP4VG\"->5RLuQU0,M<9=!j/(SUp(G&7V\n0PAP*d\r4=ՀϼْXOC#Zϝ[/;%\0L``*?PpI\$c)),2̜-\$P)B1B\nZlEGzr/aA%ȾɆThcbSxv5^Zb@#	`#Br8#km&DrJ:JUU>DhG~Q0;J7,#V\0\ne>>qPP∋ @ފillG BbZv޶b0(Â1s6o%99p69sK2s8;_k\02rFP@\rq_\$̏S6LblHe_bn+(/з\r2`n\$m5KN\n8TЖZ\nJXMMV%fCm\0LCt:k(q	\rYP%";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MLx 2fM\"pNCI=v:LRS	pM7\r3I7\\c*i@D#-޽MQ\$FNYQje1G! :6pG:9.jY'wf[2jz+r/vt{\"j	-ޞB\np7\rܓIs4Ό\08#&:3P@::ʡ-IZ\n\0ԡ5p!,\nVɗCjP2'KB2,2{@%@!C:2(9Fc.}-:J+-2Bj1P`P2@CrDD9đ4D0h2@q21N#HoX D49Ax^;tLr3@_YJ|63.x'J2k6ɲ@Q=Ŏ4M#+Ѧ._М79@P0pΊ @1(Hxcx:+=LpJO2 p:k#-<u8kCtӧwL8#fM{JP09<s \"t':2\0V6\$[vY)\0(S4C;mҥ,9(%Fk9r؋\n	7sS8j6ʂHQ4(2]*Vl!?g\\6\"6:%\n1p~a+w3V߀\$7d:73M'\0LR@z1RU)a]J?0p^d\ndņPPJFP4sO	T\n9rroq\\.g©roUX	b,eR/5gAy\\qs\\i	M*#fÛ8,4ϙ:,2`\"pʿX+\rbuIxwA3PO/IX1	kCvJ8%!`H	q,*\0P)1<#@x Е(-)X&	Xl|\$XQ}	Ġ4#^愞D@\$Fi@`\rs#ĖxԫU<ᆓqҢ/MO7\0OI8@!72^B155tԚ FaI0\\hEQ;\"e\$TTC|Ba) hHd(TwzhD2w&)8\n'dTJ	C(WvG1ʐcDap E0Ύ*DH<\0aQ	%8h1&\nǚ*aFD0P@PP	L**O-VSd,FOs\rT#i)ja\r%\rXS褨M6CvqN1;M\0F\nx\"ε\"H!\$H=p@\0\0U\n @uD0\"1ae	mބ:	`R02zOpjD4GCe9[xM<HxL*>0U9*%np	Qb.J(<(D<2R\0PV \0u\"7oܛAkJ6Gʁ:5\"Y0a(zdd\nfBC \nLE\nS4X* B̑:3a-1c#s- u*r\\RЇr'=}juȣ0ΚȊ5+wHgvK1Ƹ?dsWƊC(H͈N'\"nT!\$]Q*LN*#%*\0/,,6odWaJ~]Feh^ W̯	lfU`Dqm%;p!Raēp\nR\rЌ̜gŢyљ<r\$\"&܊H=w!K?=Xf#kwY*@AC>@Be턴;P\"Mq\"M璉l%P@ugUݻDr??BNYy45~EN`a~9Fz5{G̕Ke6d]Lpw<l\$Q\rRڙj}ǎ[	\";K/\$\n-S'Je\r*8w6 JHʠvolrZG/ĈM\\{G/Lv4,NC<yBbn\nXNfj,~77R^V*HPv8\rTbЁKA}	cdBP<<ڔ+\$b:V,&n O\"NQd:Gk\nd <2IW%ڱP0ֹ\nKC>r4|K`	'.`/^pۀ@`2?qTqV#1Hqds\nkHtZx5DiF(HKDRQl@C\$J(aEư=1fЕqqn3r;+.%kmF&1;Qb<OFyĄkFd%qr 	]R	 B~\"r#r\"V\"+qZ\nOM#'=Vn7v3p1Z-_&&&/H:2y&c}'fϲv&Snr.w!0(~-tSq5ҦRtW`@\n2Q&ib[, r &W`A-PC\$L\n^\"[+o.22T3@<ʭ-C\$d\$?!3\$93)f]cP9C2/n4@n\"&50W3:?\0j\r&DJE#1V\$. Zl\$p`FD3j(\nZgDb_/D};䉘)8/ǾU1F/4ы\"A}mA-Ӈ(B\r^[9 @?(Hѡthbndq,#FQ\"adϨ2RCDb.vd3f{@	a)@ދ\nшUE	E\$X̔\\/a(\\@@(L0jD^\n4rvG:̋.4y%f=b2m6N(&GHROLBt4M,:4@,T<ad>U@.!r-zѡ\0007PNO'P";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7ML 2L\nA(NgZʬhAbNs)/M8Yf6h8eَR)du2{:-6nsDd0?ɜWmhܕBMꙸ/iH+20~tx8(^\$zz\nP*X7rT97cr\":,D.[:\"èD9Ȝ@38qs\$3H3Va򰭫h@5(mh.Cj? C!0\nC+,\r\0ٳ2-|,ܕR6C\n\$׉z	)z7%h0 C<2q#\0;J\0LDR9`@SCn3:x_axc ^+۾Cp̾'|Ԡ&O8*cb\r?	jH7]׀7r/B^7IHC^\"6XKKT15<czC97ɆSǎ]g\n.(7c&hbB}XNHO&n&(ʖnmؔ.J,1*&LANP H[!NLo=<2`82#+mq\\CYf\r#b<H@@P<uG&&B]w4fsq#f*cǰ#E6ҕwFl3D^M{|%3c\0002#\\\r\n|<'M9c͙j4W?`3Г\0 Qʜ2\n_)%:0ھU	9\n	uLQ9*\\jʣPVYUnUڽW`ƅ2\r>D-ż	,'«\"/F\$vl\\.̙\0hEDCnz\\+x9,uYEɡ>'B9=\rgĩOIDJ\\YQ1'v))0H4H\rm2CAtf/M'_LBb%陂8,pz''Dj΁M\0 RJ2E4̐LJ	\r\"ON;9L-soB	xItbۣl#\0;7t\$G,e\n-,BuhE[H|[3AA FZPp-=rS3&BqbDH D(\"\r!SOfhdj.FܘkL\"ߘȱ+PÛvYy!nD\$ړUexxS\nע\0gJ&'YʫSܩf\\NJꨀBI=X0z	u/R\\0T\r:.|\0fUd9t,N'FVEso'@BD!P\"[(L0&4nx_^0}?-,ha.B@(+0iyQ^GϸBcl98j\r*ze0΁s1W)\\NJT6y@_P\nļ42Nlў=Xr8V{S˪~\$Y@=E^qG9 Cqb0Ϣtg	L雱 ES^\\#Rn+Z`N\\ad2pb*\0#OehN}KTU/6`քq׮nO]A/\r.Ck7;I֋ȋ!`((	y\rg%`\0\rRNyq&B T!\$_Pݫ\nUOG\\<Fyi&݁ bh7lT5ƠTWnqf@+\0Ž)dX#\rю<R~O*-*K\"GSW<HSNȷG[S;.{:maD;xA3+̊̪ˊE6I?&xfMHH%|LeQq`W\na7քuA!gt[a,O{J!4_˞F㎸O`73rq8jGv+~qmp10?	Ca04EZh|0Km2]up\n(4ⶤm:Cv#3WA~S-]ËzzBxxs26:@¯z\nH,nA'1Pd0'p+tp 6?\0pFwdm͐V/Pg͍.'P\nM0\r߮<O2t؎<~lMn(}JӰLPP\nP8\0AP8m3P1rb2G/%c1\"\$>(#(\n0U&C65!\r4Q%G.OA#0P\\JЬ^n,L`r60gl32,>^md0`>se+=\r&:Rt@(:#&	9dpjm0w{&,/q(ْg\"Ld\nlα|\"h `\rOk%(RVBS&RYp!\r\n2s&d#Y(1@r<\$2[4RM\$^c1*B8\$p4`Dm+@++%A,,ƶW!M-R)m/R2\n&*c0m)\ncmO /23-00T&@4@K(cƨf5\"REQ2,/6x⠆jE09<0o5lBp73GPJo2z`?\0j\r&\"E#BE8 ZjBsf\r\$D@\0\np%RV\rLӎC.\0O	77Q6`\n*¬肛RwA?dKBb.Z\n\$=#OSCr<nP+:Zdq?\nPdat^BB/0#CT3c&\"IG!0-Ĉ4Ԣ%G7t+L*bH%K)@2F\\04+8q'wEg8l\06@.fFND50'AO5d5=#_05пs&%Nf,>q&2ժ=Ĩds|";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rبi^DIĄl4'KG#+82bDt0,d4Q\$suh8l瞒If;=,foNs) h4:IN;ق Af24- !9cp99P2PA5x&c𞈌[B0*n8´8D茺J\n)cP!j/H,H^4l(IĦ;5)4%c1c+k!c:)	2k܊\nH!6(6zJ('I01P\"!205	x\"f**Z@:qhLj2(ԍp12\0x\rC@:t㽼)JeR9A|a]C ^*Aڼ'̼(|c,U+)ȆRh%CU>o\r8\rȷm\"9c @7cYBp0b8g1\"#z&*X03(ͨ\r쾎0oq FgzCR.<Qvd%HCS #::Jj:*؛4&9 V18ӈ-/7Ma\rKpwIgT2e8(9Ng	#mmB(x#ȴsX\r45pfjU**rĔ{3658(I3II Ŷ@r@y:F:5t1C\r\0,\n/`\r{(`9\0J`65]ШqN^x:j&k4Wx Z-Yj-eW.5ʃ@n{x>8 erq(fpK-fn8v<LA=	؍lj>g-V[kuo^4Q]U?>y!(Pb#QCZEꝠ1YjGPA18q.Tᖐ8\\HdIa&I3P0hmqXJ\nLEu'__Ie88|1sC9	&J#:ڙJ4Pܪf:,T4(|H.)e=#J#[tdm!K'I8m0c\nq,h%)n\$d\0vZc̈́\r=aL)cIN(4yPMLIC(%Jk]x%5ڜN	b+\$r. AQx0'.N\r,ʆ\0)N>jt<G̏H14K)09PO\naRqf*\n)PvA\$TF!)%ͥP.!i\n}&;I'yJWӶ7.V9%*9_EpkNC;\\yH\n=t}Tbc3XImT1M(ɣ!114\$MU@3zĀPM(za\$jvb@d,\\W:j+W9T%A̚23;W]Z m*\n/\0(+4BsʄX8B`c,2Q%.RBP#Oj2)R- ׹3CBT#h(@\"AW;^]dbhA<[>ṕN@Csc>-Pxdwj1î?N{^vmadc46kMl\naF[G@{AgR!9*06:_&G#}bST&Z1;p\"['ZlȮsFSPA\nP 0\\2,T]D@PGid-#f GW)]ݙroPQsp(0&l̘_'Ng.<ș@͍8*<rϘP`	<	8湋=z7H1}0[z7phTx; I+%ǥ(2NJoiJ	\\ĸD\"^\"}T5EvyAMM}( dÎY/fa Ӛc~mIQ12zҎqؙ5Xv_߿u}d~>n@O\0L\nfSd\$u!vj&6]K~7DʰMRih<\"L棬k paZ1&&JH%(Vϴ0/mLpd\$pe,/d,h,BPjSPnUP 'U[\n֛	/n`w/{\"\nŬgggf%L40@n#ބ.y0>&s\n#s0Kx\n@<O&mK-7cИf|S¼ij ?\rA@ʂn>:ВK7F<ҁj\\nT4`ͬg-{M~OԥCְ2(#XO->h\n1>qbp*Ce{ 2i+QO.bm=MBmUG O˃L\$O!1!)FTo\"N\0z,HP.*f<@aDC\"~`F<cJætfPay(LQ=( 11\$Ira\$=(\$z#fNvl>E1p&\n!rvr-U.2Ҡ'`Rr.)M'*@A0 0b.r<12,\n cN2*0#4phDUC\0LFR\rsV)E5Le3T8l]0BhvMMR91Ǩ]9\$)099R+)4+<o;yR @\n#9jǉ=C==µ\"{>J1=1N'D2#h\nN::L\$\\Lރ~PjB\$:)+,H&U#4lgA1A\"N玄41>a|E\rV;6&9`&NT<GqHچ4J\\\0\npIOddJfJVL-Ln4#>\$\"F{G҃o0sDC5&tm%EK/?&j\"Sp1v~kfEdRB)F\\(2N&(VnuH1fDL@]j(&AUo)ujo>cH)È8n2MiT16U\\) /&zj>ZMpSh\\F=#Fv#c4DRP @b/|SHXudcX	B%7'S+nu\rh\rr F#3&>	\0@	t\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>Ĺ\rYy&K\"k\rjce4# G4C]TBC6(Nf7ʙHW:fsuQʻnLUA8||Ֆ!۶n歎)#chB))\n,\"nhm&ۄ6CJ3oD<DJPlq0ۭ\n.Wjt,E);եB'ͱ\$BߗI꯫)W\nBW&\\`=m%0=q* ̙2EoU.@k6<@Jj.\"]Od\nö4N(+2J\$]xh&:±ŭd%&=\\X&qTĶ(\"Ќ\nu<_\\-ңjأ3cҕ:*㷋#\$xn1JcC&)ѐ2\rH2NM;#=ZJ&%T]7z4߷E?\\xX@4C(C@:t㾄8fx3(9PK}ܤa3NZbip|2ݭ6N8@&.	wdòC^W%IBSyC 51%IcZY?U-\n=g\\}[uKͶSUe{mAH1]4/3+=3#\$z\\n'P5\nt}	H^>Z]u`#;huȲ%EDG5ŢJqq\$]\nT)X#n)<,#Y\r)fxX,#܏y&[<G89Q	DI%1%-bC 3J\"\rz+a1@CUKH3F3@p^e;bF&Up\nLYB!& `a28nCDB BQ_\r@rQ4=H	'!{*Y9\\C9Bl*1#X,0)4F\n&i&dL1\"r/5 #q*\\%ed1;\"TKb0A&kԚ>iLd\\؎si{A1M\"jEr>κJ`nSTEi{&sÁHMI5%NSmiBEᎦ҆giD'K6O\n2C ftו%Յ+-Su7KylM|L-ҹ'(1RArMً3fݜzChu4Ӂxd\r0@`[*@,:{lmʵWXNg=E[e*sDtGL=JBD.Uގm֜5Ś3fpΙ>h\r;FWKKi<2Ӄid9nQ܄ }HaC)D]I&i4xIDy`4:Zj!lDhQL|&.JjtU&*bz4ʪo3DX:ƋV쟼7GU u<ڰZZ7Hc֣4U.eIjN\0 R]_#FO`<;d5ɋiDn9\"*PŰ&	U4daY\"^0n/'zINSqX;u'\n޺)GglvCTU=̐@Rn&L>?6f6BIQ\nHBEJ\n5R2CPoV&T\rP7c9T/q\n5+^\npR10tePԽ2T=P@AW=_R?̥IH,^ZH6n7' T`@'0\"qM9j!ʛ^RWv.2c\\Qz-*c)S=i!VEjbB-%	ӗ:9J[@j/Aa'%'P@PWgfW4swK6Cn3\$tnMCqzIett^5\"m&.5be|:=Jqzʏ\\0:ȷb-:.mT!	\$[uy3<xf	o5[h\0*	!0Qʕ\$Jԛ?KD\"zv\$b*xC<_\"Щ.@tH\n\0\n\rhll\"*au\0&<krB2\nNZA,B8\r\0OK/뇾CDԶ'IV\"%8C\0/&qJ(g*R\\\"|u(F Hd~pƄCPo[aL7BPBW^0(|%4@\r\0`#\0f\n@qCRy0\rMxE.B[f倾ErLk8ގl:ȾhSyj#!K.*q.tG~2\$ZpB%Ҧ&ł \n`JF6GN_VM܀H{\$u^1d^\$lDDE{[Nfzd'\"0	@I{;C臲+!l!# \n=\"Фcr(#pg\"S)\$g>2,h:NgT(i%22҃\",.(N\$(⨪Qʈl?v߄^GlD,**K(4-_ B%\0&PE>?j\"Iw..Xn*;r-1+g{!/oRST	D\rJ/+08ςE.0v_\$Si5ڗ9C:ZO0a#4&T/!%0d>P\"s2?UPQ2cT0	23MӴ/>s./=KO@Hm)<ӭl&'Pp0\r\"\"3~8\$ڽ4\"doDC]OR]X\$.|&M]!,3@FbVJ\$^G=9O>e8IS-.dHͺታJ~)?oJsު`S4Ii(l=3BUMH,n4%?2Ksf\$_*SLFc2	5\r)NJ9:\$jMRآJ=SO*Ss5=QaQ\$lU4,|q-'L'P;XRF.Y%A	!UUՏZeBt_:.{)@ϯKhb6(0<0|C\$LIL&Gt_\0`J'zj\$M_M8_5)ZAS^Q^M_1N3=}76:HgG:EL}O+f\nZ\"IfhILTULn5glIQQUijQhԑ6ֵUs\$l\n\n{[IX0ΕlVN/>2xCiXa\roZut@2W\0fuO\nFC7fBUkTUk?&rօRugss)t6LދIg=1eVұys`QnȻB~3}6m#+w%T{#\$,TAqFO86JcEAYw6ddzpMz5DK(Կ1՗{RPWF7p~{*\$4xowq\r	0}@4Ij\\Y!t8Exqף\rffj@@@i@\r\0cXh)tbw'ц\r#˟8b1%*.(|.\"[լx.,11tuc/1?qEwxrxB<Wj}59\rUBY1\\mYKV\n)wLt,4;}U7!UE(곕[kw&QVP(*cRm#RY\"wn^.U\nK\"3u#pmI\"s&^yR	o\$فlUyul=Rm^`a0X\\H+&MA̿؟G;/w_`/퓢@\n`qU9&[DԞ٣&g[ F&j=vPc0CH`eTv\\K-rوhYn扸/-YE+\rɈHZOU`ѡs%&\"Y+IRQb\r0oR%}G	BtEPrgux>5ҵbKG>mhKW+XH9G6Nr)u9IT;LrB7e3:,[=MFq6n/)n@PZW(6MԤ_`y\rD(QtNn x_}5~XS}Cs\nP7zn*Ct茸vo;BҐmpߤ}\"IoP#g{@C\n{W7Lf@";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\n*W5it/f@t< *a~k<J	'FbRN280;F\rƚd@a5֌&I`c4p'o5oQ&\\7ߨaC8v:.y҈C|͙	ChT<m1\$`=.@1X(42#JB\r(%\"/jyhH(#pZ9*2*ʶ2\"ʓcb\"`Eȳ0K487(!ʲtb@P70	\$D\0\rb`9/*K-cME- jC#\r[#@PC,oʁ`@\" 3:xc̅<Ar&3;c ^)<0a3\"mx%\")h+@o5\n @Kv#CB~`4ʈ\0	\nv:[+#ݿ(H D<B<(pbC1H%	0Sc	1T82&#cpCè5x3c;X1|^ P2\n~7+C&%HA,êhMU&2Sa(*V:&@:\r^PĶQ}qR6m	U\\ŉB/6;؊<y0We=c/ݿSӀ/MߧJiOjgጿ2Ѐ6cdˊ`oR\"*0\"q<0'l5PxMR*ʭ+&H4Mc-P\\`p	0w`\$*V8= f\n%\"g\r[7b9@Fџh\nbR_A\$DBc\$]hRF{/l8шuV45xXd,>VzZa70dT9#WJ\$Dal&QUp\n\\,j.];ӊQ&t\n	{RP\0\\̆W`5úS=g%{'27-Á8`EjO|I\$+c(U,#K)HsLY{ ,4\nJB\"#&Ha2>9K50Ni5gAzÇ+.jSĤTp~\nh'GG%E4#uDD:RN|\0RGK~*JpLL궈ɩ7\"ב}A\\cMfhbA!FC\"\$2vKšzV,c]Sm%D@NA\0C\naH#Lv	z)9;8E%)D4#je>MOG^Z.~~C\":g`Bl(GB6d>.~VK`jC?\r	0(ZLZ+lȳ|\\f[yIG!Slsqhkϋ\r&MQñ\"5Fljh\r줄`q.y,hLvC1:Eqz*\0C(N@iPՠ66~qme\0ʮTJ~b_#D`Ո5\"y%ruW7a}| LwWK\"Wtނ`nz\nЮV`^yn\0\"gGQZN-V\\gM\n1T\$~ѸP	TvnJߔlSPOQ'tWHQ@.P\0S\"43@պ\$2ikuچ/	Y5:&\n%lL *mBsh-Ѱ3]x5\0o٤{8ǏN5!]Ck!\r	R3#PPvȍC)U@\n˕+|V\nps<'[i?@BH\"9Έ2.W}Wyc༯2SY%[)5qwP\\1s1XۣyL:s.OA&ZWx˻%Sav7yRt%`V4BQᦆȹbgW\$ZX>%dPɇ_j&tM#or}_R9lONkYi\0\$ 6I31Y=\ro\"\"HB(|c|}\\M.v@2c<`<Bd*V-J_\rf(d00Ac	gafMܱ46\$*=>(+b,i\$ bE\"n\rɣ!Cl|pè0c<\"*Mm/	R߰\"ngr0o^yb<(\"0`hƐJq,1\rG\nBm  `n'1lnht\r	ih.̩2\n\\N*lG0\n9\nj'0CM;\\ѱ`wMv?cjܰQ~{`{P{{ƒlTBK;V&0OFUN_Ѻ?qc\$Iѳp qc-0ok&x*l=\"S 2G1|R\"\"!24@\rbC\"Ʋ'PIQ,@BJV/\$Cl&f?%a}'jPˆbPwʤ,(d=z@j0b\$+,h%#5#!(oq^X`v^f&fM!2|fTU\nFN\$prFv./1pi1B`3S2o2/>,{2A1f=FD+'Dgf\$|^rG-ĪBB4oq8.Q 99rC0>BƬp:3`Lz\0A:Ʈ9\r>0-1aJpRq'\rbzGJ2>c:\n~>\ns'32Y@Q>1#ڇ@CfS3 0q:3\r-fӾ>3n@GK@*UdVd#DIEbFF.SF`E+0nJ0`SgTP%nk!+\"A#4J/38a0mhF.4eJJ\$1H4\$˟B#0/NNOC3IǽD+.8S:Ǽ04w>\rTn\rvU';Qt\n:r% \$4JI(\$\nF:JbG<\$# xJ\r\"M`c\r 7ch7ˀ(+90(Ii@NH/&*)`Gi(/@\0\npJޯmR˻]e+5^C^*UL -*T\"6#4Ӵ4'F1`42ਦ9@ei|ҮF/J5XہZk)j\0;3&??4ޔqp;2xB@\nPg?G\"U.!jJu+6\r-Mjk\r(	.@M\\3l]6fRr#BM(\r2Ҩ`͊SL9\nNn`P4ǃm#4&`1lG\$2604idL\r\09crӮ_u4qkl1k4?iz+&6<-Kb~ ";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lN	PS-{M~+UtrLrɼ 4fq|iśs)A*Ni.)yLr߶ۈ`0\r@zf1ӌU>pQ\$b/ģ)wqW⩸h;̧#j)Np#!J'T9ȗ4cR\"2:n7<8@>R*Jl0bB0J`:B0H`&#x2!\nm )|\roB\r+xI`T9AJlŢ(*7R<MLh j\0h~0cK8@ PhC\$\$&3:xUAr43_pDJ@|̍\rH7^0{1>i2%P7c\nDC;p2KH[zܗ3hLp\\̘\nD,:1&#\0`w48.yP84\0P%C\r# 93fF:T6uhB0sT-mNZ9'ӟA\r3#~P	Ixmibyft6\r;fc.@(PȃCn݈0`vr\"}37.=MkC.#;]e-\" \\#am24C]h< #tdmʏO@Vc2t%x57(<=B6`\$o}	I\r7	WP90c?5/^4\rܿ¯>hH1\0ȝʜ3P*%HBU=fCp/?xxQ+)f<\"lQHs%OPoBE̴bЛS \$&UºS.쾘`\\ RuRúO0uY%h+CHmsHXKMQ	!>oi897?e,nz*(#!j:pa-ȣP6oԌs5Ͱ0@3\r\$}\nrbh48@r\$KDP	@\nH&Nnh^APpsBh*@ xw(\$T%ɽì 2:R⥕ʘC׆9:?EkClQ0F\\4,\$0H\0!sn,&,FBI CPɈ\\\$150yB<	\$L<bO1\rךb\nY>Ԏ@;*Θc\$\n>9Ti'I}i aO\naR' TJâ!Jp2<^BЙ 8*-@e \$œp&aCA~mDXIY q#édqל˃[c\rn#Fy#@HR=\$Lb<'	4iIcA1wtKfmvd|문eĸ0!xrF~\rx;-Rn\0PV>gt\"_(̈m2݊~j2x0HA<957*DsZn`]ah\$]D'qNmBRHAC,2uL/x#@Tιp2 A[&&bqNsp72~K8FS_\"Fİc%f3Jr>\r]95jZ8Tw\nP 0*?.:ɂ[\$`:fa\"ۘn\$l\rv:p!0rHhBm]d	Zs(+3w=J#{ݞ䂧Dt<^)o8Q8ᄻ87fpMCL޼/kL[okS>~YrxsPx!&`ma.:/q>:}g%KYODr*(\re5PT\$\\_\\)σD<AI=,|e/&5\$T/]l)+LLW4AAè6ъrή2ZW?d,[#|ߏo|7\\\n@4%nsFxn֐>ؐ7\0dBt\0\$f\0\n-tA(N^och?\$b<&oB\n~eG5-jk0f6RTu\$OЋnoX'Kh	btmæm\"F(\rmjͮ0 PbUp	6NBC\$\r.p0(pjpp\nk!\nc\r\rWN\rB捶fɫB0yQ7sD\$~g7Tbf*L\"	7*cd&::〕4k˖)E1zX`N#:Cg4nF\" C(bŮ\$:CH@܏OC֫	M\\CO, _ 1	CK'@tR% ɆP%4Y*O*\rc.\rHERQ- S/;&q&Q2\"|FxMGK	%)@g`g-r#ppc\rbf\r PW*R	\"+<}CЎz+B\n92c!!|p--/C0?I0ff(Amb\n3#LZ\n&#12 ʢi`1f\$o*KC4Ŷw!55Q/shgғl<*\r4G\"d=Sn* 5n<0(Ku/!c7^ɂx0x-2[&z@rcnqGn!i\rΦ>GSԜS43Gqs4%Yn%8#Ax\$,4&.-Cna0?Et-?0%@\rV3bp\"J^6Сc~\nZi.CQ#sOEnE.I\r=JkC\rKOC,#4\\V<~@m[GL9\$*5lb&-49F\"%\r&X?Q;mF0MB,FIN,T.ڼ<uQx4DKh4CL3#72I|JOG)1^e]B	&lDmL\rL4tpb'tpͣM\0M(B\r\npukCj@-WAoVcp1c\ruJ\"b7Dh ꑇ'<ʼ;VL쨠> 2-0/`m4#v@Kj";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZI*M1F4LrSuq\$H̖j-s(e9Bc9nB,΢Aev4s)@tNC	Ӡt4{C	kWZ}1\$羔+!(hJBTZ	CAjB\"	;)P`\r#pΒ6{Α\rj\$]2s\"4@P7\rn7(9\r㒄\"<h9 #x<C'8;#\"N);\$^ 2LĄƂZ\"Z h־\"-h\n,SNkrr\\-ed]NmC>dL<,mNH40hHIJsxDa̋{w\03x3!|Ba)rl\rrRY?V-sLS\0PvS# &:Rx(a\01nu\"R;;/C'.,C X90z\r8a^\\0W\$ x7+!xDlD#46H7x6lc\\V7i3IKNhFI\05Z٥55jΚ\n#ж\n7^J2 ;ꢦ%5^):[·\\vZ+Gh:x0gӚ#Q2nAĪi\$ [JD1]5	;SeKN)ux\$fhLњy%)\n3{[\n\n\"d.eK	XL`(#QZ2jeU^tZ\"4Xn y&ξ0B`l?c͂&-h\0ѹS1.`6؅TBE2uHC{N -\0 SL27e+rG\$0f\rԫ T\rM`yg@`o9pa	*ޗn0RZ'!B\n5dD@pɔ|b\r!rsbLQ14%Lã6dLj;-o,hDM|t\n\\	8`YXz[)K~ 4d̡KKL!LXbd;:.dEؿf,	!8äHQ\0 f%D}i[y)욪Ee4P=7RYsĞN1k*A]E` G@8#_G۠a(HFO!h~RIa1*@]\$c84Jh\"ADO#TΈP@@PmQMB6 c2ΔSvNenH9Czk\0;\"QijS\rߕHG0WG&'`;)PiFzH*[hBS\nA\\A0\"/ɯc`	l{UM9ąMqC)\rqT,j41o:K/EnRgO\0(\$r4\$҃w`qt'de\\9+=Jr*5\0!\n<)K\nֆKfDֆ_L,f0(*ӝqSݯ5\$)!a)b@)@\0 ;#KCst\r4qv r9*y`'enآB*2G\0U\n @D\"XQ_O1B\$X\0D0\"a}TX\"l-c,P	(+7[Qs	\$v1/(]c <>\nAN%,əM^*C\"i\r,iY6LݙGĵ&wOҠĜfYsg)*`h\$hAO׿\$6J]xb[4NzV*iSZ#x4\\\$ؘ	b,Rήĸ߲H֒mFp?\\/h:=+5o%h(~PS\r!z9&8SjZ(kB*}AVǕWSv-Ow,d4*zOP(DI\nbn&`JuoZ`(!ԐCaR|`׺r\r+~Zh>sHO	dplA@̦~n(;ڋ&v;˳{kաP 0T򤘍F]`ഃKG@~{vnj.To@^:no㄁BH*ld\"\nXlª`jH&`\\!7PDPH'iEB0!n:k\"rFݰKI.<Ʀ{6Cf0n(*)ĿNhJ0XmM.Bw.SI*o'0}Pcn6P=,m	GS0bpCN	Ā\$HԢ,.d*)C\nl֦dvV먦&Acn[O|ghHWAP+@\rx1wNiAn'o|1n,\nWE!e\nuJq0텄(\n<٤fſVAr\$Nч lc#\$*\0.\"Fk\"ԲT0b}\"dB81F5<2F[\$C\\d qd.e/	LH\0ं8ZO#)vdX.%#L.k*p.\n\"g\$R6q#FX''2JX%.hr@.E#.s!n-.LRʅFKN%.0//%N9/s.,q1#.#b33)W1>C,DkK8X_(3(i,!HO=m`[tjsk-мpAU8Y0g8D@	ӛ	>>\r-&7\"/\n#3S|m4\"<k50lπ?=S0'OhSB!-*֮fz.:6?̦d4b`3߇@ꅴot-+1''+\rCG0C'1Kr榆T\0=3<33H([N6/T@lkM>G!A{5q\\<J1Iw͎Bo	܏93s3LԦMS7O4kXrkkTyL.&\r91#.C@\$ELq*PEl8oJ0SD55O?K](*4!uݑOWQz/Od\$5jBaBtn[KB`vCjTK-6z2/TK\rduOtuNT8zQR]T\\4m.gA-z̋|4oØHde)\nOav tbcƯ\"'B\\d=T(6_I-\\e__hBgCY<%eI+SBM'rU#U3Vm>ULVEyY\\?Uu<8BYZZz!PxM=5nե8Boo%o!Z\"pd;)QƟnheqm\"1Ks2sbu	W;	n=tqi;pʲ\rV,ijϹZ7(G.UPq(@ X Z ^Yo-s=	!zA{09;1#{v(r.\"nf<EFLf	z /%EW~6 4`|Mf8wEwm`q̿b`31([s>`x%h}WG'2N~RI\$EP!H#DCX^BlFl~B!'8]\"15l[?d5ǷFq~?'(K{&u2t -ȅ}u>`h1\$A|'\n\r:'֤r\$\021CLE'L*w}si}Tړ2X,x+\$r\n8K\r&<ny;TbQks-yF\$";break;case"sv":$f="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6& (9'X(n3&#)brKl,~7@rBH)JN#Iڣn˦#	/+8J#HJNiЦphQNu&C9bWiGrYct\"uf@Fdwh':n2\rMJ'7(\"h+.c7\$/qH\n;*i&20\nb	xܪX0/:j\"5#K!#P	@;!o`2(H)ʵ\nh\\k6ϨCh	,B6i.P܎6Jz(<5V9wЬ ?Je\0xCC\\8a^H\\Os4zd;!xDmSz7^0Z6\rH\nHè:\0[c#h0<+K>\$!-y%L/w#xE--m6z;lVZXèk6\" ;r\r1aP2˰O\"<\0d(茔8:ѷ#9q^\"`Z5xpb7	n%4}1L` <j4ns+t{62b<bH8f<qj)v1ՙ	0B9Â5+SOJ/8(3Arh&MIM5a\0ڍ4>5D#*tXÒ[){6)%[EH/>Vgw^~-?Q\"@T^\n\n<=Xs\"KEԄ_ h9<\r.5*M)<tTT*YrVAE\"W\rlC^\r禚Ђ& :`*cbXDe*-LS*n.uB*U!Ux{CVmXł0QH\"e춘_\nq#AD5/)A)4i-,! #9*DR}8=\$!\$ZhԔ'-EidTsjH\n\0dG^?2`PSK N8IsQ\n*\\:@h)\r&98v@QRMynf%^'`&	,fLFC`UZC.\rEڪ&04\r( eX-@EȤMI9QpT2|Pqlڡje!88mDGA)r3\"J`Q-fBYV)A! d!3-)鸈d\0 -R@JM#RGwT@ADuJbFd()ZKe%!*vv\\;I`Fa\n\01kQHDT(\0BE\nA\$'{rO\nAP*_2cf/=SƘftR8uy2yA/'ƁRŜÙ-Ev[^	9K*Ԛan}}\0q˰3ĖtB\"њsU!\rئ&NJKKh1Sve\r`Jg\"'hMm.JzAO\\Au_k,\0F:B-з8rgG4vEϼϳ	~r\$F=T:,&*AIEARAoML\$]r!Nj=g(dS-/\0@3zM__;58޺2P%w_6ږws/ӷݩ\$\\ZwX*ѵܒw]vTG޻%Pp#YUhmC&RwSPuh<lΪV!vqYrV4NƓ9bG:M3}o6T]30ႭE\"/0rtzܟR}T4ឱ/jw\r%u0k.ݛ]Jh˨!@ϓۊuW/=&&#i^׍nр`|/BGN\"</zmu7?sm\"#[t}zg)wNu>M+/	ȳt?;߯&f}.-p,Z,폢/\"&p/H\"@ψ&*`^x\07 >Eҗ5z\"&\n} ظdh@;R>â!AJ?pP.,cl|n\0]\0c\0POBnżr\"MpNO>\r\"=&|B:#bL\neHlX@&t\r#6#LP\"f֯OO@#\rz% c@12Nc[0ר<cS4lP iD='FJ\"ae0%|EiE	Ch?_P(q\0%zyq,Bx`-3ή\\@%&1B6q 0m(#&b5-.=@Ӄ\nf!#!mH\$Q/\"ME#&g G\$=:@AL\"a%d\"%\"A m~/5'2`r(	3#ȨH1DV0\rPVRҰRn	dlb'j^2bvŧ'Rbzt]R(Rw.CE`ArpR@HjB0tF6ҹ` pb\r+bqё+m4	1ƃPh4cG\$uD-f0p:&flBt:iB1C1@ E :|1'Bk6R0tR](eƸ/#2&2w\n/\"kq;sѴ4zF>2[̢eJoLH(Lf'8P>(4x(GCl1C79C\0QiBQMQ=&=\rgap'0u(Z\"H*Bz>\\\r@";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&ܡ굥]W^j兪V\"eY\0B9-ֹJ~\r]nWJ{֭Ay.;^,΢Ae;\r#`3@:?j04\r000P&Ț̯	\"vQndTνɁ&𭫋|J5I*b%r[Ɏ\no7W\"S+hZ j*ʣ\nb5C7JB|\n@8PC>DݪM1*A\$7ꐬCBTH[\0ҏh9#xܣZU6N>qĨ%%iLWN+FL/q~)ՠr\0:hwgGrl,A\\')Z\ntKC4H;@+iRn3ʹ3wV6(6UCZP)#6ۍvZ*ʜ8Y,_-qhTA*ĈӼ%*ThH1;I .ЖK}M~KDf,r# -!CTPFQ\01p-i.nu\0001PO40&9`@q@2D49Ax^;r]>x7IRxDlKc46}K8Z\"ǩSjE:-\\\\R`8x^ʬ5ڔ֌Xt]<kFZw17Ĥ:Yanˢ\n9%A2`_,\0~^Z__yTzD=p3<GE\0iD\"9@Cb6PWT`*)naN#T  p;V̖\$hfs*\\0৖\r!kfFERq6}\$50UL}=#/#\$M;\\%6S\0l@Q\0CrX\n!0H(8b)D#bCafpCgL1J&).׮lE0LDVd@3y	#cJpK	OkIȌZ4o^A.D9-:[؝	J-z8OIQ̖AM\0~Rb\"&;WJ)*A\$XDR\n'1abMtBDB2p*u4/ʬ]ZV38,J`L  |O?3`}7Gyw<z\00ΖÛb0A]ˤ40SVd}D?ڑa8qj%~HC3Up@]\"yq\\rnU˹6\\tm>T-9rRxH^sjoa&BpJ6h;fCR\\<{viXSqЯlۮv1<\\qFչg0t6hÓun+7|읥	(FՇK b	\$C[QۉKu7i:A7U\"E%N#/keCAn;0&	1H&C5Quֹ5[A\0\0c844Jg	tY3+h%\n<.i\0PP	@byng.6<`3a+g5lb@,Q: d\">?\rH3w?J1SȌ}h#uqyw5 kwA7\n]{a0фHgs\0 C'ê+) RIRO|@cJՐ<w^ueL><J+loGuZ*DATiN]YF@Ŕ?V%';~Fu\"d\\\0Sn*9e^Keדtdk`U`.VWI'ɷZm0H^Bɇȁ\0fOaKfwe\rAM.!C\\\\ea \n<)N@ҥL!9v5<(ig3pړ\n%\$Z@HuQ;KtI͖eϞj<ܠ2CNQS:J&hV+1>\nf\"K~'N0O	*\0BE_(@/j%xrUÚتÿ́O/#э̢Ϻ	JdC֏jhNVL+l	dCJi jp&_J(fɹi:ώH\"Ra#vP>Ս:_B~UinHTFH`j`0q\0JFJ6 gc*\0kCivbιnH\0B\ndN)#c&5nZbDZ t\$O`Nķ|cb,F`0JZ\nG(r`\rJ&^HI'*.\r 4m\"i!2H/-@GphB\0\rȆ&\nm4¯˪h&@\0W*'7j0~I_ocѲ(	'\0&NTb`B&1[ ,g\0(lԱ\nJЬr`\$ rdJ\rqk\0Qq#&2f-ͼyo+Tx=ei@kh+,k!\$ց<vAJTh\"|j\"&h{e0 Kø\0 	\0@\r%N~n`dRC\"%b6i3%O(0pS q-l37Ǟ)hWrzq34r|}(~6M6 \\3O	'2(i\r\njsf36ESH_2nv7˹:Fk\\j)k)Ĕ8\r\rXґ	6{1P5569?p?9g=7	39BB\$@	`p@O`ĦiM\\:(ZMwR4Ŭ(F\0RS7s7;2G<SspCtͯJSEHfIy`4zMDŏ6\$,N.ňVlúC)\np\rP,s7S\0.%*	O-F-dJ%9ɨǒ hLs.~l\$4HBL]1BeUHuWS[@u_TqdlRAtCsUTSWI*\"5lYUnQY5XԑY\r38Xj<O[Ֆ\0*05<@hNYItz~/&`d\\d\nv#U\r;dbfUtmbUL,<s;o])]Z[:FKR\r@\npTnG^vzkic}UWY5dl@	fy7])jSBpYl-\\vZuY2kkӶ})P6ve4՟]pj.w]5LZ8Wq3u!Vqm-mw \\lb+TIa|5Z5g,_ns3]gGih_4&8+*cOkq[mO6!w3K[I _JJWu{T1ĥ~7]W5zuZE^6opWM@W2zr/WWJ8J?Msvkr%MpMYG]<K5cx1hja#wEPUP6\"PdM\",ؐRwagdG(T%g73\\q&1ԗ͂;]NSERK{6Dk\"~h\n\0͌y^kT2K'no~'ޥ7Us}#H\"ϊ}gؼ2<uj/'ܲi;WHzغ^|nW;~xI\$?8UR;E;1\\s,,:be>jSs.e,Q-ّ|1ߙS}9}͖W\"y~  QY!7ٛم_rYb;r_+S`P Xj'd/Et\$cp<gQWujKvٵV􀗘ݺKp6'Yӓuկv}a~UhLyC3c(-V]WQVSE5r\"u0OzOU::]V:WZygz!:͑Б7+ Sh@P56Qokv{0ɫ'ZSI)CUS9urrH\0>ـufb,1%x@̃\r;2M}W1&M%uy\r5@'5\n9t{]?6uקUk{͈ط;ױDX]Yy^%=Pݕ\rBH!,Kq*13T8f<xĎ.\"5u;e˽o~{ݧ	 u9 ćB%d-)¿YI?3ysX5N%9BZSBԴs{\0˚+uI˸|GP[REmZF1\"{:\\9/Kxoaŕ^Ǧz@Ǿ~rQ6}%@\\Х\rV`ӹq@̬+%٪\nZ\npKA~Ο8ӭWt)U]z|X%ү٪:\0H%=G5^zER%8D{j5X;\0ܙF[wJ:;S)ErʌMʹ{(¼	a&o'C`eD+a|oĐ;,Suż}a<b~[(]}QβA9gxG[1P<eګKrÞݩ9@\nh@>N5C^>WH7@/Ymo>إR!]_YyK،:M*GqKO&\0rh{; \rYǒP'vXe+@=q2G0%BDR,jq@P\nrVdYvߌT}R,闋)>G1C޿-f\0?8=;\nZG=Fe(՘X/3E*\0P\0&4@S";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MVh\\(-˄\0߰Mz1N	ΟP|ֺSt&x|k\$3w+y@4#\rx@8CH4(2a\004\r00Pkڶp\0@-pDDT>\nQp;,jCb2α>Ѕ\$3\$^Q\\k\"6-+Ȕ.	\\R(2z`P\0#pά9JV9+b槤*\\\n;\09Cx@0p7 :*8PԠFc2Do~ N͢p#\rR'L KCGD)1qUl'\r\rl( 8D}s.83<Fl>3|ĲlA4,ͱÁVͭswH;ƀ&i(}eKKY~Du\\j^\\\\F++q,ή\\b|aba~略e.6튳ܢ\nrzc63:ls(2\rMQJRÅ09R13ETd;0<9`@n@2D49Ax^;pðlT=3(c;O\r440\r#x|8k >:dgbr\r6.Ͷ.ϏUO޵u\\{Q<p\">?MN\\#L\n7ncB	1Eĸfj0'i!*欄Y~잫SNaǔlKjb6-=Β]'h@`aJ`eaNi[fșN'PcW_D\r)4z'nd.!F\r! ӾUVd >dzJ	xitZk+ȮlBHPCtN\"@L|\"pќ>cl\\>(\\_9ׄoT=P.% 22ZA1|,n(ʶs+\$-J	K8\n),z\n/>ߜ!!&i/<h\"!@ P7Ou>햛:?C@H7`#	y*#zPT\rنhf`o9`8a4\nz	`a\r\nh=i':#v|]EUr!@	[j\r~(7@i\\{rnU˹7Y\\rt@;DX\nmR.~+ꚩ	Q9m	nɝI2ӹX	1J\"4@MoqA9G,sA>]:C\r\r:X}?~L;0҃Qq(ce:V{T1llAW\0!֩ZV5.TƙЕa\0mi\$47JX!YD:zUlK3#ܺ\n (\0PbJEbCy䩕Rչ\$RA\0006Pm7|AgǦ|Mj?UiA\"݃n@^Dp.\0&-\r!PG%1ς04=e3%3U 9XKDt\$K֝fCasXE!Պ[LyyŅY&Ҫ]-\rNxZ\$YL>(>p@\"I(y?e*B.,8Ð2\r<C1QG,/4ыj&77D\\%ܪqp]ɽ\"e_=VC(hAtQ.dctЁbX!2e[#\n.mm% H 5\00043OF(y%&mQ_/!VP@PO	*\0BE=\"P{K%# @tm\r9Lı8] 5Loϴ%+s^,k%	aM27C:5Dum9u%fDGR=6z4Y4_5]YD|J|VX:VwY|}gkO.r?xʔأ)Bvip B+~-.fƣ%Zff \0\"Y|/Fjnnz@\r L\nKAʄ7\0c=#D0Pl4:^)8{ЏJdº&6L|ƔF%IP*c\"zȕ/TmfFΨJf`\rgg-\0+\$PV(HhBDlVC B>CU\nhǐi(úHm96 ɰh9Thvm\\0@\0 	\0@ܰlR*&̾NH6̐^\n\0@1L0Y TMgP1PW0d6b+\0byy@1cңo,BKiI\\\$Gm	o@PF8+g2G,~rAg%J!1GHO\$F6c>d/dQlnvi''\"'JZ\$mpE@eDY\r .F>f>';0&>6cÁ,Cu,BPafGB+erZZ\np%јG!-匌iRTgKg!\"%H}!&>}jDo_31b128f+i2f@Dig55\r2S6O7܄/dǊ兕,/(YvO@PZ@~+2(#VHWy!E:[Q;E7:\r;(LOM[T=;s	@.4(C\n	\n/.dҺ+/d3G7sc>P.tﯖ(%a6A%t=7\"mC	Ik2fFpT=6\nW3o4yG	GPaD/?sHgHQBS_G*\rU3,/Q*.s9-22oK_>1B#rdG<K;\rGdmG5\rtRѓ0JEOsxNV[THGHY3@дsY`?3Dh8\rB\"e9RU]>ocFҽRSyU¥T\"TdN4\r4\rc\rPyCES5#5q3TārN>gREEP}^5	BC_>re6t_;9)cO\rSc-a\\'E^l+M[g`5I8bSa[DCQe1ffTBw9<h+n)p'sc9X!XX@\nFlTK'ck+kdi^u:V\$6RkГcuc	\r̘v-evDPqvfv65,4\rpu18EK m)L00Pq}oDmֻJTnFv`U/_D7IlCe5QY	auWeuv\rIsm>LxtW}dum1Fc/tnRgy,8wn}&>2G)TDY\$^z2T\r#QDl@~d\"[~DC7(hli*Cvm+ゆc7owV\n47[d_npDq|Pf b_dAqgV#}fXE׹DPﷅg8~9XQ86XLV|<hx4 	\r?KqEaB.+0I(|H!kLļ搲S&RF_Ҙ|6f}s28t+1 !ReM8xKMm*m\r7cciw5La>V+\0ڬ(z\nZ	\0nr#M7~-6	B.\$(&>G4\\yBf	ߖ )\$%X@<R 	s}hMsALGsVmS\"S9Fr[L	ZqfC/ybMRUƃ7hi:녑\"7.;1[MQ@oqPj'&EjuGf89hA8OCteXzERet \"@~\r+ˢǕXud6(#+SuDt8emGC٠H/Y@5@6w69j}m]-zj8Nz0cCĀ|a\rP>&:=/iSe³\"VB{a8Əm  })i\rC7ud!%~&c]Xc_:1]h	\0t	@\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(u64taR(a1\r	!y=Ld )K0gL!\n!O1y7̷ 4ɔk|:tdv-Gj4	Aȁr0\rƞ>8\n)IHrH\"^+}\n*fy9Iiوş1(99(ȓ\0=.c|(IȹJ>Z.r\"蘠j:)@,c\n/\n>49-4B\n(ަ4q8pꧭ.ň(Fz\nx@ˤ\r\r++0CȀ7o0#D9p\":\rz\$9`@\"@2D49Ax^;Ձp9H\\zbҰDJ(|63\$4^0<+T#FLm&\"494ڼjOΧ6,ЋBJ2&̈w	r//\0x:Hӈ30FÝu)E8#9Z\rѠq4m,CCRSP#2!B`Ҁk\\It:ʐA6Gc|\n\"d;#`Pinqg\\B=b7rD4nA/m+!˹kRR6RLB׫I(|)u{`Sic8+7uj#A(39Cdd:',OJ=\$*|5~!0=.[v9aCUs0'!v~&ns4΀bI{|'ˡP_).o\$蝐#j\rQ,D5q6Jp)@\"U\nVu\\&V7f9WAQbY_HpGkd2ʸEnYK2\0=I:6@ꦃay\"phYk1T|8^w CKd2Y	!2TjSVU|AZwl5W ҘLR`dC`#qss^K#l'ϰ4֞Hё.uNC`g&~']=)[3qt^9\$+4D'\n@7!'\naHą:0՜\":@AE0US\nqPm*P1A7ӓgV4PTAȹ%F|#!#\0-̹a@G~nA\\uِcG3Bloi t\0!0j5::Hi(ʞbN/콷#sq* ̗dZ\rK60Q)\n 9y޶x3d/ilT\r7{iO\naP:lYTH\r25r<)3ABp,bN\$ݽ8/,)R]:ƶ\\3b\\DS\\3ztZ;%X~'CT6P[X(.'@BD!P\"԰v^:ɂ\0W4ԢhppE	`lTvcfQ%RC.`S!n`k;i:cfH/ipow7 x|f%5\"ZI%\n2\rZZ\r/2#sˡH?[p>\$,F/h:vJiyӑfL:>[mpeojbLz6\\4i\$`v4 1U e*4oap쓄Ka;`#q#Smd\0;[nncGC6un\"<oȠ(!pɷ\"sc~xhrkoJM1{S0/JK{\n!#8kp/+Bjt3ʻl^rZ<a~UMUӫhȨ1&P#c@O3`@np)踺Tsi1r=n^\0004᭰C\n`0AcQL?8zqga7z@)\$ԌBD%>#I)FpR)g\nR.xqeohӲGijn3yuչ+uyM[îH7ĸӓr3h'\\\$P:;^;v3U?k6ۄsǈILi`1\0X nybWd!L.l-\0001`#P0\n\\Lhkl*oq`/Պ:a\"D\0*fNLgo\$BF좰`ZKs܎Vm0vp|_	Hz\$Q, i(|aD8玪(~7nND.8s*뭺\" ;.mjl]0)\rh\n#ڣkXB)f/C@#~GnSQ T\$9(B⢢B9~LW(Djp<V9[̈́\n-|0!Qb\0l21|(\n<LLz GCjN8.\rE68d*Ye#I\$H!Pndr\$;щ.#dH6,<bWϤEc!u2c	`R-'\$O/RdrmҎ\\tn\$ݨJ>~E\0>\$;bNܠ?PPAr+NM,BmD'Nu-\rXO /brM\"0DQd@<.#v\$p01>H' r^IN4`N_j4	Xw5\$A6n`,K _c5T.&΀^Y렄f#l]\"4 c~Cczd\rVck2b.\nZ L╎:LŠ	5sk:sjGcJ;\$7%\$~,<D0V&T\$j	}Q蛧3'=m\"{.˴1`\$F't(c ZmBȘ66B\r8\nԊr1(EvMB#0Q(]TFL@ObK+S>iP3\0ވF:&Kzpx4E1lN1ff%PG.xC1fʴ~\"y/`Kޢ#O'/jHЬq&bc`";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rV(C+*(*|#ƣ\$a+Xhj=AJzX2¥Ih9}n;*4Q\ne-s%\\.Hhഹ*	  L6];	}tc\$|m~-7ip?K\0*K_)&M7	vAkh@) NVBfR9?JܶPR4OCK}5HtJ꣐dʖY\"%Ȗd*mAh*l(db7D+?0OSJ\\/;E(,b9kjķ\\TfNS4J2m|Ȳd\r>?TG&\$\n4%JL4M2\rF2d:4OlҍJi\\+6B4Q\"V^Ri!J@p h7ADLn^\$0_#coXdau&7;G΁\r3:x\r}ߡp9x79cn2H.|CKB\\4!^0ΊJXPL(EU\rぴ)z/cnfݧ&p:{8Ђ&,⃱\$E\\)fa(ɊIxr5{*9啟m)l̳}j%~K#DuwD:.(g2]Ͳ2=*+=4R46Al],Z16ke40޸:l!	^\$b|\"ϩ\n(%UtY.Ihy6m)	[Di#t	J0!ȅL&޸ZEE=p7JxGDR;E	4 Fqd@`\"Rg_])rF2J0e%LujL\"'DF BW,#D9*3 \$,<FvHo\r1e8d`tOHsdZ*%M	;nT#rZH5Hx. 1扂))貪G3m`\\aĦ9̾Xy1/c-r3MA/:\\lWdf94JLvUJԌo4N;!ƞ\$CIe%Gw4(qpZ(A\"hwZP0_:\$İ&ꗥ)2D3(eL3eN7g,I\$Cgb]I\0j`殡an\n\noOemM\\A:K&]i\"LnN7Px)etTIOec+i*,Ed,vRk/řӶl<6GզƁ!E(Zvk>:K%BtHp1TYP2{!,Ê{^I\$!\$fD)Eh:5We5=8)0T(tP-(V`Û򠊒J3?sPۙUV3PDr4srA@\$\0[-.C(pSp(jݑaQc6XKԣb\0l*p\\x,n\\5ʴza:yQ}נ-\"Z~XX61-\n5`-ݒ:]J)WyhSPݽ2;)]X) }krS#_\n9`Z7S䐑U(2&+x2Z)H9N l!@	٤d6Ϥqg-b0ˍ)\",ҞVw(qo:J1xxs]\\]^\0T}F#H\\1]uBl();_%<P6Jeu=xvd'בnD:f'xv\$b0T\n+=ߔ^6̂꫖jB(C.4̸A=4YLBd|`ۉxY#uR@DMG:Ebn#m&l3TXgzk&ʊ褃\\؋/^*˜-ޕ\0ˡl\\ĒrKނ),8إ4zXo,ZyX:eF`&>i3u3;ۻp>PݕL@YQ.\"\r3<cK<7\"*U~q̗^QxkFF%@#2JHo:D̸/Zd!D1(-b|^5h9RBJ<|\"9ah0<RB荨6|!K\0(`oOlx@b\$La]dS(\"+.<|@\r\0`# dJ \nP3(|%\\S07/Ŏ*YgZkw+>xDll\"c\n/2 4( hFv̈OtkdWȺ~\$V \n 	:jKŢLrIJH(Dl'0Ess1\rN>o\$eƞJI\$\$)&,e.1~nqK&}Pxt,?B1t9Bxso11a|wQ!;!q%!iE8QnBClF,%\$rX^H1&Bllqj?i&nTiNk1.W1Ϝ*O	'Rhx#J3bW\rdI%y\r,1RGa6J~/G8P\$*7R&,Σd&(BSRA/9)I1C,ua1-F4?/@41oq3P?'2#8HQ\"Tn6(4gO%RCFPy\n#ǘyz/\0,%/pXf-仓bcBS:8'T)0hs8s`1536.s#D .h[f/G3390Jk@oT2<	OK,@6sAA4,3A)\\=*ʎ)DQ0(E3Cm'AEF&i\0N[LIq>X*1NpETs1L\rlCO#tIp'I/I3q=JbH%Ht}KIIj) k#TD:#o#COY3h<TTLK2	5	yPCSeFtZ0<().#*fŐ#,DdSFTLkԎoҬ@LbB P\r2qHw9W\".t9PR2\"5x1XZoȅt8ƽ.BoЃ9f}JO0	pAPSP^09F\$3_,t_t>/;a7^F'+F52j5OwT49d+^u8EUuBd>Z*'|uANW+G %gQ/hi49`U5DЅ{(j\\ϕd6KOrkBkIl4hGQUPDzUʿ9\r+Iz։@֍j.?,Ֆ=bM6wo\rbu>6+;\ro\"lq7[n\"_W2t[jwu!rTYsUb\n\rf@g@@g`@\r\0y\n0wwׁx@%y7wwzwx \0	yEzwùuEPYvr~+#EV;vVCvvnSdlh4'}5O8OSKJi	f80vqP4vii.Kr,fS406n%tW()s\$yVqs1M85DlJcӈ6CtpyZHD\\&k߈o7~IsQLL88Q}Р@u*9*)i<Kk˒QJ}T'YWo	~7\0\nq 1S\"(G\"R9gm9TT<wpyR8d]H2oik@\n]%%17bG/Z3Vkn,m%\nY's\rS\r&c&DkѣC<ϙ.MonFM4zu4Yp1㡏IcNVL7aRC+43(_	Y7CAP;_]P˵ŧE܆@-~\\-ݵ\\CR w&*19R\n`@QټqZ݋?\0c6Q-=.K.6E\$1/NX7aݤ%Unr3;G8|T";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡLuD,3Vҏn9·\nTh\"\r20X\$_)ɯH\0A)|@q:g!+Ccz̸6:ڋK;.ܮ@FͽLS06kMʈ4kaT5x7Ip00c+778D28Bp 1#B\\jpL+@=W vOIvL:J8楩BalJ!j!pK/vH/@<;RNBl\rx4(\n|⽒1\$)ԶMEș'<蕠lqNbjV*zT\"PiĀcRC&! bl|XV\0PԴ\rQURiD}O2## +#7P1pjAЄ\$;(:@9Q X90z\r8a^\\0V\$x79xDl	=c46Ln|+P5\nk\$Th ƀaHk((jxUeeZ9+#j\"(ŏ#aLTJt&	YIHk`vd2;#`2X6!(JpTcv:'uhc[_laKS<eEzP<<l̑c\\ԓi\$XI4%H;Vy_\n*<Fk`:eLj\"!NƯb׊b690̛*b`]he2\r]e('~vmv}MZ5ZQKTږCQ)	;b!@ґlBE  @tIPT9APnZh%Ú9\r,\0ABA3eD)K\rP`@(L0@QI!Ojf8ۻE8_G4GO+4eՐn4*dַz3å|гir\\ȱWH ]kwW~ǐ\\݊vnbi1\\@iQP3SIOJ(_Hk╔R)**st.ػ^|/,L(@aaA	2NH4\$H2<䈒vW#%9	,>\rš cm0fVRZA:@1[t!\$B*JERb<]s60:g`.\n (G^}D('R27Àr\r'	z\"4B\\HDf+B9]8.ĈQ2q,0μh-riԔ\\v<eP4ZhIwUXtZUm­,	FdXhftc_}VNP\n	\\TDZ%Y\nIpI\"AHWnhvpPf@;:ɨYUdi	\$(^xS\n4bs1mr5fGm:'Sv%}\$]0Q(^\$]_n)TX#̑AyR).A|aM~~dHīF-6%I--/MbIz%!'x`TD薅PFzf!U`ܗbJ+%W63k#a۔_pLp\r/л`(\nLG.zai'	ɜ)8gׅM~Nؕ\"/p%\$(\n)=l?Y(lr)Gw(%biHka	|RҖJ&1D333-`\\uqnB{#㮘sUQ¶peˁx3(c	]vnBCX\n'x\\L&je0rlpH/PMBxXL&9Tg&ƢQA`@BHc+`w#pKjE^r4&9r,I26.rLɯI \"	YY|dŒ]7b=ʦ@w\$̃t׼c9AaȤħTSuz^\r)GMqmP[C~\nnW`LNY) uGr.8ȭG7o1Mz62גIFKA~R0#~[wC%a\"ǴzD\0-(+bl|JfvLhS:BR;>^2K6RO-ڀ@P)\0~B.FL# !b-@q6DUpj&e9ڭ!#c7ߢp,tpJ&D\0zm*Bi\0D{|\r|`H\r;\rF\$pK@X)cbho<\"ᐘ0,%-L9=,L;Þq%pI\n/R	xeGks	6@K#&JJ*4JGIn#q\ny{j\rfmБ\"ܖj 11QPTĘbѬlKGq qrxpң Ks!(!^C.	nP<&ZNvFj\\~VQR\r&!'Hp{43g((#N\$(r/&ڐ|p=#;v`Uq0˫&0%+r,2|cC,&k'/=\"FblpKT\"j0D ?PLK1%1D,@1ҡ&y+2L⦕2 lŊ{%.9DN2SX]\r+6-6o6G0tN'QHL|+#n N8R^f&SiS:KMuJױjP77<~<=++1 =fZ)s!ƏZ{g%EJ -\ntL8HMlA-X\$;K1b6R\nZKFT.Cц=F3q~~\0Wn\$- ET-\r2BPB(mr'30Q0LWÆN%ZlpwL\rn\\\rU;\0000\0ȑO>j\r'mQ\"|\$PqeeptFFDpP\"SP(.9_,.T)TbpL	?u)dD?m\"ro~pY;ƴ.}C\n\n	Nd~ER\$mllSRf,ZQK!4@\niR.\"f#ZW%w8Ln.Vڃf* ";break;case"zh":$f="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*eJ*ȅbre\\t(jһ*,_\$e\niU.W:tRdHt/1V,r/ӵcerVuڟxsΥ[9,e@k6de[iD(4*@S^t*qNtҔLZ\nIE{@ys\n#r\\Xs%IXa4)*rp.s22Y%LȔq>sKtF5\$D)zHCQ*re^K)f]r\\E	L!\$j@Zʲ++zJosͲ| h7]	H?l_rLv/F@4C(C@:tT3>x3(9J8|1B:j\$=0!\\\$seIJi0_!tg1<B6Q(\\\$4_]/%`reշ4[AZSLtId~KeE9TrPiDOY}@PG)\0^ZTjwq D%8sN]\"^9{ns]c\n;a&G)\\V]4\$ D#1C]\nnV<)\"fn(I⶗}Q''1Q-_;nSGAM33E1g rF|MtϺ|ۢ0.dW?PD7Q\nJD:Ijsҡt_΋+6MYHXbV/̣RC\$/(,~C\$Hj6W\"DLOE<ˌ=O+Ÿt	\"QbL:\nTTZV@t\r0}`,h`! tbOHN\"\"AZD`^	lFO[cNyW#%2 T@,*<TʡUuXVj[Psj`5\0Ch\"HE&XW1,\"r,E%H:Ha2+E b5U_[q6.HRNPVh\"F8c%kS\0P	A\$#peĢ4c75\"yT~,8o&|s^9Dx3&ImX}1\rʸ NBBq(5SWT&&TZ((ī-i0PN3&\"\0C\naH#N)&̵%h\"#/i\$V50CFX:e4	8'Hs\njJA@+\\p<؎j9QB0Q4o+d1pԫ\0£[ŋAONHU *!Y?l^tِIpԬ#@G'=O']%\\DK(Я ('@BD!P\"KL(L/MEa-\"<A/t:DMBchqЖ(Ƙ0.Qw<E\")24>7dJQ2fVٻ˸-&eG\$@&g]6DCOCS0^,ˌ\n:gas9nim@6Vbǉ⹆Du;jG<^C˵wNi^Q6lWPǘ YDڊn^+1Qn0Ck¡\rNW8ـ\"s\"2tZDغ ht1}5Nm.{mD!P̹p+#draP 09iFgLzOx`\rG-	nRZa9BV.ňrF(\" MD1CFfutj(_ngbꆪY^Em\$[U\\LȝTUYD\0PWwYb䇉F5\"B4Ô@AZͅ؅j+qjZDrsx)1-tt<x۸MiM?#7|Y\\Ùʅr܃Y6hDhuILXM>EpdLL!\\YˡFZQ8]y^Rbqv/X6+`AiDTXvyX叙3W}o/En/0APܞQk-i&B7⬥g~AS9WJ^FacIJ=ø&E.e4VԹT ^%?Pg\n6yNA+>#5Y쑒;اqݼ&4I!}WvXТ%\0BPu\0R0	Msm`-e^|Nd*Oo3\0*0Vol0hrTOmVG#Ra6ώNƈap0puwrPĮzк\0p	PNb̰\re6W@@@V@\r\0LO'vOl\r˨@1Lͬ͊?pia\rqCXĺDnG0\"惶\"|ѱ~0WL/h,3A>M5m7*-!\nz\\'J1`\rnrgAAgx\rp 5Gh:ۏiH. \np8!,LMZ\n9#b:N;^֪!(6\"!^#< C1,9`ddJT4'|\n(\\*s#zҹ	*r-\"5fLy(Nr[AtmҪFX.[ah V\n`چy,,%r=&\$*r;{+K I4˧4;L@a72)0?ǰ pG";break;case"zh-tw":$f="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%N@tЀBT)*zY\$Kfs%.\nW-s}5,r(}5`%s+Ndt.T/\rc1reSLqxHι^9H̎O*r9|z>5~.Bz:I⽹iS>R\$a^+~МVģ`G)^C eUT;)K>V-sp\nBABs\"9rRrZ.Ji*\\Gi.RdLGI,I.rY j0[GAn%\0J-g9f]^LL)pY	BpR0LiyJ\\=AB6#p9% DdUԳ*w!`x0@2D49Ax^;pG4\\7C8^2x0cdxDARd)SmQ!^0pt%PCWYBW!u2irV,_U;+DesV)\"E! @1#aJV/ωP]9FJ݋5ux]q&C9zr}M) D)8!v]!*sĔ'UFbs<8*\$ov^q\nLMPGg1\nbbEI''.uU2r_\"]/te%r9tt?EͱU}CL@q@sBO*WQDUEс	 :M1Pte\"MTe?p	'1*K(܇v4GB),Ya\$\nCմ)')(dD N\$6P!EqFM H\"ՊV\\z\nÄ+d, o\r:V\"@~XCtD	+t.VF\r!ē	\r6AR>PG3	>cႲV\\+x\0wXK,ukmcA9% \n'E#XX_tt\n&A\nP	cKBq([ChVDP#[CXA! um\"	M0(M>9`PCFHܓEh8jKNi}N8!h\0P	Aͧ7D\$O)Qj7)^LIm`R`9J6SHP>4B\"Dt\nM8BUP#3Ȕގr9\0U 1/G0GUz̶Q7Af\$\0F7cSf]ErLLh¹b _05\\V\\-_d	\0P\ni`@CO	iٝ0@OBmO#X(:DI\$sKX:D4@'0TǶA6Pc}yV[ޒfQIZr\0i`	\"u\n	ͯ6&ʜ)dm8\0KA}h)P4p \n@\"@U\"w!HHLpp)\r^[n兙c0f<gQv\\E`S2|&M2 l(=<ҼFvvݹ%G8BE<%\$6i\09)p\"\$D1XC7\"=N;^{H?(U2eJ6HDAuEVtiĠ6LH2F{0TTP_`2a,SES\r0-@L_*9.7<s Fj-.fVIsnx (!Xsӊ\"P@>\"\\Tێq՚8(E'>4Lr@/B]4'xضw):2~Kx\nmNkC	\$q64	QX+f\r.sWp@Z{F@/E׬\$\\PiMCFc(h#93G\0Aޢo5WY>CzcDlT	GⰓr9,X;N&76_g4|Β5´Q^1et@~E4\\Fmt2ϙ{ 6˰U.Z9a\"{0E1G-gvp;qޚ(KZAF`4Q؋ݽ?_}|.-=/E}'H\\/t%zb3F]\\A>#޹_Ǽo8x2n*hV\rGG`{r9(Fo,lj0+έ/-5c-'>\$:\"wXR%n3ɆfUOZL^0J6\nΣ#p>Cl&İo⨗{ PgLNң46+J\"*`8P\$Ppc,8n=rAs\rMc0Mr.:^hIx y~#*\nOذb*3hzgs%*'p|1V\\%,9T\$p^d=\\C:v._10ج_l1_љӭ>\rebZ.\0@\0]Qq{'1\rQ`Ԇ5Oa2/ \r\r\nR!-[ _S\"r)Iġr!!CB.G\$2P4Z\r<0ņ)ǣdvD\rD\0ƌ\0+0`n>!H^F0~bL#k)N'z@1\0NF!z|\0;r<#ۂ~7nJij\$B\nZB\$u*	6#<^RK,ҋ:Mrx0/ʅg^3D΋<3Tqn0:l,r%lR/@@6o=P*@Ɣi\\/Da2+fETΜ.pHIH\n`ڋSV w:OZ`\r_.6g7szD)@78g#?&\$b\\*v #";break;}$ui=array();foreach(explode("\n",lzw_decompress($f))as$X)$ui[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ui;}if(!$ui){$ui=get_translations($ca);$_SESSION["translations"]=$ui;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$fg=array_search("SQL",$b->operators);if($fg!==false)unset($b->operators[$fg]);}function
dsn($tc,$V,$F,$D=array()){$D[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$D[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($tc,$V,$F,$D);}catch(Exception$Mc){auth_error(h($Mc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($P){return$this->pdo->quote($P);}function
query($G,$Ci=false){$H=$this->pdo->query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(22);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$n];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$oc=array();function
add_driver($Kd,$C){global$oc;$oc[$Kd]=$C;}function
get_driver($Kd){global$oc;return$oc[$Kd];}class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($Q,$L,$Z,$wd,$Bf=array(),$z=1,$E=0,$ng=false){global$b,$x;$de=(count($wd)<count($L));$G=$b->selectQueryBuild($L,$Z,$wd,$Bf,$z,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$z!=""&&$wd&&$de&&$x=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($wd&&$de?"\nGROUP BY ".implode(", ",$wd):"").($Bf?"\nORDER BY ".implode(", ",$Bf):""),($z!=""?+$z:null),($E?$z*$E:0),"\n");$Eh=microtime(true);$I=$this->_conn->query($G);if($ng)echo$b->selectQuery($G,$Eh,!$I);return$I;}function
delete($Q,$wg,$z=0){$G="FROM ".table($Q);return
queries("DELETE".($z?limit1($Q,$G,$wg):" $G$wg"));}function
update($Q,$N,$wg,$z=0,$gh="\n"){$Vi=array();foreach($N
as$y=>$X)$Vi[]="$y = $X";$G=table($Q)." SET$gh".implode(",$gh",$Vi);return
queries("UPDATE".($z?limit1($Q,$G,$wg,$gh):" $G$wg"));}function
insert($Q,$N){return
queries("INSERT INTO ".table($Q).($N?" (".implode(", ",array_keys($N)).")\nVALUES (".implode(", ",$N).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$K,$lg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$fi){}function
convertSearch($u,$X,$n){return$u;}function
convertOperator($xf){return$xf;}function
value($X,$n){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($Wg){return
q($Wg);}function
warnings(){return'';}function
tableHelp($C){}function
hasCStyleEscapes(){return
false;}}$oc["sqlite"]="SQLite 3";$oc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($p){$this->_link=new
SQLite3($p);$Yi=$this->_link->version();$this->server_info=$Yi["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($P){return(is_utf8($P)?"'".$this->_link->escapeString($P)."'":"x'".reset(unpack('H*',$P))."'");}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J?$J[$n]:false;}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->_offset++;$T=$this->_result->columnType($d);return(object)array("name"=>$this->_result->columnName($d),"type"=>$T,"charsetnr"=>($T==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($p){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($p);}function
query($G,$Ci=false){$Te=($Ci?"unbufferedQuery":"query");$H=@$this->_link->$Te($G,SQLITE_BOTH,$m);$this->error="";if(!$H){$this->error=$m;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($P){return"'".sqlite_escape_string($P)."'";}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$y=>$X)$I[idf_unescape($y)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$C=$this->_result->fieldName($this->_offset++);$ag='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($ag\\.)?$ag\$~",$C,$B)){$Q=($B[3]!=""?$B[3]:idf_unescape($B[2]));$C=($B[5]!=""?$B[5]:idf_unescape($B[4]));}return(object)array("name"=>$C,"orgname"=>$C,"orgtable"=>$Q,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($p){$this->dsn(DRIVER.":$p","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a")){parent::__construct($p);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$lg){$Vi=array();foreach($K
as$N)$Vi[]="(".implode(", ",$N).")";return
queries("REPLACE INTO ".table($Q)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$Vi));}function
tableHelp($C){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(23);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$z,$lf=0,$gh=" "){return" $G$Z".($z!==null?$gh."LIMIT $z".($lf?" OFFSET $lf":""):"");}function
limit1($Q,$G,$Z,$gh="\n"){global$g;return(preg_match('~^INTO~',$G)||$g->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$gh):" $G WHERE rowid = (SELECT rowid FROM ".table($Q).$Z.$gh."LIMIT 1)");}function
db_collation($k,$qb){global$g;return$g->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($C=""){global$g;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){$J["Rows"]=$g->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($C!=""?$I[$C]:$I);}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){global$g;return!$g->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($Q){global$g;$I=array();$lg="";foreach(get_rows("PRAGMA table_info(".table($Q).")")as$J){$C=$J["name"];$T=strtolower($J["type"]);$bc=$J["dflt_value"];$I[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$T)?"integer":(preg_match('~char|clob|text~i',$T)?"text":(preg_match('~blob~i',$T)?"blob":(preg_match('~real|floa|doub~i',$T)?"real":"numeric")))),"full_type"=>$T,"default"=>(preg_match("~^'(.*)'$~",$bc,$B)?str_replace("''","'",$B[1]):($bc=="NULL"?null:$bc)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($lg!="")$I[$lg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$T))$I[$C]["auto_increment"]=true;$lg=$C;}}$zh=$g->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$zh,$Fe,PREG_SET_ORDER);foreach($Fe
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));if($I[$C])$I[$C]["collation"]=trim($B[3],"'");}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$zh=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$zh,$B)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$B[1],$Fe,PREG_SET_ORDER);foreach($Fe
as$B){$I[""]["columns"][]=idf_unescape($B[2]).$B[4];$I[""]["descs"][]=(preg_match('~DESC~i',$B[5])?'1':null);}}if(!$I){foreach(fields($Q)as$C=>$n){if($n["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$Ch=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($Q),$h);foreach(get_rows("PRAGMA index_list(".table($Q).")",$h)as$J){$C=$J["name"];$v=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$v["lengths"]=array();$v["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$h)as$Vg){$v["columns"][]=$Vg["name"];$v["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($Q),'~').' \((.*)\)$~i',$Ch[$C],$Fg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Fg[2],$Fe);foreach($Fe[2]as$y=>$X){if($X)$v["descs"][$y]='1';}}if(!$I[""]||$v["type"]!="UNIQUE"||$v["columns"]!=$I[""]["columns"]||$v["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$C))$I[$C]=$v;}return$I;}function
foreign_keys($Q){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($Q).")")as$J){$q=&$I[$J["id"]];if(!$q)$q=$J;$q["source"][]=$J["from"];$q["target"][]=$J["to"];}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$g->result("SELECT sql FROM sqlite_master WHERE name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){global$g;return
h($g->error);}function
check_sqlite_name($C){global$g;$Vc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Vc)\$~",$C)){$g->error=lang(24,str_replace("|",", ",$Vc));return
false;}return
true;}function
create_database($k,$pb){global$g;if(file_exists($k)){$g->error=lang(25);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Min_SQLite($k);}catch(Exception$Mc){$g->error=$Mc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){global$g;$g->__construct(":memory:");foreach($j
as$k){if(!@unlink($k)){$g->error=lang(25);return
false;}}return
true;}function
rename_database($C,$pb){global$g;if(!check_sqlite_name($C))return
false;$g->__construct(":memory:");$g->error=lang(25);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){global$g;$Oi=($Q==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Oi=true;break;}}$c=array();$Kf=array();foreach($o
as$n){if($n[1]){$c[]=($Oi?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$Kf[$n[0]]=$n[1][0];}}if(!$Oi){foreach($c
as$X){if(!queries("ALTER TABLE ".table($Q)." $X"))return
false;}if($Q!=$C&&!queries("ALTER TABLE ".table($Q)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($Q,$C,$c,$Kf,$ld,$La))return
false;if($La){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $La WHERE name = ".q($C));if(!$g->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($C).", $La)");queries("COMMIT");}return
true;}function
recreate_table($Q,$C,$o,$Kf,$ld,$La=0,$w=array()){global$g;if($Q!=""){if(!$o){foreach(fields($Q)as$y=>$n){if($w)$n["auto_increment"]=0;$o[]=process_field($n,$n);$Kf[$y]=idf_escape($y);}}$mg=false;foreach($o
as$n){if($n[6])$mg=true;}$rc=array();foreach($w
as$y=>$X){if($X[2]=="DROP"){$rc[$X[1]]=true;unset($w[$y]);}}foreach(indexes($Q)as$je=>$v){$e=array();foreach($v["columns"]as$y=>$d){if(!$Kf[$d])continue
2;$e[]=$Kf[$d].($v["descs"][$y]?" DESC":"");}if(!$rc[$je]){if($v["type"]!="PRIMARY"||!$mg)$w[]=array($v["type"],$je,$e);}}foreach($w
as$y=>$X){if($X[0]=="PRIMARY"){unset($w[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($Q)as$je=>$q){foreach($q["source"]as$y=>$d){if(!$Kf[$d])continue
2;$q["source"][$y]=idf_unescape($Kf[$d]);}if(!isset($ld[" $je"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}foreach($o
as$y=>$n)$o[$y]="  ".implode($n);$o=array_merge($o,array_filter($ld));$Zh=($Q==$C?"adminer_$C":$C);if(!queries("CREATE TABLE ".table($Zh)." (\n".implode(",\n",$o)."\n)"))return
false;if($Q!=""){if($Kf&&!queries("INSERT INTO ".table($Zh)." (".implode(", ",$Kf).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Kf)))." FROM ".table($Q)))return
false;$_i=array();foreach(triggers($Q)as$yi=>$gi){$xi=trigger($yi);$_i[]="CREATE TRIGGER ".idf_escape($yi)." ".implode(" ",$gi)." ON ".table($C)."\n$xi[Statement]";}$La=$La?0:$g->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($Q));if(!queries("DROP TABLE ".table($Q))||($Q==$C&&!queries("ALTER TABLE ".table($Zh)." RENAME TO ".table($C)))||!alter_indexes($C,$w))return
false;if($La)queries("UPDATE sqlite_sequence SET seq = $La WHERE name = ".q($C));foreach($_i
as$xi){if(!queries($xi))return
false;}queries("COMMIT");}return
true;}function
index_sql($Q,$T,$C,$e){return"CREATE $T ".($T!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($Q."_"))." ON ".table($Q)." $e";}function
alter_indexes($Q,$c){foreach($c
as$lg){if($lg[0]=="PRIMARY")return
recreate_table($Q,$Q,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($Q,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($S){return
apply_queries("DELETE FROM",$S);}function
drop_views($aj){return
apply_queries("DROP VIEW",$aj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
move_tables($S,$aj,$Xh){return
false;}function
trigger($C){global$g;if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$u='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$zi=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$u\\s*(".implode("|",$zi["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($u))?\\s+ON\\s*$u\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$g->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$B);$kf=$B[3];return
array("Timing"=>strtoupper($B[1]),"Event"=>strtoupper($B[2]).($kf?" OF":""),"Of"=>idf_unescape($kf),"Trigger"=>$C,"Statement"=>$B[4],);}function
triggers($Q){$I=array();$zi=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$zi["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$B);$I[$J["name"]]=array($B[1],$B[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ROWID()");}function
explain($g,$G){return$g->query("EXPLAIN QUERY PLAN $G");}function
found_rows($R,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Zg){return
true;}function
create_sql($Q,$La,$Ih){global$g;$I=$g->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($Q));foreach(indexes($Q)as$C=>$v){if($C=='')continue;$I.=";\n\n".index_sql($Q,$v['type'],$C,"(".implode(", ",array_map('idf_escape',$v['columns'])).")");}return$I;}function
truncate_sql($Q){return"DELETE FROM ".table($Q);}function
use_sql($Vb){}function
trigger_sql($Q){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q)));}function
show_variables(){global$g;$I=array();foreach(get_rows("PRAGMA pragma_list")as$J)$I[$J["name"]]=$g->result("PRAGMA $J[name]");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$_f){list($y,$X)=explode("=",$_f,2);$I[$y]=$X;}return$I;}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Zc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Zc);}function
driver_config(){$U=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);return
array('possible_drivers'=>array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite"),'jush'=>"sqlite",'types'=>$U,'structured_types'=>array_keys($U),'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("hex","length","lower","round","unixepoch","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",)),);}}$oc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($Hc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){global$b;$k=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$Dh=$b->connectSsl();if(isset($Dh["mode"]))$this->_string.=" sslmode='".$Dh["mode"]."'";$this->_link=@pg_connect("$this->_string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$k!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$Yi=pg_version($this->_link);$this->server_info=$Yi["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($P){return
pg_escape_literal($this->_link,$P);}function
value($X,$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
quoteBinary($P){return"'".pg_escape_bytea($this->_link,$P)."'";}function
select_db($Vb){global$b;if($Vb==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($Vb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$Ci=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$n);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$d);$I->name=pg_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$d);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($M,$V,$F){global$b;$k=$b->database();$tc="pgsql:host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$Dh=$b->connectSsl();if(isset($Dh["mode"]))$tc.=" sslmode='".$Dh["mode"]."'";$this->dsn($tc,$V,$F);return
true;}function
select_db($Vb){global$b;return($b->database()==$Vb);}function
quoteBinary($Wg){return
q($Wg);}function
query($G,$Ci=false){$I=parent::query($G,$Ci);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$lg){global$g;foreach($K
as$N){$Ki=array();$Z=array();foreach($N
as$y=>$X){$Ki[]="$y = $X";if(isset($lg[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Ki)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
slowQuery($G,$fi){$this->_conn->query("SET statement_timeout = ".(1000*$fi));$this->_conn->timeout=1000*$fi;return$G;}function
convertSearch($u,$X,$n){$ci="char|text";if(strpos($X["op"],"LIKE")===false)$ci.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$ci~",$n["type"])?$u:"CAST($u AS text)");}function
quoteBinary($Wg){return$this->_conn->quoteBinary($Wg);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($C){$_e=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$_=$_e[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$C).".html";}function
hasCStyleEscapes(){static$Ya;if($Ya===null)$Ya=($this->_conn->result("SHOW standard_conforming_strings")=="off");return$Ya;}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Hh;$g=new
Min_DB;$Ob=$b->credentials();if($g->connect($Ob[0],$Ob[1],$Ob[2])){if(min_version(9,0,$g)){$g->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$g)){$Hh[lang(26)][]="json";$U["json"]=4294967295;if(min_version(9.4,0,$g)){$Hh[lang(26)][]="jsonb";$U["jsonb"]=4294967295;}}}return$g;}return$g->error;}function
get_databases(){return
get_vals("SELECT d.datname FROM pg_database d JOIN pg_roles r ON d.datdba = r.oid
WHERE d.datallowconn = TRUE AND has_database_privilege(d.datname, 'CONNECT') AND pg_has_role(r.rolname, 'USAGE')
ORDER BY d.datname");}function
limit($G,$Z,$z,$lf=0,$gh=" "){return" $G$Z".($z!==null?$gh."LIMIT $z".($lf?" OFFSET $lf":""):"");}function
limit1($Q,$G,$Z,$gh="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$gh):" $G".(is_view(table_status1($Q))?$Z:$gh."WHERE ctid = (SELECT ctid FROM ".table($Q).$Z.$gh."LIMIT 1)"));}function
db_collation($k,$qb){global$g;return$g->result("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($j){return
array();}function
table_status($C=""){$I=array();foreach(get_rows("SELECT
	c.relname AS \"Name\",
	CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	c.reltuples as \"Rows\",
	n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($C!=""?$I[$C]:$I);}function
is_view($R){return
in_array($R["Engine"],array("view","materialized view"));}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Ca=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(min_version(10)?", a.attidentity":"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($Q)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$B);list(,$T,$xe,$J["length"],$xa,$Fa)=$B;$J["length"].=$Fa;$fb=$T.$xa;if(isset($Ca[$fb])){$J["type"]=$Ca[$fb];$J["full_type"]=$J["type"].$xe.$Fa;}else{$J["type"]=$T;$J["full_type"]=$J["type"].$xe.$xa.$Fa;}if(in_array($J['attidentity'],array('a','d')))$J['default']='GENERATED '.($J['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['attidentity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$J["default"],$B))$J["default"]=($B[1]=="NULL"?null:idf_unescape($B[1]).$B[2]);$I[$J["field"]]=$J;}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Qh=$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($Q));$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Qh AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Qh AND ci.oid = i.indexrelid",$h)as$J){$Gg=$J["relname"];$I[$Gg]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Gg]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Sd)$I[$Gg]["columns"][]=$e[$Sd];$I[$Gg]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Td)$I[$Gg]["descs"][]=($Td&1?'1':null);$I[$Gg]["lengths"]=array();}return$I;}function
foreign_keys($Q){global$tf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($Q)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$B)){$J['source']=array_map('idf_unescape',array_map('trim',explode(',',$B[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$B[2],$Ee)){$J['ns']=idf_unescape($Ee[2]);$J['table']=idf_unescape($Ee[4]);}$J['target']=array_map('idf_unescape',array_map('trim',explode(',',$B[3])));$J['on_delete']=(preg_match("~ON DELETE ($tf)~",$B[4],$Ee)?$Ee[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($tf)~",$B[4],$Ee)?$Ee[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
view($C){global$g;return
array("select"=>trim($g->result("SELECT pg_get_viewdef(".$g->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($C)).")")));}function
collations(){return
array();}function
information_schema($k){return($k=="information_schema");}function
error(){global$g;$I=h($g->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$B))$I=$B[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($B[3]).'})(.*)~','\1<b>\2</b>',$B[2]).$B[4];return
nl_br($I);}function
create_database($k,$pb){return
queries("CREATE DATABASE ".idf_escape($k).($pb?" ENCODING ".idf_escape($pb):""));}function
drop_databases($j){global$g;$g->close();return
apply_queries("DROP DATABASE",$j,'idf_escape');}function
rename_database($C,$pb){global$g;$g->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return"";}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){$c=array();$vg=array();if($Q!=""&&$Q!=$C)$vg[]="ALTER TABLE ".table($Q)." RENAME TO ".table($C);$hh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c[]="DROP $d";else{$Ui=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($Q!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($Q!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$vg[]="ALTER TABLE ".table($C)." RENAME $d TO $X[0]";$c[]="ALTER $d TYPE$X[1]";$ih=$Q."_".idf_unescape($X[0])."_seq";$c[]="ALTER $d ".($X[3]?"SET$X[3]":(isset($X[6])?"SET DEFAULT nextval(".q($ih).")":"DROP DEFAULT"));if(isset($X[6]))$hh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($ih)." OWNED BY ".idf_escape($Q).".$X[0]";$c[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Ui!="")$vg[]="COMMENT ON COLUMN ".table($C).".$X[0] IS ".($Ui!=""?substr($Ui,9):"''");}}$c=array_merge($c,$ld);if($Q=="")array_unshift($vg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($vg,"ALTER TABLE ".table($Q)."\n".implode(",\n",$c));if($hh)array_unshift($vg,$hh);if($wb!==null)$vg[]="COMMENT ON TABLE ".table($C)." IS ".q($wb);if($La!=""){}foreach($vg
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($Q,$c){$i=array();$pc=array();$vg=array();foreach($c
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$pc[]=idf_escape($X[1]);else$vg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($i)array_unshift($vg,"ALTER TABLE ".table($Q).implode(",",$i));if($pc)array_unshift($vg,"DROP INDEX ".implode(", ",$pc));foreach($vg
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($S){return
queries("TRUNCATE ".implode(", ",array_map('table',$S)));return
true;}function
drop_views($aj){return
drop_tables($aj);}function
drop_tables($S){foreach($S
as$Q){$O=table_status($Q);if(!queries("DROP ".strtoupper($O["Engine"])." ".table($Q)))return
false;}return
true;}function
move_tables($S,$aj,$Xh){foreach(array_merge($S,$aj)as$Q){$O=table_status($Q);if(!queries("ALTER ".strtoupper($O["Engine"])." ".table($Q)." SET SCHEMA ".idf_escape($Xh)))return
false;}return
true;}function
trigger($C,$Q){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q)." AND trigger_name = ".q($C);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$J)$e[]=$J["event_object_column"];$I=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$J){if($e&&$J["Event"]=="UPDATE")$J["Event"].=" OF";$J["Of"]=implode(", ",$e);if($I)$J["Event"].=" OR $I[Event]";$I=$J;}return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q))as$J){$xi=trigger($J["trigger_name"],$Q);$I[$xi["Trigger"]]=array($xi["Timing"],$xi["Event"]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$T){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$J){$I=array();foreach($J["fields"]as$n)$I[]=$n["type"];return
idf_escape($C)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($g,$G){return$g->query("EXPLAIN $G");}function
found_rows($R,$Z){global$g;if(preg_match("~ rows=([0-9]+)~",$g->result("EXPLAIN SELECT * FROM ".idf_escape($R["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Fg))return$Fg[1];return
false;}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$g;return$g->result("SELECT current_schema()");}function
set_schema($Yg,$h=null){global$g,$U,$Hh;if(!$h)$h=$g;$I=$h->query("SET search_path TO ".idf_escape($Yg));foreach(types()as$y=>$T){if(!isset($U[$T])){$U[$T]=$y;$Hh[lang(9)][]=$T;}}return$I;}function
foreign_keys_sql($Q){$I="";$O=table_status($Q);$id=foreign_keys($Q);ksort($id);foreach($id
as$hd=>$gd)$I.="ALTER TABLE ONLY ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." ADD CONSTRAINT ".idf_escape($hd)." $gd[definition] ".($gd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($Q,$La,$Ih){$Og=array();$jh=array();$O=table_status($Q);if(is_view($O)){$Zi=view($Q);return
rtrim("CREATE VIEW ".idf_escape($Q)." AS $Zi[select]",";");}$o=fields($Q);$w=indexes($Q);ksort($w);if(!$O||empty($o))return
false;$I="CREATE TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." (\n    ";foreach($o
as$n){$Tf=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['attnotnull']?" NOT NULL":"");$Og[]=$Tf;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$Fe)){$ih=$Fe[1];$yh=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($ih)):"SELECT * FROM $ih"));$jh[]=($Ih=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $ih;\n":"")."CREATE SEQUENCE $ih INCREMENT $yh[increment_by] MINVALUE $yh[min_value] MAXVALUE $yh[max_value]".($La&&$yh['last_value']?" START ".($yh["last_value"]+1):"")." CACHE $yh[cache_value];";}}if(!empty($jh))$I=implode("\n\n",$jh)."\n\n$I";foreach($w
as$Qd=>$v){switch($v['type']){case'UNIQUE':$Og[]="CONSTRAINT ".idf_escape($Qd)." UNIQUE (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;case'PRIMARY':$Og[]="CONSTRAINT ".idf_escape($Qd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;}}$Eb=get_key_vals("SELECT conname, ".(min_version(8)?"pg_get_constraintdef(pg_constraint.oid)":"CONCAT('CHECK ', consrc)")."
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($Q)."
ORDER BY connamespace, conname");foreach($Eb
as$Bb=>$Db)$Og[]="CONSTRAINT ".idf_escape($Bb)." $Db";$I.=implode(",\n    ",$Og)."\n) WITH (oids = ".($O['Oid']?'true':'false').");";foreach($w
as$Qd=>$v){if($v['type']=='INDEX'){$e=array();foreach($v['columns']as$y=>$X)$e[]=idf_escape($X).($v['descs'][$y]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($Qd)." ON ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." USING btree (".implode(', ',$e).");";}}if($O['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." IS ".q($O['Comment']).";";foreach($o
as$bd=>$n){if($n['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($O['nspname']).".".idf_escape($O['Name']).".".idf_escape($bd)." IS ".q($n['comment']).";";}return
rtrim($I,';');}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
trigger_sql($Q){$O=table_status($Q);$I="";foreach(triggers($Q)as$wi=>$vi){$xi=trigger($wi,$O['Name']);$I.="\nCREATE TRIGGER ".idf_escape($xi['Trigger'])." $xi[Timing] $xi[Event] ON ".idf_escape($O["nspname"]).".".idf_escape($O['Name'])." $xi[Type] $xi[Statement];;\n";}return$I;}function
use_sql($Vb){return"\connect ".idf_escape($Vb);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Zc){return
preg_match('~^(check|database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Zc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$g;return$g->result("SHOW max_connections");}function
driver_config(){$U=array();$Hh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(26)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$y=>$X){$U+=$X;$Hh[$y]=array_keys($X);}return
array('possible_drivers'=>array("PgSQL","PDO_PgSQL"),'jush'=>"pgsql",'types'=>$U,'structured_types'=>$Hh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("char_length","lower","round","to_hex","to_timestamp","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",)),);}}$oc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;var$_current_db;function
_error($Hc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){$this->_link=@oci_new_connect($V,$F,$M,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$m=oci_error();$this->error=$m["message"];return
false;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Vb){$this->_current_db=$Vb;return
true;}function
query($G,$Ci=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$m=oci_error($this->_link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);oci_free_statement($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$n);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'OCI-Lob'))$J[$y]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$d);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";var$_current_db;function
connect($M,$V,$F){$this->dsn("oci:dbname=//$M;charset=AL32UTF8",$V,$F);return
true;}function
select_db($Vb){$this->_current_db=$Vb;return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}function
insertUpdate($Q,$K,$lg){global$g;foreach($K
as$N){$Ki=array();$Z=array();foreach($N
as$y=>$X){$Ki[]="$y = $X";if(isset($lg[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Ki)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Ob=$b->credentials();if($g->connect($Ob[0],$Ob[1],$Ob[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($G,$Z,$z,$lf=0,$gh=" "){return($lf?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($z+$lf).") WHERE rnum > $lf":($z!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($z+$lf):" $G$Z"));}function
limit1($Q,$G,$Z,$gh="\n"){return" $G$Z";}function
db_collation($k,$qb){global$g;return$g->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT USER FROM DUAL");}function
get_current_db(){global$g;$k=$g->_current_db?$g->_current_db:DB;unset($g->_current_db);return$k;}function
where_owner($jg,$Nf="owner"){if(!$_GET["ns"])return'';return"$jg$Nf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$Nf=where_owner('');return"(SELECT $e FROM all_views WHERE ".($Nf?$Nf:"rownum < 0").")";}function
tables_list(){$Zi=views_table("view_name");$Nf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Nf
UNION SELECT view_name, 'view' FROM $Zi
ORDER BY 1");}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=$g->result("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$I;}function
table_status($C=""){$I=array();$ah=q($C);$k=get_current_db();$Zi=views_table("view_name");$Nf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$Nf.($C!=""?" AND table_name = $ah":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Zi".($C!=""?" WHERE view_name = $ah":"")."
ORDER BY 1")as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Nf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($Q)."$Nf ORDER BY column_id")as$J){$T=$J["DATA_TYPE"];$xe="$J[DATA_PRECISION],$J[DATA_SCALE]";if($xe==",")$xe=$J["CHAR_COL_DECL_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$T.($xe?"($xe)":""),"type"=>strtolower($T),"length"=>$xe,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($Q,$h=null){$I=array();$Nf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($Q)."$Nf
ORDER BY ac.constraint_type, aic.column_position",$h)as$J){$Qd=$J["INDEX_NAME"];$tb=$J["DATA_DEFAULT"];$tb=($tb?trim($tb,'"'):$J["COLUMN_NAME"]);$I[$Qd]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Qd]["columns"][]=$tb;$I[$Qd]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Qd]["descs"][]=($J["DESCEND"]&&$J["DESCEND"]=="DESC"?'1':null);}return$I;}function
view($C){$Zi=views_table("view_name, text");$K=get_rows('SELECT text "select" FROM '.$Zi.' WHERE view_name = '.q($C));return
reset($K);}function
collations(){return
array();}function
information_schema($k){return
false;}function
error(){global$g;return
h($g->error);}function
explain($g,$G){$g->query("EXPLAIN PLAN FOR $G");return$g->query("SELECT * FROM plan_table");}function
found_rows($R,$Z){}function
auto_increment(){return"";}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){$c=$pc=array();$Hf=($Q?fields($Q):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($Q)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$Gf=$Hf[$n[0]];if($X&&$Gf){$nf=process_field($Gf,$Gf);if($X[2]==$nf[2])$X[2]="";}if($X)$c[]=($Q!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($Q!=""?")":"");else$pc[]=idf_escape($n[0]);}if($Q=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($Q)."\n".implode("\n",$c)))&&(!$pc||queries("ALTER TABLE ".table($Q)." DROP (".implode(", ",$pc).")"))&&($Q==$C||queries("ALTER TABLE ".table($Q)." RENAME TO ".table($C)));}function
alter_indexes($Q,$c){$pc=array();$vg=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($vg,"ALTER TABLE ".table($Q).$i);}elseif($X[2]=="DROP")$pc[]=idf_escape($X[1]);else$vg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($pc)array_unshift($vg,"DROP INDEX ".implode(", ",$pc));foreach($vg
as$G){if(!queries($G))return
false;}return
true;}function
foreign_keys($Q){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($Q);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($aj){return
apply_queries("DROP VIEW",$aj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
last_id(){return
0;}function
schemas(){$I=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($I?$I:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){global$g;return$g->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Zg,$h=null){global$g;if(!$h)$h=$g;return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Zg));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Zc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Zc);}function
driver_config(){$U=array();$Hh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(26)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$y=>$X){$U+=$X;$Hh[$y]=array_keys($X);}return
array('possible_drivers'=>array("OCI8","PDO_OCI"),'jush'=>"oracle",'types'=>$U,'structured_types'=>$Hh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("length","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",)),);}}$oc["mssql"]="MS SQL";if(isset($_GET["mssql"])){define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error.="$m[message]\n";}$this->error=rtrim($this->error);}function
connect($M,$V,$F){global$b;$Cb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$Dh=$b->connectSsl();if(isset($Dh["Encrypt"]))$Cb["Encrypt"]=$Dh["Encrypt"];if(isset($Dh["TrustServerCertificate"]))$Cb["TrustServerCertificate"]=$Dh["TrustServerCertificate"];$k=$b->database();if($k!="")$Cb["Database"]=$k;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$M),$Cb);if($this->_link){$Ud=sqlsrv_server_info($this->_link);$this->server_info=$Ud['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($P){$Di=strlen($P)!=strlen(utf8_decode($P));return($Di?"N":"")."'".str_replace("'","''",$P)."'";}function
select_db($Vb){return$this->query("USE ".idf_escape($Vb));}function
query($G,$Ci=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'DateTime'))$J[$y]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$n=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$n["Name"];$I->orgname=$n["Name"];$I->type=($n["Type"]==1?254:0);return$I;}function
seek($lf){for($t=0;$t<$lf;$t++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($M,$V,$F){$this->_link=@mssql_connect($M,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($P){$Di=strlen($P)!=strlen(utf8_decode($P));return($Di?"N":"")."'".str_replace("'","''",$P)."'";}function
select_db($Vb){return
mssql_select_db($Vb);}function
query($G,$Ci=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$n);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($lf){mssql_data_seek($this->_result,$lf);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($M,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F);return
true;}function
select_db($Vb){return$this->query("USE ".idf_escape($Vb));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$lg){foreach($K
as$N){$Ki=array();$Z=array();foreach($N
as$y=>$X){$Ki[]="$y = $X";if(isset($lg[idf_unescape($y)]))$Z[]="$y = $X";}if(!queries("MERGE ".table($Q)." USING (VALUES(".implode(", ",$N).")) AS source (c".implode(", c",range(1,count($N))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Ki)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($u){return"[".str_replace("]","]]",$u)."]";}function
table($u){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Ob=$b->credentials();if($Ob[0]=="")$Ob[0]="localhost:1433";if($g->connect($Ob[0],$Ob[1],$Ob[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$z,$lf=0,$gh=" "){return($z!==null?" TOP (".($z+$lf).")":"")." $G$Z";}function
limit1($Q,$G,$Z,$gh="\n"){return
limit($G,$Z,1,0,$gh);}function
db_collation($k,$qb){global$g;return$g->result("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){global$g;$I=array();foreach($j
as$k){$g->select_db($k);$I[$k]=$g->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($C=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="VIEW";}function
fk_support($R){return
true;}function
fields($Q){$yb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($Q).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default], d.name default_constraint
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($Q))as$J){$T=$J["type"];$xe=(preg_match("~char|binary~",$T)?$J["max_length"]/($T[0]=='n'?2:1):($T=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$T.($xe?"($xe)":""),"type"=>$T,"length"=>$xe,"default"=>(preg_match("~^\('(.*)'\)$~",$J["default"],$B)?str_replace("''","'",$B[1]):$J["default"]),"default_constraint"=>$J["default_constraint"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$yb[$J["name"]],);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($Q),$h)as$J){$C=$J["name"];$I[$C]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$C]["lengths"]=array();$I[$C]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$C]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$g->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$pb)$I[preg_replace('~_.*~','',$pb)][]=$pb;return$I;}function
information_schema($k){return
false;}function
error(){global$g;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$g->error)));}function
create_database($k,$pb){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$pb)?" COLLATE $pb":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$j)));}function
rename_database($C,$pb){if(preg_match('~^[a-z0-9_]+$~i',$pb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $pb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){$c=array();$yb=array();$Hf=fields($Q);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$yb[$n[0]]=$X[5];unset($X[5]);if($n[0]=="")$c["ADD"][]="\n  ".implode("",$X).($Q==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$bc=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($Q).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";$Gf=$Hf[$n[0]];if(default_value($Gf)!=$bc){if($Gf["default"]!==null)$c["DROP"][]=" ".idf_escape($Gf["default_constraint"]);if($bc)$c["ADD"][]="\n $bc FOR $d";}}}}if($Q=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$c["ADD"])."\n)");if($Q!=$C)queries("EXEC sp_rename ".q(table($Q)).", ".q($C));if($ld)$c[""]=$ld;foreach($c
as$y=>$X){if(!queries("ALTER TABLE ".table($C)." $y".implode(",",$X)))return
false;}foreach($yb
as$y=>$X){$wb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$wb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($y));}return
true;}function
alter_indexes($Q,$c){$v=array();$pc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$pc[]=idf_escape($X[1]);else$v[]=idf_escape($X[1])." ON ".table($Q);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q):"ALTER TABLE ".table($Q)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$v||queries("DROP INDEX ".implode(", ",$v)))&&(!$pc||queries("ALTER TABLE ".table($Q)." DROP ".implode(", ",$pc)));}function
last_id(){global$g;return$g->result("SELECT SCOPE_IDENTITY()");}function
explain($g,$G){$g->query("SET SHOWPLAN_ALL ON");$I=$g->query($G);$g->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($R,$Z){}function
foreign_keys($Q){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($Q).", @fktable_owner = ".q(get_schema()))as$J){$q=&$I[$J["FK_NAME"]];$q["db"]=$J["PKTABLE_QUALIFIER"];$q["table"]=$J["PKTABLE_NAME"];$q["source"][]=$J["FKCOLUMN_NAME"];$q["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($aj){return
queries("DROP VIEW ".implode(", ",array_map('table',$aj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$aj,$Xh){return
apply_queries("ALTER SCHEMA ".idf_escape($Xh)." TRANSFER",array_merge($S,$aj));}function
trigger($C){if($C=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($Q))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$g;if($_GET["ns"]!="")return$_GET["ns"];return$g->result("SELECT SCHEMA_NAME()");}function
set_schema($Yg){return
true;}function
use_sql($Vb){return"USE ".idf_escape($Vb);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Zc){return
preg_match('~^(check|comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Zc);}function
driver_config(){$U=array();$Hh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(26)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$y=>$X){$U+=$X;$Hh[$y]=array_keys($X);}return
array('possible_drivers'=>array("SQLSRV","MSSQL","PDO_DBLIB"),'jush'=>"mssql",'types'=>$U,'structured_types'=>$Hh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("len","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",)),);}}$oc["mongo"]="MongoDB (alpha)";if(isset($_GET["mongo"])){define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Li,$D){try{$this->_link=new
MongoClient($Li,$D);if($D["password"]!=""){$D["password"]="";try{new
MongoClient($Li,$D);$this->error=lang(23);}catch(Exception$vc){}}}catch(Exception$vc){$this->error=$vc->getMessage();}}function
query($G){return
false;}function
select_db($Vb){try{$this->_db=$this->_link->selectDB($Vb);return
true;}catch(Exception$Mc){$this->error=$Mc->getMessage();return
false;}}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ge){$J=array();foreach($ge
as$y=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoId')?"ObjectId(\"$X\")":(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?"$X":(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$ke=array_keys($this->_rows[0]);$C=$ke[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$lg="_id";function
select($Q,$L,$Z,$wd,$Bf=array(),$z=1,$E=0,$ng=false){$L=($L==array("*")?array():array_fill_keys($L,true));$vh=array();foreach($Bf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Kb);$vh[$X]=($Kb?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($Q)->find(array(),$L)->sort($vh)->limit($z!=""?+$z:0)->skip($E*$z));}function
insert($Q,$N){try{$I=$this->_conn->_db->selectCollection($Q)->insert($N);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$N['_id'];return!$I['err'];}catch(Exception$Mc){$this->_conn->error=$Mc->getMessage();return
false;}}}function
get_databases($jd){global$g;$I=array();$Zb=$g->_link->listDBs();foreach($Zb['databases']as$k)$I[]=$k['name'];return$I;}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=count($g->_link->selectDB($k)->getCollectionNames(true));return$I;}function
tables_list(){global$g;return
array_fill_keys($g->_db->getCollectionNames(true),'table');}function
drop_databases($j){global$g;foreach($j
as$k){$Kg=$g->_link->selectDB($k)->drop();if(!$Kg['ok'])return
false;}return
true;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->_db->selectCollection($Q)->getIndexInfo()as$v){$hc=array();foreach($v["key"]as$d=>$T)$hc[]=($T==-1?'1':null);$I[$v["name"]]=array("type"=>($v["name"]=="_id_"?"PRIMARY":($v["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($v["key"]),"lengths"=>array(),"descs"=>$hc,);}return$I;}function
fields($Q){return
fields_from_edit();}function
found_rows($R,$Z){global$g;return$g->_db->selectCollection($_GET["select"])->count($Z);}$yf=array("=");}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$affected_rows,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Li,$D){$kb='MongoDB\Driver\Manager';$this->_link=new$kb($Li,$D);$this->executeCommand($D["db"],array('ping'=>1));}function
executeCommand($k,$ub){$kb='MongoDB\Driver\Command';try{return$this->_link->executeCommand($k,new$kb($ub));}catch(Exception$vc){$this->error=$vc->getMessage();return
array();}}function
executeBulkWrite($af,$Xa,$Lb){try{$Ng=$this->_link->executeBulkWrite($af,$Xa);$this->affected_rows=$Ng->$Lb();return
true;}catch(Exception$vc){$this->error=$vc->getMessage();return
false;}}function
query($G){return
false;}function
select_db($Vb){$this->_db_name=$Vb;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ge){$J=array();foreach($ge
as$y=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$ke=array_keys($this->_rows[0]);$C=$ke[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$lg="_id";function
select($Q,$L,$Z,$wd,$Bf=array(),$z=1,$E=0,$ng=false){global$g;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$vh=array();foreach($Bf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Kb);$vh[$X]=($Kb?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$z=$_GET['limit'];$z=min(200,max(1,(int)$z));$sh=$E*$z;$kb='MongoDB\Driver\Query';try{return
new
Min_Result($g->_link->executeQuery("$g->_db_name.$Q",new$kb($Z,array('projection'=>$L,'limit'=>$z,'skip'=>$sh,'sort'=>$vh))));}catch(Exception$vc){$g->error=$vc->getMessage();return
false;}}function
update($Q,$N,$wg,$z=0,$gh="\n"){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($wg);$kb='MongoDB\Driver\BulkWrite';$Xa=new$kb(array());if(isset($N['_id']))unset($N['_id']);$Hg=array();foreach($N
as$y=>$Y){if($Y=='NULL'){$Hg[$y]=1;unset($N[$y]);}}$Ki=array('$set'=>$N);if(count($Hg))$Ki['$unset']=$Hg;$Xa->update($Z,$Ki,array('upsert'=>false));return$g->executeBulkWrite("$k.$Q",$Xa,'getModifiedCount');}function
delete($Q,$wg,$z=0){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($wg);$kb='MongoDB\Driver\BulkWrite';$Xa=new$kb(array());$Xa->delete($Z,array('limit'=>$z));return$g->executeBulkWrite("$k.$Q",$Xa,'getDeletedCount');}function
insert($Q,$N){global$g;$k=$g->_db_name;$kb='MongoDB\Driver\BulkWrite';$Xa=new$kb(array());if($N['_id']=='')unset($N['_id']);$Xa->insert($N);return$g->executeBulkWrite("$k.$Q",$Xa,'getInsertedCount');}}function
get_databases($jd){global$g;$I=array();foreach($g->executeCommand($g->_db_name,array('listDatabases'=>1))as$Zb){foreach($Zb->databases
as$k)$I[]=$k->name;}return$I;}function
count_tables($j){$I=array();return$I;}function
tables_list(){global$g;$rb=array();foreach($g->executeCommand($g->_db_name,array('listCollections'=>1))as$H)$rb[$H->name]='table';return$rb;}function
drop_databases($j){return
false;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->executeCommand($g->_db_name,array('listIndexes'=>$Q))as$v){$hc=array();$e=array();foreach(get_object_vars($v->key)as$d=>$T){$hc[]=($T==-1?'1':null);$e[]=$d;}$I[$v->name]=array("type"=>($v->name=="_id_"?"PRIMARY":(isset($v->unique)?"UNIQUE":"INDEX")),"columns"=>$e,"lengths"=>array(),"descs"=>$hc,);}return$I;}function
fields($Q){global$l;$o=fields_from_edit();if(!$o){$H=$l->select($Q,array("*"),null,null,array(),10);if($H){while($J=$H->fetch_assoc()){foreach($J
as$y=>$X){$J[$y]=null;$o[$y]=array("field"=>$y,"type"=>"string","null"=>($y!=$l->primary),"auto_increment"=>($y==$l->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}}return$o;}function
found_rows($R,$Z){global$g;$Z=where_to_query($Z);$ni=$g->executeCommand($g->_db_name,array('count'=>$R['Name'],'query'=>$Z))->toArray();return$ni[0]->n;}function
sql_query_where_parser($wg){$wg=preg_replace('~^\s*WHERE\s*~',"",$wg);while($wg[0]=="(")$wg=preg_replace('~^\((.*)\)$~',"$1",$wg);$kj=explode(' AND ',$wg);$lj=explode(') OR (',$wg);$Z=array();foreach($kj
as$ij)$Z[]=trim($ij);if(count($lj)==1)$lj=array();elseif(count($lj)>1)$Z=array();return
where_to_query($Z,$lj);}function
where_to_query($gj=array(),$hj=array()){global$b;$Tb=array();foreach(array('and'=>$gj,'or'=>$hj)as$T=>$Z){if(is_array($Z)){foreach($Z
as$Sc){list($nb,$wf,$X)=explode(" ",$Sc,3);if($nb=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$B)){list(,$kb,$X)=$B;$X=new$kb($X);}if(!in_array($wf,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$wf,$B)){$X=(float)$X;$wf=$B[1];}elseif(preg_match('~^\(date\)(.+)~',$wf,$B)){$Wb=new
DateTime($X);$kb='MongoDB\BSON\UTCDatetime';$X=new$kb($Wb->getTimestamp()*1000);$wf=$B[1];}switch($wf){case'=':$wf='$eq';break;case'!=':$wf='$ne';break;case'>':$wf='$gt';break;case'<':$wf='$lt';break;case'>=':$wf='$gte';break;case'<=':$wf='$lte';break;case'regex':$wf='$regex';break;default:continue
2;}if($T=='and')$Tb['$and'][]=array($nb=>array($wf=>$X));elseif($T=='or')$Tb['$or'][]=array($nb=>array($wf=>$X));}}}return$Tb;}$yf=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}function
table($u){return$u;}function
idf_escape($u){return$u;}function
table_status($C="",$Yc=false){$I=array();foreach(tables_list()as$Q=>$T){$I[$Q]=array("Name"=>$Q);if($C==$Q)return$I[$Q];}return$I;}function
create_database($k,$pb){return
true;}function
last_id(){global$g;return$g->last_id;}function
error(){global$g;return
h($g->error);}function
collations(){return
array();}function
logged_user(){global$b;$Ob=$b->credentials();return$Ob[1];}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();if($M=="")$M="localhost:27017";$D=array();if($V.$F!=""){$D["username"]=$V;$D["password"]=$F;}$k=$b->database();if($k!="")$D["db"]=$k;if(($Ka=getenv("MONGO_AUTH_SOURCE")))$D["authSource"]=$Ka;$g->connect("mongodb://$M",$D);if($g->error)return$g->error;return$g;}function
alter_indexes($Q,$c){global$g;foreach($c
as$X){list($T,$C,$N)=$X;if($N=="DROP")$I=$g->_db->command(array("deleteIndexes"=>$Q,"index"=>$C));else{$e=array();foreach($N
as$d){$d=preg_replace('~ DESC$~','',$d,1,$Kb);$e[$d]=($Kb?-1:1);}$I=$g->_db->selectCollection($Q)->ensureIndex($e,array("unique"=>($T=="UNIQUE"),"name"=>$C,));}if($I['errmsg']){$g->error=$I['errmsg'];return
false;}}return
true;}function
support($Zc){return
preg_match("~database|indexes|descidx~",$Zc);}function
db_collation($k,$qb){}function
information_schema(){}function
is_view($R){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
foreign_keys($Q){return
array();}function
fk_support($R){}function
engines(){return
array();}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){global$g;if($Q==""){$g->_db->createCollection($C);return
true;}}function
drop_tables($S){global$g;foreach($S
as$Q){$Kg=$g->_db->selectCollection($Q)->drop();if(!$Kg['ok'])return
false;}return
true;}function
truncate_tables($S){global$g;foreach($S
as$Q){$Kg=$g->_db->selectCollection($Q)->remove();if(!$Kg['ok'])return
false;}return
true;}function
driver_config(){global$yf;return
array('possible_drivers'=>array("mongo","mongodb"),'jush'=>"mongo",'operators'=>$yf,'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),);}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($M){return
h($M);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$p="adminer.css";if(file_exists($p))$I[]="$p?v=".crc32(file_get_contents($p));return$I;}function
loginForm(){global$oc;echo"<table class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",$oc,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($C,$Fd,$Y){return$Fd.$Y;}function
login($Ae,$F){if($F=="")return
lang(39,target_blank());return
true;}function
tableName($Oh){return
h($Oh["Name"]);}function
fieldName($n,$Bf=0){return'<span title="'.h($n["full_type"]).'">'.h($n["field"]).'</span>';}function
selectLinks($Oh,$N=""){global$x,$l;echo'<p class="links">';$_e=array("select"=>lang(40));if(support("table")||support("indexes"))$_e["table"]=lang(41);if(support("table")){if(is_view($Oh))$_e["view"]=lang(42);else$_e["create"]=lang(43);}if($N!==null)$_e["edit"]=lang(44);$C=$Oh["Name"];foreach($_e
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($C).($y=="edit"?$N:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array($x=>$l->tableHelp($C)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$Nh){return
array();}function
backwardKeysPrint($Oa,$J){}function
selectQuery($G,$Eh,$Xc=false){global$x,$l;$I="</p>\n";if(!$Xc&&($dj=$l->warnings())){$Kd="warnings";$I=", <a href='#$Kd'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$Kd');","")."$I<div id='$Kd' class='hidden'>\n$dj</div>\n";}return"<p><code class='jush-$x'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".format_time($Eh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($G)."'>".lang(11)."</a>":"").$I;}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($K,$md){return$K;}function
selectLink($X,$n){}function
selectVal($X,$_,$n,$Jf){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$I="<i>".lang(46,strlen($Jf))."</i>";if(preg_match('~json~',$n["type"]))$I="<code class='jush-js'>$I</code>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$I</a>":$I);}function
editVal($X,$n){return$X;}function
tableStructurePrint($o){global$Hh;echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";foreach($o
as$n){echo"<tr><th>".h($n["field"]);$T=h($n["full_type"]);echo"<td><span title='".h($n["collation"])."'>".(in_array($T,(array)$Hh[lang(9)])?"<a href='".h(ME.'type='.urlencode($T))."'>$T</a>":$T)."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(50)."</i>":""),(isset($n["default"])?" <span title='".lang(51)."'>[<b>".h($n["default"])."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($w){echo"<table>\n";foreach($w
as$C=>$v){ksort($v["columns"]);$ng=array();foreach($v["columns"]as$y=>$X)$ng[]="<i>".h($X)."</i>".($v["lengths"][$y]?"(".$v["lengths"][$y].")":"").($v["descs"][$y]?" DESC":"");echo"<tr title='".h($C)."'><th>$v[type]<td>".implode(", ",$ng)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$e){global$sd,$zd;print_fieldset("select",lang(52),$L);$t=0;$L[""]=array();foreach($L
as$y=>$X){$X=$_GET["columns"][$y];$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($sd||$zd?"<select name='columns[$t][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(53)=>$sd,lang(54)=>$zd)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$w){print_fieldset("search",lang(55),$Z);foreach($w
as$t=>$v){if($v["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$v["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}}$bb="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$t][op]",$this->operators,$X["op"],$bb),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $bb }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Bf,$e,$w){print_fieldset("sort",lang(57),$Bf);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(58))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(59)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($di){if($di!==null){echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($di)."'>","</div></fieldset>\n";}}function
selectActionPrint($w){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($w
as$v){$Sb=reset($v["columns"]);if($v["type"]!="FULLTEXT"&&$Sb)$e[$Sb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($Ac,$e){}function
selectColumnsProcess($e,$w){global$sd,$zd;$L=array();$wd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$sd)||in_array($X["fun"],$zd)))){$L[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$zd))$wd[]=$L[$y];}}return
array($L,$wd);}function
selectSearchProcess($o,$w){global$g,$l;$I=array();foreach($w
as$t=>$v){if($v["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$v["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$jg="";$zb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Od=process_length($X["val"]);$zb.=" ".($Od!=""?$Od:"(NULL)");}elseif($X["op"]=="SQL")$zb=" $X[val]";elseif($X["op"]=="LIKE %%")$zb=" LIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$zb=" ILIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$jg="$X[op](".q($X["val"]).", ";$zb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$zb.=" ".$this->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$jg.$l->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$zb;else{$sb=array();foreach($o
as$C=>$n){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$sb[]=$jg.$l->convertSearch(idf_escape($C),$X,$n).$zb;}$I[]=($sb?"(".implode(" OR ",$sb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($o,$w){$I=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$md){return
false;}function
selectQueryBuild($L,$Z,$wd,$Bf,$z,$E){return"";}function
messageQuery($G,$ei,$Xc=false){global$x,$l;restart_session();$Gd=&get_session("queries");if(!$Gd[$_GET["db"]])$Gd[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Gd[$_GET["db"]][]=array($G,time(),$ei);$Ah="sql-".count($Gd[$_GET["db"]]);$I="<a href='#$Ah' class='toggle'>".lang(63)."</a>\n";if(!$Xc&&($dj=$l->warnings())){$Kd="warnings-".count($Gd[$_GET["db"]]);$I="<a href='#$Kd' class='toggle'>".lang(45)."</a>, $I<div id='$Kd' class='hidden'>\n$dj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$Ah' class='hidden'><pre><code class='jush-$x'>".shorten_utf8($G,1000)."</code></pre>".($ei?" <span class='time'>($ei)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Gd[$_GET["db"]])-1)).'">'.lang(11).'</a>':'').'</div>';}function
editRowPrint($Q,$o,$J,$Ki){}function
editFunctions($n){global$wc;$I=($n["null"]?"NULL/":"");$Ki=isset($_GET["select"])||where($_GET);foreach($wc
as$y=>$sd){if(!$y||(!isset($_GET["call"])&&$Ki)){foreach($sd
as$ag=>$X){if(!$ag||preg_match("~$ag~",$n["type"]))$I.="/$X";}}if($y&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$I.="/SQL";}if($n["auto_increment"]&&!$Ki)$I=lang(50);return
explode("/",$I);}function
editInput($Q,$n,$Ia,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ia value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$Ia value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$Ia,$n,$Y,$Y===0?0:null);return"";}function
editHint($Q,$n,$Y){return"";}function
processInput($n,$Y,$s=""){if($s=="SQL")return$Y;$C=$n["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$I="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$I=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$I=idf_escape($C)." $s $I";elseif(preg_match('~^[+-] interval$~',$s))$I=idf_escape($C)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$I="$s(".idf_escape($C).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$I="$s($I)";return
unconvert_field($n,$I);}function
dumpOutput(){$I=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($Q,$Ih,$fe=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Ih)dump_csv(array_keys(fields($Q)));}else{if($fe==2){$o=array();foreach(fields($Q)as$C=>$n)$o[]=idf_escape($C)." $n[full_type]";$i="CREATE TABLE ".table($Q)." (".implode(", ",$o).")";}else$i=create_sql($Q,$_POST["auto_increment"],$Ih);set_utf8mb4($i);if($Ih&&$i){if($Ih=="DROP+CREATE"||$fe==1)echo"DROP ".($fe==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($fe==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($Q,$Ih,$G){global$g,$x;if($Ih){$He=($x=="sqlite"?0:1048576);$o=array();if($_POST["format"]=="sql"){if($Ih=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$o=fields($Q);}$H=$g->query($G,1);if($H){$Yd="";$Wa="";$ke=array();$td=array();$Kh="";$ad=($Q!=''?'fetch_assoc':'fetch_row');while($J=$H->$ad()){if(!$ke){$Vi=array();foreach($J
as$X){$n=$H->fetch_field();if($o[$n->name]['generated']){$td[$n->name]=true;continue;}$ke[]=$n->name;$y=idf_escape($n->name);$Vi[]="$y = VALUES($y)";}$Kh=($Ih=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Vi):"").";\n";}if($_POST["format"]!="sql"){if($Ih=="table"){dump_csv($ke);$Ih="INSERT";}dump_csv($J);}else{if(!$Yd)$Yd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$ke)).") VALUES";foreach($J
as$y=>$X){if($td[$y]){unset($J[$y]);continue;}$n=$o[$y];$J[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Wg=($He?"\n":" ")."(".implode(",\t",$J).")";if(!$Wa)$Wa=$Yd.$Wg;elseif(strlen($Wa)+4+strlen($Wg)+strlen($Kh)<$He)$Wa.=",$Wg";else{echo$Wa.$Kh;$Wa=$Yd.$Wg;}}}if($Wa)echo$Wa.$Kh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Ld){return
friendly_url($Ld!=""?$Ld:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Ld,$We=false){$Mf=$_POST["output"];$Tc=(preg_match('~sql~',$_POST["format"])?"sql":($We?"tar":"csv"));header("Content-Type: ".($Mf=="gz"?"application/x-gzip":($Tc=="tar"?"application/x-tar":($Tc=="sql"||$Mf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Mf=="gz")ob_start('ob_gzencode',1e6);return$Tc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($Ve){global$ia,$x,$oc,$g;echo'<h1>
',$this->name(),'<span class="version">
',$ia,' <a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($ia,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</span>
</h1>
';switch_lang();if($Ve=="auth"){$Mf="";foreach((array)$_SESSION["pwds"]as$Xi=>$lh){foreach($lh
as$M=>$Si){foreach($Si
as$V=>$F){if($F!==null){$Zb=$_SESSION["db"][$Xi][$M][$V];foreach(($Zb?array_keys($Zb):array(""))as$k)$Mf.="<li><a href='".h(auth_url($Xi,$M,$V,$k))."'>($oc[$Xi]) ".h($V.($M!=""?"@".$this->serverName($M):"").($k!=""?" - $k":""))."</a>\n";}}}}if($Mf)echo"<ul id='logins'>\n$Mf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$Ve&&DB!=""){$g->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.17.1");if(support("sql")){echo'<script',nonce(),'>
';if($S){$_e=array();foreach($S
as$Q=>$T)$_e[]=preg_quote($Q,'/');echo"var jushLinks = { $x: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$_e).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$x;\n";}$kh=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$kh):""),'\'',(preg_match('~MariaDB~',$kh)?", true":""),');
</script>
';}$this->databasesPrint($Ve);$wa=array();if(DB==""||!$Ve){if(support("sql")){$wa[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$wa[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}if(support("dump"))$wa[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Pd=$_GET["ns"]!==""&&!$Ve&&DB!="";if($Pd)$wa[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($wa?"<p class='links'>\n".implode("\n",$wa)."\n":"");if($Pd){if($S)$this->tablesPrint($S);else
echo"<p class='message'>".lang(10)."</p>\n";}}}function
databasesPrint($Ve){global$b,$g;$j=$this->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$Xb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(36)."'>".lang(74)."</span>: ".($j?"<select name='db'>".optionlist(array(""=>"")+$j,DB)."</select>$Xb":"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n"),"<input type='submit' value='".lang(21)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($Ve!="db"&&DB!=""&&$g->select_db(DB)){echo"<br>".lang(75).": <select name='ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Xb";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$O){$C=$this->tableName($O);if($C!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($O)?"view":"structure"))." title='".lang(41)."'>$C</a>":"<span>$C</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$oc=array("server"=>"MySQL")+$oc;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($M="",$V="",$F="",$Vb=null,$eg=null,$uh=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Id,$eg)=explode(":",$M,2);$Dh=$b->connectSsl();if($Dh)$this->ssl_set($Dh['key'],$Dh['cert'],$Dh['ca'],'','');$I=@$this->real_connect(($M!=""?$Id:ini_get("mysqli.default_host")),($M.$V!=""?$V:ini_get("mysqli.default_user")),($M.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$Vb,(is_numeric($eg)?$eg:ini_get("mysqli.default_port")),(!is_numeric($eg)?$eg:$uh),($Dh?(empty($Dh['cert'])?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($cb){if(parent::set_charset($cb))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $cb");}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$n];}function
quote($P){return"'".$this->escape_string($P)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($M,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(77,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($M!=""?$M:ini_get("mysql.default_host")),("$M$V"!=""?$V:ini_get("mysql.default_user")),("$M$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($cb){if(function_exists('mysql_set_charset')){if(mysql_set_charset($cb,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $cb");}function
quote($P){return"'".mysql_real_escape_string($P,$this->_link)."'";}function
select_db($Vb){return
mysql_select_db($Vb,$this->_link);}function
query($G,$Ci=false){$H=@($Ci?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$n);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($M,$V,$F){global$b;$D=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Dh=$b->connectSsl();if($Dh){if(!empty($Dh['key']))$D[PDO::MYSQL_ATTR_SSL_KEY]=$Dh['key'];if(!empty($Dh['cert']))$D[PDO::MYSQL_ATTR_SSL_CERT]=$Dh['cert'];if(!empty($Dh['ca']))$D[PDO::MYSQL_ATTR_SSL_CA]=$Dh['ca'];if(!empty($Dh['verify']))$D[PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$Dh['verify'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F,$D);return
true;}function
set_charset($cb){$this->query("SET NAMES $cb");}function
select_db($Vb){return$this->query("USE ".idf_escape($Vb));}function
query($G,$Ci=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Ci);return
parent::query($G,$Ci);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$N){return($N?parent::insert($Q,$N):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$K,$lg){$e=array_keys(reset($K));$jg="INSERT INTO ".table($Q)." (".implode(", ",$e).") VALUES\n";$Vi=array();foreach($e
as$y)$Vi[$y]="$y = VALUES($y)";$Kh="\nON DUPLICATE KEY UPDATE ".implode(", ",$Vi);$Vi=array();$xe=0;foreach($K
as$N){$Y="(".implode(", ",$N).")";if($Vi&&(strlen($jg)+$xe+strlen($Y)+strlen($Kh)>1e6)){if(!queries($jg.implode(",\n",$Vi).$Kh))return
false;$Vi=array();$xe=0;}$Vi[]=$Y;$xe+=strlen($Y)+2;}return
queries($jg.implode(",\n",$Vi).$Kh);}function
slowQuery($G,$fi){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$fi FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($fi*1000).") */ $B[2]";}}function
convertSearch($u,$X,$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($u USING ".charset($this->_conn).")":$u);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($C){$Ce=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower("information-schema-".($Ce?"$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($Ce?"mysql$C-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Ya;if($Ya===null){$Bh=$this->_conn->result("SHOW VARIABLES LIKE 'sql_mode'",1);$Ya=(strpos($Bh,'NO_BACKSLASH_ESCAPES')===false);}return$Ya;}}function
idf_escape($u){return"`".str_replace("`","``",$u)."`";}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Hh,$wc;$g=new
Min_DB;$Ob=$b->credentials();if($g->connect($Ob[0],$Ob[1],$Ob[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$Hh[lang(26)][]="json";$U["json"]=4294967295;}if(min_version('',10.7,$g)){$Hh[lang(26)][]="uuid";$U["uuid"]=128;$wc[0]['uuid']='uuid';}if(min_version(9,'',$g)){$Hh[lang(27)][]="vector";$U["vector"]=16383;$wc[0]['vector']='string_to_vector';}return$g;}$I=$g->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($Wg=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$Wg;return$I;}function
get_databases($jd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($jd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$z,$lf=0,$gh=" "){return" $G$Z".($z!==null?$gh."LIMIT $z".($lf?" OFFSET $lf":""):"");}function
limit1($Q,$G,$Z,$gh="\n"){return
limit($G,$Z,1,0,$gh);}function
db_collation($k,$qb){global$g;$I=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$B))$I=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$B))$I=$qb[$B[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($j){$I=array();foreach($j
as$k)$I[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$I;}function
table_status($C="",$Yc=false){$I=array();foreach(get_rows($Yc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($C!=""){$J["Name"]=$C;return$J;}$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$B);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$B[1],"length"=>$B[2],"unsigned"=>ltrim($B[3].$B[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$B[1])?(preg_match('~text~',$B[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$B)?$B[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$h)as$J){$C=$J["Key_name"];$I[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$C]["columns"][]=$J["Column_name"];$I[$C]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$C]["descs"][]=null;}return$I;}function
foreign_keys($Q){global$g,$tf;static$ag='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$Mb=$g->result("SHOW CREATE TABLE ".table($Q),1);if($Mb){preg_match_all("~CONSTRAINT ($ag) FOREIGN KEY ?\\(((?:$ag,? ?)+)\\) REFERENCES ($ag)(?:\\.($ag))? \\(((?:$ag,? ?)+)\\)(?: ON DELETE ($tf))?(?: ON UPDATE ($tf))?~",$Mb,$Fe,PREG_SET_ORDER);foreach($Fe
as$B){preg_match_all("~$ag~",$B[2],$wh);preg_match_all("~$ag~",$B[5],$Xh);$I[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('idf_unescape',$wh[0]),"target"=>array_map('idf_unescape',$Xh[0]),"on_delete"=>($B[6]?$B[6]:"RESTRICT"),"on_update"=>($B[7]?$B[7]:"RESTRICT"),);}}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$y=>$X)asort($I[$y]);return$I;}function
information_schema($k){return(min_version(5)&&$k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($k,$pb){return
queries("CREATE DATABASE ".idf_escape($k).($pb?" COLLATE ".q($pb):""));}function
drop_databases($j){$I=apply_queries("DROP DATABASE",$j,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($C,$pb){$I=false;if(create_database($C,$pb)){$S=array();$aj=array();foreach(tables_list()as$Q=>$T){if($T=='VIEW')$aj[]=$Q;else$S[]=$Q;}$I=(!$S&&!$aj)||move_tables($S,$aj,$C);drop_databases($I?array(DB):array());}return$I;}function
auto_increment(){$Ma=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$v){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$v["columns"],true)){$Ma="";break;}if($v["type"]=="PRIMARY")$Ma=" UNIQUE";}}return" AUTO_INCREMENT$Ma";}function
alter_table($Q,$C,$o,$ld,$wb,$Dc,$pb,$La,$Wf){$c=array();foreach($o
as$n)$c[]=($n[1]?($Q!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($Q!=""?$n[2]:""):"DROP ".idf_escape($n[0]));$c=array_merge($c,$ld);$O=($wb!==null?" COMMENT=".q($wb):"").($Dc?" ENGINE=".q($Dc):"").($pb?" COLLATE ".q($pb):"").($La!=""?" AUTO_INCREMENT=$La":"");if($Q=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)$O$Wf");if($Q!=$C)$c[]="RENAME TO ".table($C);if($O)$c[]=ltrim($O);return($c||$Wf?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$c).$Wf):true);}function
alter_indexes($Q,$c){foreach($c
as$y=>$X)$c[$y]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$c));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($aj){return
queries("DROP VIEW ".implode(", ",array_map('table',$aj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$aj,$Xh){global$g;$Ig=array();foreach($S
as$Q)$Ig[]=table($Q)." TO ".idf_escape($Xh).".".table($Q);if(!$Ig||queries("RENAME TABLE ".implode(", ",$Ig))){$ec=array();foreach($aj
as$Q)$ec[table($Q)]=view($Q);$g->select_db($Xh);$k=idf_escape(DB);foreach($ec
as$C=>$Zi){if(!queries("CREATE VIEW $C AS ".str_replace(" $k."," ",$Zi["select"]))||!queries("DROP VIEW $k.$C"))return
false;}return
true;}return
false;}function
copy_tables($S,$aj,$Xh){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$C=($Xh==DB?table("copy_$Q"):idf_escape($Xh).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $C"))||!queries("CREATE TABLE $C LIKE ".table($Q))||!queries("INSERT INTO $C SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J){$xi=$J["Trigger"];if(!queries("CREATE TRIGGER ".($Xh==DB?idf_escape("copy_$xi"):idf_escape($Xh).".".idf_escape($xi))." $J[Timing] $J[Event] ON $C FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($aj
as$Q){$C=($Xh==DB?table("copy_$Q"):idf_escape($Xh).".".table($Q));$Zi=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $C"))||!queries("CREATE VIEW $C AS $Zi[select]"))return
false;}return
true;}function
trigger($C){if($C=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($K);}function
triggers($Q){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$T){global$g,$Fc,$Wd,$U;$Ca=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$xh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Bi="((".implode("|",array_merge(array_keys($U),$Ca)).")\\b(?:\\s*\\(((?:[^'\")]|$Fc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$ag="$xh*(".($T=="FUNCTION"?"":$Wd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Bi";$i=$g->result("SHOW CREATE $T ".idf_escape($C),2);preg_match("~\\(((?:$ag\\s*,?)*)\\)\\s*".($T=="FUNCTION"?"RETURNS\\s+$Bi\\s+":"")."(.*)~is",$i,$B);$o=array();preg_match_all("~$ag\\s*,?~is",$B[1],$Fe,PREG_SET_ORDER);foreach($Fe
as$Qf)$o[]=array("field"=>str_replace("``","`",$Qf[2]).$Qf[3],"type"=>strtolower($Qf[5]),"length"=>preg_replace_callback("~$Fc~s",'normalize_enum',$Qf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Qf[8] $Qf[7]"))),"null"=>1,"full_type"=>$Qf[4],"inout"=>strtoupper($Qf[1]),"collation"=>strtolower($Qf[9]),);return
array("fields"=>$o,"comment"=>$g->result("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB)." AND ROUTINE_NAME = ".q($C)),)+($T!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($C,$J){return
idf_escape($C);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$G){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$G);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Yg,$h=null){return
true;}function
create_sql($Q,$La,$Ih){global$g;$I=$g->result("SHOW CREATE TABLE ".table($Q),1);if(!$La)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($Vb){return"USE ".idf_escape($Vb);}function
trigger_sql($Q){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field($n,$I){if(preg_match("~binary~",$n["type"]))$I="UNHEX($I)";if($n["type"]=="bit")$I="CONVERT(b$I, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$jg=(min_version(8)?"ST_":"");$I=$jg."GeomFromText($I, $jg"."SRID($n[field]))";}return$I;}function
support($Zc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view"))).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Zc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}function
driver_config(){$U=array();$Hh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(26)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(78)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$y=>$X){$U+=$X;$Hh[$y]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$U,'structured_types'=>$Hh,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$_b=driver_config();$ig=$_b['possible_drivers'];$x=$_b['jush'];$U=$_b['types'];$Hh=$_b['structured_types'];$Ji=$_b['unsigned'];$yf=$_b['operators'];$sd=$_b['functions'];$zd=$_b['grouping'];$wc=$_b['edit_functions'];if($b->operators===null)$b->operators=$yf;define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($hi,$m="",$Va=array(),$ii=""){global$ca,$ia,$b,$oc,$x;page_headers();if(is_ajax()&&$m){page_messages($m);exit;}$ji=$hi.($ii!=""?": $ii":"");$ki=strip_tags($ji.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(79),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width">
<title>',$ki,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.17.1"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.17.1");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.17.1"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.17.1"),'">
';foreach($b->css()as$Qb){echo'<link rel="stylesheet" type="text/css" href="',h($Qb),'">
';}}echo'
<body class="',lang(79),' nojs">
';$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Yi=unserialize(file_get_contents($p));$tg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Yi["version"],base64_decode($Yi["signature"]),$tg)==1)$_COOKIE["adminer_version"]=$Yi["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(80)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$x,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Va!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?$_:".").'">'.$oc[DRIVER].'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$M=$b->serverName(SERVER);$M=($M!=""?$M:lang(33));if($Va===false)echo"$M\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$M</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Va)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Va)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Va
as$y=>$X){$gc=(is_array($X)?$X[1]:h($X));if($gc!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$gc</a> » ";}}echo"$hi\n";}}echo"<h2>$ji</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Pb){$Ed=array();foreach($Pb
as$y=>$X)$Ed[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Ed));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$ff;if(!$ff)$ff=base64_encode(rand_string());return$ff;}function
page_messages($m){$Li=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Se=$_SESSION["messages"][$Li];if($Se){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Se)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Li]);}if($m)echo"<div class='error'>$m</div>\n";}function
page_footer($Ve=""){global$b,$oi;echo'</div>

<div id="menu">
';$b->navigation($Ve);echo'</div>

';if($Ve!="auth"){echo'<form action="" method="post">
<p class="logout">
',h($_GET["username"])."\n",'<input type="submit" name="logout" value="',lang(81),'" id="logout">
<input type="hidden" name="token" value="',$oi,'">
</p>
</form>
';}echo
script("setupSubmitHighlight(document);");}function
int32($Ye){while($Ye>=2147483648)$Ye-=4294967296;while($Ye<=-2147483649)$Ye+=4294967296;return(int)$Ye;}function
long2str($W,$cj){$Wg='';foreach($W
as$X)$Wg.=pack('V',$X);if($cj)return
substr($Wg,0,end($W));return$Wg;}function
str2long($Wg,$cj){$W=array_values(unpack('V*',str_pad($Wg,4*ceil(strlen($Wg)/4),"\0")));if($cj)$W[]=strlen($Wg);return$W;}function
xxtea_mx($oj,$nj,$Lh,$ie){return
int32((($oj>>5&0x7FFFFFF)^$nj<<2)+(($nj>>3&0x1FFFFFFF)^$oj<<4))^int32(($Lh^$nj)+($ie^$oj));}function
encrypt_string($Gh,$y){if($Gh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Gh,true);$Ye=count($W)-1;$oj=$W[$Ye];$nj=$W[0];$ug=floor(6+52/($Ye+1));$Lh=0;while($ug-->0){$Lh=int32($Lh+0x9E3779B9);$vc=$Lh>>2&3;for($Of=0;$Of<$Ye;$Of++){$nj=$W[$Of+1];$Xe=xxtea_mx($oj,$nj,$Lh,$y[$Of&3^$vc]);$oj=int32($W[$Of]+$Xe);$W[$Of]=$oj;}$nj=$W[0];$Xe=xxtea_mx($oj,$nj,$Lh,$y[$Of&3^$vc]);$oj=int32($W[$Ye]+$Xe);$W[$Ye]=$oj;}return
long2str($W,false);}function
decrypt_string($Gh,$y){if($Gh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Gh,false);$Ye=count($W)-1;$oj=$W[$Ye];$nj=$W[0];$ug=floor(6+52/($Ye+1));$Lh=int32($ug*0x9E3779B9);while($Lh){$vc=$Lh>>2&3;for($Of=$Ye;$Of>0;$Of--){$oj=$W[$Of-1];$Xe=xxtea_mx($oj,$nj,$Lh,$y[$Of&3^$vc]);$nj=int32($W[$Of]-$Xe);$W[$Of]=$nj;}$oj=$W[$Ye];$Xe=xxtea_mx($oj,$nj,$Lh,$y[$Of&3^$vc]);$nj=int32($W[0]-$Xe);$W[0]=$nj;$Lh=int32($Lh-0x9E3779B9);}return
long2str($W,true);}$g='';$Dd=$_SESSION["token"];if(!$Dd)$_SESSION["token"]=rand(1,1e6);$oi=get_token();$cg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$cg[$y]=$X;}}function
add_invalid_login(){global$b;$r=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$r)return;$be=unserialize(stream_get_contents($r));$ei=time();if($be){foreach($be
as$ce=>$X){if($X[0]<$ei)unset($be[$ce]);}}$ae=&$be[$b->bruteForceKey()];if(!$ae)$ae=array($ei+30*60,0);$ae[1]++;file_write_unlock($r,serialize($be));}function
check_invalid_login(){global$b;$be=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$ae=($be?$be[$b->bruteForceKey()]:array());$ef=($ae[1]>29?$ae[0]-time():0);if($ef>0)auth_error(lang(82,ceil($ef/60)));}$Ja=$_POST["auth"];if($Ja){session_regenerate_id();$Xi=$Ja["driver"];$M=$Ja["server"];$V=$Ja["username"];$F=(string)$Ja["password"];$k=$Ja["db"];set_password($Xi,$M,$V,$F);$_SESSION["db"][$Xi][$M][$V][$k]=true;if($Ja["permanent"]){$y=base64_encode($Xi)."-".base64_encode($M)."-".base64_encode($V)."-".base64_encode($k);$og=$b->permanentLogin(true);$cg[$y]="$y:".base64_encode($og?encrypt_string($F,$og):"");cookie("adminer_permanent",implode(" ",$cg));}if(count($_POST)==1||DRIVER!=$Xi||SERVER!=$M||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Xi,$M,$V,$k));}elseif($_POST["logout"]&&(!$Dd||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(83).' '.lang(84));}elseif($cg&&!$_SESSION["pwds"]){session_regenerate_id();$og=$b->permanentLogin();foreach($cg
as$y=>$X){list(,$jb)=explode(":",$X);list($Xi,$M,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Xi,$M,$V,decrypt_string(base64_decode($jb),$og));$_SESSION["db"][$Xi][$M][$V][$k]=true;}}function
unset_permanent(){global$cg;foreach($cg
as$y=>$X){list($Xi,$M,$V,$k)=array_map('base64_decode',explode("-",$y));if($Xi==DRIVER&&$M==SERVER&&$V==$_GET["username"]&&$k==DB)unset($cg[$y]);}cookie("adminer_permanent",implode(" ",$cg));}function
auth_error($m){global$b,$Dd;$mh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$mh]||$_GET[$mh])&&!$Dd)$m=lang(85);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m.=($m?'<br>':'').lang(86,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$mh]&&$_GET[$mh]&&ini_bool("session.use_only_cookies"))$m=lang(87);$Rf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Rf["lifetime"]);page_header(lang(37),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(88)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(89),lang(90,implode(", ",$ig)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Id,$eg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$eg,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(91));check_invalid_login();$g=connect();$l=new
Min_Driver($g);}$Ae=null;if(!is_object($g)||($Ae=$b->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Ae)?$Ae:lang(92)));auth_error($m.(preg_match('~^ | $~',get_password())?'<br>'.lang(93):''));}if($_POST["logout"]&&$Dd&&!verify_token()){page_header(lang(81),lang(94));page_footer("db");exit;}if($Ja&&$_POST["token"])$_POST["token"]=$oi;$m='';if($_POST){if(!verify_token()){$Vd="max_input_vars";$Le=ini_get($Vd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Le||$X<$Le)){$Vd=$y;$Le=$X;}}}$m=(!$_POST["token"]&&$Le?lang(95,"'$Vd'"):lang(94).' '.lang(96));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(97,"'post_max_size'");if(isset($_GET["sql"]))$m.=' '.lang(98);}function
select($H,$h=null,$Ef=array(),$z=0){global$x;$_e=array();$w=array();$e=array();$Ta=array();$U=array();$I=array();for($t=0;(!$z||$t<$z)&&($J=$H->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($he=0;$he<count($J);$he++){$n=$H->fetch_field();$C=$n->name;$Df=$n->orgtable;$Cf=$n->orgname;$I[$n->table]=$Df;if($Ef&&$x=="sql")$_e[$he]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($Df!=""){if(!isset($w[$Df])){$w[$Df]=array();foreach(indexes($Df,$h)as$v){if($v["type"]=="PRIMARY"){$w[$Df]=array_flip($v["columns"]);break;}}$e[$Df]=$w[$Df];}if(isset($e[$Df][$Cf])){unset($e[$Df][$Cf]);$w[$Df][$Cf]=$he;$_e[$he]=$Df;}}if($n->charsetnr==63)$Ta[$he]=true;$U[$he]=$n->type;echo"<th".($Df!=""||$n->name!=$Cf?" title='".h(($Df!=""?"$Df.":"").$Cf)."'":"").">".h($C).($Ef?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($J
as$y=>$X){$_="";if(isset($_e[$y])&&!$e[$_e[$y]]){if($Ef&&$x=="sql"){$Q=$J[array_search("table=",$_e)];$_=ME.$_e[$y].urlencode($Ef[$Q]!=""?$Ef[$Q]:$Q);}else{$_=ME."edit=".urlencode($_e[$y]);foreach($w[$_e[$y]]as$nb=>$he)$_.="&where".urlencode("[".bracket_escape($nb)."]")."=".urlencode($J[$he]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ta[$y]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($U[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(13))."\n";return$I;}function
referencable_primary($eh){$I=array();foreach(table_status('',true)as$Ph=>$Q){if($Ph!=$eh&&fk_support($Q)){foreach(fields($Ph)as$n){if($n["primary"]){if($I[$Ph]){unset($I[$Ph]);break;}$I[$Ph]=$n;}}}}return$I;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$oh);return$oh;}function
adminer_setting($y){$oh=adminer_settings();return$oh[$y];}function
set_adminer_settings($oh){return
cookie("adminer_settings",http_build_query($oh+adminer_settings()));}function
textarea($C,$Y,$K=10,$sb=80){global$x;echo"<textarea name='".h($C)."' rows='$K' cols='$sb' class='sqlarea jush-$x' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($Ia,$D,$Y="",$uf="",$dg=""){$Wh=($D?"select":"input");return"<$Wh$Ia".($D?"><option value=''>$dg".optionlist($D,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$dg'>").($uf?script("qsl('$Wh').onchange = $uf;",""):"");}function
json_row($y,$X=null){static$ed=true;if($ed)echo"{";if($y!=""){echo($ed?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$ed=false;}else{echo"\n}\n";$ed=true;}}function
edit_type($y,$n,$qb,$nd=array(),$Wc=array()){global$Hh,$U,$Ji,$tf;$T=$n["type"];echo'<td><select name="',h($y),'[type]" class="type" aria-labelledby="label-type">';if($T&&!isset($U[$T])&&!isset($nd[$T])&&!in_array($T,$Wc))$Wc[]=$T;if($nd)$Hh[lang(99)]=$nd;echo
optionlist(array_merge($Wc,$Hh),$T),'</select><td><input
	name="',h($y),'[length]"
	value="',h($n["length"]),'"
	size="3"
	',(!$n["length"]&&preg_match('~var(char|binary)$~',$T)?" class='required'":"");echo'	aria-labelledby="label-length"><td class="options">',($qb?"<select name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$T)?"":" class='hidden'").'><option value="">('.lang(100).')'.optionlist($qb,$n["collation"]).'</select>':''),($Ji?"<select name='".h($y)."[unsigned]'".(!$T||preg_match(number_type(),$T)?"":" class='hidden'").'><option>'.optionlist($Ji,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$T)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(101).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$T)?"":" class='hidden'")."><option value=''>(".lang(102).")".optionlist(explode("|",$tf),$n["on_delete"])."</select> ":" ");}function
get_partitions_info($Q){global$g;$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($Q);$H=$g->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$I=array();list($I["partition_by"],$I["partition"],$I["partitions"])=$H->fetch_row();$Xf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$I["partition_names"]=array_keys($Xf);$I["partition_values"]=array_values($Xf);return$I;}function
process_length($xe){global$Fc;return(preg_match("~^\\s*\\(?\\s*$Fc(?:\\s*,\\s*$Fc)*+\\s*\\)?\\s*\$~",$xe)&&preg_match_all("~$Fc~",$xe,$Fe)?"(".implode(",",$Fe[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$xe)));}function
process_type($n,$ob="COLLATE"){global$Ji;return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],$Ji)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $ob ".q($n["collation"]):"");}function
process_field($n,$Ai){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($Ai),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value($n){global$x;$bc=$n["default"];return($bc===null?"":" DEFAULT ".(!preg_match('~^GENERATED ~i',$bc)&&(preg_match('~char|binary|text|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$bc))?q($bc):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",($x=="sqlite"?"($bc)":$bc))));}function
type_class($T){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$T))return" class='$y'";}}function
edit_fields($o,$qb,$T="TABLE",$nd=array()){global$Wd;$o=array_values($o);$cc=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$xb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($T=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($T=="TABLE"?lang(103):lang(104)),'<td id="label-type">',lang(48),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(105),'<td>',lang(106);if($T=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><abbr id="label-ai" title="',lang(50),'">AI</abbr>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),'<td id="label-default"',$cc,'>',lang(51),(support("comment")?"<td id='label-comment'$xb>".lang(49):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($o))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.17.1")."' alt='+' title='".lang(107)."'>".script("row_count = ".count($o).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$Ff=$n[($_POST?"orig":"field")];$lc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!$_POST["drop_col"][$t]))&&(support("drop_col")||$Ff=="");echo'<tr',($lc?"":" style='display: none;'"),'>
',($T=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",$Wd),$n["inout"]):""),'<th>';if($lc){echo'<input name="fields[',$t,'][field]" value="',h($n["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$t,'][orig]" value="',h($Ff),'">';edit_type("fields[$t]",$n,$qb,$nd);if($T=="TABLE"){echo'<td>',checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$t,'"';if($n["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$cc,'>',checkbox("fields[$t][has_default]",1,$n["has_default"],"","","","label-default"),'<input name="fields[',$t,'][default]" value="',h($n["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$xb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.17.1")."' alt='+' title='".lang(107)."'> "."<input type='image' class='icon' name='up[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.17.1")."' alt='↑' title='".lang(108)."'> "."<input type='image' class='icon' name='down[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.17.1")."' alt='↓' title='".lang(109)."'> ":""),($Ff==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.17.1")."' alt='x' title='".lang(110)."'>":"");}}function
process_fields(&$o){$lf=0;if($_POST["up"]){$re=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$re,0,array($n));break;}if(isset($n["field"]))$re=$lf;$lf++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$lf,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$lf++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($B){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($B[0][0].$B[0][0],$B[0][0],substr($B[0],1,-1))),'\\'))."'";}function
grant($ud,$qg,$e,$sf){if(!$qg)return
true;if($qg==array("ALL PRIVILEGES","GRANT OPTION"))return($ud=="GRANT"?queries("$ud ALL PRIVILEGES$sf WITH GRANT OPTION"):queries("$ud ALL PRIVILEGES$sf")&&queries("$ud GRANT OPTION$sf"));return
queries("$ud ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$qg).$e).$sf);}function
drop_create($pc,$i,$qc,$ai,$sc,$A,$Re,$Pe,$Qe,$pf,$cf){if($_POST["drop"])query_redirect($pc,$A,$Re);elseif($pf=="")query_redirect($i,$A,$Qe);elseif($pf!=$cf){$Nb=queries($i);queries_redirect($A,$Pe,$Nb&&queries($pc));if($Nb)queries($qc);}else
queries_redirect($A,$Pe,queries($ai)&&queries($sc)&&queries($pc)&&queries($i));}function
create_trigger($sf,$J){global$x;$gi=" $J[Timing] $J[Event]".(preg_match('~ OF~',$J["Event"])?" $J[Of]":"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($x=="mssql"?$sf.$gi:$gi.$sf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($Sg,$J){global$Wd,$x;$N=array();$o=(array)$J["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$N[]=(preg_match("~^($Wd)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$dc=rtrim($J["definition"],";");return"CREATE $Sg ".idf_escape(trim($J["name"]))." (".implode(", ",$N).")".($Sg=="FUNCTION"?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($x=="pgsql"?" AS ".q($dc):"\n$dc;");}function
check_constraints($Q){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($Q)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($q){global$tf;$k=$q["db"];$gf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($gf!=""&&$gf!=$_GET["ns"]?idf_escape($gf).".":"").table($q["table"])." (".implode(", ",array_map('idf_escape',$q["target"])).")".(preg_match("~^($tf)\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^($tf)\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$li){$I=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($li->size),decoct(time()));$ib=8*32;for($t=0;$t<strlen($I);$t++)$ib+=ord($I[$t]);$I.=sprintf("%06o",$ib)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$li->send();echo
str_repeat("\0",511-($li->size+511)%512);}function
ini_bytes($Vd){$X=ini_get($Vd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link($Zf,$bi="<sup>?</sup>"){global$x,$g;$kh=$g->server_info;$Yi=preg_replace('~^(\d\.?\d).*~s','\1',$kh);$Ni=array('sql'=>"https://dev.mysql.com/doc/refman/$Yi/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$Yi/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$kh)."&id=",);if(preg_match('~MariaDB~',$kh)){$Ni['sql']="https://mariadb.com/kb/en/";$Zf['sql']=(isset($Zf['mariadb'])?$Zf['mariadb']:str_replace(".html","/",$Zf['sql']));}return($Zf[$x]?"<a href='".h($Ni[$x].$Zf[$x].($x=='mssql'?"?view=sql-server-ver$Yi":""))."'".target_blank().">$bi</a>":"");}function
ob_gzencode($P){return
gzencode($P);}function
db_size($k){global$g;if(!$g->select_db($k))return"?";$I=0;foreach(table_status()as$R)$I+=$R["Data_length"]+$R["Index_length"];return
format_number($I);}function
set_utf8mb4($i){global$g;static$N=false;if(!$N&&preg_match('~\butf8mb4~i',$i)){$N=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$b,$g,$oi,$m,$oc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(111),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(112),drop_databases($_POST["db"]));page_header(lang(113),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(114),'privileges'=>lang(70),'processlist'=>lang(115),'variables'=>lang(116),'status'=>lang(117),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(118,$oc[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(119,"<b>".h(logged_user())."</b>")."\n";$j=$b->databases();if($j){$Zg=support("scheme");$qb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36)." - <a href='".h(ME)."refresh=1'>".lang(120)."</a>"."<td>".lang(121)."<td>".lang(122)."<td>".lang(123)." - <a href='".h(ME)."dbsize=1'>".lang(124)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$S){$Rg=h(ME)."db=".urlencode($k);$Kd=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$Kd):""),"<th><a href='$Rg' id='$Kd'>".h($k)."</a>";$pb=h(db_collation($k,$qb));echo"<td>".(support("database")?"<a href='$Rg".($Zg?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$pb</a>":$pb),"<td align='right'><a href='$Rg&amp;schema=' id='tables-".h($k)."' title='".lang(69)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(125)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(126)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$oi'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(127),true);page_footer("ns");exit;}}}$tf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Gb){$this->size+=strlen($Gb);fwrite($this->handler,$Gb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$Fc="'(?:''|[^'\\\\]|\\\\.)*'";$Wd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$l->select($a,$L,array(where($_GET,$o)),$L);$J=($H?$H->fetch_row():array());echo$l->value($J[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error();$R=table_status1($a,true);$C=$b->tableName($R);page_header(($o&&is_view($R)?$R['Engine']=='materialized view'?lang(128):lang(129):lang(130)).": ".($C!=""?$C:h($a)),$m);$Qg=array();foreach($o
as$y=>$n)$Qg+=$n["privileges"];$b->selectLinks($R,(isset($Qg["insert"])||!support("table")?"":null));$wb=$R["Comment"];if($wb!="")echo"<p class='nowrap'>".lang(49).": ".h($wb)."\n";if($o)$b->tableStructurePrint($o);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(131)."</h3>\n";$w=indexes($a);if($w)$b->tableIndexesPrint($w);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(132)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(99)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(133)."<td>".lang(134)."<td>".lang(102)."<td>".lang(101)."<td></thead>\n";foreach($nd
as$C=>$q){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('h',$q["source"]))."</i>","<td><a href='".h($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME))."table=".urlencode($q["table"])."'>".($q["db"]!=""?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(135).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(136)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(137)."</h3>\n";$eb=check_constraints($a);if($eb){echo"<table>\n";foreach($eb
as$y=>$X){echo"<tr title='".h($y)."'>","<td><code class='jush-$x'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(135)."</a>","\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(138)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(139)."</h3>\n";$_i=triggers($a);if($_i){echo"<table>\n";foreach($_i
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(135)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(140)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Rh=array();$Sh=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Fe,PREG_SET_ORDER);foreach($Fe
as$t=>$B){$Rh[$B[1]]=array($B[2],$B[3]);$Sh[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$pi=0;$Qa=-1;$Yg=array();$Dg=array();$ve=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$fg=0;$Yg[$Q]["fields"]=array();foreach(fields($Q)as$C=>$n){$fg+=1.25;$n["pos"]=$fg;$Yg[$Q]["fields"][$C]=$n;}$Yg[$Q]["pos"]=($Rh[$Q]?$Rh[$Q]:array($pi,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$te=$Qa;if($Rh[$Q][1]||$Rh[$X["table"]][1])$te=min(floatval($Rh[$Q][1]),floatval($Rh[$X["table"]][1]))-1;else$Qa-=.1;while($ve[(string)$te])$te-=.0001;$Yg[$Q]["references"][$X["table"]][(string)$te]=array($X["source"],$X["target"]);$Dg[$X["table"]][$Q][(string)$te]=$X["target"];$ve[(string)$te]=true;}}$pi=max($pi,$Yg[$Q]["pos"][0]+2.5+$fg);}echo'<div id="schema" style="height: ',$pi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Sh)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$pi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Yg
as$C=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["full_type"].($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$Yh=>$Eg){foreach($Eg
as$te=>$Ag){$ue=$te-$Rh[$C][1];$t=0;foreach($Ag[0]as$wh)echo"\n<div class='references' title='".h($Yh)."' id='refs$te-".($t++)."' style='left: $ue"."em; top: ".$Q["fields"][$wh]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$ue)."em;'></div></div>";}}foreach((array)$Dg[$C]as$Yh=>$Eg){foreach($Eg
as$te=>$e){$ue=$te-$Rh[$C][1];$t=0;foreach($e
as$Xh)echo"\n<div class='references' title='".h($Yh)."' id='refd$te-".($t++)."' style='left: $ue"."em; top: ".$Q["fields"][$Xh]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.17.1")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$ue)."em;'></div></div>";}}echo"\n</div>\n";}foreach($Yg
as$C=>$Q){foreach((array)$Q["references"]as$Yh=>$Eg){foreach($Eg
as$te=>$Ag){$Ue=$pi;$Je=-10;foreach($Ag[0]as$y=>$wh){$gg=$Q["pos"][0]+$Q["fields"][$wh]["pos"];$hg=$Yg[$Yh]["pos"][0]+$Yg[$Yh]["fields"][$Ag[1][$y]]["pos"];$Ue=min($Ue,$gg,$hg);$Je=max($Je,$gg,$hg);}echo"<div class='references' id='refl$te' style='left: $te"."em; top: $Ue"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Je-$Ue)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(141),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){$Jb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$y)$Jb.="&$y=".urlencode($_POST[$y]);cookie("adminer_export",substr($Jb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Tc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$ee=preg_match('~sql~',$_POST["format"]);if($ee){echo"-- Adminer $ia ".$oc[DRIVER]." ".str_replace("\n"," ",$g->server_info)." dump\n\n";if($x=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00'");$g->query("SET sql_mode = ''");}}$Ih=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){$b->dumpDatabase($k);if($g->select_db($k)){if($ee&&preg_match('~CREATE~',$Ih)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($Ih=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($ee){if($Ih)echo
use_sql($k).";\n\n";$Lf="";if($_POST["routines"]){foreach(routines()as$J){$C=$J["ROUTINE_NAME"];$Sg=$J["ROUTINE_TYPE"];$i=create_routine($Sg,array("name"=>$C)+routine($J["SPECIFIC_NAME"],$Sg));set_utf8mb4($i);$Lf.=($Ih!='DROP+CREATE'?"DROP $Sg IF EXISTS ".idf_escape($C).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($i);$Lf.=($Ih!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}echo($Lf&&$x=='sql'?"DELIMITER ;;\n\n$Lf"."DELIMITER ;\n\n":$Lf);}if($_POST["table_style"]||$_POST["data_style"]){$aj=array();foreach(table_status('',true)as$C=>$R){$Q=(DB==""||in_array($C,(array)$_POST["tables"]));$Tb=(DB==""||in_array($C,(array)$_POST["data"]));if($Q||$Tb){if($Tc=="tar"){$li=new
TmpFile;ob_start(array($li,'write'),1e5);}$b->dumpTable($C,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$aj[]=$C;elseif($Tb){$o=fields($C);$b->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($C));}if($ee&&$_POST["triggers"]&&$Q&&($_i=trigger_sql($C)))echo"\nDELIMITER ;;\n$_i\nDELIMITER ;\n";if($Tc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$C.csv",$li);}elseif($ee)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$C=>$R){$Q=(DB==""||in_array($C,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($C);}}foreach($aj
as$Zi)$b->dumpTable($Zi,$_POST["table_style"],1);if($Tc=="tar")echo
pack("x512");}}}if($ee)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(72),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Yb=array('','USE','DROP+CREATE','CREATE');$Th=array('','DROP+CREATE','CREATE');$Ub=array('','TRUNCATE+INSERT','INSERT');if($x=="sql")$Ub[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(142)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(143)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($x=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Yb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(144)):"").(support("event")?checkbox("events",1,$J["events"],lang(145)):"")),"<tr><th>".lang(122)."<td>".html_select('table_style',$Th,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(139)):""),"<tr><th>".lang(146)."<td>".html_select('data_style',$Ub,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
<input type="hidden" name="token" value="',$oi,'">

<table>
',script("qsl('table').onclick = dumpClick;");$kg=array();if(DB!=""){$gb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$gb>".lang(122)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(146)."<input type='checkbox' id='check-data'$gb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$aj="";$Uh=tables_list();foreach($Uh
as$C=>$T){$jg=preg_replace('~_.*~','',$C);$gb=($a==""||$a==(substr($a,-1)=="%"?"$jg%":$C));$ng="<tr><td>".checkbox("tables[]",$C,$gb,$C,"","block");if($T!==null&&!preg_match('~table~i',$T))$aj.="$ng\n";else
echo"$ng<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$gb)."</label>\n";$kg[$jg]++;}echo$aj;if($Uh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=$b->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$jg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$jg%",$k,"","block")."\n";$kg[$jg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$ed=true;foreach($kg
as$y=>$X){if($y!=""&&$X>1){echo($ed?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$ed=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(147)."</a>";$H=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$ud=$H;if(!$H)$H=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($ud?"":"<input type='hidden' name='grant' value=''>\n"),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(11)."</a>\n";if(!$ud||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(11)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Hd=&get_session("queries");$Gd=&$Hd[DB];if(!$m&&$_POST["clear"]){$Gd=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(71):lang(63)),$m);if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$_h=$b->importServerPath();$r=@fopen((file_exists($_h)?$_h:"compress.zlib://$_h.gz"),"rb");$G=($r?fread($r,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage')&&($Ne=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Ne,2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$ug=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Gd||reset(end($Gd))!=$ug){restart_session();$Gd[]=array($ug,time());set_session("queries",$Hd);stop_session();}}$xh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$fc=";";$lf=0;$Cc=true;$h=connect();if(is_object($h)&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$vb=0;$Ic=array();$Sf='[\'"'.($x=="sql"?'`#':($x=="sqlite"?'`[':($x=="mssql"?'[':''))).']|/\*|-- |$'.($x=="pgsql"?'|\$[^$]*\$':'');$qi=microtime(true);parse_str($_COOKIE["adminer_export"],$ya);$uc=$b->dumpFormat();unset($uc["sql"]);while($G!=""){if(!$lf&&preg_match("~^$xh*+DELIMITER\\s+(\\S+)~i",$G,$B)){$fc=$B[1];$G=substr($G,strlen($B[0]));}else{preg_match('('.preg_quote($fc)."\\s*|$Sf)",$G,$B,PREG_OFFSET_CAPTURE,$lf);list($pd,$fg)=$B[0];if(!$pd&&$r&&!feof($r))$G.=fread($r,1e5);else{if(!$pd&&rtrim($G)=="")break;$lf=$fg+strlen($pd);if($pd&&rtrim($pd)!=$fc){$Za=$l->hasCStyleEscapes()||($x=="pgsql"&&($fg>0&&strtolower($G[$fg-1])=="e"));$ag=($pd=='/*'?'\*/':($pd=='['?']':(preg_match('~^-- |^#~',$pd)?"\n":preg_quote($pd).($Za?"|\\\\.":""))));while(preg_match("($ag|\$)s",$G,$B,PREG_OFFSET_CAPTURE,$lf)){$Wg=$B[0][0];if(!$Wg&&$r&&!feof($r))$G.=fread($r,1e5);else{$lf=$B[0][1]+strlen($Wg);if(!$Wg||$Wg[0]!="\\")break;}}}else{$Cc=false;$ug=substr($G,0,$fg);$vb++;$ng="<pre id='sql-$vb'><code class='jush-$x'>".$b->sqlCommandQuery($ug)."</code></pre>\n";if($x=="sqlite"&&preg_match("~^$xh*+ATTACH\\b~i",$ug,$B)){echo$ng,"<p class='error'>".lang(148)."\n";$Ic[]=" <a href='#sql-$vb'>$vb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$ng;ob_flush();flush();}$Eh=microtime(true);if($g->multi_query($ug)&&is_object($h)&&preg_match("~^$xh*+USE\\b~i",$ug))$h->query($ug);do{$H=$g->store_result();if($g->error){echo($_POST["only_errors"]?$ng:""),"<p class='error'>".lang(149).($g->errno?" ($g->errno)":"").": ".error()."\n";$Ic[]=" <a href='#sql-$vb'>$vb</a>";if($_POST["error_stops"])break
2;}else{$ei=" <span class='time'>(".format_time($Eh).")</span>".(strlen($ug)<1000?" <a href='".h(ME)."sql=".urlencode(trim($ug))."'>".lang(11)."</a>":"");$_a=$g->affected_rows;$dj=($_POST["only_errors"]?"":$l->warnings());$ej="warnings-$vb";if($dj)$ei.=", <a href='#$ej'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$ej');","");$Qc=null;$Rc="explain-$vb";if(is_object($H)){$z=$_POST["limit"];$Ef=select($H,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$hf=$H->num_rows;echo"<p>".($hf?($z&&$hf>$z?lang(150,$z):"").lang(151,$hf):""),$ei;if($h&&preg_match("~^($xh|\\()*+SELECT\\b~i",$ug)&&($Qc=explain($h,$ug)))echo", <a href='#$Rc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Rc');","");$Kd="export-$vb";echo", <a href='#$Kd'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$Kd');","")."<span id='$Kd' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ya["output"])." ".html_select("format",$uc,$ya["format"])."<input type='hidden' name='query' value='".h($ug)."'>"." <input type='submit' name='export' value='".lang(72)."'><input type='hidden' name='token' value='$oi'></span>\n"."</form>\n";}}else{if(preg_match("~^$xh*+(CREATE|DROP|ALTER)$xh++(DATABASE|SCHEMA)\\b~i",$ug)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(152,$_a)."$ei\n";}echo($dj?"<div id='$ej' class='hidden'>\n$dj</div>\n":"");if($Qc){echo"<div id='$Rc' class='hidden explain'>\n";select($Qc,$h,$Ef);echo"</div>\n";}}$Eh=microtime(true);}while($g->next_result());}$G=substr($G,$lf);$lf=0;}}}}if($Cc)echo"<p class='message'>".lang(153)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(154,$vb-count($Ic))," <span class='time'>(".format_time($qi).")</span>\n";}elseif($Ic&&$vb>1)echo"<p class='error'>".lang(149).": ".implode("",$Ic)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Oc="<input type='submit' value='".lang(155)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$ug=$_GET["sql"];if($_POST)$ug=$_POST["query"];elseif($_GET["history"]=="all")$ug=$Gd;elseif($_GET["history"]!="")$ug=$Gd[$_GET["history"]][0];echo"<p>";textarea("query",$ug,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$Oc\n",lang(156).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(157)."</legend><div>";$_d=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$_d (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Oc":lang(158)),"</div></fieldset>\n";$Nd=$b->importServerPath();if($Nd){echo"<fieldset><legend>".lang(159)."</legend><div>",lang(160,"<code>".h($Nd)."$_d</code>"),' <input type="submit" name="webfile" value="'.lang(161).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(162))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(163))."\n","<input type='hidden' name='token' value='$oi'>\n";if(!isset($_GET["import"])&&$Gd){print_fieldset("history",lang(164),$_GET["history"]!="");for($X=end($Gd);$X;$X=prev($Gd)){$y=key($Gd);list($ug,$ei,$yc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(11)."</a>"." <span class='time' title='".@date('Y-m-d',$ei)."'>".@date("H:i:s",$ei)."</span>"." <code class='jush-$x'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$ug)))),80,"</code>").($yc?" <span class='time'>($yc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(165)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(166)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$Ki=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$C=>$n){if(!isset($n["privileges"][$Ki?"update":"insert"])||$b->fieldName($n)==""||$n["generated"])unset($o[$C]);}if($_POST&&!$m&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($Ki?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$w=indexes($a);$Fi=unique_array($_GET["where"],$w);$xg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,lang(167),$l->delete($a,$xg,!$Fi));else{$N=array();foreach($o
as$C=>$n){$X=process_input($n);if($X!==false&&$X!==null)$N[idf_escape($C)]=$X;}if($Ki){if(!$N)redirect($A);queries_redirect($A,lang(168),$l->update($a,$N,$xg,!$Fi));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$H=$l->insert($a,$N);$se=($H?last_id():0);queries_redirect($A,lang(169,($se?" $se":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["select"])){$Ga=convert_field($n);if($_POST["clone"]&&$n["auto_increment"])$Ga="''";if($x=="sql"&&preg_match("~enum|set~",$n["type"]))$Ga="1*".idf_escape($C);$L[]=($Ga?"$Ga AS ":"").idf_escape($C);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$l->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$m=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$o){if(!$Z){$H=$l->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($l->primary=>"");}if($J){foreach($J
as$y=>$X){if(!$Z)$J[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=$l->primary),"auto_increment"=>($y==$l->primary));}}}edit_form($a,$o,$J,$Ki);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Uf=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$Uf[$y]=$y;$Cg=referencable_primary($a);$nd=array();foreach($Cg
as$Ph=>$n)$nd[str_replace("`","``",$Ph)."`".str_replace("`","``",$n["field"])]=$Ph;$Hf=array();$R=array();if($a!=""){$Hf=fields($a);$R=table_status($a);if(!$R)$m=lang(10);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($J["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(170),drop_tables(array($a)));else{$o=array();$Da=array();$Oi=false;$ld=array();$Gf=reset($Hf);$Ba=" FIRST";foreach($J["fields"]as$y=>$n){$q=$nd[$n["type"]];$Ai=($q!==null?$Cg[$q]:$n);if($n["field"]!=""){if(!$n["has_default"])$n["default"]=null;$sg=process_field($n,$Ai);$Da[]=array($n["orig"],$sg,$Ba);if(!$Gf||$sg!==process_field($Gf,$Gf)){$o[]=array($n["orig"],$sg,$Ba);if($n["orig"]!=""||$Ba)$Oi=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&$x!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($Ai["field"]),'on_delete'=>$n["on_delete"],));$Ba=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Oi=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$Gf=next($Hf);if(!$Gf)$Ba="";}}$Wf="";if(support("partitioning")){if(isset($Uf[$J["partition_by"]])){$Rf=array_filter($J,function($y){return
preg_match('~^partition~',$y);},ARRAY_FILTER_USE_KEY);foreach($Rf["partition_names"]as$y=>$C){if($C==""){unset($Rf["partition_names"][$y]);unset($Rf["partition_values"][$y]);}}if($Rf!=get_partitions_info($a)){$Xf=array();if($Rf["partition_by"]=='RANGE'||$Rf["partition_by"]=='LIST'){foreach($Rf["partition_names"]as$y=>$C){$Y=$Rf["partition_values"][$y];$Xf[]="\n  PARTITION ".idf_escape($C)." VALUES ".($Rf["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Wf.="\nPARTITION BY $Rf[partition_by]($Rf[partition])";if($Xf)$Wf.=" (".implode(",",$Xf)."\n)";elseif($Rf["partitions"])$Wf.=" PARTITIONS ".(+$Rf["partitions"]);}}elseif(preg_match("~partitioned~",$R["Create_options"]))$Wf.="\nREMOVE PARTITIONING";}$Oe=lang(171);if($a==""){cookie("adminer_engine",$J["Engine"]);$Oe=lang(172);}$C=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Oe,alter_table($a,$C,($x=="sqlite"&&($Oi||$ld)?$Da:$o),$ld,($J["Comment"]!=$R["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$R["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$R["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$Wf));}}page_header(($a!=""?lang(43):lang(73)),$m,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($U["int"])?"int":(isset($U["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$R;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Hf
as$n){$n["has_default"]=isset($n["default"]);$J["fields"][]=$n;}if(support("partitioning")){$J+=get_partitions_info($a);$J["partition_names"][]="";$J["partition_values"][]="";}}}$qb=collations();$Ec=engines();foreach($Ec
as$Dc){if(!strcasecmp($Dc,$J["Engine"])){$J["Engine"]=$Dc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(173),': <input name="name"',($a==""&&!$_POST?" autofocus":""),' data-maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
',($Ec?"<select name='Engine'>".optionlist(array(""=>"(".lang(174).")")+$Ec,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($qb&&!preg_match("~sqlite|mssql~",$x)?html_select("Collation",array(""=>"(".lang(100).")")+$qb,$J["Collation"]):""),' <input type="submit" value="',lang(15),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table id="edit-fields" class="nowrap">
';edit_fields($J["fields"],$qb,"TABLE",$nd);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(50),': <input type="number" name="Auto_increment" class="size" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(175),"columnShow(this.checked, 5)","jsonly");$yb=($_POST?$_POST["comments"]:adminer_setting("comments"));echo(support("comment")?checkbox("comments",1,$yb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$J["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($yb?"":" class='hidden'").">".h($J["Comment"])."</textarea>":'<input name="Comment" value="'.h($J["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($yb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(15),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$a));}if(support("partitioning")){$Vf=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(177),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Uf,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(178),': <input type="number" name="partitions" class="size',($Vf||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table id="partition-table"',($Vf?"":" class='hidden'"),'>
<thead><tr><th>',lang(179),'<th>',lang(180),'</thead>
';foreach($J["partition_names"]as$y=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$y]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Rd=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$Rd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$Rd[]="SPATIAL";$w=indexes($a);$lg=array();if($x=="mongo"){$lg=$w["_id_"];unset($Rd[0]);unset($w["_id_"]);}$J=$_POST;if($J)set_adminer_settings(array("index_options"=>$J["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$v){$C=$v["name"];if(in_array($v["type"],$Rd)){$e=array();$ye=array();$hc=array();$N=array();ksort($v["columns"]);foreach($v["columns"]as$y=>$d){if($d!=""){$xe=$v["lengths"][$y];$gc=$v["descs"][$y];$N[]=idf_escape($d).($xe?"(".(+$xe).")":"").($gc?" DESC":"");$e[]=$d;$ye[]=($xe?$xe:null);$hc[]=$gc;}}if($e){$Pc=$w[$C];if($Pc){ksort($Pc["columns"]);ksort($Pc["lengths"]);ksort($Pc["descs"]);if($v["type"]==$Pc["type"]&&array_values($Pc["columns"])===$e&&(!$Pc["lengths"]||array_values($Pc["lengths"])===$ye)&&array_values($Pc["descs"])===$hc){unset($w[$C]);continue;}}$c[]=array($v["type"],$C,$N);}}}foreach($w
as$C=>$Pc)$c[]=array($Pc["type"],$C,"DROP");if(!$c)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(181),alter_indexes($a,$c));}page_header(lang(131),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$y=>$v){if($v["columns"][count($v["columns"])]!="")$J["indexes"][$y]["columns"][]="";}$v=end($J["indexes"]);if($v["type"]||array_filter($v["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($w
as$y=>$v){$w[$y]["name"]=$y;$w[$y]["columns"][]="";}$w[]=array("columns"=>array(1=>""));$J["indexes"]=$w;}$ye=($x=="sql"||$x=="mssql");$ph=($_POST?$_POST["options"]:adminer_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(182),'<th><input type="submit" class="wayoff">',lang(47).($ye?"<span class='idxopts".($ph?"":" hidden")."'> (".lang(183).")</span>":"");if($ye||support("descidx"))echo
checkbox("options",1,$ph,lang(106),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(184),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.17.1")."' alt='+' title='".lang(107)."'>",'</noscript>
</thead>
';if($lg){echo"<tr><td>PRIMARY<td>";foreach($lg["columns"]as$y=>$d){echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(58)."</label> ";}echo"<td><td>\n";}$he=1;foreach($J["indexes"]as$v){if(!$_POST["drop_col"]||$he!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$he][type]",array(-1=>"")+$Rd,$v["type"],($he==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($v["columns"]);$t=1;foreach($v["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$he][columns][$t]' title='".lang(47)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($v["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($x=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($ph?"":" hidden")."'>",($ye?"<input type='number' name='indexes[$he][lengths][$t]' class='size' value='".h($v["lengths"][$y])."' title='".lang(105)."'>":""),(support("descidx")?checkbox("indexes[$he][descs][$t]",1,$v["descs"][$y],lang(58)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$he][name]' value='".h($v["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$he]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.17.1")."' alt='x' title='".lang(110)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$he++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(15),'">
<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$m&&!isset($_POST["add_x"])){$C=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(185),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(186),rename_database($C,$J["collation"]));}else{$j=explode("\n",str_replace("\r","",$C));$Jh=true;$re="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$J["collation"]))$Jh=false;$re=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($re),lang(187),$Jh);}}else{if(!$J["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(188));}}page_header(DB!=""?lang(66):lang(114),$m,array(),h(DB));$qb=collations();$C=DB;if($_POST)$C=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$qb);elseif($x=="sql"){foreach(get_vals("SHOW GRANTS")as$ud){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$ud,$B)&&$B[1]){$C=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($C,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" autofocus value="'.h($C).'" data-maxlength="64" autocapitalize="off">')."\n".($qb?html_select("collation",array(""=>"(".lang(100).")")+$qb,$J["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(15),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(176,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.17.1")."' alt='+' title='".lang(107)."'>\n";echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(189));else{$C=trim($J["name"]);$_.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$_,lang(190));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$_,lang(191));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$m);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(15),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(176,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(192).": ".h($da),$m);$Sg=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Od=array();$Lf=array();foreach($Sg["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT")$Lf[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Od[]=$t;}if(!$m&&$_POST){$ab=array();foreach($Sg["fields"]as$y=>$n){if(in_array($y,$Od)){$X=process_input($n);if($X===false)$X="''";if(isset($Lf[$y]))$g->query("SET @".idf_escape($n["field"])." = $X");}$ab[]=(isset($Lf[$y])?"@".idf_escape($n["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$ab).")";$Eh=microtime(true);$H=$g->multi_query($G);$_a=$g->affected_rows;echo$b->selectQuery($G,$Eh,!$H);if(!$H)echo"<p class='error'>".error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$H=$g->store_result();if(is_object($H))select($H,$h);else
echo"<p class='message'>".lang(193,$_a)." <span class='time'>".@date("H:i:s")."</span>\n";}while($g->next_result());if($Lf)select($g->query("SELECT ".implode(", ",$Lf)));}}echo'
<form action="" method="post">
';if($Od){echo"<table class='layout'>\n";foreach($Od
as$y){$n=$Sg["fields"][$y];$C=$n["field"];echo"<tr><th>".$b->fieldName($n);$Y=$_POST["fields"][$C];if($Y!=""){if($n["type"]=="enum")$Y=+$Y;if($n["type"]=="set")$Y=array_sum($Y);}input($n,$Y,(string)$_POST["function"][$C]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(192),'">
<input type="hidden" name="token" value="',$oi,'">
</form>

<pre>
';function
pre_tr($Wg){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Wg))));}$Q='(\+--[-+]+\+\n)';$J='(\| .* \|\n)';echo
preg_replace_callback("~^$Q?$J$Q?($J*)$Q?~m",function($B){$fd=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$fd</thead>\n":$fd).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Sg['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$J=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Oe=($_POST["drop"]?lang(194):($C!=""?lang(195):lang(196)));$A=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$Xh=array();foreach($J["source"]as$y=>$X)$Xh[$y]=$J["target"][$y];$J["target"]=$Xh;}if($x=="sqlite")queries_redirect($A,$Oe,recreate_table($a,$a,array(),array(),array(" $C"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$pc="\nDROP ".($x=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C);if($_POST["drop"])query_redirect($c.$pc,$A,$Oe);else{query_redirect($c.($C!=""?"$pc,":"")."\nADD".format_foreign_key($J),$A,$Oe);$m=lang(197)."<br>$m";}}}page_header(lang(198),$m,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($C!=""){$nd=foreign_keys($a);$J=$nd[$C];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}echo'
<form action="" method="post">
';$wh=array_keys(fields($a));if($J["db"]!="")$g->select_db($J["db"]);if($J["ns"]!="")set_schema($J["ns"]);$Bg=array_keys(array_filter(table_status('',true),'fk_support'));$Xh=array_keys(fields(in_array($J["table"],$Bg)?$J["table"]:reset($Bg)));$uf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(199).": ".html_select("table",$Bg,$J["table"],$uf)."\n";if($x=="pgsql")echo
lang(75).": ".html_select("ns",$b->schemas(),$J["ns"]!=""?$J["ns"]:$_GET["ns"],$uf);elseif($x!="sqlite"){$Zb=array();foreach($b->databases()as$k){if(!information_schema($k))$Zb[]=$k;}echo
lang(74).": ".html_select("db",$Zb,$J["db"]!=""?$J["db"]:$_GET["db"],$uf);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(200),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(133),'<th id="label-target">',lang(134),'</thead>
';$he=0;foreach($J["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$wh,$X,($he==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$y)."]",$Xh,$J["target"][$y],1,"label-target");$he++;}echo'</table>
<p>
',lang(102),': ',html_select("on_delete",array(-1=>"")+explode("|",$tf),$J["on_delete"]),' ',lang(101),': ',html_select("on_update",array(-1=>"")+explode("|",$tf),$J["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(15),'">
<noscript><p><input type="submit" name="add" value="',lang(201),'"></noscript>
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$C));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$If="VIEW";if($x=="pgsql"&&$a!=""){$O=table_status($a);$If=strtoupper($O["Engine"]);}if($_POST&&!$m){$C=trim($J["name"]);$Ga=" AS\n$J[select]";$A=ME."table=".urlencode($C);$Oe=lang(202);$T=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&$x!="sqlite"&&$T=="VIEW"&&$If=="VIEW")query_redirect(($x=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$Ga,$A,$Oe);else{$Zh=$C."_adminer_".uniqid();drop_create("DROP $If ".table($a),"CREATE $T ".table($C).$Ga,"DROP $T ".table($C),"CREATE $T ".table($Zh).$Ga,"DROP $T ".table($Zh),($_POST["drop"]?substr(ME,0,-1):$A),lang(203),$Oe,lang(204),$a,$C);}}if(!$_POST&&$a!=""){$J=view($a);$J["name"]=$a;$J["materialized"]=($If!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(205)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(184),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(128)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(15),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$a));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Zd=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Fh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(206));elseif(in_array($J["INTERVAL_FIELD"],$Zd)&&isset($Fh[$J["STATUS"]])){$Xg="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(207):lang(208)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Xg.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$Xg)."\n".$Fh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(209).": ".h($aa):lang(210)),$m);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(184),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(211),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(212),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(213),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Zd,$J["INTERVAL_FIELD"]),'<tr><th>',lang(117),'<td>',html_select("STATUS",$Fh,$J["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(214)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(15),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$aa));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Sg=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$m){$Ff=routine($_GET["procedure"],$Sg);$Zh="$J[name]_adminer_".uniqid();drop_create("DROP $Sg ".routine_id($da,$Ff),create_routine($Sg,$J),"DROP $Sg ".routine_id($J["name"],$J),create_routine($Sg,array("name"=>$Zh)+$J),"DROP $Sg ".routine_id($Zh,$J),substr(ME,0,-1),lang(215),lang(216),lang(217),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(218):lang(219)).": ".h($da):(isset($_GET["function"])?lang(220):lang(221))),$m);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$Sg);$J["name"]=$da;}$qb=get_vals("SHOW CHARACTER SET");sort($qb);$Tg=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(184),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',($Tg?lang(20).": ".html_select("language",$Tg,$J["language"])."\n":""),'<input type="submit" value="',lang(15),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($J["fields"],$qb,$Sg);if(isset($_GET["function"])){echo"<tr><td>".lang(222);edit_type("returns",$J["returns"],$qb,array(),($x=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(15),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$da));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$C=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$_,lang(223));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$_,lang(224));elseif($fa!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($C),$_,lang(225));else
redirect($_);}page_header($fa!=""?lang(226).": ".h($fa):lang(227),$m);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(15),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(176,$fa))."\n";echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$_,lang(228));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$_,lang(229));}page_header($ga!=""?lang(230).": ".h($ga):lang(231),$m);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(176,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(15)."'>\n";}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$C=$_GET["name"];$J=$_POST;if($J&&!$m){$H=($C==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($C)));if(!$J["drop"])$H=queries("ALTER TABLE ".table($a)." ADD".($J["name"]!=""?" CONSTRAINT ".idf_escape($J["name"])."":"")." CHECK ($J[clause])");queries_redirect(ME."table=".urlencode($a),($J["drop"]?lang(232):($C!=""?lang(233):lang(234))),$H);}page_header(($C!=""?lang(235).": ".h($C):lang(138)),$m,array("table"=>$a));if(!$J){$hb=check_constraints($a);$J=array("name"=>$C,"clause"=>$hb[$C]);}echo'
<form action="" method="post">
<p>',lang(184),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">',doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",)),'<p>';textarea("clause",$J["clause"]);echo'<p><input type="submit" value="',lang(15),'">
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$C));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C=$_GET["name"];$zi=trigger_options();$J=(array)trigger($C,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$zi["Timing"])&&in_array($_POST["Event"],$zi["Event"])&&in_array($_POST["Type"],$zi["Type"])){$sf=" ON ".table($a);$pc="DROP TRIGGER ".idf_escape($C).($x=="pgsql"?$sf:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($pc,$A,lang(236));else{if($C!="")queries($pc);queries_redirect($A,($C!=""?lang(237):lang(238)),queries(create_trigger($sf,$_POST)));if($C!="")queries(create_trigger($sf,$J+array("Type"=>reset($zi["Type"]))));}}$J=$_POST;}page_header(($C!=""?lang(239).": ".h($C):lang(240)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(241),'<td>',html_select("Timing",$zi["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(242),'<td>',html_select("Event",$zi["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$zi["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$zi["Type"],$J["Type"]),'</table>
<p>',lang(184),': <input name="Trigger" value="',h($J["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(15),'">
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,$C));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$qg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Hb)$qg[$Hb][$J["Privilege"]]=$J["Comment"];}$qg["Server Admin"]+=$qg["File access on server"];$qg["Databases"]["Create routine"]=$qg["Procedures"]["Create routine"];unset($qg["Procedures"]["Create routine"]);$qg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$qg["Columns"][$X]=$qg["Tables"][$X];unset($qg["Server Admin"]["Usage"]);foreach($qg["Tables"]as$y=>$X)unset($qg["Databases"][$y]);$bf=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$bf[$X]=(array)$bf[$X]+(array)$_POST["grants"][$y];}$vd=array();$qf="";if(isset($_GET["host"])&&($H=$g->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Fe,PREG_SET_ORDER)){foreach($Fe
as$X){if($X[1]!="USAGE")$vd["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$vd["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$B))$qf=$B[1];}}if($_POST&&!$m){$rf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $rf",ME."privileges=",lang(243));else{$df=q($_POST["user"])."@".q($_POST["host"]);$Yf=$_POST["pass"];if($Yf!=''&&!$_POST["hashed"]&&!min_version(8)){$Yf=$g->result("SELECT PASSWORD(".q($Yf).")");$m=!$Yf;}$Nb=false;if(!$m){if($rf!=$df){$Nb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $df IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Yf));$m=!$Nb;}elseif($Yf!=$qf)queries("SET PASSWORD FOR $df = ".q($Yf));}if(!$m){$Pg=array();foreach($bf
as$jf=>$ud){if(isset($_GET["grant"]))$ud=array_filter($ud);$ud=array_keys($ud);if(isset($_GET["grant"]))$Pg=array_diff(array_keys(array_filter($bf[$jf],'strlen')),$ud);elseif($rf==$df){$of=array_keys((array)$vd[$jf]);$Pg=array_diff($of,$ud);$ud=array_diff($ud,$of);unset($vd[$jf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$jf,$B)&&(!grant("REVOKE",$Pg,$B[2]," ON $B[1] FROM $df")||!grant("GRANT",$ud,$B[2]," ON $B[1] TO $df"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($rf!=$df)queries("DROP USER $rf");elseif(!isset($_GET["grant"])){foreach($vd
as$jf=>$Pg){if(preg_match('~^(.+)(\(.*\))?$~U',$jf,$B))grant("REVOKE",array_keys($Pg),$B[2]," ON $B[1] FROM $df");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(244):lang(245)),!$m);if($Nb)$g->query("DROP USER $df");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ha@$_GET[host]"):lang(147)),$m,array("privileges"=>array('',lang(70))));if($_POST){$J=$_POST;$vd=$bf;}else{$J=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$qf;if($qf!="")$J["hashed"]=true;$vd[(DB==""||$vd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$J["hashed"],lang(246),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($vd
as$jf=>$ud){echo'<th>'.($jf!="*.*"?"<input name='objects[$t]' value='".h($jf)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$t]' value='*.*' size='10'>*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(130),"Columns"=>lang(47),"Procedures"=>lang(247),)as$Hb=>$gc){foreach((array)$qg[$Hb]as$pg=>$wb){echo"<tr><td".($gc?">$gc<td":" colspan='2'").' lang="en" title="'.h($wb).'">'.h($pg);$t=0;foreach($vd
as$jf=>$ud){$C="'grants[$t][".h(strtoupper($pg))."]'";$Y=$ud[strtoupper($pg)];if($Hb=="Server Admin"&&$jf!=(isset($vd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(248)."<option value='0'".($Y=="0"?" selected":"").">".lang(249)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($pg=="All privileges"?" id='grants-$t-all'>":">".($pg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";}$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(15),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(176,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$me=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$me++;}queries_redirect(ME."processlist=",lang(250,$me),$me||!$_POST["kill"]);}}page_header(lang(115),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$J){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$J[$x=="sql"?"Id":"pid"],0):"");foreach($J
as$y=>$X)echo"<td>".(($x=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($x=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||($x=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-$x'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(251).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($t+1)."/".lang(252,max_connections()),"<p><input type='submit' value='".lang(253)."'>\n";}echo'<input type="hidden" name="token" value="',$oi,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$w=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$mf=$R["Oid"];parse_str($_COOKIE["adminer_import"],$za);$Qg=array();$e=array();$di=null;foreach($o
as$y=>$n){$C=$b->fieldName($n);if(isset($n["privileges"]["select"])&&$C!=""){$e[$y]=html_entity_decode(strip_tags($C),ENT_QUOTES);if(is_shortable($n))$di=$b->selectLengthProcess();}$Qg+=$n["privileges"];}list($L,$wd)=$b->selectColumnsProcess($e,$w);$de=count($wd)<count($L);$Z=$b->selectSearchProcess($o,$w);$Bf=$b->selectOrderProcess($o,$w);$z=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Gi=>$J){$Ga=convert_field($o[key($J)]);$L=array($Ga?$Ga:idf_escape(key($J)));$Z[]=where_check($Gi,$o);$I=$l->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$lg=$Ii=null;foreach($w
as$v){if($v["type"]=="PRIMARY"){$lg=array_flip($v["columns"]);$Ii=($L?$lg:array());foreach($Ii
as$y=>$X){if(in_array(idf_escape($y),$L))unset($Ii[$y]);}break;}}if($mf&&!$lg){$lg=$Ii=array($mf=>0);$w[]=array("type"=>"PRIMARY","columns"=>array($mf));}if($_POST&&!$m){$jj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$hb=array();foreach($_POST["check"]as$db)$hb[]=where_check($db,$o);$jj[]="((".implode(") OR (",$hb)."))";}$jj=($jj?"\nWHERE ".implode(" AND ",$jj):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$rd=($L?implode(", ",$L):"*").convert_fields($e,$o,$L)."\nFROM ".table($a);$yd=($wd&&$de?"\nGROUP BY ".implode(", ",$wd):"").($Bf?"\nORDER BY ".implode(", ",$Bf):"");if(!is_array($_POST["check"])||$lg)$G="SELECT $rd$jj$yd";else{$Ei=array();foreach($_POST["check"]as$X)$Ei[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$yd,1).")";$G=implode(" UNION ALL ",$Ei);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$H=true;$_a=0;$N=array();if(!$_POST["delete"]){foreach($e
as$C=>$X){$X=process_input($o[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$N[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$N){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($N)).")\nSELECT ".implode(", ",$N)."\nFROM ".table($a);if($_POST["all"]||($lg&&is_array($_POST["check"]))||$de){$H=($_POST["delete"]?$l->delete($a,$jj):($_POST["clone"]?queries("INSERT $G$jj"):$l->update($a,$N,$jj)));$_a=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$fj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$H=($_POST["delete"]?$l->delete($a,$fj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$fj)):$l->update($a,$N,$fj,1)));if(!$H)break;$_a+=$g->affected_rows;}}}$Oe=lang(254,$_a);if($_POST["clone"]&&$H&&$_a==1){$se=last_id();if($se)$Oe=lang(169," $se");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Oe,$H);if(!$_POST["delete"]){edit_form($a,$o,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(255);else{$H=true;$_a=0;foreach($_POST["val"]as$Gi=>$J){$N=array();foreach($J
as$y=>$X){$y=bracket_escape($y,1);$N[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?$b->processInput($o[$y],$X):"NULL");}$H=$l->update($a,$N," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Gi,$o),!$de&&!$lg," ");if(!$H)break;$_a+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(254,$_a),$H);}}elseif(!is_string($cd=get_file("csv_file",true)))$m=upload_error($cd);elseif(!preg_match('~~u',$cd))$m=lang(256);else{cookie("adminer_import","output=".urlencode($za["output"])."&format=".urlencode($_POST["separator"]));$H=true;$sb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$cd,$Fe);$_a=count($Fe[0]);$l->begin();$gh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($Fe[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$gh]*)$gh~",$X.$gh,$Ge);if(!$y&&!array_diff($Ge[1],$sb)){$sb=$Ge[1];$_a--;}else{$N=array();foreach($Ge[1]as$t=>$nb)$N[idf_escape($sb[$t])]=($nb==""&&$o[$sb[$t]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$nb))));$K[]=$N;}}$H=(!$K||$l->insertUpdate($a,$K,$lg));if($H)$H=$l->commit();queries_redirect(remove_from_uri("page"),lang(257,$_a),$H);$l->rollback();}}}$Ph=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $Ph",$m);$N=null;if(isset($Qg["insert"])||!support("table")){$Rf=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$Rf["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$N=$Rf?"&".http_build_query($Rf):"";}$b->selectLinks($R,$N);if(!$e&&support("table"))echo"<p class='error'>".lang(258).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$e);$b->selectSearchPrint($Z,$e,$w);$b->selectOrderPrint($Bf,$e,$w);$b->selectLimitPrint($z);$b->selectLengthPrint($di);$b->selectActionPrint($w);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$qd=$g->result(count_rows($a,$Z,$de,$wd));$E=floor(max(0,$qd-1)/$z);}$bh=$L;$xd=$wd;if(!$bh){$bh[]="*";$Ib=convert_fields($e,$o,$L);if($Ib)$bh[]=substr($Ib,2);}foreach($L
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($Ga=convert_field($n)))$bh[$y]="$Ga AS $X";}if(!$de&&$Ii){foreach($Ii
as$y=>$X){$bh[]=idf_escape($y);if($xd)$xd[]=idf_escape($y);}}$H=$l->select($a,$bh,$Z,$xd,$Bf,$z,$E,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($x=="mssql"&&$E)$H->seek($z*$E);$Bc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$x=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$z!=""&&$wd&&$de&&$x=="sql")$qd=$g->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(13)."\n";else{$Pa=$b->backwardKeys($a,$Ph);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$wd&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(259)."</a>");$Ze=array();$sd=array();reset($L);$zg=1;foreach($K[0]as$y=>$X){if(!isset($Ii[$y])){$X=$_GET["columns"][key($L)];$n=$o[$L?($X?$X["col"]:current($L)):$y];$C=($n?$b->fieldName($n,$zg):($X["fun"]?"*":h($y)));if($C!=""){$zg++;$Ze[$y]=$C;$d=idf_escape($y);$Jd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$gc="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Jd.($Bf[0]==$d||$Bf[0]==$y||(!$Bf&&$de&&$wd[0]==$d)?$gc:'')).'">';echo
apply_sql_function($X["fun"],$C)."</a>";echo"<span class='column hidden'>","<a href='".h($Jd.$gc)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");}echo"</span>";}$sd[$y]=$X["fun"];next($L);}}$ye=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$y=>$X)$ye[$y]=max($ye[$y],min(40,strlen(utf8_decode($X))));}}echo($Pa?"<th>".lang(260):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach($b->rowDescriptions($K,$nd)as$Ye=>$J){$Fi=unique_array($K[$Ye],$w);if(!$Fi){$Fi=array();foreach($K[$Ye]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Fi[$y]=$X;}}$Gi="";foreach($Fi
as$y=>$X){if(($x=="sql"||$x=="pgsql")&&preg_match('~char|text|enum|set~',$o[$y]["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".($x!='sql'||preg_match("~^utf8~",$o[$y]["collation"])?$y:"CONVERT($y USING ".charset($g).")").")";$X=md5($X);}$Gi.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$wd&&$L?"":"<td>".checkbox("check[]",substr($Gi,1),in_array(substr($Gi,1),(array)$_POST["check"])).($de||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Gi)."' class='edit'>".lang(261)."</a>"));foreach($J
as$y=>$X){if(isset($Ze[$y])){$n=$o[$y];$X=$l->value($X,$n);if($X!=""&&(!isset($Bc[$y])||$Bc[$y]!=""))$Bc[$y]=(is_mail($X)?$Ze[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$Gi;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$wh)$_.=where_link($t,$q["target"][$t],$K[$Ye][$wh]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Fi))$_.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($Fi
as$ie=>$W)$_.=where_link($t++,$ie,$W);}$X=select_value($X,$_,$n,$di);$Kd=h("val[$Gi][".bracket_escape($y)."]");$Y=$_POST["val"][$Gi][bracket_escape($y)];$xc=!is_array($J[$y])&&is_utf8($X)&&$K[$Ye][$y]==$J[$y]&&!$sd[$y];$bi=preg_match('~text|lob~',$n["type"]);echo"<td id='$Kd'";if(($_GET["modify"]&&$xc)||$Y!==null){$Ad=h($Y!==null?$Y:$J[$y]);echo">".($bi?"<textarea name='$Kd' cols='30' rows='".(substr_count($J[$y],"\n")+1)."'>$Ad</textarea>":"<input name='$Kd' value='$Ad' size='$ye[$y]'>");}else{$Be=strpos($X,"<i>…</i>");echo" data-text='".($Be?2:($bi?1:0))."'".($xc?"":" data-warning='".h(lang(262))."'").">$X</td>";}}}if($Pa)echo"<td>";$b->backwardKeysPrint($Pa,$K[$Ye]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$E){$Nc=true;if($_GET["page"]!="last"){if($z==""||(count($K)<$z&&($K||!$E)))$qd=($E?$E*$z:0)+count($K);elseif($x!="sql"||!$de){$qd=($de?false:found_rows($R,$Z));if($qd<max(1e4,2*($E+1)*$z))$qd=reset(slow_query(count_rows($a,$Z,$de,$wd)));else$Nc=false;}}$Pf=($z!=""&&($qd===false||$qd>$z||$E));if($Pf){echo(($qd===false?count($K)+1:$qd-$E*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(263).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$z).", '".lang(264)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Pf){$Ie=($qd===false?$E+(count($K)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if($x!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(265)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(265)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($t=max(1,$E-4);$t<min($Ie,$E+5);$t++)echo
pagination($t,$E);if($Ie>0){echo($E+5<$Ie?" …":""),($Nc&&$qd!==false?pagination($Ie,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Ie'>".lang(266)."</a>");}}else{echo"<legend>".lang(265)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Ie>$E?pagination($E+1,$E).($Ie>$E+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(267)."</legend>";$mc=($Nc?"":"~ ").$qd;echo
checkbox("all",1,0,($qd!==false?($Nc?"":"~ ").lang(151,$qd):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$mc' : checked); selectCount('selected2', this.checked || !checked ? '$mc' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(259),'</legend><div>
<input type="submit" value="',lang(15),'"',($_GET["modify"]?'':' title="'.lang(255).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(125),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(11),'">
<input type="submit" name="clone" value="',lang(251),'">
<input type="submit" name="delete" value="',lang(19),'">',confirm(),'</div></fieldset>
';}$od=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(72)." <span id='selected2'></span>");$Mf=$b->dumpOutput();echo($Mf?html_select("output",$Mf,$za["output"])." ":""),html_select("format",$od,$za["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($Bc,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$za["format"],1);echo" <input type='submit' name='import' value='".lang(71)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$oi'>\n","</form>\n",(!$wd&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$O=isset($_GET["status"]);page_header($O?lang(117):lang(116));$Wi=($O?show_status():show_variables());if(!$Wi)echo"<p class='message'>".lang(13)."\n";else{echo"<table>\n";foreach($Wi
as$y=>$X){echo"<tr>","<th><code class='jush-".$x.($O?"status":"set")."'>".h($y)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Mh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$R){json_row("Comment-$C",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$y)json_row("$y-$C",h($R[$y]));foreach($Mh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($R[$y]!=""){$X=format_number($R[$y]);json_row("$y-$C",($y=="Rows"&&$X&&$R["Engine"]==($x=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Mh[$y]))$Mh[$y]+=($R["Engine"]!="InnoDB"||$y!="Data_free"?$R[$y]:0);}elseif(array_key_exists($y,$R))json_row("$y-$C");}}}foreach($Mh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Vh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Vh&&!$m&&!$_POST["search"]){$H=true;$Oe="";if($x=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Oe=lang(268);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Oe=lang(269);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Oe=lang(270);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Oe=lang(271);}elseif($x!="sql"){$H=($x=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Oe=lang(272);}elseif(!$_POST["tables"])$Oe=lang(10);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Oe.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Oe,$H);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$m,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(273)."</h3>\n";$Uh=tables_list();if(!$Uh)echo"<p class='message'>".lang(10)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(274)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$l->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(130),'<td>'.lang(275).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(121).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(276).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(277).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(278).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(279).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$S=0;foreach($Uh
as$C=>$T){$Zi=($T!==null&&!preg_match('~table|sequence~i',$T));$Kd=h("Table-".$C);echo'<tr><td>'.checkbox(($Zi?"views[]":"tables[]"),$C,in_array($C,$Vh,true),"","","",$Kd),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(41)."' id='$Kd'>".h($C).'</a>':h($C));if($Zi){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$T)?lang(128):lang(129)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(40).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(132)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$y=>$_){$Kd=" id='$y-".h($C)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($C)."'$Kd title='$_[1]'>?</a>":"<span$Kd>?</span>"):"<td id='$y-".h($C)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":""),"\n";}echo"<tr><td><th>".lang(252,count($Uh)),"<td>".h($x=="sql"?$g->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Ti="<input type='submit' value='".lang(280)."'> ".on_help("'VACUUM'");$zf="<input type='submit' name='optimize' value='".lang(281)."'> ".on_help($x=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(125)." <span id='selected'></span></legend><div>".($x=="sqlite"?$Ti:($x=="pgsql"?$Ti.$zf:($x=="sql"?"<input type='submit' value='".lang(282)."'> ".on_help("'ANALYZE TABLE'").$zf."<input type='submit' name='check' value='".lang(283)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(284)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(285)."'> ".on_help($x=="sqlite"?"'DELETE'":"'TRUNCATE".($x=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(126)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?$b->schemas():$b->databases());if(count($j)!=1&&$x!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(286).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(287)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(288)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(289)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$oi'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(73)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(205)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(144)."</h3>\n";$Ug=routines();if($Ug){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(184).'<td>'.lang(48).'<td>'.lang(222)."<td></thead>\n";foreach($Ug
as$J){$C=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.lang(135)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(221).'</a>':'').'<a href="'.h(ME).'function=">'.lang(220)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(290)."</h3>\n";$jh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($jh){echo"<table class='odds'>\n","<thead><tr><th>".lang(184)."</thead>\n";foreach($jh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(227)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(9)."</h3>\n";$Ri=types();if($Ri){echo"<table class='odds'>\n","<thead><tr><th>".lang(184)."</thead>\n";foreach($Ri
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(231)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(145)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table>\n","<thead><tr><th>".lang(184)."<td>".lang(291)."<td>".lang(211)."<td>".lang(212)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(292)."<td>".$J["Execute at"]:lang(213)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(135).'</a>';}echo"</table>\n";$Lc=$g->result("SELECT @@event_scheduler");if($Lc&&$Lc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Lc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(210)."</a>\n";}if($Uh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();